/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.api.event.ProjectileHitEvent;
import com.atsuishio.superbwarfare.client.particle.BulletDecalOption;
import com.atsuishio.superbwarfare.client.particle.CustomCloudOption;
import com.atsuishio.superbwarfare.config.server.ProjectileConfig;
import com.atsuishio.superbwarfare.entity.DPSGeneratorEntity;
import com.atsuishio.superbwarfare.entity.OBBEntity;
import com.atsuishio.superbwarfare.entity.TargetEntity;
import com.atsuishio.superbwarfare.entity.mixin.ICustomKnockback;
import com.atsuishio.superbwarfare.entity.mixin.OBBHitter;
import com.atsuishio.superbwarfare.entity.projectile.CustomSyncMotionEntity;
import com.atsuishio.superbwarfare.entity.projectile.ExplosiveProjectile;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModParticleTypes;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.item.Beast;
import com.atsuishio.superbwarfare.network.NetworkRegistry;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.network.message.receive.ClientMotionSyncMessage;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.HitboxHelper;
import com.atsuishio.superbwarfare.tools.OBB;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.atsuishio.superbwarfare.world.phys.EntityResult;
import com.atsuishio.superbwarfare.world.phys.ExtendedEntityRayTraceResult;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ProjectileEntity
extends Projectile
implements GeoEntity,
CustomSyncMotionEntity,
ExplosiveProjectile {
    public static final EntityDataAccessor<Float> COLOR_R = SynchedEntityData.m_135353_(ProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> COLOR_G = SynchedEntityData.m_135353_(ProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> COLOR_B = SynchedEntityData.m_135353_(ProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final Predicate<Entity> PROJECTILE_TARGETS = input -> input != null && input.m_6087_() && !input.m_5833_() && input.m_6084_();
    private static final Predicate<BlockState> IGNORE_LIST = input -> input != null && input.m_204336_(ModTags.Blocks.BULLET_IGNORE) && !input.m_60713_(Blocks.f_50166_) && !input.m_60713_(Blocks.f_50376_);
    public static final float DEFAULT_R = 1.0f;
    public static final float DEFAULT_G = 0.87058824f;
    public static final float DEFAULT_B = 0.15294118f;
    @Nullable
    protected Entity shooter;
    protected int shooterId;
    private float damage = 1.0f;
    private float headShot = 1.0f;
    private float legShot = 0.5f;
    private boolean beast = false;
    private boolean zoom = false;
    private float bypassArmorRate = 0.0f;
    private float explosionDamage = 0.0f;
    private float explosionRadius = 0.0f;
    private int fireLevel = 0;
    private boolean dragonBreath = false;
    private float knockback = 0.05f;
    private float velocity = 20.0f;
    private boolean forceKnockback = false;
    private boolean penetrating = false;
    private final ArrayList<MobEffectInstance> mobEffects = new ArrayList();
    private String gunItemId;
    private float gravity = 0.05f;

    public ProjectileEntity(EntityType<? extends ProjectileEntity> entityType, Level level) {
        super(entityType, level);
        this.f_19811_ = true;
    }

    public ProjectileEntity(Level level) {
        this((EntityType<? extends ProjectileEntity>)((EntityType)ModEntities.PROJECTILE.get()), level);
    }

    @Nullable
    protected EntityResult findEntityOnPath(Vec3 startVec, Vec3 endVec) {
        Vec3 hitVec = null;
        Entity hitEntity = null;
        boolean headshot = false;
        boolean legShot = false;
        List entities = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82369_(this.m_20184_()).m_82400_(this.beast ? 3.0 : 1.0), PROJECTILE_TARGETS);
        double closestDistance = Double.MAX_VALUE;
        for (Entity entity : entities) {
            double distanceToHit;
            Vec3 hitPos;
            EntityResult result;
            if (entity.equals((Object)this.shooter) || this.shooter != null && entity.equals((Object)this.shooter.m_20202_()) || this.shooter != null && entity.m_20201_() == this.shooter.m_20201_() || entity instanceof TargetEntity && (Integer)entity.m_20088_().m_135370_(TargetEntity.DOWN_TIME) > 0 || entity instanceof DPSGeneratorEntity && (Integer)entity.m_20088_().m_135370_(DPSGeneratorEntity.DOWN_TIME) > 0 || (result = this.getHitResult(entity, startVec, endVec)) == null || (hitPos = result.getHitPos()) == null || !((distanceToHit = startVec.m_82554_(hitPos)) < closestDistance)) continue;
            hitVec = hitPos;
            hitEntity = entity;
            closestDistance = distanceToHit;
            headshot = result.isHeadshot();
            legShot = result.isLegShot();
        }
        return hitEntity != null ? new EntityResult(hitEntity, hitVec, headshot, legShot) : null;
    }

    @Nullable
    protected List<EntityResult> findEntitiesOnPath(Vec3 startVec, Vec3 endVec) {
        ArrayList<EntityResult> hitEntities = new ArrayList<EntityResult>();
        List entities = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), PROJECTILE_TARGETS);
        for (Entity entity : entities) {
            EntityResult result;
            if (this.shooter != null && (entity == this.shooter || entity == this.shooter.m_20202_()) || (result = this.getHitResult(entity, startVec, endVec)) == null || entity.m_20202_() != null && this.shooter != null && entity.m_20202_() == this.shooter.m_20202_()) continue;
            hitEntities.add(result);
        }
        return hitEntities;
    }

    @Nullable
    private EntityResult getHitResult(Entity entity, Vec3 startVec, Vec3 endVec) {
        OBBEntity obbEntity;
        double expandHeight = entity instanceof Player && !entity.m_6047_() ? 0.0625 : 0.0;
        Vec3 hitPos = null;
        if (entity instanceof OBBEntity && !(obbEntity = (OBBEntity)entity).enableAABB()) {
            for (OBB obb : obbEntity.getOBBs()) {
                Vector3d obbVec = obb.clip(OBB.vec3ToVector3d(startVec), OBB.vec3ToVector3d(endVec)).orElse(null);
                if (obbVec == null) continue;
                hitPos = OBB.vector3dToVec3(obbVec);
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    this.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)hitPos), (SoundEvent)ModSounds.HIT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    ParticleTool.sendParticle(serverLevel, (SimpleParticleType)ModParticleTypes.FIRE_STAR.get(), hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, 2, 0.0, 0.0, 0.0, 0.2, false);
                    ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123762_, hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, 2, 0.0, 0.0, 0.0, 0.01, false);
                }
                OBBHitter acc = OBBHitter.getInstance((Entity)this);
                acc.sbw$setCurrentHitPart(obb.part());
            }
        } else {
            AABB boundingBox = entity.m_20191_();
            Vec3 velocity = new Vec3(entity.m_20185_() - entity.f_19790_, entity.m_20186_() - entity.f_19791_, entity.m_20189_() - entity.f_19792_);
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                Entity entity2 = this.shooter;
                if (entity2 instanceof ServerPlayer) {
                    ServerPlayer serverPlayerOwner = (ServerPlayer)entity2;
                    int ping = Mth.m_14107_((double)((double)serverPlayerOwner.f_8943_ / 1000.0 * 20.0 + 0.5));
                    boundingBox = HitboxHelper.getBoundingBox((Player)player, ping);
                    velocity = HitboxHelper.getVelocity((Player)player, ping);
                }
            }
            boundingBox = boundingBox.m_82363_(0.0, expandHeight, 0.0);
            boundingBox = boundingBox.m_82363_(velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
            double playerHitboxOffset = 3.0;
            if (entity instanceof ServerPlayer) {
                if (entity.m_20202_() != null) {
                    boundingBox = boundingBox.m_82383_(velocity.m_82542_(playerHitboxOffset / 2.0, playerHitboxOffset / 2.0, playerHitboxOffset / 2.0));
                }
                boundingBox = boundingBox.m_82383_(velocity.m_82542_(playerHitboxOffset, playerHitboxOffset, playerHitboxOffset));
            }
            if (entity.m_20202_() != null) {
                boundingBox = boundingBox.m_82383_(velocity.m_82542_(-2.5, -2.5, -2.5));
            }
            boundingBox = boundingBox.m_82383_(velocity.m_82542_(-5.0, -5.0, -5.0));
            if (this.beast) {
                boundingBox = boundingBox.m_82400_(3.0);
            }
            hitPos = boundingBox.m_82371_(startVec, endVec).orElse(null);
        }
        if (hitPos == null) {
            return null;
        }
        Vec3 hitBoxPos = hitPos.m_82546_(entity.m_20182_());
        boolean headshot = false;
        boolean legShot = false;
        float eyeHeight = entity.m_20192_();
        float bodyHeight = entity.m_20206_();
        if ((double)eyeHeight - 0.25 < hitBoxPos.f_82480_ && hitBoxPos.f_82480_ < (double)eyeHeight + 0.3 && entity instanceof LivingEntity) {
            headshot = true;
        }
        if (hitBoxPos.f_82480_ < 0.33 * (double)bodyHeight && entity instanceof LivingEntity) {
            legShot = true;
        }
        if (this.explosionDamage > 0.0f) {
            this.explosionBullet((Entity)this, hitPos);
        }
        return new EntityResult(entity, hitPos, headshot, legShot);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(COLOR_R, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_G, (Object)Float.valueOf(0.87058824f));
        this.f_19804_.m_135372_(COLOR_B, (Object)Float.valueOf(0.15294118f));
    }

    public void m_8119_() {
        Level randomPos2;
        ServerLevel serverLevel;
        Vec3 endVec;
        super.m_8119_();
        this.updateHeading();
        Vec3 vec = this.m_20184_();
        if (!this.m_9236_().m_5776_()) {
            Vec3 startVec = this.m_20182_();
            endVec = startVec.m_82549_(this.m_20184_());
            Object result = ProjectileEntity.rayTraceBlocks(this.m_9236_(), new ClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this), this.penetrating || this.beast ? state -> true : ((Boolean)ProjectileConfig.ALLOW_PROJECTILE_DESTROY_BLOCKS.get() != false ? IGNORE_LIST.and(input -> !input.m_204336_(ModTags.Blocks.BULLET_CAN_DESTROY)) : IGNORE_LIST));
            BlockHitResult fluidResult = ProjectileEntity.rayTraceBlocks(this.m_9236_(), new ClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)this), this.penetrating || this.beast ? state -> true : ((Boolean)ProjectileConfig.ALLOW_PROJECTILE_DESTROY_BLOCKS.get() != false ? IGNORE_LIST.and(input -> !input.m_204336_(ModTags.Blocks.BULLET_CAN_DESTROY)) : IGNORE_LIST));
            if (result.m_6662_() != HitResult.Type.MISS) {
                endVec = result.m_82450_();
            }
            ArrayList<EntityResult> entityResults = new ArrayList<EntityResult>();
            List<EntityResult> temp = this.findEntitiesOnPath(startVec, endVec);
            if (temp != null) {
                entityResults.addAll(temp);
            }
            if (this.shooter != null) {
                entityResults.sort(Comparator.comparingDouble(e -> e.getHitPos().m_82554_(this.shooter.m_20182_())));
            }
            for (EntityResult entityResult : entityResults) {
                DPSGeneratorEntity dpsGeneratorEntity;
                TargetEntity target;
                Entity entity;
                result = new ExtendedEntityRayTraceResult(entityResult);
                Entity entity2 = ((EntityHitResult)result).m_82443_();
                if (entity2 instanceof Player) {
                    Player p;
                    Player player = (Player)entity2;
                    entity = this.shooter;
                    if (entity instanceof Player && !(p = (Player)entity).m_7099_(player)) {
                        result = null;
                    }
                }
                if (result != null) {
                    this.m_6532_((HitResult)result);
                }
                if (this.beast) continue;
                this.bypassArmorRate -= 0.2f;
                if (!(this.bypassArmorRate < 0.8f) || result == null || (entity = ((EntityHitResult)result).m_82443_()) instanceof TargetEntity && (Integer)(target = (TargetEntity)entity).m_20088_().m_135370_(TargetEntity.DOWN_TIME) > 0 || (entity = ((EntityHitResult)result).m_82443_()) instanceof DPSGeneratorEntity && (Integer)(dpsGeneratorEntity = (DPSGeneratorEntity)entity).m_20088_().m_135370_(DPSGeneratorEntity.DOWN_TIME) > 0) continue;
                break;
            }
            if (entityResults.isEmpty()) {
                this.m_6532_((HitResult)result);
            }
            this.onHitWater(fluidResult.m_82450_(), fluidResult);
            this.m_6034_(this.m_20185_() + vec.f_82479_, this.m_20186_() + vec.f_82480_, this.m_20189_() + vec.f_82481_);
        } else {
            this.m_20343_(this.m_20185_() + vec.f_82479_, this.m_20186_() + vec.f_82480_, this.m_20189_() + vec.f_82481_);
        }
        this.m_20256_(this.m_20184_().m_82520_(0.0, (double)(-this.gravity), 0.0));
        if (this.f_19797_ > (this.fireLevel > 0 ? 10 : 40)) {
            this.m_146870_();
        }
        if (this.fireLevel > 0 && this.dragonBreath && (endVec = this.m_9236_()) instanceof ServerLevel) {
            serverLevel = (ServerLevel)endVec;
            double randomPos2 = (double)this.f_19797_ * 0.08 * (Math.random() - 0.5);
            ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123744_, (this.f_19854_ + this.m_20185_()) / 2.0 + randomPos2, (this.f_19855_ + this.m_20186_()) / 2.0 + randomPos2, (this.f_19856_ + this.m_20189_()) / 2.0 + randomPos2, 0, this.m_20184_().f_82479_, this.m_20184_().f_82480_, this.m_20184_().f_82481_, Math.max(this.m_20184_().m_82553_() - 1.1 * (double)this.f_19797_, 0.2), true);
        }
        if ((randomPos2 = this.m_9236_()) instanceof ServerLevel) {
            serverLevel = (ServerLevel)randomPos2;
            if (VectorTool.isInLiquid((Level)serverLevel, this.m_20182_())) {
                this.m_20256_(this.m_20184_().m_82542_(0.75, 0.75, 0.75));
            }
            if (this.m_20069_()) {
                double l = this.m_20184_().m_82553_();
                for (double i = 0.0; i < l; i += 1.0) {
                    Vec3 startPos = new Vec3(this.f_19854_, this.f_19855_, this.f_19856_);
                    Vec3 pos = startPos.m_82549_(this.m_20184_().m_82541_().m_82490_(i));
                    ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123774_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, 0.0, 0.0, 0.0, 0.001, true);
                }
            }
        }
        this.syncMotion();
    }

    @Override
    public void syncMotion() {
        if (!this.m_9236_().f_46443_) {
            NetworkRegistry.PACKET_HANDLER.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new ClientMotionSyncMessage((Entity)this));
        }
    }

    protected void m_6532_(@Nullable HitResult result) {
        if (result instanceof BlockHitResult) {
            Level level;
            BlockHitResult blockHitResult = (BlockHitResult)result;
            if (blockHitResult.m_6662_() == HitResult.Type.MISS) {
                return;
            }
            BlockPos resultPos = blockHitResult.m_82425_();
            BlockState state = this.m_9236_().m_8055_(resultPos);
            SoundEvent event = state.m_60734_().getSoundType(state, (LevelReader)this.m_9236_(), resultPos, (Entity)this).m_56775_();
            this.m_9236_().m_6263_(null, result.m_82450_().f_82479_, result.m_82450_().f_82480_, result.m_82450_().f_82481_, event, SoundSource.AMBIENT, 1.0f, 1.0f);
            Vec3 hitVec = result.m_82450_();
            this.onHitBlock(hitVec, blockHitResult);
            if (this.explosionDamage > 0.0f) {
                this.explosionBullet((Entity)this, hitVec);
            }
            if (this.fireLevel > 0 && (level = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123756_, hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_, 3, 0.0, 0.0, 0.0, 0.5, true);
            }
        }
        if (result instanceof ExtendedEntityRayTraceResult) {
            Player player;
            ExtendedEntityRayTraceResult entityHitResult = (ExtendedEntityRayTraceResult)result;
            Entity entity = entityHitResult.m_82443_();
            if (entity.m_19879_() == this.shooterId) {
                return;
            }
            Entity entity2 = this.shooter;
            if (entity2 instanceof Player && entity.m_20367_((Entity)(player = (Player)entity2))) {
                return;
            }
            this.onHitEntity(entity, entityHitResult);
            entity.f_19802_ = 0;
        }
    }

    private int getRings(@NotNull Direction direction, @NotNull Vec3 hitVec) {
        double x = Math.abs(Mth.m_14185_((double)hitVec.f_82479_) - 0.5);
        double y = Math.abs(Mth.m_14185_((double)hitVec.f_82480_) - 0.5);
        double z = Math.abs(Mth.m_14185_((double)hitVec.f_82481_) - 0.5);
        Direction.Axis axis = direction.m_122434_();
        double v = axis == Direction.Axis.Y ? Math.max(x, z) : (axis == Direction.Axis.Z ? Math.max(x, y) : Math.max(y, z));
        return Math.max(1, Mth.m_14165_((double)(10.0 * Mth.m_14008_((double)((0.5 - v) / 0.5), (double)0.0, (double)1.0))));
    }

    public void recordHitScore(@NotNull Direction direction, @NotNull Vec3 hitVec) {
        ItemStack stack;
        Entity entity;
        if (this.shooter == null) {
            return;
        }
        int score = this.getRings(direction, hitVec);
        double distance = this.shooter.m_20182_().m_82554_(hitVec);
        Entity entity2 = this.shooter;
        if (!(entity2 instanceof Player)) {
            return;
        }
        Player player = (Player)entity2;
        player.m_5661_((Component)Component.m_237113_((String)String.valueOf(score)).m_7220_((Component)Component.m_237115_((String)"tips.superbwarfare.shoot.rings")).m_7220_((Component)Component.m_237113_((String)(" " + FormatTool.format1D(distance, "m")))), false);
        if (!this.m_9236_().m_5776_() && (entity = this.shooter) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            Holder holder = score == 10 ? Holder.m_205709_((Object)((SoundEvent)ModSounds.HEADSHOT.get())) : Holder.m_205709_((Object)((SoundEvent)ModSounds.INDICATION.get()));
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(holder, SoundSource.PLAYERS, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, 1.0f, player.m_9236_().f_46441_.m_188505_()));
            NetworkRegistry.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new ClientIndicatorMessage(score == 10 ? 1 : 0, 5));
        }
        if ((stack = player.m_21206_()).m_150930_((Item)ModItems.TRANSCRIPT.get())) {
            int size = 10;
            ListTag tags = stack.m_41784_().m_128437_("Scores", 10);
            ArrayDeque<CompoundTag> queue = new ArrayDeque<CompoundTag>();
            for (int i = 0; i < tags.size(); ++i) {
                queue.add(tags.m_128728_(i));
            }
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("Score", score);
            tag.m_128347_("Distance", distance);
            queue.offer(tag);
            while (queue.size() > 10) {
                queue.poll();
            }
            ListTag newTags = new ListTag();
            newTags.addAll(queue);
            stack.m_41784_().m_128365_("Scores", (Tag)newTags);
        }
    }

    protected void onHitWater(Vec3 location, BlockHitResult result) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = result.m_82425_();
            Direction face = result.m_82434_();
            BlockState state = this.m_9236_().m_8055_(pos);
            double vx = face.m_122429_();
            double vy = face.m_122430_();
            double vz = face.m_122431_();
            Vec3 dir = new Vec3(vx, vy, vz).m_82549_(this.m_20184_().m_82541_().m_82490_(-0.1));
            if (state.m_60734_() == Blocks.f_49990_) {
                if (!this.m_20069_()) {
                    CustomCloudOption particleData = new CustomCloudOption(1.0f, 1.0f, 1.0f, 80, 0.5f, 1.0f, false, false);
                    for (int i = 0; i < 10; ++i) {
                        Vec3 vec3 = this.randomVec(dir, 40.0);
                        ParticleTool.sendParticle(serverLevel, particleData, location.f_82479_ + 0.12 * (double)i * dir.f_82479_, location.f_82480_ + 0.12 * (double)i * dir.f_82480_, location.f_82481_ + 0.12 * (double)i * dir.f_82481_, 0, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 15.0, true);
                    }
                    ParticleTool.spawnBulletHitWaterParticles((Level)serverLevel, location);
                    serverLevel.m_5594_(null, new BlockPos((int)location.f_82479_, (int)location.f_82480_, (int)location.f_82481_), (SoundEvent)ModSounds.HIT_WATER.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    double l = this.m_20184_().m_82553_();
                    for (double i = 0.0; i < l; i += 1.0) {
                        Vec3 p = location.m_82549_(this.m_20184_().m_82541_().m_82490_(i));
                        ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123774_, p.f_82479_, p.f_82480_, p.f_82481_, 1, 0.0, 0.0, 0.0, 0.001, false);
                    }
                    this.m_20256_(this.m_20184_().m_82542_(0.1, 0.1, 0.1));
                }
            } else if (state.m_60734_() == Blocks.f_49991_ && !this.m_20077_()) {
                BlockParticleOption particleData = new BlockParticleOption(ParticleTypes.f_123794_, state);
                for (int i = 0; i < 7; ++i) {
                    Vec3 vec3 = this.randomVec(dir, 20.0);
                    ParticleTool.sendParticle(serverLevel, particleData, location.f_82479_ + 0.1 * (double)i * dir.f_82479_, location.f_82480_ + 0.1 * (double)i * dir.f_82480_, location.f_82481_ + 0.1 * (double)i * dir.f_82481_, 0, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 10.0, true);
                }
                ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123756_, location.f_82479_, location.f_82480_, location.f_82481_, 4, 0.0, 0.0, 0.0, 0.6, true);
                serverLevel.m_5594_(null, new BlockPos((int)location.f_82479_, (int)location.f_82480_, (int)location.f_82481_), SoundEvents.f_12032_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.m_146870_();
            }
        }
    }

    protected void onHitBlock(Vec3 location, BlockHitResult result) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = result.m_82425_();
            Direction face = result.m_82434_();
            BlockState state = this.m_9236_().m_8055_(pos);
            if (MinecraftForge.EVENT_BUS.post((Event)new ProjectileHitEvent.HitBlock(pos, state, face, this.shooter, this, result.m_82450_()))) {
                return;
            }
            double vx = face.m_122429_();
            double vy = face.m_122430_();
            double vz = face.m_122431_();
            Vec3 dir = new Vec3(vx, vy, vz);
            if (this.beast) {
                ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123810_, location.f_82479_, location.f_82480_, location.f_82481_, 15, 0.1, 0.1, 0.1, 0.05, true);
            } else {
                BulletDecalOption bulletDecalOption = ((Float)this.f_19804_.m_135370_(COLOR_R)).floatValue() == 1.0f && ((Float)this.f_19804_.m_135370_(COLOR_G)).floatValue() == 0.87058824f && ((Float)this.f_19804_.m_135370_(COLOR_B)).floatValue() == 0.15294118f ? new BulletDecalOption(result.m_82434_(), result.m_82425_()) : new BulletDecalOption(result.m_82434_(), result.m_82425_(), ((Float)this.f_19804_.m_135370_(COLOR_R)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_G)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_B)).floatValue());
                ParticleTool.sendParticle(serverLevel, bulletDecalOption, location.f_82479_, location.f_82480_, location.f_82481_, 1, 0.0, 0.0, 0.0, 0.0, true);
                this.summonVectorParticle(serverLevel, state, location, dir);
                this.m_146870_();
            }
            serverLevel.m_5594_(null, new BlockPos((int)location.f_82479_, (int)location.f_82480_, (int)location.f_82481_), (SoundEvent)ModSounds.LAND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void summonVectorParticle(ServerLevel serverLevel, BlockState state, Vec3 pos, Vec3 dir) {
        Vec3 vec3;
        int i;
        BlockParticleOption particleData = new BlockParticleOption(ParticleTypes.f_123794_, state);
        for (i = 0; i < 7; ++i) {
            vec3 = this.randomVec(dir, 40.0);
            ParticleTool.sendParticle(serverLevel, particleData, pos.f_82479_ + 0.05 * (double)i * dir.f_82479_, pos.f_82480_ + 0.05 * (double)i * dir.f_82480_, pos.f_82481_ + 0.05 * (double)i * dir.f_82481_, 0, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 10.0, true);
        }
        for (i = 0; i < 3; ++i) {
            vec3 = this.randomVec(dir, 20.0);
            ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123762_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0.05, true);
        }
        if (state.m_60827_() == SoundType.f_56743_ || state.m_60827_() == SoundType.f_56749_ || state.m_60827_() == SoundType.f_56728_ || state.m_60827_() == SoundType.f_154663_ || state.m_60827_() == SoundType.f_56725_) {
            serverLevel.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, (SoundEvent)ModSounds.HIT.get(), SoundSource.BLOCKS, 2.0f, 1.0f);
            for (i = 0; i < 3; ++i) {
                vec3 = this.randomVec(dir, 80.0);
                ParticleTool.sendParticle(serverLevel, (SimpleParticleType)ModParticleTypes.FIRE_STAR.get(), pos.f_82479_, pos.f_82480_, pos.f_82481_, 0, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0.2 + 0.1 * Math.random(), true);
            }
        }
    }

    public Vec3 randomVec(Vec3 vec3, double spread) {
        return vec3.m_82541_().m_82520_(this.f_19796_.m_216328_(0.0, 0.0172275 * spread), this.f_19796_.m_216328_(0.0, 0.0172275 * spread), this.f_19796_.m_216328_(0.0, 0.0172275 * spread));
    }

    protected void onHitEntity(Entity entity, ExtendedEntityRayTraceResult result) {
        LivingEntity living;
        if (entity == null) {
            return;
        }
        boolean headshot = result.isHeadshot();
        boolean legShot = result.isLegShot();
        if (MinecraftForge.EVENT_BUS.post((Event)new ProjectileHitEvent.HitEntity(this.shooter, (Projectile)this, result))) {
            return;
        }
        if (entity instanceof PartEntity) {
            PartEntity part = (PartEntity)entity;
            entity = part.getParent();
        }
        if (entity instanceof LivingEntity) {
            living = (LivingEntity)entity;
            living.m_9236_().m_5594_(null, living.m_20097_(), (SoundEvent)ModSounds.MELEE_HIT.get(), SoundSource.PLAYERS, 1.0f, (float)(2.0 * Math.random() - 1.0) * 0.1f + 1.0f);
            if (this.beast) {
                Beast.beastKill(this.shooter, (Entity)living);
                return;
            }
        }
        this.damage *= (float)Mth.m_14008_((double)(this.m_20184_().m_82553_() / (double)this.velocity), (double)0.0, (double)1.0);
        if (headshot) {
            Object object;
            if (!this.m_9236_().m_5776_() && (object = this.shooter) instanceof ServerPlayer) {
                player = (ServerPlayer)object;
                holder = Holder.m_205709_((Object)((SoundEvent)ModSounds.HEADSHOT.get()));
                player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket((Holder)holder, SoundSource.PLAYERS, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, 1.0f, player.m_9236_().f_46441_.m_188505_()));
                NetworkRegistry.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientIndicatorMessage(1, 5));
            }
            this.performOnHit(entity, this.damage, true, this.knockback);
        } else {
            if (!this.m_9236_().m_5776_() && (holder = this.shooter) instanceof ServerPlayer) {
                player = (ServerPlayer)holder;
                holder = Holder.m_205709_((Object)((SoundEvent)ModSounds.INDICATION.get()));
                player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket((Holder)holder, SoundSource.PLAYERS, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, 1.0f, player.m_9236_().f_46441_.m_188505_()));
                NetworkRegistry.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientIndicatorMessage(0, 5));
            }
            if (legShot) {
                if (entity instanceof LivingEntity) {
                    Player player;
                    living = (LivingEntity)entity;
                    if (living instanceof Player && (player = (Player)living).m_7500_()) {
                        return;
                    }
                    if (!living.m_9236_().m_5776_()) {
                        living.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 2, false, false));
                    }
                }
                this.damage *= this.legShot;
            }
            this.performOnHit(entity, this.damage, false, this.knockback);
        }
        if (!this.mobEffects.isEmpty() && entity instanceof LivingEntity) {
            living = (LivingEntity)entity;
            for (MobEffectInstance instance : this.mobEffects) {
                living.m_147207_(instance, this.shooter);
            }
        }
        this.m_146870_();
    }

    public void performOnHit(Entity entity, float damage, boolean headshot, double knockback) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (this.forceKnockback) {
                Vec3 vec3 = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_();
                living.m_246865_(vec3.m_82490_(knockback));
                this.performDamage(entity, damage, headshot);
            } else {
                ICustomKnockback iCustomKnockback = ICustomKnockback.getInstance(living);
                iCustomKnockback.superbWarfare$setKnockbackStrength(knockback);
                this.performDamage(entity, damage, headshot);
                iCustomKnockback.superbWarfare$resetKnockbackStrength();
            }
        } else {
            this.performDamage(entity, damage, headshot);
        }
    }

    protected void explosionBullet(Entity projectile, Vec3 hitVec) {
        new CustomExplosion.Builder(projectile).attacker(this.getShooter()).damage(this.explosionDamage).radius(this.explosionRadius).position(hitVec).explode();
    }

    @Override
    public void setDamage(float damage) {
        this.damage = damage;
    }

    public float getDamage() {
        return this.damage;
    }

    public void shoot(LivingEntity living, double vecX, double vecY, double vecZ, float velocity, float spread) {
        Vec3 vec3 = new Vec3(vecX, vecY, vecZ).m_82541_().m_82520_(this.f_19796_.m_216328_(0.0, 0.0172275 * (double)spread), this.f_19796_.m_216328_(0.0, 0.0172275 * (double)spread), this.f_19796_.m_216328_(0.0, 0.0172275 * (double)spread)).m_82490_((double)velocity);
        this.m_20256_(vec3);
        double d0 = vec3.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    public static BlockHitResult rayTraceBlocks(Level world, ClipContext context, Predicate<BlockState> ignorePredicate) {
        return ProjectileEntity.performRayTrace(context, (rayTraceContext, blockPos) -> {
            BlockState blockState = world.m_8055_(blockPos);
            if (ignorePredicate.test(blockState)) {
                return null;
            }
            FluidState fluidState = world.m_6425_(blockPos);
            Vec3 startVec = rayTraceContext.m_45702_();
            Vec3 endVec = rayTraceContext.m_45693_();
            VoxelShape blockShape = rayTraceContext.m_45694_(blockState, (BlockGetter)world, blockPos);
            BlockHitResult blockResult = world.m_45558_(startVec, endVec, blockPos, blockShape, blockState);
            VoxelShape fluidShape = rayTraceContext.m_45698_(fluidState, (BlockGetter)world, blockPos);
            BlockHitResult fluidResult = fluidShape.m_83220_(startVec, endVec, blockPos);
            double blockDistance = blockResult == null ? Double.MAX_VALUE : rayTraceContext.m_45702_().m_82557_(blockResult.m_82450_());
            double fluidDistance = fluidResult == null ? Double.MAX_VALUE : rayTraceContext.m_45702_().m_82557_(fluidResult.m_82450_());
            return blockDistance <= fluidDistance ? blockResult : fluidResult;
        }, rayTraceContext -> {
            Vec3 Vector3d2 = rayTraceContext.m_45702_().m_82546_(rayTraceContext.m_45693_());
            return BlockHitResult.m_82426_((Vec3)rayTraceContext.m_45693_(), (Direction)Direction.m_122366_((double)Vector3d2.f_82479_, (double)Vector3d2.f_82480_, (double)Vector3d2.f_82481_), (BlockPos)BlockPos.m_274446_((Position)rayTraceContext.m_45693_()));
        });
    }

    private static <T> T performRayTrace(ClipContext context, BiFunction<ClipContext, BlockPos, T> hitFunction, Function<ClipContext, T> p_217300_2_) {
        Vec3 endVec;
        Vec3 startVec = context.m_45702_();
        if (!startVec.equals((Object)(endVec = context.m_45693_()))) {
            int blockZ;
            int blockY;
            double startX = Mth.m_14139_((double)-1.0E-7, (double)endVec.f_82479_, (double)startVec.f_82479_);
            double startY = Mth.m_14139_((double)-1.0E-7, (double)endVec.f_82480_, (double)startVec.f_82480_);
            double startZ = Mth.m_14139_((double)-1.0E-7, (double)endVec.f_82481_, (double)startVec.f_82481_);
            double endX = Mth.m_14139_((double)-1.0E-7, (double)startVec.f_82479_, (double)endVec.f_82479_);
            double endY = Mth.m_14139_((double)-1.0E-7, (double)startVec.f_82480_, (double)endVec.f_82480_);
            double endZ = Mth.m_14139_((double)-1.0E-7, (double)startVec.f_82481_, (double)endVec.f_82481_);
            int blockX = Mth.m_14107_((double)endX);
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(blockX, blockY = Mth.m_14107_((double)endY), blockZ = Mth.m_14107_((double)endZ));
            T t = hitFunction.apply(context, (BlockPos)mutablePos);
            if (t != null) {
                return t;
            }
            double deltaX = startX - endX;
            double deltaY = startY - endY;
            double deltaZ = startZ - endZ;
            int signX = Mth.m_14205_((double)deltaX);
            int signY = Mth.m_14205_((double)deltaY);
            int signZ = Mth.m_14205_((double)deltaZ);
            double d9 = signX == 0 ? Double.MAX_VALUE : (double)signX / deltaX;
            double d10 = signY == 0 ? Double.MAX_VALUE : (double)signY / deltaY;
            double d11 = signZ == 0 ? Double.MAX_VALUE : (double)signZ / deltaZ;
            double d12 = d9 * (signX > 0 ? 1.0 - Mth.m_14185_((double)endX) : Mth.m_14185_((double)endX));
            double d13 = d10 * (signY > 0 ? 1.0 - Mth.m_14185_((double)endY) : Mth.m_14185_((double)endY));
            double d14 = d11 * (signZ > 0 ? 1.0 - Mth.m_14185_((double)endZ) : Mth.m_14185_((double)endZ));
            while (d12 <= 1.0 || d13 <= 1.0 || d14 <= 1.0) {
                T t1;
                if (d12 < d13) {
                    if (d12 < d14) {
                        blockX += signX;
                        d12 += d9;
                    } else {
                        blockZ += signZ;
                        d14 += d11;
                    }
                } else if (d13 < d14) {
                    blockY += signY;
                    d13 += d10;
                } else {
                    blockZ += signZ;
                    d14 += d11;
                }
                if ((t1 = hitFunction.apply(context, (BlockPos)mutablePos.m_122178_(blockX, blockY, blockZ))) == null) continue;
                return t1;
            }
        }
        return p_217300_2_.apply(context);
    }

    @Nullable
    public Entity getShooter() {
        return this.shooter;
    }

    public int getShooterId() {
        return this.shooterId;
    }

    public float getBypassArmorRate() {
        return this.bypassArmorRate;
    }

    public void updateHeading() {
        double horizontalDistance = this.m_20184_().m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)this.m_20184_().m_7096_(), (double)this.m_20184_().m_7094_()) * 57.29577951308232));
        this.m_146926_((float)(Mth.m_14136_((double)this.m_20184_().m_7098_(), (double)horizontalDistance) * 57.29577951308232));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    private void performDamage(Entity entity, float damage, boolean isHeadshot) {
        float headShotModifier;
        float rate = Mth.m_14036_((float)this.bypassArmorRate, (float)0.0f, (float)1.0f);
        float normalDamage = damage * Mth.m_14036_((float)(1.0f - rate), (float)0.0f, (float)1.0f);
        float absoluteDamage = damage * Mth.m_14036_((float)rate, (float)0.0f, (float)1.0f);
        entity.f_19802_ = 0;
        float f = headShotModifier = isHeadshot ? this.headShot : 1.0f;
        if (absoluteDamage > 0.0f) {
            DamageHandler.doDamage(entity, isHeadshot ? ModDamageTypes.causeGunFireHeadshotAbsoluteDamage(this.m_9236_().m_9598_(), (Entity)this, this.shooter) : ModDamageTypes.causeGunFireAbsoluteDamage(this.m_9236_().m_9598_(), (Entity)this, this.shooter), absoluteDamage * headShotModifier);
            entity.f_19802_ = 0;
            if (entity instanceof VehicleEntity) {
                VehicleEntity vehicle = (VehicleEntity)entity;
                if (this.bypassArmorRate > 1.0f) {
                    vehicle.m_6469_(ModDamageTypes.causeGunFireAbsoluteDamage(this.m_9236_().m_9598_(), (Entity)this, this.shooter), absoluteDamage * (this.bypassArmorRate - 1.0f) * 0.5f);
                }
            }
        }
        if (normalDamage > 0.0f) {
            entity.m_6469_(isHeadshot ? ModDamageTypes.causeGunFireHeadshotDamage(this.m_9236_().m_9598_(), (Entity)this, this.shooter) : ModDamageTypes.causeGunFireDamage(this.m_9236_().m_9598_(), (Entity)this, this.shooter), normalDamage * headShotModifier);
            entity.f_19802_ = 0;
        }
    }

    @Override
    public void setGravity(float gravity) {
        this.gravity = gravity;
    }

    @Override
    public void setExplosionDamage(float explosionDamage) {
        this.explosionDamage = explosionDamage;
    }

    @Override
    public void setExplosionRadius(float radius) {
        this.explosionRadius = radius;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean isZoom() {
        return this.zoom;
    }

    @Nullable
    public String getGunItemId() {
        return this.gunItemId;
    }

    public boolean isPenetrating() {
        return this.penetrating;
    }

    public void setPenetrating(boolean penetrating) {
        this.penetrating = penetrating;
    }

    public ProjectileEntity shooter(@Nullable Entity shooter) {
        this.shooter = shooter;
        return this;
    }

    public ProjectileEntity damage(float damage) {
        this.damage = damage;
        return this;
    }

    public ProjectileEntity velocity(float velocity) {
        this.velocity = velocity;
        return this;
    }

    public ProjectileEntity headShot(float headShot) {
        this.headShot = headShot;
        return this;
    }

    public ProjectileEntity legShot(float legShot) {
        this.legShot = legShot;
        return this;
    }

    public ProjectileEntity beast() {
        this.beast = true;
        return this;
    }

    public ProjectileEntity fireBullet(int fireLevel, boolean dragonBreath) {
        this.fireLevel = fireLevel;
        this.dragonBreath = dragonBreath;
        return this;
    }

    public ProjectileEntity zoom(boolean zoom) {
        this.zoom = zoom;
        return this;
    }

    public ProjectileEntity bypassArmorRate(float bypassArmorRate) {
        this.bypassArmorRate = bypassArmorRate;
        return this;
    }

    public ProjectileEntity effect(ArrayList<MobEffectInstance> mobEffectInstances) {
        this.mobEffects.addAll(mobEffectInstances);
        return this;
    }

    public void setRGB(float[] rgb) {
        this.f_19804_.m_135381_(COLOR_R, (Object)Float.valueOf(rgb[0]));
        this.f_19804_.m_135381_(COLOR_G, (Object)Float.valueOf(rgb[1]));
        this.f_19804_.m_135381_(COLOR_B, (Object)Float.valueOf(rgb[2]));
    }

    public ProjectileEntity knockback(float knockback) {
        this.knockback = knockback;
        return this;
    }

    public ProjectileEntity forceKnockback() {
        this.forceKnockback = true;
        return this;
    }

    public ProjectileEntity setGunItemId(ItemStack stack) {
        this.gunItemId = stack.m_41778_();
        return this;
    }

    public ProjectileEntity setGunItemId(String id) {
        this.gunItemId = id;
        return this;
    }
}

