/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.entity.projectile.CustomSyncMotionEntity;
import com.atsuishio.superbwarfare.entity.projectile.DestroyableProjectile;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import org.jetbrains.annotations.NotNull;

public abstract class MissileProjectile
extends DestroyableProjectile
implements CustomSyncMotionEntity,
IEntityAdditionalSpawnData {
    public static final EntityDataAccessor<String> TARGET_UUID = SynchedEntityData.m_135353_(MissileProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public Vec3 targetPos;
    public int guideType = 0;
    public boolean distracted = false;
    public boolean lost = false;
    public boolean lostTarget = false;

    public MissileProjectile(EntityType<? extends ThrowableItemProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public MissileProjectile(EntityType<? extends ThrowableItemProjectile> pEntityType, @Nullable Entity pShooter, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_5602_(pShooter);
        if (pShooter != null) {
            this.m_6034_(pShooter.m_20185_(), pShooter.m_20188_() - (double)0.1f, pShooter.m_20189_());
        }
    }

    public void setTargetUuid(String uuid) {
        this.f_19804_.m_135381_(TARGET_UUID, (Object)uuid);
    }

    public void setGuideType(int guideType) {
        this.guideType = guideType;
    }

    public void setTargetVec(Vec3 targetPos) {
        if (targetPos != null) {
            this.targetPos = targetPos;
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TARGET_UUID, (Object)"none");
    }

    @Override
    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("TargetUuid")) {
            this.f_19804_.m_135381_(TARGET_UUID, (Object)compound.m_128461_("TargetUuid"));
        }
    }

    @Override
    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("TargetUuid", (String)this.f_19804_.m_135370_(TARGET_UUID));
    }

    protected void m_37283_() {
    }

    public void turn(Vec3 vec3, float turnSpeed) {
        Vec3 v0 = this.m_20184_().m_82541_();
        vec3 = vec3.m_82549_(v0.m_82490_(-0.4));
        double d0 = vec3.m_165924_();
        float targetAngleY = (float)(-Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875);
        float targetAngleX = (float)(-Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875);
        float diffY = Mth.m_14177_((float)(targetAngleY - this.m_146908_()));
        float diffX = Mth.m_14177_((float)(targetAngleX - this.m_146909_()));
        this.m_146922_(this.m_146908_() + Mth.m_14036_((float)(0.95f * diffY), (float)(-turnSpeed), (float)turnSpeed));
        this.m_146926_(this.m_146909_() + Mth.m_14036_((float)(0.95f * diffX), (float)(-turnSpeed), (float)turnSpeed));
    }

    public void m_6686_(double pX, double pY, double pZ, float pVelocity, float pInaccuracy) {
        Vec3 vec3 = new Vec3(pX, pY, pZ).m_82541_().m_82520_(this.f_19796_.m_216328_(0.0, 0.0172275 * (double)pInaccuracy), this.f_19796_.m_216328_(0.0, 0.0172275 * (double)pInaccuracy), this.f_19796_.m_216328_(0.0, 0.0172275 * (double)pInaccuracy)).m_82490_((double)pVelocity);
        this.m_20256_(vec3);
        double d0 = vec3.m_165924_();
        this.m_146922_((float)(-Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(-Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    @Override
    public boolean shouldSyncMotion() {
        return true;
    }

    @Override
    public boolean forceLoadChunk() {
        return true;
    }

    public boolean m_20068_() {
        return true;
    }

    @Override
    public float m_7139_() {
        return 0.0f;
    }
}

