/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.entity.projectile.FastThrowableProjectile;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.NetworkRegistry;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.ProjectileTool;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GunGrenadeEntity
extends FastThrowableProjectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public GunGrenadeEntity(EntityType<? extends GunGrenadeEntity> type, Level world) {
        super(type, world);
        this.f_19811_ = true;
    }

    public GunGrenadeEntity(@Nullable Entity entity, Level level, float damage, float explosionDamage, float explosionRadius) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntities.GUN_GRENADE.get()), entity, level);
        this.f_19811_ = true;
        this.damage = damage;
        this.explosionDamage = explosionDamage;
        this.explosionRadius = explosionRadius;
    }

    @NotNull
    protected Item m_7881_() {
        return (Item)ModItems.GRENADE_40MM.get();
    }

    @Override
    protected void m_5790_(@NotNull EntityHitResult result) {
        LivingEntity living;
        super.m_5790_(result);
        Entity entity = result.m_82443_();
        if (this.m_19749_() != null && this.m_19749_().m_20202_() != null && entity == this.m_19749_().m_20202_()) {
            return;
        }
        Entity entity2 = this.m_19749_();
        if (entity2 instanceof LivingEntity && !(living = (LivingEntity)entity2).m_9236_().m_5776_() && living instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)living;
            living.m_9236_().m_5594_(null, living.m_20183_(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 1.0f, 1.0f);
            NetworkRegistry.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientIndicatorMessage(0, 5));
        }
        DamageHandler.doDamage(entity, ModDamageTypes.causeProjectileHitDamage(this.m_9236_().m_9598_(), (Entity)this, this.m_19749_()), this.damage);
        if (entity instanceof LivingEntity) {
            entity.f_19802_ = 0;
        }
        if (this.f_19797_ > 0 && this.m_9236_() instanceof ServerLevel) {
            ProjectileTool.causeCustomExplode((ThrowableItemProjectile)this, ModDamageTypes.causeProjectileExplosionDamage(this.m_9236_().m_9598_(), (Entity)this, this.m_19749_()), entity, this.explosionDamage, this.explosionRadius);
        }
        this.m_146870_();
    }

    @Override
    public void m_8060_(@NotNull BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        BlockPos resultPos = blockHitResult.m_82425_();
        BlockState state = this.m_9236_().m_8055_(resultPos);
        Block block = state.m_60734_();
        if (block instanceof BellBlock) {
            BellBlock bell = (BellBlock)block;
            bell.m_49712_(this.m_9236_(), resultPos, blockHitResult.m_82434_());
        }
        if (this.m_9236_() instanceof ServerLevel) {
            ProjectileTool.causeCustomExplode((ThrowableItemProjectile)this, ModDamageTypes.causeProjectileExplosionDamage(this.m_9236_().m_9598_(), (Entity)this, this.m_19749_()), (Entity)this, this.explosionDamage, this.explosionRadius);
        }
        this.m_146870_();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.smallTrail();
        if (this.f_19797_ > 200 || this.m_20069_()) {
            if (this.m_9236_() instanceof ServerLevel) {
                ProjectileTool.causeCustomExplode((ThrowableItemProjectile)this, ModDamageTypes.causeProjectileExplosionDamage(this.m_9236_().m_9598_(), (Entity)this, this.m_19749_()), (Entity)this, this.explosionDamage, this.explosionRadius);
            }
            this.m_146870_();
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public boolean isFastMoving() {
        return false;
    }
}

