/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.entity.SenpaiEntity;
import com.atsuishio.superbwarfare.entity.projectile.PtkmProjectileEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Ptkm1rEntity
extends Entity
implements GeoEntity,
OwnableEntity {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(Ptkm1rEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<String> LAST_ATTACKER_UUID = SynchedEntityData.m_135353_(Ptkm1rEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Float> HEALTH = SynchedEntityData.m_135353_(Ptkm1rEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<String> TARGET_UUID = SynchedEntityData.m_135353_(Ptkm1rEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int aimingTime;
    private static final DamageModifier DAMAGE_MODIFIER = DamageModifier.createDefaultModifier().multiply(0.02f, ModDamageTypes.CUSTOM_EXPLOSION).multiply(0.02f, ModDamageTypes.MINE).multiply(0.02f, ModDamageTypes.PROJECTILE_EXPLOSION).multiply(0.02f, (ResourceKey<DamageType>)DamageTypes.f_268565_);

    public Ptkm1rEntity(EntityType<Ptkm1rEntity> type, Level world) {
        super(type, world);
    }

    public Ptkm1rEntity(LivingEntity owner, Level level) {
        super((EntityType)ModEntities.PTKM_1R.get(), level);
        if (owner != null) {
            this.setOwnerUUID(owner.m_20148_());
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(LAST_ATTACKER_UUID, (Object)"undefined");
        this.f_19804_.m_135372_(TARGET_UUID, (Object)"undefined");
        this.f_19804_.m_135372_(HEALTH, (Object)Float.valueOf(40.0f));
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        amount = DAMAGE_MODIFIER.compute(source, amount);
        if (source.m_7639_() != null) {
            this.f_19804_.m_135381_(LAST_ATTACKER_UUID, (Object)source.m_7639_().m_20149_());
        }
        this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(HEALTH)).floatValue() - amount));
        return super.m_6469_(source, amount);
    }

    public void setOwnerUUID(@Nullable UUID pUuid) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.ofNullable(pUuid));
    }

    @Nullable
    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).orElse(null);
    }

    public boolean isOwnedBy(LivingEntity pEntity) {
        return pEntity == this.m_269323_();
    }

    protected float m_6380_(@NotNull Pose pPose, @NotNull EntityDimensions pSize) {
        return 0.2f;
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128350_("Health", ((Float)this.f_19804_.m_135370_(HEALTH)).floatValue());
        compound.m_128359_("LastAttacker", (String)this.f_19804_.m_135370_(LAST_ATTACKER_UUID));
        compound.m_128359_("Target", (String)this.f_19804_.m_135370_(TARGET_UUID));
        if (this.m_21805_() != null) {
            compound.m_128362_("Owner", this.m_21805_());
        }
    }

    public void m_7378_(CompoundTag compound) {
        UUID uuid;
        if (compound.m_128441_("Health")) {
            this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(compound.m_128457_("Health")));
        }
        if (compound.m_128441_("LastAttacker")) {
            this.f_19804_.m_135381_(LAST_ATTACKER_UUID, (Object)compound.m_128461_("LastAttacker"));
        }
        if (compound.m_128441_("Target")) {
            this.f_19804_.m_135381_(TARGET_UUID, (Object)compound.m_128461_("Target"));
        }
        if (compound.m_128403_("Owner")) {
            uuid = compound.m_128342_("Owner");
        } else {
            String s = compound.m_128461_("Owner");
            try {
                uuid = this.m_20194_() == null ? UUID.fromString(s) : OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
            }
            catch (Exception exception) {
                Mod.LOGGER.error("Couldn't load owner UUID of {}: {}", (Object)this, (Object)exception);
                uuid = null;
            }
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (this.isOwnedBy((LivingEntity)player) && player.m_6144_()) {
            if (!this.m_9236_().m_5776_()) {
                this.m_146870_();
            }
            if (!player.m_150110_().f_35937_) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)ModItems.PTKM_1R.get()));
            }
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        if (!this.m_9236_().m_45772_(this.m_20191_())) {
            this.m_20314_(this.m_20185_(), (this.m_20191_().f_82289_ + this.m_20191_().f_82292_) / 2.0, this.m_20189_());
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        float f = 0.98f;
        if (this.m_20096_()) {
            BlockPos pos = this.m_20099_();
            f = this.m_9236_().m_8055_(pos).getFriction((LevelReader)this.m_9236_(), pos, (Entity)this) * 0.98f;
        }
        this.m_20256_(this.m_20184_().m_82542_((double)f, 0.98, (double)f));
        if (this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, -0.9, 1.0));
        }
        if (((Float)this.f_19804_.m_135370_(HEALTH)).floatValue() <= 0.0f) {
            this.triggerExplode();
        }
        if (this.f_19797_ == 1) {
            this.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)this.m_20182_()), (SoundEvent)ModSounds.PTKM_1R_DEPLOY.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if (this.f_19797_ > 20 && this.m_20096_()) {
            this.findTarget();
        }
        this.m_6210_();
    }

    public void findTarget() {
        int range = 40;
        Entity target = null;
        List<Entity> list = new SeekTool.Builder(this).withinRange(range).build();
        for (Entity entity : list) {
            Player player;
            boolean condition;
            boolean bl = condition = entity.m_20096_() && this.m_269323_() != entity && (!(entity instanceof Player) || !(player = (Player)entity).m_7500_() && !player.m_5833_()) && this.m_269323_() != null && !SeekTool.IS_FRIENDLY.test((Entity)this.m_269323_(), entity) && entity != this.m_269323_().m_20202_() && !entity.m_6144_() && (entity.m_20191_().m_82309_() > 1.5 || entity instanceof VehicleEntity || entity instanceof SenpaiEntity) && entity.m_20184_().m_82556_() > 0.009;
            if (!condition) continue;
            target = entity;
            break;
        }
        if (target != null) {
            float targetXRot;
            double distance = target.m_20270_((Entity)this);
            if (distance < (double)range) {
                targetXRot = -40.0f;
                this.look(target.m_20182_());
                if (distance < (double)(range - 5)) {
                    ++this.aimingTime;
                } else if (this.aimingTime > 0) {
                    --this.aimingTime;
                }
            } else {
                this.m_146926_(0.0f);
                targetXRot = 0.0f;
            }
            float diffX = Math.clamp((float)-60.0f, (float)60.0f, (float)Mth.m_14177_((float)(targetXRot - this.m_146909_())));
            this.m_146926_(this.m_146909_() + 0.25f * diffX);
            if (this.aimingTime > 10) {
                this.shoot(target, distance);
            }
        } else if (this.aimingTime > 0) {
            --this.aimingTime;
        }
    }

    private void shoot(Entity entity, double distance) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PtkmProjectileEntity ptkmProjectile = new PtkmProjectileEntity(this.m_269323_(), (Level)serverLevel);
            ptkmProjectile.setDamage(500.0f);
            ptkmProjectile.setExplosionDamage(80.0f);
            ptkmProjectile.setExplosionRadius(7.0f);
            ptkmProjectile.setTarget(entity);
            ptkmProjectile.setShootTime((int)(0.5 * distance));
            ptkmProjectile.m_6034_(this.m_20182_().f_82479_, this.m_146892_().f_82480_, this.m_20182_().f_82481_);
            ptkmProjectile.m_6686_(this.m_20154_().f_82479_, this.m_20154_().f_82480_, this.m_20154_().f_82481_, 4.0f, 0.4f);
            serverLevel.m_7967_((Entity)ptkmProjectile);
            int count = 6;
            for (float i = 1.0f; i < 8.0f; i += 0.5f) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123777_, this.m_20182_().f_82479_ + (double)i * this.m_20154_().f_82479_, this.m_146892_().f_82480_ + (double)i * this.m_20154_().f_82480_, this.m_20182_().f_82481_ + (double)i * this.m_20154_().f_82481_, Mth.m_14045_((int)count--, (int)1, (int)3), 0.15, 0.15, 0.15, 0.0025);
            }
            ParticleTool.spawnSmallExplosionParticles((Level)serverLevel, this.m_20182_());
            this.m_146870_();
        }
    }

    public void look(Vec3 pTarget) {
        Vec3 vec3 = EntityAnchorArgument.Anchor.EYES.m_90377_((Entity)this);
        double d0 = (pTarget.f_82479_ - vec3.f_82479_) * 0.2;
        double d2 = (pTarget.f_82481_ - vec3.f_82481_) * 0.2;
        float diffY = Mth.m_14177_((float)(Mth.m_14177_((float)((float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f)) - this.m_146908_()));
        this.m_146922_(this.m_146908_() + 0.5f * diffY);
    }

    private void triggerExplode() {
        new CustomExplosion.Builder(this).damage(100.0f).radius(6.0f).attacker((Entity)this.m_269323_()).withParticleType(ParticleTool.ParticleType.HUGE).explode();
        this.m_146870_();
    }

    private PlayState movementPredicate(AnimationState<Ptkm1rEntity> event) {
        if (this.m_20096_()) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.ptkm.deploy"));
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

