/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Blu43Entity
extends Entity
implements GeoEntity,
OwnableEntity {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(Blu43Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<String> LAST_ATTACKER_UUID = SynchedEntityData.m_135353_(Blu43Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Float> HEALTH = SynchedEntityData.m_135353_(Blu43Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final DamageModifier DAMAGE_MODIFIER = DamageModifier.createDefaultModifier().multiply(0.02f, ModDamageTypes.CUSTOM_EXPLOSION).multiply(0.02f, ModDamageTypes.MINE).multiply(0.02f, ModDamageTypes.PROJECTILE_EXPLOSION).multiply(0.02f, (ResourceKey<DamageType>)DamageTypes.f_268565_);

    public Blu43Entity(EntityType<Blu43Entity> type, Level world) {
        super(type, world);
    }

    public Blu43Entity(LivingEntity owner, Level level) {
        super((EntityType)ModEntities.BLU_43.get(), level);
        if (owner != null) {
            this.setOwnerUUID(owner.m_20148_());
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(LAST_ATTACKER_UUID, (Object)"undefined");
        this.f_19804_.m_135372_(HEALTH, (Object)Float.valueOf(5.0f));
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        amount = DAMAGE_MODIFIER.compute(source, amount);
        if (source.m_7639_() != null) {
            this.f_19804_.m_135381_(LAST_ATTACKER_UUID, (Object)source.m_7639_().m_20149_());
        }
        this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(HEALTH)).floatValue() - amount));
        return super.m_6469_(source, amount);
    }

    public void setOwnerUUID(@Nullable UUID pUuid) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.ofNullable(pUuid));
    }

    @Nullable
    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).orElse(null);
    }

    public boolean isOwnedBy(LivingEntity pEntity) {
        return pEntity == this.m_269323_();
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128350_("Health", ((Float)this.f_19804_.m_135370_(HEALTH)).floatValue());
        compound.m_128359_("LastAttacker", (String)this.f_19804_.m_135370_(LAST_ATTACKER_UUID));
        if (this.m_21805_() != null) {
            compound.m_128362_("Owner", this.m_21805_());
        }
    }

    public void m_7378_(CompoundTag compound) {
        UUID uuid;
        if (compound.m_128441_("Health")) {
            this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(compound.m_128457_("Health")));
        }
        if (compound.m_128441_("LastAttacker")) {
            this.f_19804_.m_135381_(LAST_ATTACKER_UUID, (Object)compound.m_128461_("LastAttacker"));
        }
        if (compound.m_128403_("Owner")) {
            uuid = compound.m_128342_("Owner");
        } else {
            String s = compound.m_128461_("Owner");
            try {
                uuid = this.m_20194_() == null ? UUID.fromString(s) : OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
            }
            catch (Exception exception) {
                Mod.LOGGER.error("Couldn't load owner UUID of {}: {}", (Object)this, (Object)exception);
                uuid = null;
            }
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @NotNull
    public InteractionResult m_6096_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (this.isOwnedBy((LivingEntity)player) && player.m_6144_()) {
            if (!this.m_9236_().m_5776_()) {
                this.m_146870_();
            }
            if (!player.m_150110_().f_35937_) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)ModItems.BLU_43_MINE.get()));
            }
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ >= 20 && this.m_20096_()) {
            this.touchEntity();
        }
        this.m_20256_(this.m_20184_().m_82520_(0.0, -0.03, 0.0));
        if (!this.m_9236_().m_45772_(this.m_20191_())) {
            this.m_20314_(this.m_20185_(), (this.m_20191_().f_82289_ + this.m_20191_().f_82292_) / 2.0, this.m_20189_());
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        float f = 0.98f;
        if (this.m_20096_()) {
            BlockPos pos = this.m_20099_();
            f = this.m_9236_().m_8055_(pos).getFriction((LevelReader)this.m_9236_(), pos, (Entity)this) * 0.98f;
        }
        this.m_20256_(this.m_20184_().m_82542_((double)f, 0.98, (double)f));
        if (this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, -0.9, 1.0));
        }
        if (((Float)this.f_19804_.m_135370_(HEALTH)).floatValue() <= 0.0f) {
            this.triggerExplode();
        }
        this.m_6210_();
    }

    public void touchEntity() {
        if (this.m_9236_() instanceof ServerLevel) {
            AABB frontBox = this.m_20191_().m_82400_(0.2);
            boolean trigger = false;
            List entities = this.m_9236_().m_142425_(EntityTypeTest.m_156916_(Entity.class), frontBox, entity -> entity != this && !(entity instanceof HangingEntity) && entity.m_20191_().m_82309_() > 0.4).stream().toList();
            for (Entity entity2 : entities) {
                ArmorItem armorItem;
                Item item;
                if (entity2 == null) continue;
                trigger = true;
                if (entity2.m_9236_().m_5776_() || !(entity2 instanceof LivingEntity)) break;
                LivingEntity living = (LivingEntity)entity2;
                int baseAmplifier = 3;
                int baseDuration = 600;
                ItemStack boot = living.m_6844_(EquipmentSlot.FEET);
                ItemStack leggings = living.m_6844_(EquipmentSlot.LEGS);
                if (!boot.m_41619_()) {
                    --baseAmplifier;
                    baseDuration -= 100;
                    item = boot.m_41720_();
                    if (item instanceof ArmorItem) {
                        armorItem = (ArmorItem)item;
                        baseDuration -= armorItem.m_40404_() * 10;
                    }
                }
                if (!leggings.m_41619_()) {
                    --baseAmplifier;
                    baseDuration -= 100;
                    item = leggings.m_41720_();
                    if (item instanceof ArmorItem) {
                        armorItem = (ArmorItem)item;
                        baseDuration -= armorItem.m_40404_() * 10;
                    }
                }
                living.m_147207_(new MobEffectInstance(MobEffects.f_19597_, Math.max(baseDuration, 20), baseAmplifier, false, false), (Entity)this.m_269323_());
                living.m_147207_(new MobEffectInstance(MobEffects.f_19613_, Math.max(baseDuration, 20), baseAmplifier, false, false), (Entity)this.m_269323_());
                living.m_147207_(new MobEffectInstance(MobEffects.f_19610_, 30, 0, false, false), (Entity)this.m_269323_());
                break;
            }
            if (trigger) {
                this.triggerExplode();
            }
        }
    }

    private void triggerExplode() {
        new CustomExplosion.Builder(this).attacker((Entity)this.m_269323_()).damage(10.0f).radius(2.0f).keepBlock().withParticleType(ParticleTool.ParticleType.SMALL).explode();
        this.m_146870_();
    }

    public boolean m_6094_() {
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void shoot(double pX, double pY, double pZ, float pVelocity, float pInaccuracy) {
        Vec3 vec3 = new Vec3(pX, pY, pZ).m_82541_().m_82520_(this.f_19796_.m_216328_(0.0, 0.0172275 * (double)pInaccuracy), this.f_19796_.m_216328_(0.0, 0.0172275 * (double)pInaccuracy), this.f_19796_.m_216328_(0.0, 0.0172275 * (double)pInaccuracy)).m_82490_((double)pVelocity);
        this.m_20256_(vec3);
    }
}

