/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.data.DataLoader;
import com.atsuishio.superbwarfare.data.IDBasedData;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class ComplexJsonResourceReloadListener
extends SimplePreparableReloadListener<Object> {
    private final Map<String, DataLoader.GeneralData<?>> data;
    private static final Object NULL = new Object();

    public ComplexJsonResourceReloadListener(Map<String, DataLoader.GeneralData<?>> data) {
        this.data = data;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    protected Object m_5944_(ResourceManager resourceManager, ProfilerFiller profiler) {
        this.data.forEach((name, value) -> {
            HashMap<String, Object> map = value.data();
            map.clear();
            FileToIdConverter converter = FileToIdConverter.m_246568_((String)name);
            for (Map.Entry entry : converter.m_247457_(resourceManager).entrySet()) {
                ResourceLocation resourcelocation = (ResourceLocation)entry.getKey();
                ResourceLocation pathLocation = converter.m_245273_(resourcelocation);
                try {
                    BufferedReader reader = ((Resource)entry.getValue()).m_215508_();
                    try {
                        String id;
                        IDBasedData IDData;
                        Object data = DataLoader.GSON.fromJson((Reader)reader, value.type());
                        if (data instanceof IDBasedData && !(IDData = (IDBasedData)data).getId().isEmpty()) {
                            id = IDData.getId();
                        } else {
                            id = pathLocation.toString();
                            Mod.LOGGER.warn("{} ID for {} is empty, try using {} as id", name, (Object)id, (Object)pathLocation);
                        }
                        map.put(id, data);
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
                catch (JsonParseException | IOException | IllegalArgumentException exception) {
                    Mod.LOGGER.error("Couldn't parse data file {} from {}", (Object)pathLocation, (Object)resourcelocation, (Object)exception);
                }
            }
            if (value.onReload() != null) {
                value.onReload().accept(map);
            }
        });
        return NULL;
    }

    @ParametersAreNonnullByDefault
    protected void m_5787_(Object obj, ResourceManager resourceManager, ProfilerFiller profiler) {
    }
}

