/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.tooltip;

import com.atsuishio.superbwarfare.client.tooltip.component.GunImageComponent;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ClientChargingStationImageTooltip
implements ClientTooltipComponent {
    protected final int width;
    protected final int height;
    protected final ItemStack stack;

    public ClientChargingStationImageTooltip(GunImageComponent tooltip) {
        this.width = tooltip.width;
        this.height = tooltip.height;
        this.stack = tooltip.stack;
    }

    public void m_183452_(@NotNull Font font, int x, int y, GuiGraphics guiGraphics) {
        guiGraphics.m_280168_().m_85836_();
        this.renderEnergyTooltip(font, guiGraphics, x, y);
        guiGraphics.m_280168_().m_85849_();
    }

    protected void renderEnergyTooltip(Font font, GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.m_280430_(font, this.getEnergyComponent(), x, y, 0xFFFFFF);
    }

    protected Component getEnergyComponent() {
        int i;
        CompoundTag tag = BlockItem.m_186336_((ItemStack)this.stack);
        int energy = tag == null ? 0 : tag.m_128451_("Energy");
        int maxEnergy = 4000000;
        float percentage = Mth.m_14036_((float)((float)energy / (float)maxEnergy), (float)0.0f, (float)1.0f);
        MutableComponent component = Component.m_237119_();
        ChatFormatting format = percentage <= 0.2f ? ChatFormatting.RED : (percentage <= 0.6f ? ChatFormatting.YELLOW : ChatFormatting.GREEN);
        int count = (int)(percentage * 50.0f);
        for (i = 0; i < count; ++i) {
            component.m_7220_((Component)Component.m_237113_((String)"|").m_130940_(format));
        }
        component.m_7220_((Component)Component.m_237119_().m_130940_(ChatFormatting.RESET));
        for (i = 0; i < 50 - count; ++i) {
            component.m_7220_((Component)Component.m_237113_((String)"|").m_130940_(ChatFormatting.GRAY));
        }
        component.m_7220_((Component)Component.m_237113_((String)(" " + energy + "/" + maxEnergy + " FE")).m_130940_(ChatFormatting.GRAY));
        return component;
    }

    public int m_142103_() {
        return Math.max(20, this.height) - 10;
    }

    public int m_142069_(@NotNull Font font) {
        if (Screen.m_96638_()) {
            return Math.max(this.width, 20);
        }
        return 20;
    }
}

