/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.screens.modsell;

import com.atsuishio.superbwarfare.client.screens.modsell.TranslationRecord;
import com.atsuishio.superbwarfare.config.client.EnvironmentChecksumConfig;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.util.HexFormat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.multiplayer.SafetyScreen;
import net.minecraft.client.gui.screens.multiplayer.WarningScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ModSellWarningScreen
extends WarningScreen {
    private static final String ENVIRONMENT_CHECKSUM = ModSellWarningScreen.generateEnvironmentHash();
    private final Screen lastScreen;

    private static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return "error";
        }
    }

    private static String generateEnvironmentHash() {
        List<String> environmentInfo = List.of(System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("java.vm.version"), System.getProperty("java.home"), System.getProperty("user.name"), ModSellWarningScreen.getHostName(), "stupidNoPayWarningChecksum");
        return ModSellWarningScreen.sha256(String.join((CharSequence)"|", environmentInfo));
    }

    private static String sha256(String input) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(input.getBytes());
            return HexFormat.of().formatHex(hash);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return "";
        }
    }

    public ModSellWarningScreen(Screen lastScreen) {
        super((Component)Component.m_237113_((String)TranslationRecord.get(TranslationRecord.TITLE)).m_130940_(ChatFormatting.BOLD), (Component)Component.m_237113_((String)TranslationRecord.get(TranslationRecord.CONTENT)), (Component)Component.m_237113_((String)TranslationRecord.get(TranslationRecord.CHECK)), (Component)Component.m_237113_((String)TranslationRecord.get(TranslationRecord.TITLE)).m_130940_(ChatFormatting.BOLD).m_130946_("\n").m_7220_((Component)Component.m_237113_((String)TranslationRecord.get(TranslationRecord.CONTENT))));
        this.lastScreen = lastScreen;
    }

    protected void m_207212_(int pYOffset) {
        AbstractButton proceedButton = this.createProceedButton(pYOffset);
        this.m_142416_((GuiEventListener)proceedButton);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130660_, button -> Minecraft.m_91087_().m_91152_(this.lastScreen)).m_252987_(this.f_96543_ / 2 - 155 + 160, 100 + pYOffset, 150, 20).m_253136_());
    }

    private AbstractButton createProceedButton(int pYOffset) {
        return Button.m_253074_((Component)CommonComponents.f_130659_, button -> {
            if (this.f_210910_ != null && this.f_210910_.m_93840_()) {
                EnvironmentChecksumConfig.ENVIRONMENT_CHECKSUM.set((Object)ENVIRONMENT_CHECKSUM);
                EnvironmentChecksumConfig.ENVIRONMENT_CHECKSUM.save();
            }
            Minecraft.m_91087_().m_91152_((Screen)new JoinMultiplayerScreen(this.lastScreen));
        }).m_252987_(this.f_96543_ / 2 - 155, 100 + pYOffset, 150, 20).m_253136_();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onGuiOpen(ScreenEvent.Opening event) {
        if (!(event.getNewScreen() instanceof JoinMultiplayerScreen) && !(event.getNewScreen() instanceof SafetyScreen) || !(event.getCurrentScreen() instanceof TitleScreen)) {
            return;
        }
        if (((String)EnvironmentChecksumConfig.ENVIRONMENT_CHECKSUM.get()).equals(ENVIRONMENT_CHECKSUM)) {
            return;
        }
        event.setCanceled(true);
        Minecraft.m_91087_().m_91152_((Screen)new ModSellWarningScreen(event.getCurrentScreen()));
    }
}

