/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.screens;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.item.curio.DogTagItem;
import com.atsuishio.superbwarfare.network.NetworkRegistry;
import com.atsuishio.superbwarfare.network.message.send.DogTagFinishEditMessage;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundRenameItemPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class DogTagEditorScreen
extends Screen {
    private static final ResourceLocation TEXTURE = Mod.loc("textures/gui/dog_tag_editor.png");
    public EditBox name;
    private short currentColor = 0;
    private short[][] icon = new short[16][16];
    public ItemStack stack;
    private final InteractionHand hand;
    private boolean init = false;
    protected int imageWidth = 207;
    protected int imageHeight = 185;
    @Nullable
    private String itemName;

    public DogTagEditorScreen(ItemStack stack, InteractionHand hand) {
        super(GameNarrator.f_93310_);
        this.stack = stack;
        this.hand = hand;
    }

    public boolean m_7043_() {
        return false;
    }

    protected void renderBg(GuiGraphics pGuiGraphics) {
        int i = (this.f_96543_ - this.imageWidth) / 2;
        int j = (this.f_96544_ - this.imageHeight) / 2;
        pGuiGraphics.m_280163_(TEXTURE, i, j, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        pGuiGraphics.m_280480_(this.stack, i + 18, j + 36);
        PoseStack pose = pGuiGraphics.m_280168_();
        pose.m_85836_();
        for (int x = 0; x < this.icon.length; ++x) {
            for (int y = 0; y < this.icon.length; ++y) {
                short num = this.icon[x][y];
                if (num == -1) continue;
                pGuiGraphics.m_280509_(i + 66 + x * 9, j + 44 + y * 9, i + 58 + x * 9, j + 36 + y * 9, DogTagEditorScreen.getColorByNum(num));
            }
        }
        pose.m_85849_();
    }

    @ParametersAreNonnullByDefault
    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(pGuiGraphics);
        this.renderBg(pGuiGraphics);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.name.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        this.drawColor(pMouseX, pMouseY, pButton);
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        this.drawColor(pMouseX, pMouseY, pButton);
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    private void drawColor(double pMouseX, double pMouseY, int pButton) {
        int i = (this.f_96543_ - this.imageWidth) / 2;
        int j = (this.f_96544_ - this.imageHeight) / 2;
        if (pMouseX >= (double)(i + 57) && pMouseX <= (double)(i + 201) && pMouseY >= (double)(j + 36) && pMouseY <= (double)(j + 179)) {
            double posX = pMouseX - (double)i - 57.0;
            double posY = pMouseY - (double)j - 36.0;
            if (Math.ceil(posX) % 9.0 == 0.0 || Math.ceil(posY) % 9.0 == 0.0) {
                return;
            }
            int x = (int)Math.floor(posX / 9.0);
            int y = (int)Math.floor(posY / 9.0);
            this.icon[Mth.m_14045_((int)x, (int)0, (int)15)][Mth.m_14045_((int)y, (int)0, (int)15)] = pButton == 0 ? (int)this.currentColor : -1;
        }
    }

    public void m_86600_() {
        super.m_86600_();
        this.name.m_94120_();
        if (!this.init) {
            if (!this.stack.m_41619_()) {
                this.name.m_94144_(this.stack.m_41786_().getString());
                this.icon = DogTagItem.getColors(this.stack);
            }
            this.init = true;
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.subInit();
        this.clearColors();
        int i = (this.f_96543_ - this.imageWidth) / 2;
        int j = (this.f_96544_ - this.imageHeight) / 2;
        for (short k = 0; k < 16; k = (short)(k + 1)) {
            ColorButton button = new ColorButton(k, i + 6 + k % 2 * 22, j + 62 + k / 2 * 10, 18, 8);
            this.m_142416_((GuiEventListener)button);
        }
        ColorButton eraserButton = new ColorButton(-1, i + 17, j + 143, 18, 8);
        this.m_142416_((GuiEventListener)eraserButton);
        FinishButton finishButton = new FinishButton(i + 6, j + 167, 40, 13);
        this.m_142416_((GuiEventListener)finishButton);
    }

    protected void subInit() {
        int i = (this.f_96543_ - this.imageWidth) / 2;
        int j = (this.f_96544_ - this.imageHeight) / 2;
        this.name = new EditBox(this.f_96547_, i + 9, j + 11, 180, 12, (Component)Component.m_237119_());
        this.name.m_94190_(false);
        this.name.m_94202_(-1);
        this.name.m_94205_(-1);
        this.name.m_94182_(false);
        this.name.m_94199_(30);
        this.name.m_94151_(this::onNameChanged);
        this.m_7787_((GuiEventListener)this.name);
        this.name.m_94186_(true);
    }

    private void onNameChanged(String name) {
        String s = name;
        if (!this.stack.m_41788_() && name.equals(this.stack.m_41786_().getString())) {
            s = "";
        }
        if (this.setItemName(s) && this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            this.f_96541_.f_91074_.f_108617_.m_104955_((Packet)new ServerboundRenameItemPacket(s));
        }
    }

    public void clearColors() {
        for (short[] el : this.icon) {
            Arrays.fill(el, (short)-1);
        }
    }

    @Nullable
    private static String validateName(String pItemName) {
        String s = SharedConstants.m_136190_((String)pItemName);
        return s.length() <= 30 ? s : null;
    }

    public boolean setItemName(String pItemName) {
        String s = DogTagEditorScreen.validateName(pItemName);
        if (s != null && !s.equals(this.itemName)) {
            this.itemName = s;
            if (!this.stack.m_41619_()) {
                if (Util.m_288217_((String)s)) {
                    this.stack.m_41787_();
                } else {
                    this.stack.m_41714_((Component)Component.m_237113_((String)s));
                }
            }
            return true;
        }
        return false;
    }

    public static int getColorByNum(short num) {
        return switch (num) {
            case 0 -> -16777216;
            case 1 -> -1;
            case 2 -> -8355712;
            case 3 -> -2874332;
            case 4 -> -22016;
            case 5 -> -256;
            case 6 -> -12787652;
            case 7 -> -10040065;
            case 8 -> -12955649;
            case 9 -> -4827905;
            case 10 -> -8562623;
            case 11 -> -26713;
            case 12 -> -9005986;
            case 13 -> -15360;
            case 14 -> -11779493;
            case 15 -> -465712;
            default -> -1;
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    class ColorButton
    extends AbstractButton {
        short color;

        public ColorButton(short color, int pX, int pY, int pWidth, int pHeight) {
            super(pX, pY, pWidth, pHeight, (Component)Component.m_237119_());
            this.color = color;
        }

        public void m_5691_() {
            DogTagEditorScreen.this.currentColor = this.color;
            if (this.color == -1 && Screen.m_96638_()) {
                DogTagEditorScreen.this.clearColors();
            }
        }

        protected void m_168797_(@NotNull NarrationElementOutput pNarrationElementOutput) {
        }

        protected void m_87963_(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            if (this.f_93622_ || DogTagEditorScreen.this.currentColor == this.color) {
                if (this.color == -1) {
                    pGuiGraphics.m_280163_(TEXTURE, this.m_252754_(), this.m_252907_(), 19.0f, 186.0f, 18, 8, 256, 256);
                } else {
                    pGuiGraphics.m_280163_(TEXTURE, this.m_252754_(), this.m_252907_(), 0.0f, 186.0f, 18, 8, 256, 256);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class FinishButton
    extends AbstractButton {
        public FinishButton(int pX, int pY, int pWidth, int pHeight) {
            super(pX, pY, pWidth, pHeight, (Component)Component.m_237119_());
        }

        public void m_5691_() {
            if (!DogTagEditorScreen.this.init) {
                return;
            }
            if (DogTagEditorScreen.this.f_96541_ != null) {
                DogTagEditorScreen.this.f_96541_.m_91152_(null);
            }
            this.updateLocal(DogTagEditorScreen.this.icon, DogTagEditorScreen.this.name.m_94155_());
            NetworkRegistry.PACKET_HANDLER.sendToServer((Object)new DogTagFinishEditMessage(DogTagEditorScreen.this.icon, DogTagEditorScreen.this.name.m_94155_(), DogTagEditorScreen.this.hand == InteractionHand.MAIN_HAND));
        }

        protected void m_87963_(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            if (this.f_93622_) {
                pGuiGraphics.m_280163_(TEXTURE, this.m_252754_(), this.m_252907_(), 0.0f, 195.0f, 40, 13, 256, 256);
            }
        }

        protected void m_168797_(@NotNull NarrationElementOutput pNarrationElementOutput) {
        }

        protected void updateLocal(short[][] colors, String name) {
            CompoundTag colorsTag = new CompoundTag();
            for (int i = 0; i < colors.length; ++i) {
                int[] color = new int[colors[i].length];
                for (int j = 0; j < colors[i].length; ++j) {
                    color[j] = colors[i][j];
                }
                colorsTag.m_128385_("Color" + i, color);
            }
            DogTagEditorScreen.this.stack.m_41784_().m_128365_("Colors", (Tag)colorsTag);
            if (!name.isEmpty()) {
                DogTagEditorScreen.this.stack.m_41714_((Component)Component.m_237113_((String)name));
            }
        }
    }
}

