/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.block;

import com.atsuishio.superbwarfare.block.entity.SuperbItemInterfaceBlockEntity;
import com.atsuishio.superbwarfare.init.ModBlockEntities;
import com.atsuishio.superbwarfare.init.ModTags;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuperbItemInterfaceBlock
extends BaseEntityBlock {
    public static final BooleanProperty ENABLED = BlockStateProperties.f_61431_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;

    public SuperbItemInterfaceBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60999_().m_60913_(3.0f, 4.8f).m_60918_(SoundType.f_56743_));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)FACING, (Comparable)Direction.DOWN));
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new SuperbItemInterfaceBlockEntity((BlockEntityType)ModBlockEntities.SUPERB_ITEM_INTERFACE.get(), pPos, pState);
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return pLevel.f_46443_ ? null : SuperbItemInterfaceBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.SUPERB_ITEM_INTERFACE.get()), SuperbItemInterfaceBlockEntity::serverTick);
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        Direction direction = context.m_43719_().m_122424_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction)).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(true));
    }

    public void m_6402_(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        BlockEntity blockentity;
        if (pStack.m_41788_() && (blockentity = pLevel.m_7702_(pPos)) instanceof SuperbItemInterfaceBlockEntity) {
            SuperbItemInterfaceBlockEntity entity = (SuperbItemInterfaceBlockEntity)blockentity;
            entity.m_58638_(pStack.m_41786_());
        }
    }

    @ParametersAreNonnullByDefault
    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pOldState.m_60713_(pState.m_60734_())) {
            this.checkPoweredState(pLevel, pPos, pState, 2);
        }
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResult m_6227_(BlockState state, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack stack = pPlayer.m_21120_(pHand);
        if (stack.m_204117_(ModTags.Items.TOOLS_CROWBAR) || stack.m_204117_(ModTags.Items.WRENCHES) || stack.m_204117_(ModTags.Items.TOOLS_WRENCH)) {
            Direction facing = pHit.m_82434_();
            if (state.m_61143_((Property)FACING) == facing) {
                facing = facing.m_122424_();
            }
            pLevel.m_46597_(pPos, (BlockState)state.m_61124_((Property)FACING, (Comparable)facing));
            return InteractionResult.SUCCESS;
        }
        if (pLevel.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockentity = pLevel.m_7702_(pPos);
        if (blockentity instanceof SuperbItemInterfaceBlockEntity) {
            SuperbItemInterfaceBlockEntity entity = (SuperbItemInterfaceBlockEntity)blockentity;
            pPlayer.m_5893_((MenuProvider)entity);
        }
        return InteractionResult.CONSUME;
    }

    @ParametersAreNonnullByDefault
    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        this.checkPoweredState(pLevel, pPos, pState, 4);
    }

    private void checkPoweredState(Level pLevel, BlockPos pPos, BlockState pState, int pFlags) {
        boolean flag;
        boolean bl = flag = !pLevel.m_276867_(pPos);
        if (flag != (Boolean)pState.m_61143_((Property)ENABLED)) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(flag)), pFlags);
        }
    }

    @ParametersAreNonnullByDefault
    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.m_60713_(pNewState.m_60734_())) {
            BlockEntity blockentity = pLevel.m_7702_(pPos);
            if (blockentity instanceof SuperbItemInterfaceBlockEntity) {
                SuperbItemInterfaceBlockEntity entity = (SuperbItemInterfaceBlockEntity)blockentity;
                Containers.m_19002_((Level)pLevel, (BlockPos)pPos, (Container)entity);
                pLevel.m_46717_(pPos, (Block)this);
            }
            super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState pState) {
        return RenderShape.MODEL;
    }

    public boolean m_7278_(@NotNull BlockState pState) {
        return true;
    }

    @ParametersAreNonnullByDefault
    public int m_6782_(BlockState pBlockState, Level pLevel, BlockPos pPos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)pLevel.m_7702_(pPos));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{ENABLED}).m_61104_(new Property[]{FACING});
    }

    @ParametersAreNonnullByDefault
    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public void m_5871_(@NotNull ItemStack pStack, @Nullable BlockGetter pLevel, @NotNull List<Component> pTooltip, @NotNull TooltipFlag pFlag) {
        pTooltip.add((Component)Component.m_237115_((String)"des.superbwarfare.superb_item_interface").m_130940_(ChatFormatting.GRAY));
    }
}

