/*
 * Decompiled with CFR 0.152.
 */
package shadersmod.client;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import shadersmod.client.Shaders;
import shadersmod.common.SMCLog;

public class ShadersBuiltIn {
    public static Reader getShaderReader(String filename) {
        if (filename.endsWith("/deferred_last.vsh")) {
            return ShadersBuiltIn.getCompositeShaderReader(true, true);
        }
        if (filename.endsWith("/composite_last.vsh")) {
            return ShadersBuiltIn.getCompositeShaderReader(false, true);
        }
        if (filename.endsWith("/deferred_last.fsh")) {
            return ShadersBuiltIn.getCompositeShaderReader(true, false);
        }
        if (filename.endsWith("/composite_last.fsh")) {
            return ShadersBuiltIn.getCompositeShaderReader(false, false);
        }
        return null;
    }

    private static Reader getCompositeShaderReader(boolean deferred, boolean vertex) {
        if (!ShadersBuiltIn.hasDeferredPrograms() && !ShadersBuiltIn.hasSkipClear()) {
            return null;
        }
        int[] flipBuffers = ShadersBuiltIn.getLastFlipBuffers(deferred);
        if (flipBuffers == null) {
            return null;
        }
        if (!vertex) {
            String stage = deferred ? "deferred" : "composite";
            SMCLog.info("flipped buffers after " + stage + ": " + Config.arrayToString(flipBuffers));
        }
        String shader = vertex ? ShadersBuiltIn.getCompositeVertexShader(flipBuffers) : ShadersBuiltIn.getCompositeFragmentShader(flipBuffers);
        return new StringReader(shader);
    }

    private static Reader getCompositeFragmentShaderReader(boolean deferred) {
        if (!ShadersBuiltIn.hasDeferredPrograms() && !ShadersBuiltIn.hasSkipClear()) {
            return null;
        }
        int[] flipBuffers = ShadersBuiltIn.getLastFlipBuffers(deferred);
        if (flipBuffers == null) {
            return null;
        }
        String shader = ShadersBuiltIn.getCompositeFragmentShader(flipBuffers);
        return new StringReader(shader);
    }

    private static boolean hasDeferredPrograms() {
        for (int i = 33; i < 41; ++i) {
            if (Shaders.programsID[i] == 0) continue;
            return true;
        }
        return false;
    }

    private static boolean hasSkipClear() {
        for (int i = 0; i < Shaders.gbuffersClear.length; ++i) {
            if (Shaders.gbuffersClear[i]) continue;
            return true;
        }
        return false;
    }

    private static String getCompositeVertexShader(int[] buffers) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("#version 120                        ");
        list.add("varying vec2 texcoord;              ");
        list.add("void main()                         ");
        list.add("{                                   ");
        list.add("  gl_Position = ftransform();       ");
        list.add("  texcoord = gl_MultiTexCoord0.xy;  ");
        list.add("}                                   ");
        return Config.listToString(list, "\n");
    }

    private static String getCompositeFragmentShader(int[] buffers) {
        int i;
        ArrayList<String> list = new ArrayList<String>();
        String drawBuffers = Config.arrayToString(buffers, "");
        list.add("#version 120                                           ");
        for (i = 0; i < buffers.length; ++i) {
            list.add("uniform sampler2D colortex" + buffers[i] + ";        ");
        }
        list.add("varying vec2 texcoord;                                 ");
        list.add("/* DRAWBUFFERS:" + drawBuffers + " */                  ");
        list.add("void main()                                            ");
        list.add("{                                                      ");
        for (i = 0; i < buffers.length; ++i) {
            list.add("  gl_FragData[" + i + "] = texture2D(colortex" + buffers[i] + ", texcoord);     ");
        }
        list.add("}                                                      ");
        return Config.listToString(list, "\n");
    }

    private static int[] getLastFlipBuffers(boolean deferred) {
        if (deferred) {
            return ShadersBuiltIn.getLastFlipBuffers(33, 8);
        }
        return ShadersBuiltIn.getLastFlipBuffers(21, 8);
    }

    private static int[] getLastFlipBuffers(int programStart, int programCount) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        boolean[] toggled = new boolean[8];
        for (int p = programStart; p < programStart + programCount; ++p) {
            if (Shaders.programsID[p] == 0) continue;
            boolean[] togglesTexture = ShadersBuiltIn.getProgramTogglesTexture(p);
            for (int t = 0; t < togglesTexture.length; ++t) {
                boolean toggle = togglesTexture[t];
                if (!toggle) continue;
                toggled[t] = !toggled[t];
            }
        }
        for (int t = 0; t < toggled.length; ++t) {
            boolean toggle = toggled[t];
            if (!toggle) continue;
            list.add(new Integer(t));
        }
        if (list.isEmpty()) {
            return null;
        }
        Integer[] arr = list.toArray(new Integer[list.size()]);
        return Config.toPrimitive(arr);
    }

    private static boolean[] getProgramTogglesTexture(int program) {
        boolean[] toggles = new boolean[8];
        String drawBufStr = Shaders.programsDrawBufSettings[program];
        if (drawBufStr == null) {
            return toggles;
        }
        for (int i = 0; i < drawBufStr.length(); ++i) {
            char ch = drawBufStr.charAt(i);
            int buf = ch - 48;
            if (buf < 0 || buf >= toggles.length) continue;
            toggles[buf] = true;
        }
        return toggles;
    }
}

