/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.properties;

import cpw.mods.fml.client.FMLClientHandler;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.techbrew.journeymap.model.MapType;
import net.techbrew.journeymap.properties.InGameMapProperties;
import net.techbrew.journeymap.properties.config.Config;
import net.techbrew.journeymap.ui.minimap.Orientation;
import net.techbrew.journeymap.ui.minimap.Position;
import net.techbrew.journeymap.ui.minimap.ReticleOrientation;
import net.techbrew.journeymap.ui.minimap.Shape;

public class MiniMapProperties
extends InGameMapProperties {
    @Config(category=Config.Category.Inherit, master=true, key="jm.minimap.enable_minimap")
    public final AtomicBoolean enabled = new AtomicBoolean(true);
    @Config(category=Config.Category.Inherit, key="jm.minimap.shape", defaultEnum="Circle")
    public final AtomicReference<Shape> shape = new AtomicReference<Shape>(Shape.Circle);
    @Config(category=Config.Category.Inherit, key="jm.minimap.position", defaultEnum="TopRight")
    public final AtomicReference<Position> position = new AtomicReference<Position>(Position.TopRight);
    @Config(category=Config.Category.Inherit, key="jm.minimap.show_fps", defaultBoolean=false)
    public final AtomicBoolean showFps = new AtomicBoolean(false);
    @Config(category=Config.Category.Inherit, key="jm.minimap.show_biome")
    public final AtomicBoolean showBiome = new AtomicBoolean(true);
    @Config(category=Config.Category.Inherit, key="jm.minimap.show_location")
    public final AtomicBoolean showLocation = new AtomicBoolean(true);
    @Config(category=Config.Category.Inherit, key="jm.minimap.size", minValue=1.0, maxValue=100.0, defaultValue=30.0)
    public final AtomicInteger sizePercent = new AtomicInteger(30);
    @Config(category=Config.Category.Inherit, key="jm.minimap.frame_alpha", minValue=0.0, maxValue=100.0, defaultValue=100.0)
    public final AtomicInteger frameAlpha = new AtomicInteger(100);
    @Config(category=Config.Category.Inherit, key="jm.minimap.terrain_alpha", minValue=0.0, maxValue=100.0, defaultValue=100.0)
    public final AtomicInteger terrainAlpha = new AtomicInteger(100);
    @Config(category=Config.Category.Inherit, key="jm.minimap.orientation.button", defaultEnum="PlayerHeading")
    public final AtomicReference<Orientation> orientation = new AtomicReference<Orientation>(Orientation.PlayerHeading);
    @Config(category=Config.Category.Inherit, key="jm.minimap.compass_font_scale", minValue=1.0, maxValue=4.0, defaultValue=1.0)
    public final AtomicInteger compassFontScale = new AtomicInteger(1);
    @Config(category=Config.Category.Inherit, key="jm.minimap.show_compass")
    public final AtomicBoolean showCompass = new AtomicBoolean(true);
    @Config(category=Config.Category.Inherit, key="jm.minimap.show_reticle")
    public final AtomicBoolean showReticle = new AtomicBoolean(true);
    @Config(category=Config.Category.Inherit, key="jm.minimap.reticle_orientation", defaultEnum="Compass")
    public final AtomicReference<ReticleOrientation> reticleOrientation = new AtomicReference<ReticleOrientation>(ReticleOrientation.Compass);
    public final AtomicReference<MapType.Name> preferredMapType = new AtomicReference<MapType.Name>(MapType.Name.day);
    protected final transient String name;
    protected boolean active = false;

    public MiniMapProperties() {
        this("minimap");
    }

    protected MiniMapProperties(String name) {
        this.name = name;
    }

    @Override
    public AtomicReference<String> getEntityIconSetName() {
        return this.entityIconSetName;
    }

    @Override
    public AtomicReference<MapType.Name> getPreferredMapType() {
        return this.preferredMapType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        this.save();
    }

    public int getId() {
        return 1;
    }

    public int getSize() {
        return (int)Math.max(128.0, Math.floor((double)this.sizePercent.get() / 100.0 * (double)FMLClientHandler.instance().getClient().field_71440_d));
    }

    @Override
    public void newFileInit() {
        this.setActive(true);
        if (FMLClientHandler.instance().getClient().field_71466_p.func_82883_a()) {
            this.fontScale.set(2);
            this.compassFontScale.set(2);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MiniMapProperties that = (MiniMapProperties)o;
        return 0 == this.compareTo(that);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
        result = 31 * result + (this.shape != null ? this.shape.hashCode() : 0);
        result = 31 * result + (this.position != null ? this.position.hashCode() : 0);
        result = 31 * result + (this.showFps != null ? this.showFps.hashCode() : 0);
        result = 31 * result + (this.showBiome != null ? this.showBiome.hashCode() : 0);
        result = 31 * result + (this.showLocation != null ? this.showLocation.hashCode() : 0);
        result = 31 * result + this.showWaypointLabels.hashCode();
        result = 31 * result + this.sizePercent.hashCode();
        result = 31 * result + this.frameAlpha.hashCode();
        result = 31 * result + this.terrainAlpha.hashCode();
        result = 31 * result + this.orientation.hashCode();
        result = 31 * result + this.compassFontScale.hashCode();
        result = 31 * result + this.showCompass.hashCode();
        result = 31 * result + this.showReticle.hashCode();
        result = 31 * result + this.reticleOrientation.hashCode();
        result = 31 * result + this.entityIconSetName.hashCode();
        result = 31 * result + this.preferredMapType.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        return super.toStringHelper(this).add("active", this.active).add("compassFontScale", (Object)this.compassFontScale).add("enabled", (Object)this.enabled).add("frameAlpha", (Object)this.frameAlpha).add("name", (Object)this.name).add("orientation", this.orientation).add("position", this.position).add("preferredMapType", this.preferredMapType).add("reticleOrientation", this.reticleOrientation).add("shape", this.shape).add("showBiome", (Object)this.showBiome).add("showCompass", (Object)this.showCompass).add("showFps", (Object)this.showFps).add("showLocation", (Object)this.showLocation).add("showReticle", (Object)this.showReticle).add("sizePercent", (Object)this.sizePercent).add("terrainAlpha", (Object)this.terrainAlpha).toString();
    }
}

