/*
 * Decompiled with CFR 0.152.
 */
package crosshairmod.utils;

import crosshairmod.utils.GuiTheme;
import crosshairmod.utils.RGBA;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

public class GuiGraphics {
    private static FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;

    public static void drawHorizontalLine(int y, int x1, int x2, RGBA colour) {
        GuiGraphics.drawFilledRectangle(x1, y, x2, y + 1, colour);
    }

    public static void drawVerticalLine(int x, int y1, int y2, RGBA colour) {
        GuiGraphics.drawFilledRectangle(x, y1, x + 1, y2, colour);
    }

    public static void drawRectangle(int x1, int y1, int x2, int y2, RGBA colour) {
        GuiGraphics.drawHorizontalLine(y1, x1, x2, colour);
        GuiGraphics.drawHorizontalLine(y2, x1, x2 + 1, colour);
        GuiGraphics.drawVerticalLine(x1, y1, y2, colour);
        GuiGraphics.drawVerticalLine(x2, y1, y2, colour);
    }

    public static void drawFilledRectangle(int x1, int y1, int x2, int y2, RGBA colour) {
        if (x1 < x2) {
            int tempX = x1;
            x1 = x2;
            x2 = tempX;
        }
        if (y1 < y2) {
            int tempY = y1;
            y1 = y2;
            y2 = tempY;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glColor4f((float)((float)colour.getRed() / 255.0f), (float)((float)colour.getGreen() / 255.0f), (float)((float)colour.getBlue() / 255.0f), (float)((float)colour.getOpacity() / 255.0f));
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)x1, (double)y2, 0.0);
        tessellator.func_78377_a((double)x2, (double)y2, 0.0);
        tessellator.func_78377_a((double)x2, (double)y1, 0.0);
        tessellator.func_78377_a((double)x1, (double)y1, 0.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawTexturedRectangle(int x, int y, int textureX, int textureY, int width, int height) {
        float f = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + height), 0.0, (double)((float)(textureX + 0) * f), (double)((float)(textureY + height) * f));
        tessellator.func_78374_a((double)(x + width), (double)(y + height), 0.0, (double)((float)(textureX + width) * f), (double)((float)(textureY + height) * f));
        tessellator.func_78374_a((double)(x + width), (double)y, 0.0, (double)((float)(textureX + height) * f), (double)((float)(textureY + 0) * f));
        tessellator.func_78374_a((double)x, (double)y, 0.0, (double)((float)(textureX + 0) * f), (double)((float)(textureY + 0) * f));
        tessellator.func_78381_a();
    }

    public static void drawBorderedRectangle(int x1, int y1, int x2, int y2, RGBA innerColour, RGBA outerColour) {
        GuiGraphics.drawFilledRectangle(x1, y1, x2, y2, innerColour);
        GuiGraphics.drawRectangle(x1, y1, x2, y2, outerColour);
    }

    public static void drawThemeBorderedRectangle(int x1, int y1, int x2, int y2) {
        GuiGraphics.drawBorderedRectangle(x1, y1, x2, y2, GuiTheme.PRIMARY_T, GuiTheme.SECONDARY);
    }

    public static void drawString(String text, int x, int y, int colour) {
        fontRenderer.func_78276_b(text, x, y, colour);
    }

    public static void drawStringWithShadow(String text, int x, int y, int colour) {
        fontRenderer.func_78261_a(text, x, y, colour);
    }

    public static int getStringWidth(String text) {
        return fontRenderer.func_78256_a(text);
    }

    public static int[] getScreenSize() {
        int[] size = new int[2];
        ScaledResolution resolution = new ScaledResolution(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
        size[0] = resolution.func_78326_a();
        size[1] = resolution.func_78328_b();
        return size;
    }

    public static double[] getScreenSizeDouble() {
        double[] size = new double[2];
        ScaledResolution resolution = new ScaledResolution(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
        size[0] = resolution.func_78327_c();
        size[1] = resolution.func_78324_d();
        return size;
    }

    public static void drawLine(int x1, int y1, int x2, int y2, RGBA colour) {
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)colour.getRed(), (float)colour.getGreen(), (float)colour.getBlue(), (float)colour.getOpacity());
        GL11.glBegin((int)2);
        GL11.glVertex2d((double)x1, (double)y1);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static void drawCircle(double x, double y, double radius, RGBA colour) {
        GL11.glPushMatrix();
        GL11.glEnable((int)2848);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)colour.getRed(), (float)colour.getGreen(), (float)colour.getBlue(), (float)colour.getOpacity());
        GL11.glBegin((int)2);
        for (int degrees = 0; degrees <= 360; ++degrees) {
            float radians = (float)degrees * (float)Math.PI / 180.0f;
            GL11.glVertex2d((double)(x + Math.cos(radians) * radius), (double)(y + Math.sin(radians) * radius));
        }
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static void drawFilledCircle(double x, double y, double radius, RGBA colour) {
    }

    public static void drawImage(String directory, int x, int y, int width, int height) {
    }
}

