/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import foxz.utils.Market;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.EventHooks;
import noppes.npcs.LogWriter;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.Server;
import noppes.npcs.ServerEventsHandler;
import noppes.npcs.constants.EnumCompanionStage;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumJobType;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.constants.EnumPlayerData;
import noppes.npcs.constants.EnumRoleType;
import noppes.npcs.containers.ContainerCustomGui;
import noppes.npcs.containers.ContainerMail;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.CustomGuiController;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.LinkedNpcController;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.RecipeController;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.controllers.SpawnController;
import noppes.npcs.controllers.TransportController;
import noppes.npcs.controllers.data.Bank;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.DialogCategory;
import noppes.npcs.controllers.data.DialogOption;
import noppes.npcs.controllers.data.Faction;
import noppes.npcs.controllers.data.ForgeDataScript;
import noppes.npcs.controllers.data.NPCDataScript;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerDataScript;
import noppes.npcs.controllers.data.PlayerMail;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.controllers.data.QuestCategory;
import noppes.npcs.controllers.data.RecipeCarpentry;
import noppes.npcs.controllers.data.SpawnData;
import noppes.npcs.controllers.data.TransportLocation;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobSpawner;
import noppes.npcs.roles.RoleCompanion;
import noppes.npcs.roles.RoleTrader;
import noppes.npcs.roles.RoleTransporter;
import noppes.npcs.scripted.NpcAPI;
import noppes.npcs.scripted.gui.ScriptGui;
import noppes.npcs.scripted.interfaces.entity.IPlayer;
import noppes.npcs.scripted.item.ScriptCustomItem;

public class PacketHandlerServer {
    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        block38: {
            EntityPlayerMP player = ((NetHandlerPlayServer)event.handler).field_147369_b;
            if (CustomNpcs.OpsOnly && !NoppesUtilServer.isOp((EntityPlayer)player)) {
                this.warn((EntityPlayer)player, "tried to use custom npcs without being an op");
                return;
            }
            ByteBuf buffer = event.packet.payload();
            EnumPacketServer type = null;
            try {
                type = EnumPacketServer.values()[buffer.readInt()];
                ItemStack item = player.field_71071_by.func_70448_g();
                EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
                if (type == EnumPacketServer.IsGuiOpen) {
                    this.isGuiOpenPacket(buffer, player);
                    return;
                }
                if (type == EnumPacketServer.CustomGuiButton && player.field_71070_bA instanceof ContainerCustomGui) {
                    ((ContainerCustomGui)player.field_71070_bA).customGui.fromNBT(Server.readNBT(buffer));
                    EventHooks.onCustomGuiButton((IPlayer)NpcAPI.Instance().getIEntity((Entity)player), ((ContainerCustomGui)player.field_71070_bA).customGui, buffer.readInt());
                    return;
                }
                if (type == EnumPacketServer.CustomGuiSlotChange && player.field_71070_bA instanceof ContainerCustomGui) {
                    ((ContainerCustomGui)player.field_71070_bA).customGui.fromNBT(Server.readNBT(buffer));
                    EventHooks.onCustomGuiSlot((IPlayer)NpcAPI.Instance().getIEntity((Entity)player), ((ContainerCustomGui)player.field_71070_bA).customGui, buffer.readInt());
                    return;
                }
                if (type == EnumPacketServer.CustomGuiUnfocused && player.field_71070_bA instanceof ContainerCustomGui) {
                    ((ContainerCustomGui)player.field_71070_bA).customGui.fromNBT(Server.readNBT(buffer));
                    EventHooks.onCustomGuiUnfocused((IPlayer)NpcAPI.Instance().getIEntity((Entity)player), ((ContainerCustomGui)player.field_71070_bA).customGui, buffer.readInt());
                    return;
                }
                if (type == EnumPacketServer.CustomGuiScrollClick && player.field_71070_bA instanceof ContainerCustomGui) {
                    ((ContainerCustomGui)player.field_71070_bA).customGui.fromNBT(Server.readNBT(buffer));
                    EventHooks.onCustomGuiScrollClick((IPlayer)NpcAPI.Instance().getIEntity((Entity)player), ((ContainerCustomGui)player.field_71070_bA).customGui, buffer.readInt(), buffer.readInt(), CustomGuiController.readScrollSelection(buffer), buffer.readBoolean());
                    return;
                }
                if (type == EnumPacketServer.CustomGuiClose) {
                    EventHooks.onCustomGuiClose((IPlayer)NpcAPI.Instance().getIEntity((Entity)player), new ScriptGui().fromNBT(Server.readNBT(buffer)));
                    return;
                }
                if (type == EnumPacketServer.UpdateTrackedQuest) {
                    this.updateTrackedQuest(buffer, player);
                    return;
                }
                if (type.needsNpc && npc == null) break block38;
                if (type.hasPermission()) {
                    if (!CustomNpcsPermissions.hasPermission((EntityPlayer)player, type.permission)) break block38;
                }
                if (item == null && (type == EnumPacketServer.ScriptPlayerGet || type == EnumPacketServer.ScriptPlayerSave || type == EnumPacketServer.ScriptNPCGet || type == EnumPacketServer.ScriptNPCSave || type == EnumPacketServer.ScriptForgeGet || type == EnumPacketServer.ScriptForgeSave)) {
                    this.warn((EntityPlayer)player, "tried to use custom npcs without a tool in hand, probably a hacker");
                } else if (item != null) {
                    if (item.func_77973_b() == CustomItems.wand) {
                        this.wandPackets(type, buffer, player, npc);
                    } else if (item.func_77973_b() == CustomItems.moving) {
                        this.movingPackets(type, buffer, player, npc);
                    } else if (item.func_77973_b() == CustomItems.mount) {
                        this.mountPackets(type, buffer, player);
                    } else if (item.func_77973_b() == CustomItems.cloner) {
                        this.clonePackets(type, buffer, player);
                    } else if (item.func_77973_b() == CustomItems.teleporter) {
                        this.featherPackets(type, buffer, player);
                    } else if (type == EnumPacketServer.ScriptPlayerGet || type == EnumPacketServer.ScriptPlayerSave) {
                        this.playerScriptPackets(type, buffer, player);
                    } else if (type == EnumPacketServer.ScriptNPCGet || type == EnumPacketServer.ScriptNPCSave) {
                        this.npcScriptPackets(type, buffer, player);
                    } else if (type == EnumPacketServer.ScriptForgeGet || type == EnumPacketServer.ScriptForgeSave) {
                        this.forgeScriptPackets(type, buffer, player);
                    } else if (type == EnumPacketServer.ScriptItemDataGet || type == EnumPacketServer.ScriptItemDataSave) {
                        this.itemScriptPackets(type, buffer, player);
                    } else if (type == EnumPacketServer.ScriptGlobalGuiDataGet || type == EnumPacketServer.ScriptGlobalGuiDataSave) {
                        this.getScriptsEnabled(type, buffer, player);
                    } else if (item.func_77973_b() == CustomItems.scripter) {
                        this.scriptPackets(type, buffer, player, npc);
                    } else if (item.func_77973_b() == Item.func_150898_a((Block)CustomItems.waypoint) || item.func_77973_b() == Item.func_150898_a((Block)CustomItems.border) || item.func_77973_b() == Item.func_150898_a((Block)CustomItems.redstoneBlock)) {
                        this.blockPackets(type, buffer, player);
                    }
                }
            }
            catch (Exception e) {
                LogWriter.error("Error with EnumPacketServer." + (Object)((Object)type), e);
            }
        }
    }

    private void updateTrackedQuest(ByteBuf buffer, EntityPlayerMP player) {
        String trackedQuestString = Server.readString(buffer);
        if (trackedQuestString != null && trackedQuestString.contains(":")) {
            String[] splitString = trackedQuestString.split(":");
            String categoryName = splitString[0];
            String questName = splitString[1];
            for (QuestCategory category : QuestController.instance.categories.values()) {
                if (!category.title.equals(categoryName)) continue;
                for (Quest quest : category.quests.values()) {
                    if (!quest.title.equals(questName)) continue;
                    PlayerDataController.instance.getPlayerData((EntityPlayer)player).questData.trackedQuest = quest;
                    NoppesUtilPlayer.sendTrackedQuestData(player, quest);
                    return;
                }
            }
        }
        PlayerDataController.instance.getPlayerData((EntityPlayer)player).questData.trackedQuest = null;
        Server.sendData(player, EnumPacketClient.OVERLAY_QUEST_TRACKING, new Object[0]);
    }

    private void isGuiOpenPacket(ByteBuf buffer, EntityPlayerMP player) throws IOException {
        NoppesUtilServer.isGUIOpen(buffer, (EntityPlayer)player);
    }

    private void getScriptsEnabled(EnumPacketServer type, ByteBuf buffer, EntityPlayerMP player) throws IOException {
        if (type == EnumPacketServer.ScriptGlobalGuiDataGet) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74757_a("ScriptsEnabled", CustomNpcs.GlobalPlayerScripts);
            compound.func_74757_a("PlayerScriptsEnabled", CustomNpcs.GlobalPlayerScripts);
            compound.func_74757_a("GlobalNPCScriptsEnabled", CustomNpcs.GlobalNPCScripts);
            compound.func_74757_a("ForgeScriptsEnabled", CustomNpcs.GlobalForgeScripts);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.ScriptGlobalGuiDataSave) {
            NBTTagCompound compound = Server.readNBT(buffer);
            CustomNpcs.GlobalPlayerScripts = compound.func_74767_n("ScriptsEnabled");
            CustomNpcs.GlobalPlayerScripts = compound.func_74767_n("PlayerScriptsEnabled");
            CustomNpcs.GlobalNPCScripts = compound.func_74767_n("GlobalNPCScriptsEnabled");
            CustomNpcs.GlobalForgeScripts = compound.func_74767_n("ForgeScriptsEnabled");
        }
    }

    private void scriptPackets(EnumPacketServer type, ByteBuf buffer, EntityPlayerMP player, EntityNPCInterface npc) throws Exception {
        if (type == EnumPacketServer.ScriptDataSave) {
            npc.script.readFromNBT(Server.readNBT(buffer));
            npc.updateAI = true;
            npc.script.hasInited = false;
        } else if (type == EnumPacketServer.ScriptDataGet) {
            NBTTagCompound compound = npc.script.writeToNBT(new NBTTagCompound());
            compound.func_74782_a("Languages", (NBTBase)ScriptController.Instance.nbtLanguages());
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        }
    }

    private void playerScriptPackets(EnumPacketServer type, ByteBuf buffer, EntityPlayerMP player) throws Exception {
        if (type == EnumPacketServer.ScriptPlayerGet) {
            PlayerDataScript data = ScriptController.Instance.playerScripts;
            NBTTagCompound compound = data.writeToNBT(new NBTTagCompound());
            compound.func_74757_a("ScriptEnabled", ScriptController.Instance.playerScripts.getEnabled());
            compound.func_74782_a("Languages", (NBTBase)ScriptController.Instance.nbtLanguages());
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.ScriptPlayerSave) {
            ScriptController.Instance.setPlayerScripts(Server.readNBT(buffer));
        }
    }

    private void forgeScriptPackets(EnumPacketServer type, ByteBuf buffer, EntityPlayerMP player) throws Exception {
        if (type == EnumPacketServer.ScriptForgeGet) {
            ForgeDataScript data = ScriptController.Instance.forgeScripts;
            NBTTagCompound compound = data.writeToNBT(new NBTTagCompound());
            compound.func_74757_a("ScriptEnabled", ScriptController.Instance.forgeScripts.getEnabled());
            compound.func_74782_a("Languages", (NBTBase)ScriptController.Instance.nbtLanguages());
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.ScriptForgeSave) {
            ScriptController.Instance.setForgeScripts(Server.readNBT(buffer));
        }
    }

    private void npcScriptPackets(EnumPacketServer type, ByteBuf buffer, EntityPlayerMP player) throws Exception {
        if (type == EnumPacketServer.ScriptNPCGet) {
            NPCDataScript data = ScriptController.Instance.npcScripts;
            NBTTagCompound compound = data.writeToNBT(new NBTTagCompound());
            compound.func_74757_a("ScriptEnabled", ScriptController.Instance.npcScripts.getEnabled());
            compound.func_74782_a("Languages", (NBTBase)ScriptController.Instance.nbtLanguages());
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.ScriptNPCSave) {
            ScriptController.Instance.setNPCScripts(Server.readNBT(buffer));
        }
    }

    private void itemScriptPackets(EnumPacketServer type, ByteBuf buffer, EntityPlayerMP player) throws Exception {
        if (type == EnumPacketServer.ScriptItemDataGet) {
            ScriptCustomItem iw = (ScriptCustomItem)NpcAPI.Instance().getIItemStack(player.func_70694_bm());
            NBTTagCompound compound = iw.getMCNbt();
            compound.func_74782_a("Languages", (NBTBase)ScriptController.Instance.nbtLanguages());
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.ScriptItemDataSave) {
            if (!player.field_71075_bZ.field_75098_d) {
                return;
            }
            NBTTagCompound compound = Server.readNBT(buffer);
            ScriptCustomItem wrapper = (ScriptCustomItem)NpcAPI.Instance().getIItemStack(player.func_70694_bm());
            wrapper.setMCNbt(compound);
            wrapper.lastInited = -1L;
            wrapper.saveScriptData();
            player.func_71120_a(player.field_71069_bz);
        }
    }

    private void featherPackets(EnumPacketServer type, ByteBuf buffer, EntityPlayerMP player) throws IOException {
        if (type == EnumPacketServer.DimensionsGet) {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            Integer[] integerArray = DimensionManager.getStaticDimensionIDs();
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int id = integerArray[i];
                WorldProvider provider = DimensionManager.createProviderFor((int)id);
                map.put(provider.func_80007_l(), id);
            }
            NoppesUtilServer.sendScrollData(player, map);
        } else if (type == EnumPacketServer.DimensionTeleport) {
            int dimension = buffer.readInt();
            WorldServer world = MinecraftServer.func_71276_C().func_71218_a(dimension);
            ChunkCoordinates coords = world.func_73054_j();
            if (coords == null) {
                coords = world.func_72861_E();
                if (!world.func_147437_c(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c)) {
                    coords.field_71572_b = world.func_72825_h(coords.field_71574_a, coords.field_71573_c);
                } else {
                    while (world.func_147437_c(coords.field_71574_a, coords.field_71572_b - 1, coords.field_71573_c) && coords.field_71572_b > 0) {
                        --coords.field_71572_b;
                    }
                    if (coords.field_71572_b == 0) {
                        coords.field_71572_b = world.func_72825_h(coords.field_71574_a, coords.field_71573_c);
                    }
                }
            }
            NoppesUtilPlayer.teleportPlayer(player, coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, dimension);
        }
    }

    private void movingPackets(EnumPacketServer type, ByteBuf buffer, EntityPlayerMP player, EntityNPCInterface npc) throws IOException {
        if (type == EnumPacketServer.MovingPathGet) {
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.ai.writeToNBT(new NBTTagCompound()));
        } else if (type == EnumPacketServer.MovingPathSave) {
            npc.ai.setMovingPath(NBTTags.getIntegerArraySet(Server.readNBT(buffer).func_150295_c("MovingPathNew", 10)));
        }
    }

    private void blockPackets(EnumPacketServer type, ByteBuf buffer, EntityPlayerMP player) throws IOException {
        if (type == EnumPacketServer.SaveTileEntity) {
            NoppesUtilServer.saveTileEntity(player, Server.readNBT(buffer));
        } else if (type == EnumPacketServer.GetTileEntity) {
            TileEntity tile = player.field_70170_p.func_147438_o(buffer.readInt(), buffer.readInt(), buffer.readInt());
            NBTTagCompound compound = new NBTTagCompound();
            tile.func_145841_b(compound);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.DialogCategoriesGet) {
            NoppesUtilServer.sendScrollData(player, DialogController.instance.getScroll());
        } else if (type == EnumPacketServer.DialogsGetFromDialog) {
            Dialog dialog = DialogController.instance.dialogs.get(buffer.readInt());
            if (dialog == null) {
                return;
            }
            NoppesUtilServer.sendDialogData(player, dialog.category);
        } else if (type == EnumPacketServer.DialogsGet) {
            NoppesUtilServer.sendDialogData(player, DialogController.instance.categories.get(buffer.readInt()));
        } else if (type == EnumPacketServer.QuestsGetFromQuest) {
            Quest quest = QuestController.instance.quests.get(buffer.readInt());
            if (quest == null) {
                return;
            }
            NoppesUtilServer.sendQuestData(player, quest.category);
        } else if (type == EnumPacketServer.QuestCategoriesGet) {
            NoppesUtilServer.sendQuestCategoryData(player);
        } else if (type == EnumPacketServer.QuestsGet) {
            QuestCategory category = QuestController.instance.categories.get(buffer.readInt());
            NoppesUtilServer.sendQuestData(player, category);
        } else if (type == EnumPacketServer.FactionsGet) {
            NoppesUtilServer.sendFactionDataAll(player);
        } else if (type == EnumPacketServer.DialogGet) {
            Dialog dialog = DialogController.instance.dialogs.get(buffer.readInt());
            if (dialog != null) {
                NBTTagCompound compound = dialog.writeToNBT(new NBTTagCompound());
                Quest quest = QuestController.instance.quests.get(dialog.quest);
                if (quest != null) {
                    compound.func_74778_a("DialogQuestName", quest.title);
                }
                Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
            }
        } else if (type == EnumPacketServer.QuestGet) {
            Quest quest = QuestController.instance.quests.get(buffer.readInt());
            if (quest != null) {
                NBTTagCompound compound = new NBTTagCompound();
                if (quest.hasNewQuest()) {
                    compound.func_74778_a("NextQuestTitle", quest.getNextQuest().title);
                }
                Server.sendData(player, EnumPacketClient.GUI_DATA, quest.writeToNBT(compound));
            }
        } else if (type == EnumPacketServer.FactionGet) {
            NBTTagCompound compound = new NBTTagCompound();
            Faction faction = FactionController.getInstance().get(buffer.readInt());
            faction.writeNBT(compound);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        }
    }

    private void wandPackets(EnumPacketServer type, ByteBuf buffer, EntityPlayerMP player, EntityNPCInterface npc) throws IOException {
        if (type == EnumPacketServer.Delete) {
            npc.delete();
            NoppesUtilServer.deleteNpc(npc, (EntityPlayer)player);
        } else if (type == EnumPacketServer.LinkedAdd) {
            LinkedNpcController.Instance.addData(Server.readString(buffer));
            ArrayList<String> list = new ArrayList<String>();
            for (LinkedNpcController.LinkedData data : LinkedNpcController.Instance.list) {
                list.add(data.name);
            }
            Server.sendData(player, EnumPacketClient.SCROLL_LIST, list);
        } else if (type == EnumPacketServer.LinkedRemove) {
            LinkedNpcController.Instance.removeData(Server.readString(buffer));
            ArrayList<String> list = new ArrayList<String>();
            for (LinkedNpcController.LinkedData data : LinkedNpcController.Instance.list) {
                list.add(data.name);
            }
            Server.sendData(player, EnumPacketClient.SCROLL_LIST, list);
        } else if (type == EnumPacketServer.LinkedGetAll) {
            ArrayList<String> list = new ArrayList<String>();
            for (LinkedNpcController.LinkedData data : LinkedNpcController.Instance.list) {
                list.add(data.name);
            }
            Server.sendData(player, EnumPacketClient.SCROLL_LIST, list);
            if (npc != null) {
                Server.sendData(player, EnumPacketClient.SCROLL_SELECTED, npc.linkedName);
            }
        } else if (type == EnumPacketServer.LinkedSet) {
            npc.linkedName = Server.readString(buffer);
            LinkedNpcController.Instance.loadNpcData(npc);
        } else if (type == EnumPacketServer.NpcMenuClose) {
            npc.reset();
            if (npc.linkedData != null) {
                LinkedNpcController.Instance.saveNpcData(npc);
            }
            NoppesUtilServer.setEditingNpc((EntityPlayer)player, null);
        } else if (type == EnumPacketServer.BanksGet) {
            NoppesUtilServer.sendBankDataAll(player);
        } else if (type == EnumPacketServer.BankGet) {
            Bank bank = BankController.getInstance().getBank(buffer.readInt());
            NoppesUtilServer.sendBank(player, bank);
        } else if (type == EnumPacketServer.BankSave) {
            Bank bank = new Bank();
            bank.readEntityFromNBT(Server.readNBT(buffer));
            BankController.getInstance().saveBank(bank);
            NoppesUtilServer.sendBankDataAll(player);
            NoppesUtilServer.sendBank(player, bank);
        } else if (type == EnumPacketServer.BankRemove) {
            BankController.getInstance().removeBank(buffer.readInt());
            NoppesUtilServer.sendBankDataAll(player);
            NoppesUtilServer.sendBank(player, new Bank());
        } else if (type == EnumPacketServer.RemoteMainMenu) {
            Entity entity = player.field_70170_p.func_73045_a(buffer.readInt());
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            NoppesUtilServer.sendOpenGui((EntityPlayer)player, EnumGuiType.MainMenuDisplay, (EntityNPCInterface)entity);
        } else if (type == EnumPacketServer.RemoteDelete) {
            Entity entity = player.field_70170_p.func_73045_a(buffer.readInt());
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            npc = (EntityNPCInterface)entity;
            npc.delete();
            NoppesUtilServer.deleteNpc(npc, (EntityPlayer)player);
            NoppesUtilServer.sendNearbyNpcs(player);
        } else if (type == EnumPacketServer.RemoteNpcsGet) {
            NoppesUtilServer.sendNearbyNpcs(player);
            Server.sendData(player, EnumPacketClient.SCROLL_SELECTED, CustomNpcs.FreezeNPCs ? "Unfreeze Npcs" : "Freeze Npcs");
        } else if (type == EnumPacketServer.RemoteFreeze) {
            CustomNpcs.FreezeNPCs = !CustomNpcs.FreezeNPCs;
            Server.sendData(player, EnumPacketClient.SCROLL_SELECTED, CustomNpcs.FreezeNPCs ? "Unfreeze Npcs" : "Freeze Npcs");
        } else if (type == EnumPacketServer.RemoteReset) {
            Entity entity = player.field_70170_p.func_73045_a(buffer.readInt());
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            npc = (EntityNPCInterface)entity;
            npc.reset();
        } else if (type == EnumPacketServer.RemoteTpToNpc) {
            Entity entity = player.field_70170_p.func_73045_a(buffer.readInt());
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            npc = (EntityNPCInterface)entity;
            player.field_71135_a.func_147364_a(npc.field_70165_t, npc.field_70163_u, npc.field_70161_v, 0.0f, 0.0f);
        } else if (type == EnumPacketServer.Gui) {
            EnumGuiType gui = EnumGuiType.values()[buffer.readInt()];
            int i = buffer.readInt();
            int j = buffer.readInt();
            int k = buffer.readInt();
            NoppesUtilServer.sendOpenGui((EntityPlayer)player, gui, npc, i, j, k);
        } else if (type == EnumPacketServer.RecipesGet) {
            NoppesUtilServer.sendRecipeData(player, buffer.readInt());
        } else if (type == EnumPacketServer.RecipeGet) {
            RecipeCarpentry recipe = RecipeController.instance.getRecipe(buffer.readInt());
            NoppesUtilServer.setRecipeGui(player, recipe);
        } else if (type == EnumPacketServer.RecipeRemove) {
            RecipeCarpentry recipe = RecipeController.instance.delete(buffer.readInt());
            NoppesUtilServer.sendRecipeData(player, recipe.isGlobal ? 3 : 4);
            NoppesUtilServer.setRecipeGui(player, new RecipeCarpentry(""));
        } else if (type == EnumPacketServer.RecipeSave) {
            RecipeCarpentry recipe = RecipeController.instance.saveRecipe(Server.readNBT(buffer));
            NoppesUtilServer.sendRecipeData(player, recipe.isGlobal ? 3 : 4);
            NoppesUtilServer.setRecipeGui(player, recipe);
        } else if (type == EnumPacketServer.NaturalSpawnGetAll) {
            NoppesUtilServer.sendScrollData(player, SpawnController.instance.getScroll());
        } else if (type == EnumPacketServer.NaturalSpawnGet) {
            SpawnData spawn = SpawnController.instance.getSpawnData(buffer.readInt());
            if (spawn != null) {
                Server.sendData(player, EnumPacketClient.GUI_DATA, spawn.writeNBT(new NBTTagCompound()));
            }
        } else if (type == EnumPacketServer.NaturalSpawnSave) {
            SpawnData data = new SpawnData();
            data.readNBT(Server.readNBT(buffer));
            SpawnController.instance.saveSpawnData(data);
            NoppesUtilServer.sendScrollData(player, SpawnController.instance.getScroll());
        } else if (type == EnumPacketServer.NaturalSpawnRemove) {
            SpawnController.instance.removeSpawnData(buffer.readInt());
            NoppesUtilServer.sendScrollData(player, SpawnController.instance.getScroll());
        } else if (type == EnumPacketServer.DialogCategorySave) {
            DialogCategory category = new DialogCategory();
            category.readNBT(Server.readNBT(buffer));
            DialogController.instance.saveCategory(category);
            NoppesUtilServer.sendScrollData(player, DialogController.instance.getScroll());
        } else if (type == EnumPacketServer.DialogCategoryRemove) {
            DialogController.instance.removeCategory(buffer.readInt());
            NoppesUtilServer.sendScrollData(player, DialogController.instance.getScroll());
        } else if (type == EnumPacketServer.DialogCategoryGet) {
            DialogCategory category = DialogController.instance.categories.get(buffer.readInt());
            if (category != null) {
                NBTTagCompound comp = category.writeNBT(new NBTTagCompound());
                comp.func_82580_o("Dialogs");
                Server.sendData(player, EnumPacketClient.GUI_DATA, comp);
            }
        } else if (type == EnumPacketServer.DialogSave) {
            int category = buffer.readInt();
            Dialog dialog = new Dialog();
            dialog.readNBT(Server.readNBT(buffer));
            DialogController.instance.saveDialog(category, dialog);
            if (dialog.category != null) {
                NoppesUtilServer.sendDialogData(player, dialog.category);
            }
        } else if (type == EnumPacketServer.QuestOpenGui) {
            Quest quest = new Quest();
            int gui = buffer.readInt();
            quest.readNBT(Server.readNBT(buffer));
            NoppesUtilServer.setEditingQuest((EntityPlayer)player, quest);
            player.openGui((Object)CustomNpcs.instance, gui, player.field_70170_p, 0, 0, 0);
        } else if (type == EnumPacketServer.DialogRemove) {
            Dialog dialog = DialogController.instance.dialogs.get(buffer.readInt());
            if (dialog != null && dialog.category != null) {
                DialogController.instance.removeDialog(dialog);
                NoppesUtilServer.sendDialogData(player, dialog.category);
            }
        } else if (type == EnumPacketServer.DialogNpcGet) {
            NoppesUtilServer.sendNpcDialogs((EntityPlayer)player);
        } else if (type == EnumPacketServer.DialogNpcSet) {
            int dialog;
            int slot = buffer.readInt();
            DialogOption option = NoppesUtilServer.setNpcDialog(slot, dialog = buffer.readInt(), (EntityPlayer)player);
            if (option != null && option.hasDialog()) {
                NBTTagCompound compound = option.writeNBT();
                compound.func_74768_a("Position", slot);
                Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
            }
        } else if (type == EnumPacketServer.DialogNpcRemove) {
            npc.dialogs.remove(buffer.readInt());
        } else if (type == EnumPacketServer.QuestCategoryGet) {
            QuestCategory category = QuestController.instance.categories.get(buffer.readInt());
            if (category != null) {
                NBTTagCompound comp = category.writeNBT(new NBTTagCompound());
                comp.func_82580_o("Dialogs");
                Server.sendData(player, EnumPacketClient.GUI_DATA, comp);
            }
        } else if (type == EnumPacketServer.QuestCategorySave) {
            QuestCategory category = new QuestCategory();
            category.readNBT(Server.readNBT(buffer));
            QuestController.instance.saveCategory(category);
            NoppesUtilServer.sendQuestCategoryData(player);
        } else if (type == EnumPacketServer.QuestCategoryRemove) {
            QuestController.instance.removeCategory(buffer.readInt());
            NoppesUtilServer.sendQuestCategoryData(player);
        } else if (type == EnumPacketServer.QuestSave) {
            int category = buffer.readInt();
            Quest quest = new Quest();
            quest.readNBT(Server.readNBT(buffer));
            QuestController.instance.saveQuest(category, quest);
            if (quest.category != null) {
                NoppesUtilServer.sendQuestData(player, quest.category);
            }
        } else if (type == EnumPacketServer.QuestDialogGetTitle) {
            Dialog quest = DialogController.instance.dialogs.get(buffer.readInt());
            Dialog quest2 = DialogController.instance.dialogs.get(buffer.readInt());
            Dialog quest3 = DialogController.instance.dialogs.get(buffer.readInt());
            NBTTagCompound compound = new NBTTagCompound();
            if (quest != null) {
                compound.func_74778_a("1", quest.title);
            }
            if (quest2 != null) {
                compound.func_74778_a("2", quest2.title);
            }
            if (quest3 != null) {
                compound.func_74778_a("3", quest3.title);
            }
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.QuestRemove) {
            Quest quest = QuestController.instance.quests.get(buffer.readInt());
            if (quest != null) {
                QuestController.instance.removeQuest(quest);
                NoppesUtilServer.sendQuestData(player, quest.category);
            }
        } else if (type == EnumPacketServer.TransportCategoriesGet) {
            NoppesUtilServer.sendTransportCategoryData(player);
        } else if (type == EnumPacketServer.TransportCategorySave) {
            TransportController.getInstance().saveCategory(Server.readString(buffer), buffer.readInt());
        } else if (type == EnumPacketServer.TransportCategoryRemove) {
            TransportController.getInstance().removeCategory(buffer.readInt());
            NoppesUtilServer.sendTransportCategoryData(player);
        } else if (type == EnumPacketServer.TransportRemove) {
            int id = buffer.readInt();
            TransportLocation loc = TransportController.getInstance().removeLocation(id);
            if (loc != null) {
                NoppesUtilServer.sendTransportData(player, loc.category.id);
            }
        } else if (type == EnumPacketServer.TransportsGet) {
            NoppesUtilServer.sendTransportData(player, buffer.readInt());
        } else if (type == EnumPacketServer.TransportSave) {
            int cat = buffer.readInt();
            TransportLocation location = TransportController.getInstance().saveLocation(cat, Server.readNBT(buffer), npc);
            if (location != null) {
                if (npc.advanced.role != EnumRoleType.Transporter) {
                    return;
                }
                RoleTransporter role = (RoleTransporter)npc.roleInterface;
                role.setTransport(location);
            }
        } else if (type == EnumPacketServer.TransportGetLocation) {
            if (npc.advanced.role != EnumRoleType.Transporter) {
                return;
            }
            RoleTransporter role = (RoleTransporter)npc.roleInterface;
            if (role.hasTransport()) {
                Server.sendData(player, EnumPacketClient.GUI_DATA, role.getLocation().writeNBT());
                Server.sendData(player, EnumPacketClient.SCROLL_SELECTED, role.getLocation().category.title);
            }
        } else if (type == EnumPacketServer.FactionSet) {
            npc.setFaction(buffer.readInt());
        } else if (type == EnumPacketServer.FactionSave) {
            Faction faction = new Faction();
            faction.readNBT(Server.readNBT(buffer));
            FactionController.getInstance().saveFaction(faction);
            NoppesUtilServer.sendFactionDataAll(player);
            NBTTagCompound compound = new NBTTagCompound();
            faction.writeNBT(compound);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.FactionRemove) {
            FactionController.getInstance().delete(buffer.readInt());
            NoppesUtilServer.sendFactionDataAll(player);
            NBTTagCompound compound = new NBTTagCompound();
            new Faction().writeNBT(compound);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.PlayerDataGet) {
            int id = buffer.readInt();
            if (EnumPlayerData.values().length <= id) {
                return;
            }
            String name = null;
            EnumPlayerData datatype = EnumPlayerData.values()[id];
            if (datatype != EnumPlayerData.Players) {
                name = Server.readString(buffer);
            }
            NoppesUtilServer.sendPlayerData(datatype, player, name);
        } else if (type == EnumPacketServer.PlayerDataRemove) {
            NoppesUtilServer.removePlayerData(buffer, player);
        } else if (type == EnumPacketServer.MainmenuDisplayGet) {
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.display.writeToNBT(new NBTTagCompound()));
        } else if (type == EnumPacketServer.MainmenuDisplaySave) {
            npc.display.readToNBT(Server.readNBT(buffer));
            npc.updateClient = true;
        } else if (type == EnumPacketServer.MainmenuStatsGet) {
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.stats.writeToNBT(new NBTTagCompound()));
        } else if (type == EnumPacketServer.MainmenuStatsSave) {
            npc.stats.readToNBT(Server.readNBT(buffer));
            npc.updateClient = true;
        } else if (type == EnumPacketServer.MainmenuInvGet) {
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.inventory.writeEntityToNBT(new NBTTagCompound()));
        } else if (type == EnumPacketServer.MainmenuInvSave) {
            npc.inventory.readEntityFromNBT(Server.readNBT(buffer));
            npc.updateAI = true;
            npc.updateClient = true;
        } else if (type == EnumPacketServer.MainmenuAIGet) {
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.ai.writeToNBT(new NBTTagCompound()));
        } else if (type == EnumPacketServer.MainmenuAISave) {
            npc.ai.readToNBT(Server.readNBT(buffer));
            npc.func_70606_j(npc.func_110138_aP());
            npc.updateAI = true;
            npc.updateClient = true;
        } else if (type == EnumPacketServer.MainmenuAdvancedGet) {
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.advanced.writeToNBT(new NBTTagCompound()));
        } else if (type == EnumPacketServer.MainmenuAdvancedSave) {
            npc.advanced.readToNBT(Server.readNBT(buffer));
            npc.updateAI = true;
            npc.updateClient = true;
        } else if (type == EnumPacketServer.JobSave) {
            NBTTagCompound original = npc.jobInterface.writeToNBT(new NBTTagCompound());
            NBTTagCompound compound = Server.readNBT(buffer);
            Set names = compound.func_150296_c();
            for (String name : names) {
                original.func_74782_a(name, compound.func_74781_a(name));
            }
            npc.jobInterface.readFromNBT(original);
            npc.updateClient = true;
        } else if (type == EnumPacketServer.JobGet) {
            if (npc.jobInterface == null) {
                return;
            }
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74757_a("JobData", true);
            npc.jobInterface.writeToNBT(compound);
            if (npc.advanced.job == EnumJobType.Spawner) {
                ((JobSpawner)npc.jobInterface).cleanCompound(compound);
            }
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
            if (npc.advanced.job == EnumJobType.Spawner) {
                Server.sendData(player, EnumPacketClient.GUI_DATA, ((JobSpawner)npc.jobInterface).getTitles());
            }
        } else if (type == EnumPacketServer.JobSpawnerAdd) {
            if (npc.advanced.job != EnumJobType.Spawner) {
                return;
            }
            JobSpawner job = (JobSpawner)npc.jobInterface;
            if (buffer.readBoolean()) {
                NBTTagCompound compound = ServerCloneController.Instance.getCloneData(null, Server.readString(buffer), buffer.readInt());
                job.setJobCompound(buffer.readInt(), compound);
            } else {
                job.setJobCompound(buffer.readInt(), Server.readNBT(buffer));
            }
            Server.sendData(player, EnumPacketClient.GUI_DATA, job.getTitles());
        } else if (type == EnumPacketServer.RoleCompanionUpdate) {
            if (npc.advanced.role != EnumRoleType.Companion) {
                return;
            }
            ((RoleCompanion)npc.roleInterface).matureTo(EnumCompanionStage.values()[buffer.readInt()]);
            npc.updateClient = true;
        } else if (type == EnumPacketServer.JobSpawnerRemove) {
            if (npc.advanced.job != EnumJobType.Spawner) {
                return;
            }
        } else if (type == EnumPacketServer.RoleSave) {
            npc.roleInterface.readFromNBT(Server.readNBT(buffer));
            npc.updateClient = true;
        } else if (type == EnumPacketServer.RoleGet) {
            if (npc.roleInterface == null) {
                return;
            }
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74757_a("RoleData", true);
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.roleInterface.writeToNBT(compound));
        } else if (type == EnumPacketServer.MerchantUpdate) {
            Entity entity = player.field_70170_p.func_73045_a(buffer.readInt());
            if (entity == null || !(entity instanceof EntityVillager)) {
                return;
            }
            MerchantRecipeList list = MerchantRecipeList.func_151390_b((PacketBuffer)new PacketBuffer(buffer));
            ((EntityVillager)entity).func_70930_a(list);
        } else if (type == EnumPacketServer.ModelDataSave) {
            if (npc instanceof EntityCustomNpc) {
                ((EntityCustomNpc)npc).modelData.readFromNBT(Server.readNBT(buffer));
            }
        } else if (type == EnumPacketServer.MailOpenSetup) {
            PlayerMail mail = new PlayerMail();
            mail.readNBT(Server.readNBT(buffer));
            ContainerMail.staticmail = mail;
            player.openGui((Object)CustomNpcs.instance, EnumGuiType.PlayerMailman.ordinal(), player.field_70170_p, 1, 0, 0);
        } else if (type == EnumPacketServer.TransformSave) {
            boolean isValid = npc.transform.isValid();
            npc.transform.readOptions(Server.readNBT(buffer));
            if (isValid != npc.transform.isValid()) {
                npc.updateAI = true;
            }
        } else if (type == EnumPacketServer.TransformGet) {
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.transform.writeOptions(new NBTTagCompound()));
        } else if (type == EnumPacketServer.TransformLoad) {
            if (npc.transform.isValid()) {
                npc.transform.transform(buffer.readBoolean());
            }
        } else if (type == EnumPacketServer.TraderMarketSave) {
            String market = Server.readString(buffer);
            boolean bo = buffer.readBoolean();
            if (npc.roleInterface instanceof RoleTrader) {
                if (bo) {
                    Market.setMarket(npc, market);
                } else {
                    Market.save((RoleTrader)npc.roleInterface, market);
                }
            }
        } else {
            this.blockPackets(type, buffer, player);
        }
    }

    private void mountPackets(EnumPacketServer type, ByteBuf buffer, EntityPlayerMP player) throws IOException {
        if (type == EnumPacketServer.SpawnRider) {
            Entity entity = EntityList.func_75615_a((NBTTagCompound)Server.readNBT(buffer), (World)player.field_70170_p);
            player.field_70170_p.func_72838_d(entity);
            entity.func_70078_a(ServerEventsHandler.mounted);
        } else if (type == EnumPacketServer.PlayerRider) {
            player.func_70078_a(ServerEventsHandler.mounted);
        } else if (type == EnumPacketServer.CloneList) {
            NBTTagList list = new NBTTagList();
            for (String name : ServerCloneController.Instance.getClones(buffer.readInt())) {
                list.func_74742_a((NBTBase)new NBTTagString(name));
            }
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a("List", (NBTBase)list);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else {
            this.warn((EntityPlayer)player, "tried todo something with the wrong tool, probably a hacker");
        }
    }

    private void clonePackets(EnumPacketServer type, ByteBuf buffer, EntityPlayerMP player) throws IOException {
        if (type == EnumPacketServer.SpawnMob) {
            boolean server = buffer.readBoolean();
            int x = buffer.readInt();
            int y = buffer.readInt();
            int z = buffer.readInt();
            NBTTagCompound compound = server ? ServerCloneController.Instance.getCloneData((ICommandSender)player, Server.readString(buffer), buffer.readInt()) : Server.readNBT(buffer);
            if (compound == null) {
                return;
            }
            Entity entity = NoppesUtilServer.spawnClone(compound, x, y, z, player.field_70170_p);
            if (entity == null) {
                player.func_145747_a((IChatComponent)new ChatComponentText("Failed to create an entity out of your clone"));
                return;
            }
        } else if (type == EnumPacketServer.MobSpawner) {
            boolean server = buffer.readBoolean();
            int x = buffer.readInt();
            int y = buffer.readInt();
            int z = buffer.readInt();
            NBTTagCompound compound = server ? ServerCloneController.Instance.getCloneData((ICommandSender)player, Server.readString(buffer), buffer.readInt()) : Server.readNBT(buffer);
            if (compound != null) {
                NoppesUtilServer.createMobSpawner(x, y, z, compound, (EntityPlayer)player);
            }
        } else if (type == EnumPacketServer.ClonePreSave) {
            boolean bo = ServerCloneController.Instance.getCloneData(null, Server.readString(buffer), buffer.readInt()) != null;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74757_a("NameExists", bo);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.CloneSave) {
            PlayerData data = PlayerDataController.instance.getPlayerData((EntityPlayer)player);
            if (data.cloned == null) {
                return;
            }
            ServerCloneController.Instance.addClone(data.cloned, Server.readString(buffer), buffer.readInt());
        } else if (type == EnumPacketServer.CloneRemove) {
            int tab = buffer.readInt();
            ServerCloneController.Instance.removeClone(Server.readString(buffer), tab);
            NBTTagList list = new NBTTagList();
            for (String name : ServerCloneController.Instance.getClones(tab)) {
                list.func_74742_a((NBTBase)new NBTTagString(name));
            }
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a("List", (NBTBase)list);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.CloneList) {
            NBTTagList list = new NBTTagList();
            for (String name : ServerCloneController.Instance.getClones(buffer.readInt())) {
                list.func_74742_a((NBTBase)new NBTTagString(name));
            }
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a("List", (NBTBase)list);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else {
            this.warn((EntityPlayer)player, "tried todo something with the wrong tool, probably a hacker");
        }
    }

    private void warn(EntityPlayer player, String warning) {
        MinecraftServer.func_71276_C().func_71236_h(player.func_70005_c_() + ": " + warning);
    }
}

