/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import java.util.HashMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.ModelPartConfig;
import noppes.npcs.ModelPartData;

public class ModelDataShared {
    public ModelPartConfig arms = new ModelPartConfig();
    public ModelPartConfig body = new ModelPartConfig();
    public ModelPartConfig legs = new ModelPartConfig();
    public ModelPartConfig head = new ModelPartConfig();
    public ModelPartData legParts = new ModelPartData();
    public Class<? extends EntityLivingBase> entityClass;
    public EntityLivingBase entity;
    public NBTTagCompound extra = new NBTTagCompound();
    private HashMap<String, ModelPartData> parts = new HashMap();
    public byte breasts = 0;
    public byte headwear = (byte)2;
    public byte bodywear = 0;
    public byte armwear = 0;
    public byte legwear = 0;
    public byte solidArmwear = 0;
    public byte solidLegwear = 0;
    public byte hideHead = 0;
    public byte hideBody = 0;
    public byte hideArms = 0;
    public byte hideLegs = 0;

    public NBTTagCompound writeToNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        if (this.entityClass != null) {
            compound.func_74778_a("EntityClass", this.entityClass.getCanonicalName());
        }
        compound.func_74782_a("ArmsConfig", (NBTBase)this.arms.writeToNBT());
        compound.func_74782_a("BodyConfig", (NBTBase)this.body.writeToNBT());
        compound.func_74782_a("LegsConfig", (NBTBase)this.legs.writeToNBT());
        compound.func_74782_a("HeadConfig", (NBTBase)this.head.writeToNBT());
        compound.func_74782_a("LegParts", (NBTBase)this.legParts.writeToNBT());
        compound.func_74774_a("Headwear", this.headwear);
        compound.func_74774_a("Bodywear", this.bodywear);
        compound.func_74774_a("Armwear", this.armwear);
        compound.func_74774_a("Legwear", this.legwear);
        compound.func_74774_a("SolidArmwear", this.solidArmwear);
        compound.func_74774_a("SolidLegwear", this.solidLegwear);
        compound.func_74774_a("hideHead", this.hideHead);
        compound.func_74774_a("hideBody", this.hideBody);
        compound.func_74774_a("hideArms", this.hideArms);
        compound.func_74774_a("hideLegs", this.hideLegs);
        compound.func_74774_a("Breasts", this.breasts);
        compound.func_74782_a("ExtraData", (NBTBase)this.extra);
        NBTTagList list = new NBTTagList();
        for (String name : this.parts.keySet()) {
            NBTTagCompound item = this.parts.get(name).writeToNBT();
            item.func_74778_a("PartName", name);
            list.func_74742_a((NBTBase)item);
        }
        compound.func_74782_a("Parts", (NBTBase)list);
        return compound;
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.setEntityClass(compound.func_74779_i("EntityClass"));
        this.arms.readFromNBT(compound.func_74775_l("ArmsConfig"));
        this.body.readFromNBT(compound.func_74775_l("BodyConfig"));
        this.legs.readFromNBT(compound.func_74775_l("LegsConfig"));
        this.head.readFromNBT(compound.func_74775_l("HeadConfig"));
        this.legParts.readFromNBT(compound.func_74775_l("LegParts"));
        this.headwear = compound.func_74771_c("Headwear");
        this.bodywear = compound.func_74771_c("Bodywear");
        this.armwear = compound.func_74771_c("Armwear");
        this.legwear = compound.func_74771_c("Legwear");
        this.solidArmwear = compound.func_74771_c("SolidArmwear");
        this.solidLegwear = compound.func_74771_c("SolidLegwear");
        this.hideHead = compound.func_74771_c("hideHead");
        this.hideBody = compound.func_74771_c("hideBody");
        this.hideArms = compound.func_74771_c("hideArms");
        this.hideLegs = compound.func_74771_c("hideLegs");
        this.breasts = compound.func_74771_c("Breasts");
        this.extra = compound.func_74775_l("ExtraData");
        HashMap<String, ModelPartData> parts = new HashMap<String, ModelPartData>();
        NBTTagList list = compound.func_150295_c("Parts", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound item = list.func_150305_b(i);
            ModelPartData part = new ModelPartData();
            part.readFromNBT(item);
            parts.put(item.func_74779_i("PartName"), part);
        }
        this.parts = parts;
    }

    public void readPartsFromNBT(NBTTagCompound compound) {
        this.legParts.readFromNBT(compound.func_74775_l("LegParts"));
        HashMap<String, ModelPartData> parts = new HashMap<String, ModelPartData>();
        NBTTagList list = compound.func_150295_c("Parts", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound item = list.func_150305_b(i);
            ModelPartData part = new ModelPartData();
            part.readFromNBT(item);
            parts.put(item.func_74779_i("PartName"), part);
        }
        this.parts = parts;
    }

    private void setEntityClass(String string) {
        this.entityClass = null;
        this.entity = null;
        try {
            Class<?> cls = Class.forName(string);
            if (EntityLivingBase.class.isAssignableFrom(cls)) {
                this.entityClass = cls.asSubclass(EntityLivingBase.class);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void setEntityClass(Class<? extends EntityLivingBase> entityClass) {
        this.entityClass = entityClass;
        this.entity = null;
        this.extra = new NBTTagCompound();
        if (entityClass == EntityHorse.class) {
            this.extra.func_74768_a("Type", -1);
        }
    }

    public Class<? extends EntityLivingBase> getEntityClass() {
        return this.entityClass;
    }

    public float offsetY() {
        if (this.entity == null) {
            return -this.getBodyY();
        }
        return this.entity.field_70131_O - 1.8f;
    }

    public void clearEntity() {
        this.entity = null;
    }

    public ModelPartData getPartData(String type) {
        return this.parts.get(type);
    }

    public void removePart(String type) {
        this.parts.remove(type);
    }

    public ModelPartData getOrCreatePart(String type) {
        ModelPartData part = this.parts.get(type);
        if (part == null) {
            part = new ModelPartData();
            this.parts.put(type, part);
        }
        return part;
    }

    public float getBodyY() {
        if (this.legParts.type == 3) {
            return (0.9f - this.body.scaleY) * 0.75f + this.getLegsY();
        }
        if (this.legParts.type == 3) {
            return (0.5f - this.body.scaleY) * 0.75f + this.getLegsY();
        }
        return (1.0f - this.body.scaleY) * 0.75f + this.getLegsY();
    }

    public float getLegsY() {
        if (this.legParts.type == 3) {
            return (0.87f - this.legs.scaleY) * 1.0f;
        }
        return (1.0f - this.legs.scaleY) * 0.75f;
    }
}

