/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.network;

import com.flansmod.common.FlansMod;
import com.flansmod.common.network.PacketBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class PacketParticle
extends PacketBase {
    public float x;
    public float y;
    public float z;
    public float mx;
    public float my;
    public float mz;
    public float scale;
    public String particleType;

    public PacketParticle() {
    }

    public PacketParticle(String s, double x1, double y1, double z1, double x2, double y2, double z2) {
        this(s, x1, y1, z1, x2, y2, z2, 1.0f);
    }

    public PacketParticle(String s, double x1, double y1, double z1, double x2, double y2, double z2, float size) {
        this.x = (float)x1;
        this.y = (float)y1;
        this.z = (float)z1;
        this.mx = (float)x2;
        this.my = (float)y2;
        this.mz = (float)z2;
        this.particleType = s;
        this.scale = size;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        data.writeFloat(this.x);
        data.writeFloat(this.y);
        data.writeFloat(this.z);
        data.writeFloat(this.mx);
        data.writeFloat(this.my);
        data.writeFloat(this.mz);
        data.writeFloat(this.scale);
        this.writeUTF(data, this.particleType);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        this.x = data.readFloat();
        this.y = data.readFloat();
        this.z = data.readFloat();
        this.mx = data.readFloat();
        this.my = data.readFloat();
        this.mz = data.readFloat();
        this.scale = data.readFloat();
        this.particleType = this.readUTF(data);
    }

    @Override
    public void handleServerSide(EntityPlayerMP playerEntity) {
        FlansMod.log("Received particle packet on server. Disregarding.");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer clientPlayer) {
        FlansMod.proxy.spawnParticle(this.particleType, this.x, this.y, this.z, this.mx, this.my, this.mz, this.scale);
    }
}

