/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.driveables;

import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.DriveableData;
import com.flansmod.common.driveables.EntityPlane;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.driveables.EnumPlaneMode;
import com.flansmod.common.driveables.PlaneType;
import com.flansmod.common.driveables.Propeller;
import com.flansmod.common.network.PacketParticle;
import com.flansmod.common.vector.Vector3f;
import net.minecraft.util.DamageSource;

public class FlightController {
    public float throttle;
    public float yawControl;
    public float pitchControl;
    public float rollControl;
    public EnumPlaneMode mode;
    public float gravity = 1.0f;
    public float drag = 0.0f;
    public float thrust = 0.0f;
    public float lift = 0.0f;
    public Vector3f angularMomentum = new Vector3f(0.0f, 0.0f, 0.0f);
    public float fuelConsumptionMultiplier = 2.0f;
    public boolean leftWing = true;
    public boolean rightWing = true;
    public boolean tail = true;
    public float doomsday = 0.0f;

    public void UpdateParams(EntityPlane plane) {
        this.throttle = plane.throttle;
        this.yawControl = plane.flapsYaw;
        this.pitchControl = (plane.flapsPitchLeft + plane.flapsPitchRight) / 2.0f;
        this.rollControl = (plane.flapsPitchRight - plane.flapsPitchLeft) / 2.0f;
        this.mode = plane.mode;
    }

    public void fly(EntityPlane plane) {
        PlaneType type = plane.getPlaneType();
        DriveableData data = plane.getDriveableData();
        this.UpdateParams(plane);
        this.SetAxes(plane);
        this.thrust = this.throttle > 0.0f ? 0.01f * ((plane.isUnderWater() ? type.maxThrottleInWater : type.maxThrottle) + (data.engine == null ? 0.0f : data.engine.engineSpeed)) : 0.01f * (type.maxNegativeThrottle + (data.engine == null ? 0.0f : data.engine.engineSpeed));
        this.gravity = 0.098000005f;
        this.drag = 1.0f - 0.05f * type.drag;
        boolean doSpeedKick = false;
        if (plane.collisionHardness.floatValue() > 0.2f) {
            this.thrust = 0.0f;
            this.throttle = 0.0f;
            this.drag = 0.8f - (float)plane.getSpeedXYZ() < 0.0f ? 0.0f : 0.8f - (float)plane.getSpeedXYZ();
            doSpeedKick = plane.getSpeedXYZ() > 0.1;
        }
        plane.collisionHardness = Float.valueOf(0.0f);
        switch (this.mode) {
            case PLANE: {
                if (type.newFlightControl) {
                    this.NewPlaneModeFly(plane);
                    break;
                }
                this.PlaneModeFly(plane);
                break;
            }
            case HELI: {
                this.HeliModeFly(plane);
                break;
            }
            case SIXDOF: {
                break;
            }
        }
        if (doSpeedKick) {
            plane.field_70159_w = 0.0;
            plane.field_70179_y = 0.0;
        }
    }

    public void SetAxes(EntityPlane plane) {
        PlaneType type = plane.getPlaneType();
        float sensitivityAdjust = 0.0f;
        float yawSensitivity = 0.0f;
        float speed = (float)plane.getSpeedXYZ();
        if (this.mode == EnumPlaneMode.HELI) {
            float f = sensitivityAdjust = this.throttle > 0.5f ? 1.5f - this.throttle : 4.0f * this.throttle - 1.0f;
            if (sensitivityAdjust < 0.0f) {
                sensitivityAdjust = 0.0f;
            }
            yawSensitivity = sensitivityAdjust;
        } else {
            sensitivityAdjust = speed < 0.5f ? 0.0f : (speed < 1.0f ? 2.0f * speed - 1.0f : (speed < 3.0f ? 1.5f - speed / 2.0f : 0.0f));
            yawSensitivity = plane.getSpeedXZ() < 0.7 ? 5.0f * (0.5f * speed) / (float)Math.sqrt(type.turnRightModifier) : sensitivityAdjust;
        }
        float yaw = this.yawControl * (this.yawControl > 0.0f ? type.turnLeftModifier : type.turnRightModifier) * (yawSensitivity *= 0.125f);
        float pitch = this.pitchControl * (this.pitchControl > 0.0f ? type.lookUpModifier : type.lookDownModifier) * (sensitivityAdjust *= 0.125f);
        float roll = this.rollControl * (this.rollControl > 0.0f ? type.rollLeftModifier : type.rollRightModifier) * sensitivityAdjust;
        if (this.mode == EnumPlaneMode.PLANE) {
            if (!plane.isPartIntact(EnumDriveablePart.tail)) {
                yaw = 0.0f;
                pitch = 0.0f;
            }
            if (!plane.isPartIntact(EnumDriveablePart.leftWing)) {
                roll = (float)((double)roll - 2.0 * plane.getSpeedXZ());
            }
            if (!plane.isPartIntact(EnumDriveablePart.rightWing)) {
                roll = (float)((double)roll + 2.0 * plane.getSpeedXZ());
            }
        } else if (this.mode == EnumPlaneMode.HELI && !plane.isPartIntact(EnumDriveablePart.tail)) {
            yaw = 10.0f * this.throttle;
        }
        this.angularMomentum.x = this.moveToTarget(this.angularMomentum.x, yaw, 1.0f);
        this.angularMomentum.y = this.moveToTarget(this.angularMomentum.y, pitch, 1.0f);
        this.angularMomentum.z = this.moveToTarget(this.angularMomentum.z, roll, 1.0f);
        this.LimitAngularMomentum(this.angularMomentum, 20.0f);
        plane.axes.rotateLocalYaw(this.angularMomentum.x);
        plane.axes.rotateLocalPitch(this.angularMomentum.y);
        plane.axes.rotateLocalRoll(-this.angularMomentum.z);
        this.angularMomentum.scale(0.99f);
    }

    public float moveToTarget(float current, float target, float speed) {
        float pitchToMove;
        for (pitchToMove = (float)(Math.sqrt(target * target) - Math.sqrt(current * current)); pitchToMove > 180.0f; pitchToMove -= 360.0f) {
        }
        while (pitchToMove <= -180.0f) {
            pitchToMove += 360.0f;
        }
        float signDeltaY = 0.0f;
        if (pitchToMove > speed) {
            signDeltaY = 1.0f;
        } else if (pitchToMove < -speed) {
            signDeltaY = -1.0f;
        } else {
            signDeltaY = 0.0f;
            return target;
        }
        if (current > target) {
            current -= speed;
        } else if (current < target) {
            current += speed;
        }
        return current;
    }

    public void LimitAngularMomentum(Vector3f vec, float angle) {
        if (vec.x > angle) {
            vec.x = angle;
        }
        if (vec.x < -angle) {
            vec.x = -angle;
        }
        if (vec.y > angle) {
            vec.y = angle;
        }
        if (vec.y < -angle) {
            vec.y = -angle;
        }
        if (vec.z > angle) {
            vec.z = angle;
        }
        if (vec.z < -angle) {
            vec.z = -angle;
        }
    }

    public void PlaneModeFly(EntityPlane plane) {
        PlaneType type = plane.getPlaneType();
        DriveableData data = plane.getDriveableData();
        if (plane.mode == EnumPlaneMode.HELI) {
            return;
        }
        int numPropsWorking = 0;
        int numProps = 0;
        float flap = this.angularMomentum.length();
        this.drag -= flap / 100.0f;
        this.throttle -= -flap / 500.0f;
        for (Propeller prop : type.propellers) {
            if (!plane.isPartIntact(prop.planePart)) continue;
            ++numPropsWorking;
        }
        numProps = type.propellers.size();
        if (numProps == 0) {
            return;
        }
        Vector3f forwards = (Vector3f)plane.axes.getXAxis().normalise();
        float lastTickSpeed = (float)plane.getSpeedXYZ();
        if (lastTickSpeed > 2.0f) {
            lastTickSpeed = 2.0f;
        }
        float newSpeed = lastTickSpeed + this.thrust * 2.0f;
        float proportionOfMotionToCorrect = 2.0f * Math.abs(this.throttle);
        if (proportionOfMotionToCorrect < 0.0f) {
            proportionOfMotionToCorrect = 0.0f;
        }
        if (proportionOfMotionToCorrect > 1.5f) {
            proportionOfMotionToCorrect = 1.5f;
        }
        int numWingsIntact = 0;
        if (plane.isPartIntact(EnumDriveablePart.rightWing)) {
            ++numWingsIntact;
        }
        if (plane.isPartIntact(EnumDriveablePart.leftWing)) {
            ++numWingsIntact;
        }
        this.lift = (float)plane.getSpeedXYZ() * (float)plane.getSpeedXYZ() * (float)numWingsIntact / 2.0f;
        Vector3f up2 = (Vector3f)plane.axes.getYAxis().normalise();
        this.lift = (float)((double)this.lift * Math.sqrt(up2.y * up2.y));
        if (this.lift > this.gravity) {
            this.lift = this.gravity;
        }
        plane.field_70159_w *= (double)(1.0f - proportionOfMotionToCorrect);
        plane.field_70181_x *= (double)(1.0f - proportionOfMotionToCorrect);
        plane.field_70179_y *= (double)(1.0f - proportionOfMotionToCorrect);
        plane.field_70159_w += (double)(proportionOfMotionToCorrect * newSpeed * forwards.x);
        plane.field_70181_x += (double)(proportionOfMotionToCorrect * newSpeed * forwards.y);
        plane.field_70179_y += (double)(proportionOfMotionToCorrect * newSpeed * forwards.z);
        plane.field_70181_x += (double)this.lift;
        plane.field_70181_x = plane.wheels.length > 1 && plane.wheels[0] != null && plane.wheels[1] != null && plane.wheels[0].field_70122_E && plane.wheels[1].field_70122_E ? -0.01 : (plane.field_70181_x -= (double)this.gravity);
        if (!plane.isPartIntact(EnumDriveablePart.rightWing) && !plane.isPartIntact(EnumDriveablePart.rightWing)) {
            plane.field_70181_x += -1.0;
        }
        plane.field_70159_w *= (double)this.drag;
        plane.field_70181_x = plane.field_70163_u - plane.field_70167_r < 0.0 ? plane.field_70181_x * (this.drag < 1.0f ? 0.999 : 1.0) : (plane.field_70181_x *= (double)this.drag);
        plane.field_70179_y *= (double)this.drag;
        plane.lastPos = new Vector3f(plane.field_70159_w, plane.field_70181_x, plane.field_70179_y);
        if (!plane.driverIsCreative()) {
            data.fuelInTank = data.fuelInTank >= this.thrust * this.fuelConsumptionMultiplier * data.engine.fuelConsumption ? (data.fuelInTank -= this.thrust * this.fuelConsumptionMultiplier * data.engine.fuelConsumption) : 0.0f;
        }
        if (plane.getSpeedXYZ() > 2.0) {
            plane.axes.rotateLocalPitch(((float)Math.random() - 0.5f) / 4.0f);
            plane.axes.rotateLocalYaw(((float)Math.random() - 0.5f) / 4.0f);
            plane.axes.rotateLocalRoll(((float)Math.random() - 0.5f) / 4.0f);
        }
    }

    public void NewPlaneModeFly(EntityPlane plane) {
        PlaneType type = plane.getPlaneType();
        DriveableData data = plane.getDriveableData();
        float speed = (float)plane.getSpeedXYZ();
        Vector3f longAxis = (Vector3f)plane.axes.getXAxis().normalise();
        Vector3f vertAxis = (Vector3f)plane.axes.getYAxis().normalise();
        if (plane.mode == EnumPlaneMode.HELI) {
            return;
        }
        int numPropsWorking = 0;
        int numProps = 0;
        float flap = this.angularMomentum.length();
        this.drag -= flap / 100.0f;
        this.throttle -= -flap / 500.0f;
        this.thrust = this.throttle * type.maxThrust;
        for (Propeller prop : type.propellers) {
            if (!plane.isPartIntact(prop.planePart)) continue;
            ++numPropsWorking;
        }
        numProps = type.propellers.size();
        if (numProps == 0) {
            return;
        }
        if (speed > type.maxSpeed) {
            speed = type.maxSpeed;
        }
        float newSpeed = speed + this.thrust / type.mass * (float)numPropsWorking;
        float proportionOfMotionToCorrect = 2.0f * Math.abs(this.throttle);
        if (proportionOfMotionToCorrect < 0.0f) {
            proportionOfMotionToCorrect = 0.0f;
        }
        if (proportionOfMotionToCorrect > 1.5f) {
            proportionOfMotionToCorrect = 1.5f;
        }
        this.gravity = 0.098000005f;
        plane.field_70181_x -= (double)this.gravity;
        int numWingsIntact = 0;
        if (plane.isPartIntact(EnumDriveablePart.rightWing)) {
            ++numWingsIntact;
        }
        if (plane.isPartIntact(EnumDriveablePart.leftWing)) {
            ++numWingsIntact;
        }
        this.lift = type.lift * (speed * speed / 2.0f) * type.wingArea * (float)numWingsIntact / 2.0f;
        this.lift = (float)((double)this.lift * Math.sqrt(vertAxis.y * vertAxis.y));
        if (speed < type.takeoffSpeed) {
            this.lift = -9.8f;
        } else if (speed < type.takeoffSpeed * 0.5f) {
            this.lift = -4.9f;
        } else if (speed < type.takeoffSpeed * 0.75f) {
            this.lift = -2.45f;
        } else if (speed < type.takeoffSpeed * 0.9f) {
            this.lift = -0.65f;
        } else if (speed < type.takeoffSpeed) {
            this.lift = -0.3f;
        } else if (speed > type.takeoffSpeed) {
            this.lift = this.gravity;
        }
        if (this.lift > this.gravity) {
            this.lift = this.gravity;
        }
        if ((double)this.thrust / ((double)(type.mass * this.gravity) * 0.5) > (double)type.mass) {
            this.lift = this.gravity;
        }
        plane.field_70159_w *= (double)(1.0f - proportionOfMotionToCorrect);
        plane.field_70181_x *= (double)(1.0f - proportionOfMotionToCorrect);
        plane.field_70179_y *= (double)(1.0f - proportionOfMotionToCorrect);
        plane.field_70159_w += (double)(proportionOfMotionToCorrect * newSpeed * longAxis.x);
        plane.field_70181_x += (double)(proportionOfMotionToCorrect * newSpeed * longAxis.y);
        plane.field_70179_y += (double)(proportionOfMotionToCorrect * newSpeed * longAxis.z);
        plane.field_70181_x -= (double)this.gravity;
        plane.field_70181_x = plane.wheels[0] != null && plane.wheels[1] != null && plane.wheels[0].field_70122_E && plane.wheels[1].field_70122_E ? -0.001 : (plane.field_70181_x -= (double)this.gravity);
        if (!plane.isPartIntact(EnumDriveablePart.rightWing) && !plane.isPartIntact(EnumDriveablePart.rightWing)) {
            plane.field_70181_x -= (double)this.gravity;
        }
        plane.field_70159_w *= (double)this.drag;
        plane.field_70181_x = plane.field_70163_u - plane.field_70167_r < 0.0 ? plane.field_70181_x * (this.drag < 1.0f ? 0.999 : 1.0) : (plane.field_70181_x *= (double)this.drag);
        plane.field_70179_y *= (double)this.drag;
        plane.lastPos = new Vector3f(plane.field_70159_w, plane.field_70181_x, plane.field_70179_y);
        if (!plane.isPartIntact(EnumDriveablePart.airframe)) {
            plane.field_70181_x += (double)(-this.gravity);
            this.lift = -9.8f;
            plane.throttle = 0.0f;
            if (plane.axes.getRoll() > 0.1f) {
                plane.axes.rotateLocalRoll(-5.0f);
            }
            if (plane.axes.getRoll() < -0.1f) {
                plane.axes.rotateLocalRoll(5.0f);
            }
            this.doomsday += 1.0f;
            if (plane.axes.getPitch() < 35.0f) {
                plane.axes.rotateLocalPitch(-0.05f * this.doomsday);
            }
            plane.attackPart(EnumDriveablePart.core, DamageSource.field_76377_j, 1.0f);
        }
        if (!plane.isPartIntact(EnumDriveablePart.tail)) {
            plane.field_70181_x += (double)(-this.gravity);
            this.lift *= 0.8f;
            this.lift = (float)((double)this.lift - 1.960000029206276);
            this.tail = false;
            if (this.doomsday < 1500.0f) {
                this.doomsday += 1.0f;
            }
            if (this.doomsday >= 1500.0f) {
                plane.attackPart(EnumDriveablePart.core, DamageSource.field_76377_j, 1.0f);
            }
            plane.axes.rotateLocalPitch(type.lookUpModifier * this.doomsday / this.doomsday / 2.0f);
            plane.attackPart(EnumDriveablePart.core, DamageSource.field_76377_j, 1.0f);
        }
        if (!plane.isPartIntact(EnumDriveablePart.leftWing)) {
            plane.field_70181_x += (double)(-this.gravity);
            this.leftWing = false;
            if (this.doomsday < 1500.0f) {
                this.doomsday += 1.0f;
            }
            if (this.doomsday >= 1500.0f) {
                plane.attackPart(EnumDriveablePart.core, DamageSource.field_76377_j, 1.0f);
            }
            plane.axes.rotateLocalRoll(type.rollRightModifier * this.doomsday / this.doomsday / 1.0f);
            plane.attackPart(EnumDriveablePart.core, DamageSource.field_76377_j, 1.0f);
        }
        if (!plane.isPartIntact(EnumDriveablePart.rightWing)) {
            plane.field_70181_x += (double)this.gravity;
            this.rightWing = false;
            if (this.doomsday < 1500.0f) {
                this.doomsday += 1.0f;
            }
            if (this.doomsday >= 1500.0f) {
                plane.attackPart(EnumDriveablePart.core, DamageSource.field_76377_j, 1.0f);
            }
            plane.axes.rotateLocalRoll(-type.rollLeftModifier * this.doomsday / this.doomsday / 15.0f);
            plane.attackPart(EnumDriveablePart.core, DamageSource.field_76377_j, 1.0f);
        }
        if (this.doomsday >= 100.0f) {
            FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("largeexplode", plane.field_70165_t, plane.field_70163_u + 1.0, plane.field_70161_v, 0.0, 0.0, 0.0), plane.field_70165_t, plane.field_70163_u, plane.field_70161_v, 150.0f, plane.field_71093_bK);
        }
        if (this.doomsday >= 100.0f) {
            FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("largesmoke", plane.field_70165_t, plane.field_70163_u, plane.field_70161_v, 0.0, 0.0, 0.0), plane.field_70165_t, plane.field_70163_u, plane.field_70161_v, 150.0f, plane.field_71093_bK);
        }
        if (this.doomsday >= 20.0f) {
            FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("flansmod.fmflame", plane.field_70165_t, plane.field_70163_u, plane.field_70161_v + 1.0, 0.0, 0.0, 0.0), plane.field_70165_t, plane.field_70163_u, plane.field_70161_v, 150.0f, plane.field_71093_bK);
        }
        if (this.doomsday >= 20.0f) {
            FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("flansmod.fmflame", plane.field_70165_t, plane.field_70163_u + 3.0, plane.field_70161_v - 0.7, 0.0, 0.0, 0.0), plane.field_70165_t, plane.field_70163_u, plane.field_70161_v, 150.0f, plane.field_71093_bK);
        }
        if (this.doomsday >= 20.0f) {
            FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("flansmod.fmflame", plane.field_70165_t, plane.field_70163_u + 1.0, plane.field_70161_v + 1.3, 0.0, 0.0, 0.0), plane.field_70165_t, plane.field_70163_u, plane.field_70161_v, 150.0f, plane.field_71093_bK);
        }
        if (this.doomsday >= 100.0f) {
            FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("largesmoke", plane.field_70165_t, plane.field_70163_u + 1.5, plane.field_70161_v + 0.5, 0.0, 0.0, 0.0), plane.field_70165_t, plane.field_70163_u, plane.field_70161_v, 150.0f, plane.field_71093_bK);
        }
        if (this.doomsday >= 100.0f) {
            FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("lava", plane.field_70165_t, plane.field_70163_u + 1.0, plane.field_70161_v - 0.5, 0.0, 0.0, 0.0), plane.field_70165_t, plane.field_70163_u, plane.field_70161_v, 150.0f, plane.field_71093_bK);
        }
        if (this.doomsday >= 100.0f) {
            FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("lava", plane.field_70165_t, plane.field_70163_u, plane.field_70161_v + 0.5, 0.0, 0.0, 0.0), plane.field_70165_t, plane.field_70163_u, plane.field_70161_v, 150.0f, plane.field_71093_bK);
        }
        if (this.doomsday >= 100.0f) {
            FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("lava", plane.field_70165_t, plane.field_70163_u - 0.5, plane.field_70161_v - 2.0, 0.0, 0.0, 0.0), plane.field_70165_t, plane.field_70163_u, plane.field_70161_v, 150.0f, plane.field_71093_bK);
        }
        if (this.doomsday >= 100.0f) {
            FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("flansmod.fmflame", plane.field_70165_t, plane.field_70163_u + 1.0, plane.field_70161_v, 0.0, 0.0, 0.0), plane.field_70165_t, plane.field_70163_u, plane.field_70161_v, 150.0f, plane.field_71093_bK);
        }
        if (this.doomsday == 5.0f) {
            FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("hugeexplosion", plane.field_70165_t, plane.field_70163_u + 1.0, plane.field_70161_v, 0.0, 0.0, 0.0), plane.field_70165_t, plane.field_70163_u, plane.field_70161_v, 150.0f, plane.field_71093_bK);
        }
        if (this.doomsday == 18.0f) {
            FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("largeexplode", plane.field_70165_t, plane.field_70163_u + 1.0, plane.field_70161_v, 0.0, 0.0, 0.0), plane.field_70165_t, plane.field_70163_u, plane.field_70161_v, 150.0f, plane.field_71093_bK);
        }
        if (this.doomsday == 30.0f) {
            FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("largeexplode", plane.field_70165_t, plane.field_70163_u + 1.0, plane.field_70161_v, 0.0, 0.0, 0.0), plane.field_70165_t, plane.field_70163_u, plane.field_70161_v, 150.0f, plane.field_71093_bK);
        }
        if (this.doomsday == 100.0f) {
            FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("hugeexplosion", plane.field_70165_t, plane.field_70163_u + 1.0, plane.field_70161_v, 0.0, 0.0, 0.0), plane.field_70165_t, plane.field_70163_u, plane.field_70161_v, 150.0f, plane.field_71093_bK);
        }
        if (!(this.doomsday != 700.0f || this.leftWing && this.tail && this.rightWing)) {
            FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("hugeexplosion", plane.field_70165_t, plane.field_70163_u + 1.0, plane.field_70161_v, 0.0, 0.0, 0.0), plane.field_70165_t, plane.field_70163_u, plane.field_70161_v, 150.0f, plane.field_71093_bK);
        }
        if (!(this.doomsday != 720.0f || this.leftWing && this.tail && this.rightWing)) {
            FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("hugeexplosion", plane.field_70165_t, plane.field_70163_u + 1.0, plane.field_70161_v, 0.0, 0.0, 0.0), plane.field_70165_t, plane.field_70163_u, plane.field_70161_v, 150.0f, plane.field_71093_bK);
        }
        if (!(this.doomsday != 725.0f || this.leftWing && this.tail && this.rightWing)) {
            FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("hugeexplosion", plane.field_70165_t, plane.field_70163_u + 1.0, plane.field_70161_v, 0.0, 0.0, 0.0), plane.field_70165_t, plane.field_70163_u, plane.field_70161_v, 150.0f, plane.field_71093_bK);
        }
        if (!(this.doomsday != 740.0f || this.leftWing && this.tail && this.rightWing)) {
            FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("hugeexplosion", plane.field_70165_t, plane.field_70163_u + 1.0, plane.field_70161_v, 0.0, 0.0, 0.0), plane.field_70165_t, plane.field_70163_u, plane.field_70161_v, 150.0f, plane.field_71093_bK);
        }
        if (!(this.doomsday != 748.0f || this.leftWing && this.tail && this.rightWing)) {
            FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("hugeexplosion", plane.field_70165_t, plane.field_70163_u + 1.0, plane.field_70161_v, 0.0, 0.0, 0.0), plane.field_70165_t, plane.field_70163_u, plane.field_70161_v, 150.0f, plane.field_71093_bK);
        }
        if (!plane.driverIsCreative()) {
            data.fuelInTank = data.fuelInTank >= this.thrust * this.fuelConsumptionMultiplier * data.engine.fuelConsumption ? (data.fuelInTank -= this.thrust * this.fuelConsumptionMultiplier * data.engine.fuelConsumption) : 0.0f;
        }
        if ((double)speed > 1.9 && (double)speed < 2.05) {
            plane.axes.rotateLocalPitch(((float)Math.random() - 0.5f) / 4.0f);
            plane.axes.rotateLocalYaw(((float)Math.random() - 0.5f) / 4.0f);
            plane.axes.rotateLocalRoll(((float)Math.random() - 0.5f) / 4.0f);
        }
    }

    public void HeliModeFly(EntityPlane plane) {
        PlaneType type = plane.getPlaneType();
        DriveableData data = plane.getDriveableData();
        int numPropsWorking = 0;
        int numProps = 0;
        for (Propeller prop : type.heliPropellers) {
            if (!plane.isPartIntact(prop.planePart)) continue;
            ++numPropsWorking;
        }
        numProps = type.heliPropellers.size();
        this.gravity = 0.05f;
        if (numProps == 0) {
            return;
        }
        Vector3f up = (Vector3f)plane.axes.getYAxis().normalise();
        this.thrust *= (float)(numPropsWorking / numProps) * 2.0f;
        float upwardsForce = this.throttle * this.thrust + (this.gravity - this.thrust / 2.0f);
        if (this.throttle < 0.5f) {
            upwardsForce = this.gravity * this.throttle * 2.0f;
        }
        if (!plane.isPartIntact(EnumDriveablePart.blades)) {
            upwardsForce = 0.0f;
        }
        if (this.throttle < 0.52f && this.throttle > 0.48f && up.y >= 0.7f) {
            upwardsForce = this.gravity / up.y;
        }
        plane.field_70159_w += (double)(upwardsForce * up.x * 0.5f);
        plane.field_70181_x += (double)(upwardsForce * up.y - this.gravity);
        plane.field_70179_y += (double)(upwardsForce * up.z * 0.5f);
        plane.field_70159_w *= (double)(1.0f - (1.0f - this.drag) / 5.0f);
        plane.field_70181_x *= (double)this.drag;
        plane.field_70179_y *= (double)(1.0f - (1.0f - this.drag) / 5.0f);
        plane.lastPos = new Vector3f(plane.field_70159_w, plane.field_70181_x, plane.field_70179_y);
        if (!plane.driverIsCreative()) {
            data.fuelInTank = data.fuelInTank >= upwardsForce * this.fuelConsumptionMultiplier * data.engine.fuelConsumption ? (data.fuelInTank -= upwardsForce * this.fuelConsumptionMultiplier * data.engine.fuelConsumption) : 0.0f;
        }
    }
}

