/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.driveables;

import com.flansmod.client.model.ModelDriveable;
import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.BoxExplosion;
import com.flansmod.common.driveables.CollisionBox;
import com.flansmod.common.driveables.DriveablePart;
import com.flansmod.common.driveables.DriveablePosition;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.driveables.EnumWeaponType;
import com.flansmod.common.driveables.PilotGun;
import com.flansmod.common.driveables.Seat;
import com.flansmod.common.driveables.ShootPoint;
import com.flansmod.common.driveables.collisions.CollisionShapeBox;
import com.flansmod.common.driveables.mechas.MechaType;
import com.flansmod.common.guns.BulletType;
import com.flansmod.common.guns.EnumFireMode;
import com.flansmod.common.paintjob.PaintableType;
import com.flansmod.common.parts.PartType;
import com.flansmod.common.types.TypeFile;
import com.flansmod.common.vector.Vector3f;
import com.flansmod.utils.ConfigMap;
import com.flansmod.utils.ConfigUtils;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.model.ModelBase;
import net.minecraft.init.Items;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;

public class DriveableType
extends PaintableType {
    public ModelDriveable model;
    public HashMap<EnumDriveablePart, CollisionBox> health = new HashMap();
    public HashMap<EnumDriveablePart, BoxExplosion> partDeathExplosions = new HashMap();
    public HashMap<EnumDriveablePart, ItemStack[]> partwiseRecipe = new HashMap();
    public ArrayList<ItemStack> driveableRecipe = new ArrayList();
    public boolean acceptAllAmmo = true;
    public List<BulletType> ammo = new ArrayList<BulletType>();
    public boolean harvestBlocks = false;
    public ArrayList<Material> materialsHarvested = new ArrayList();
    public boolean collectHarvest = false;
    public boolean dropHarvest = false;
    public Vector3f harvestBoxSize = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f harvestBoxPos = new Vector3f(0.0f, 0.0f, 0.0f);
    public int reloadSoundTick = 15214541;
    public float fallDamageFactor = 1.0f;
    public int engineStartTime = 0;
    public EnumWeaponType primary = EnumWeaponType.NONE;
    public EnumWeaponType secondary = EnumWeaponType.NONE;
    public boolean alternatePrimary = false;
    public boolean alternateSecondary = false;
    public float shootDelayPrimary = -1.0f;
    public float shootDelaySecondary = -1.0f;
    public float damageMultiplierPrimary = 1.0f;
    public float damageMultiplierSecondary = 1.0f;
    public EnumFireMode modePrimary = EnumFireMode.FULLAUTO;
    public EnumFireMode modeSecondary = EnumFireMode.FULLAUTO;
    public String shootSoundPrimary;
    public String shootSoundSecondary;
    public String shootReloadSound;
    public ArrayList<ShootPoint> shootPointsPrimary = new ArrayList();
    public ArrayList<ShootPoint> shootPointsSecondary = new ArrayList();
    public ArrayList<PilotGun> pilotGuns = new ArrayList();
    public int reloadTimePrimary = 0;
    public int reloadTimeSecondary = 0;
    public String reloadSoundPrimary = "";
    public String reloadSoundSecondary = "";
    public int placeTimePrimary = 5;
    public int placeTimeSecondary = 5;
    public String placeSoundPrimary = "";
    public String placeSoundSecondary = "";
    public int numPassengers = 0;
    public Seat[] seats;
    public int numPassengerGunners = 0;
    public float vehicleGunModelScale = 1.0f;
    public boolean filterAmmunition = false;
    public boolean worksUnderWater = false;
    public ArrayList<ShootParticle> shootParticlesPrimary = new ArrayList();
    public ArrayList<ShootParticle> shootParticlesSecondary = new ArrayList();
    public int numCargoSlots;
    public int numBombSlots;
    public int numMissileSlots;
    public int fuelTankSize = 100;
    public float yOffset = 0.625f;
    public float cameraDistance = 5.0f;
    public ArrayList<ParticleEmitter> emitters = new ArrayList();
    public float maxThrottle = 1.0f;
    public float maxNegativeThrottle = 0.0f;
    public float clutchBrake = 0.0f;
    public Vector3f turretOrigin = new Vector3f();
    public Vector3f turretOriginOffset = new Vector3f();
    public DriveablePosition[] wheelPositions = new DriveablePosition[0];
    public float wheelSpringStrength = 0.5f;
    public float wheelStepHeight = 1.0f;
    public boolean canRoll = true;
    public ArrayList<DriveablePosition> collisionPoints = new ArrayList();
    public float drag = 1.0f;
    public boolean floatOnWater = false;
    public boolean placeableOnLand = true;
    public boolean placeableOnWater = false;
    public boolean placeableOnSponge = false;
    public float buoyancy = 0.0165f;
    public float floatOffset = 0.0f;
    public float bulletDetectionRadius = -1.0f;
    public boolean onRadar = false;
    public int animFrames = 2;
    public int startSoundRange = 50;
    public String startSound = "";
    public int startSoundLength;
    public int engineSoundRange = 50;
    public String engineSound = "";
    public int engineSoundLength;
    public int backSoundRange = 50;
    public String exitSound = "";
    public int exitSoundLength = 50;
    public String idleSound = "";
    public int idleSoundLength = 50;
    public String backSound = "";
    public int backSoundLength;
    public boolean collisionDamageEnable = false;
    public float collisionDamageThrottle = 0.0f;
    public float collisionDamageTimes = 0.0f;
    public boolean canMountEntity = false;
    public float bulletSpread = 0.0f;
    public float bulletSpeed = 3.0f;
    public boolean rangingGun = false;
    public boolean isExplosionWhenDestroyed = false;
    public float deathFireRadius = 0.0f;
    public float deathExplosionRadius = 4.0f;
    public float deathExplosionPower = 1.0f;
    public boolean deathExplosionBreaksBlocks = false;
    public float deathExplosionDamageVsLiving = 1.0f;
    public float deathExplosionDamageVsPlayer = 1.0f;
    public float deathExplosionDamageVsPlane = 1.0f;
    public float deathExplosionDamageVsVehicle = 1.0f;
    public String lockedOnSound = "";
    public int soundTime = 0;
    public int canLockOnAngle = 10;
    public int lockOnSoundTime = 60;
    public String lockOnSound = "";
    public int maxRangeLockOn = 500;
    public int lockedOnSoundRange = 5;
    public String lockingOnSound = "";
    public boolean lockOnToPlanes = false;
    public boolean lockOnToVehicles = false;
    public boolean lockOnToMechas = false;
    public boolean lockOnToPlayers = false;
    public boolean lockOnToLivings = false;
    public boolean hasFlare = false;
    public int flareDelay = 200;
    public String flareSound = "";
    public int timeFlareUsing = 1;
    public float recoilTime = 5.0f;
    public boolean fixedPrimaryFire = false;
    public Vector3f primaryFireAngle = new Vector3f(0.0f, 0.0f, 0.0f);
    public boolean fixedSecondaryFire = false;
    public Vector3f secondaryFireAngle = new Vector3f(0.0f, 0.0f, 0.0f);
    public boolean setPlayerInvisible = false;
    public float maxThrottleInWater = 0.5f;
    public int maxDepth = 3;
    public ArrayList<Vector3f> leftTrackPoints = new ArrayList();
    public ArrayList<Vector3f> rightTrackPoints = new ArrayList();
    public float trackLinkLength = 0.0f;
    public boolean IT1 = false;
    public static ArrayList<DriveableType> types = new ArrayList();
    public ArrayList<CollisionShapeBox> collisionBox = new ArrayList();
    public boolean fancyCollision = false;

    public DriveableType(TypeFile file) {
        super(file);
    }

    @Override
    public void preRead(TypeFile file) {
        super.preRead(file);
    }

    @Override
    public void postRead(TypeFile file) {
        super.postRead(file);
        if (this.bulletDetectionRadius == -1.0f) {
            for (CollisionBox box : this.health.values()) {
                this.bulletDetectionRadius = Math.max(this.bulletDetectionRadius, box.getRootPosition().length() + box.getRadius());
            }
            this.bulletDetectionRadius += 1.0f;
        }
        if (this.shortName != null && this.isValid) {
            types.add(this);
        }
    }

    @Override
    protected void read(ConfigMap config, TypeFile file) {
        super.read(config, file);
        try {
            ArrayList<String[]> splits;
            try {
                splits = ConfigUtils.getSplitsFromKey(config, new String[]{"Passenger"});
                this.numPassengers = splits.size();
                this.seats = new Seat[this.numPassengers + 1];
                for (String[] split : splits) {
                    Seat seat = new Seat(split);
                    if (seat.id >= this.seats.length) continue;
                    this.seats[seat.id] = seat;
                    if (seat.gunType == null) continue;
                    ++this.numPassengerGunners;
                    seat.gunnerID = seat.gunnerID;
                    this.driveableRecipe.add(new ItemStack(seat.gunType.item));
                }
            }
            catch (Exception ex) {
                FlansMod.logPackError(file.name, this.packName, this.shortName, "Fatal error: error parsing Passenger definitions", null, ex);
                throw new Exception("Invalid Passenger Definitions");
            }
            if (!(this instanceof MechaType)) {
                try {
                    splits = ConfigUtils.getSplitsFromKey(config, new String[]{"Wheel", "WheelPosition"});
                    int numWheels = splits.size();
                    if (numWheels < 2) {
                        FlansMod.logPackError(file.name, this.packName, this.shortName, "Fatal error: Either 3 or 4 wheels are required", null, null);
                        throw new Exception("Invalid Wheel Configuration");
                    }
                    if (numWheels > 4) {
                        FlansMod.logPackError(file.name, this.packName, this.shortName, "Too many wheel definitions, the maximum is 4", null, null);
                    }
                    this.wheelPositions = new DriveablePosition[Math.min(4, numWheels)];
                    int counter = 0;
                    for (String[] split : splits) {
                        DriveablePosition wheelPosition;
                        int wheelIndex = Integer.parseInt(split[1]);
                        if (wheelIndex >= numWheels) {
                            FlansMod.logPackError(file.name, this.packName, this.shortName, "Incorrect wheel index given, defaulting to counting.", split, null);
                            wheelIndex = counter;
                        }
                        float x = Float.parseFloat(split[2]) / 16.0f;
                        float y = Float.parseFloat(split[3]) / 16.0f;
                        float z = Float.parseFloat(split[4]) / 16.0f;
                        EnumDriveablePart part = EnumDriveablePart.coreWheel;
                        if (split.length > 5) {
                            part = EnumDriveablePart.getPart(split[5]);
                        }
                        this.wheelPositions[wheelIndex] = wheelPosition = new DriveablePosition(new Vector3f(x, y, z), part);
                        if (++counter < 4) continue;
                        break;
                    }
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Fatal error thrown while parsing wheels", null, ex);
                    throw new Exception("Invalid Wheel Configuration");
                }
            }
            try {
                Object split;
                splits = ConfigUtils.getSplitsFromKey(config, new String[]{"Driver", "Pilot"});
                if (splits.isEmpty()) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "No Driver or Pilot configured", null, null);
                    throw new Exception("No Driver/Pilot Configured!");
                }
                if (splits.size() > 1) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Multiple Drivers or Pilots configured. Using first.", null, null);
                }
                this.seats[0] = ((String[])(split = splits.get(0))).length > 4 ? new Seat(Integer.parseInt(split[1]), Integer.parseInt(split[2]), Integer.parseInt(split[3]), Float.parseFloat(split[4]), Float.parseFloat(split[5]), Float.parseFloat(split[6]), Float.parseFloat(split[7])) : new Seat(Integer.parseInt(split[1]), Integer.parseInt(split[2]), Integer.parseInt(split[3]));
            }
            catch (Exception ex) {
                FlansMod.logPackError(file.name, this.packName, this.shortName, "Errored while reading Driver/Pilot", null, ex);
                throw new Exception("Invalid Driver/Pilot Definitions");
            }
            if (FMLCommonHandler.instance().getSide().isClient()) {
                this.model = FlansMod.proxy.loadModel(this.modelString, this.shortName, ModelDriveable.class);
            }
            this.vehicleGunModelScale = ConfigUtils.configFloat(config, "VehicleGunModelScale", this.vehicleGunModelScale);
            this.reloadSoundTick = ConfigUtils.configInt(config, "VehicleGunReloadTick", this.reloadSoundTick);
            this.texture = ConfigUtils.configString(config, "Texture", this.texture);
            this.isExplosionWhenDestroyed = ConfigUtils.configBool(config, "IsExplosionWhenDestroyed", this.isExplosionWhenDestroyed);
            this.deathFireRadius = ConfigUtils.configFloat(config, new String[]{"DeathFireRadius", "DeathFire"}, this.deathFireRadius);
            this.deathExplosionRadius = ConfigUtils.configFloat(config, new String[]{"DeathExplosionRadius", "DeathExplosion"}, this.deathExplosionRadius);
            this.deathExplosionPower = ConfigUtils.configFloat(config, "DeathExplosionPower", this.deathExplosionPower);
            this.deathExplosionBreaksBlocks = ConfigUtils.configBool(config, "DeathExplosionBreaksBlocks", this.deathExplosionBreaksBlocks);
            this.deathExplosionDamageVsLiving = ConfigUtils.configFloat(config, "DeathExplosionDamageVsLiving", this.deathExplosionDamageVsLiving);
            this.deathExplosionDamageVsPlayer = ConfigUtils.configFloat(config, "DeathExplosionDamageVsPlayer", this.deathExplosionDamageVsPlayer);
            this.deathExplosionDamageVsPlane = ConfigUtils.configFloat(config, "DeathExplosionDamageVsPlane", this.deathExplosionDamageVsPlane);
            this.deathExplosionDamageVsVehicle = ConfigUtils.configFloat(config, "DeathExplosionDamageVsVehicle", this.deathExplosionDamageVsVehicle);
            this.fallDamageFactor = ConfigUtils.configFloat(config, "FallDamageFactor", this.fallDamageFactor);
            this.maxThrottle = ConfigUtils.configFloat(config, "MaxThrottle", this.maxThrottle);
            this.maxNegativeThrottle = ConfigUtils.configFloat(config, "MaxNegativeThrottle", this.maxNegativeThrottle);
            this.clutchBrake = ConfigUtils.configFloat(config, "ClutchBrake", this.clutchBrake);
            this.maxThrottleInWater = ConfigUtils.configFloat(config, "MaxThrottleInWater", this.maxThrottleInWater);
            this.maxDepth = ConfigUtils.configInt(config, "MaxDepth", this.maxDepth);
            this.drag = ConfigUtils.configFloat(config, "Drag", this.drag);
            this.turretOrigin = ConfigUtils.configVector(config, "TurretOrigin", this.turretOrigin, 0.0625f);
            this.turretOriginOffset = ConfigUtils.configVector(config, "TurretOrigin", this.turretOriginOffset, 0.0625f);
            splits = ConfigUtils.getSplitsFromKey(config, new String[]{"CollisionPoint", "AddCollisionPoint"});
            for (String[] split : splits) {
                try {
                    this.collisionPoints.add(new DriveablePosition(split));
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Error thrown while adding collision point", split, ex);
                }
            }
            this.collisionDamageEnable = ConfigUtils.configBool(config, "CollisionDamageEnable", this.collisionDamageEnable);
            this.collisionDamageThrottle = ConfigUtils.configFloat(config, "CollisionDamageThrottle", this.collisionDamageThrottle);
            this.collisionDamageTimes = ConfigUtils.configFloat(config, "CollisionDamageTimes", this.collisionDamageTimes);
            this.canLockOnAngle = ConfigUtils.configInt(config, "CanLockAngle", this.canLockOnAngle);
            this.lockOnSoundTime = ConfigUtils.configInt(config, "LockOnSoundTime", this.lockOnSoundTime);
            this.lockOnToVehicles = this.lockOnToMechas = ConfigUtils.configBool(config, "LockOnToDriveables", false);
            this.lockOnToPlanes = this.lockOnToMechas;
            this.lockOnToVehicles = ConfigUtils.configBool(config, "LockOnToVehicles", this.lockOnToVehicles);
            this.lockOnToPlanes = ConfigUtils.configBool(config, "LockOnToPlanes", this.lockOnToPlanes);
            this.lockOnToMechas = ConfigUtils.configBool(config, "LockOnToMechas", this.lockOnToMechas);
            this.lockOnToPlayers = ConfigUtils.configBool(config, "LockOnToPlayers", this.lockOnToPlayers);
            this.lockOnToLivings = ConfigUtils.configBool(config, "LockOnToLivings", this.lockOnToLivings);
            this.lockedOnSoundRange = ConfigUtils.configInt(config, "LockedOnSoundRange", this.lockedOnSoundRange);
            this.canRoll = ConfigUtils.configBool(config, "CanRoll", this.canRoll);
            this.hasFlare = ConfigUtils.configBool(config, "HasFlare", this.hasFlare);
            this.flareDelay = Math.max(1, ConfigUtils.configInt(config, "FlareDelay", this.flareDelay));
            this.timeFlareUsing = Math.max(1, ConfigUtils.configInt(config, "TimeFlareUsing", this.timeFlareUsing));
            if (config.containsKey("Boat")) {
                this.placeableOnLand = false;
                this.placeableOnWater = true;
                this.floatOnWater = true;
                this.wheelStepHeight = 0.0f;
            }
            this.placeableOnLand = ConfigUtils.configBool(config, "PlaceableOnLand", this.placeableOnLand);
            this.placeableOnWater = ConfigUtils.configBool(config, "PlaceableOnWater", this.placeableOnWater);
            this.worksUnderWater = ConfigUtils.configBool(config, "WorksUnderwater", this.worksUnderWater);
            this.placeableOnSponge = ConfigUtils.configBool(config, "PlaceableOnSponge", this.placeableOnSponge);
            this.floatOnWater = ConfigUtils.configBool(config, "FloatOnWater", this.floatOnWater);
            this.buoyancy = ConfigUtils.configFloat(config, "Buoyancy", this.buoyancy);
            this.floatOffset = ConfigUtils.configFloat(config, "FloatOffset", this.floatOffset);
            this.canMountEntity = ConfigUtils.configBool(config, "CanMountEntity", this.canMountEntity);
            this.wheelStepHeight = ConfigUtils.configFloat(config, new String[]{"WheelRadius", "WheelStepHeight"}, this.wheelStepHeight);
            this.wheelSpringStrength = ConfigUtils.configFloat(config, new String[]{"WheelSpringStrength", "SpringStrength"}, this.wheelSpringStrength);
            this.animFrames = ConfigUtils.configInt(config, "TrackFrames", this.animFrames);
            this.harvestBlocks = ConfigUtils.configBool(config, "Harvester", this.harvestBlocks);
            this.collectHarvest = ConfigUtils.configBool(config, "CollectHarvest", this.collectHarvest);
            this.dropHarvest = ConfigUtils.configBool(config, "DropHarvest", this.dropHarvest);
            String[] asplit = ConfigUtils.getSplitFromKey(config, "HarvestBox");
            if (asplit != null) {
                try {
                    this.harvestBoxSize = new Vector3f(asplit[1]);
                    this.harvestBoxPos = new Vector3f(asplit[2]);
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Error thrown while adding harvester", asplit, ex);
                }
            }
            splits = ConfigUtils.getSplitsFromKey(config, new String[]{"HarvestMaterial"});
            for (String[] split : splits) {
                try {
                    Material m = DriveableType.getMaterial(split[1]);
                    if (m != null) {
                        this.materialsHarvested.add(m);
                        continue;
                    }
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Couldn't find material for HarvestMaterial", split, null);
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Error thrown while adding HarvestMaterial", split, ex);
                }
            }
            splits = ConfigUtils.getSplitsFromKey(config, new String[]{"HarvestToolType"});
            for (String[] split : splits) {
                try {
                    switch (split[1]) {
                        case "Axe": {
                            this.materialsHarvested.add(Material.field_151575_d);
                            this.materialsHarvested.add(Material.field_151585_k);
                            this.materialsHarvested.add(Material.field_151582_l);
                            break;
                        }
                        case "Pickaxe": 
                        case "Drill": {
                            this.materialsHarvested.add(Material.field_151573_f);
                            this.materialsHarvested.add(Material.field_151574_g);
                            this.materialsHarvested.add(Material.field_151576_e);
                            break;
                        }
                        case "Spade": 
                        case "Shovel": 
                        case "Excavator": {
                            this.materialsHarvested.add(Material.field_151578_c);
                            this.materialsHarvested.add(Material.field_151577_b);
                            this.materialsHarvested.add(Material.field_151595_p);
                            this.materialsHarvested.add(Material.field_151597_y);
                            this.materialsHarvested.add(Material.field_151571_B);
                            break;
                        }
                        case "Hoe": 
                        case "Combine": {
                            this.materialsHarvested.add(Material.field_151585_k);
                            this.materialsHarvested.add(Material.field_151584_j);
                            this.materialsHarvested.add(Material.field_151582_l);
                            this.materialsHarvested.add(Material.field_151570_A);
                            this.materialsHarvested.add(Material.field_151572_C);
                            break;
                        }
                        case "Tank": {
                            this.materialsHarvested.add(Material.field_151584_j);
                            this.materialsHarvested.add(Material.field_151570_A);
                            this.materialsHarvested.add(Material.field_151575_d);
                            this.materialsHarvested.add(Material.field_151585_k);
                        }
                    }
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Setting HarvestToolType failed", split, ex);
                }
            }
            this.numCargoSlots = ConfigUtils.configInt(config, "CargoSlots", this.numCargoSlots);
            this.numBombSlots = ConfigUtils.configInt(config, new String[]{"BombSlots", "MineSlots"}, this.numBombSlots);
            this.numMissileSlots = ConfigUtils.configInt(config, new String[]{"MissileSlots", "ShellSlots"}, this.numMissileSlots);
            this.fuelTankSize = ConfigUtils.configInt(config, "FuelTankSize", this.fuelTankSize);
            this.engineStartTime = ConfigUtils.configInt(config, "EngineStartTime", this.engineStartTime);
            this.filterAmmunition = ConfigUtils.configBool(config, "FilterAmmunitionInput", this.filterAmmunition);
            this.bulletDetectionRadius = ConfigUtils.configFloat(config, "BulletDetection", this.bulletDetectionRadius);
            splits = ConfigUtils.getSplitsFromKey(config, new String[]{"AddAmmo"});
            for (String[] split : splits) {
                try {
                    if (split.length == 2) {
                        BulletType bullet = BulletType.getBullet(split[1]);
                        if (bullet != null) {
                            this.ammo.add(bullet);
                            continue;
                        }
                        FlansMod.logPackError(file.name, this.packName, this.shortName, "Could not find bullet for AddAmmo", split, null);
                        continue;
                    }
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Incorrect format supplied to AddAmmo", split, null);
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Error thrown from AddAmmo", split, ex);
                }
            }
            this.acceptAllAmmo = ConfigUtils.configBool(config, new String[]{"AllowAllAmmo", "AcceptAllAmmo"}, this.acceptAllAmmo);
            String line = ConfigUtils.configString(config, "Primary", "NONE");
            try {
                if (line != null) {
                    this.primary = EnumWeaponType.valueOf(line.toUpperCase());
                }
            }
            catch (Exception ex) {
                FlansMod.logPackError(file.name, this.packName, this.shortName, "Primary weapon type not known", new String[]{"Primary", line}, ex);
            }
            line = ConfigUtils.configString(config, "Secondary", "NONE");
            try {
                if (line != null) {
                    this.secondary = EnumWeaponType.valueOf(line.toUpperCase());
                }
            }
            catch (Exception ex) {
                FlansMod.logPackError(file.name, this.packName, this.shortName, "Secondary weapon type not known", new String[]{"Secondary", line}, ex);
            }
            this.damageMultiplierPrimary = ConfigUtils.configFloat(config, "DamageMultiplierPrimary", this.damageMultiplierPrimary);
            this.damageMultiplierSecondary = ConfigUtils.configFloat(config, "DamageMultiplierSecondary", this.damageMultiplierSecondary);
            this.shootDelayPrimary = ConfigUtils.configFloat(config, new String[]{"ShootDelayPrimary", "ShellDelay", "BombDelay"}, this.shootDelayPrimary);
            this.shootDelaySecondary = ConfigUtils.configFloat(config, new String[]{"ShootDelaySecondary", "ShootDelay"}, this.shootDelaySecondary);
            try {
                if (this.shootDelayPrimary == -1.0f) {
                    this.shootDelayPrimary = Math.max(1200.0f / ConfigUtils.configFloat(config, "RoundsPerMinPrimary", 60.0f), 1.0f);
                }
                if (this.shootDelaySecondary == -1.0f) {
                    this.shootDelaySecondary = Math.max(1200.0f / ConfigUtils.configFloat(config, "RoundsPerMinSecondary", 60.0f), 1.0f);
                }
            }
            catch (Exception ex) {
                FlansMod.logPackError(file.name, this.packName, this.shortName, "Error thrown setting RoundsPerMin", null, ex);
            }
            this.placeTimePrimary = ConfigUtils.configInt(config, "PlaceTimePrimary", this.placeTimePrimary);
            this.placeTimeSecondary = ConfigUtils.configInt(config, "PlaceTimeSecondary", this.placeTimeSecondary);
            this.reloadTimePrimary = ConfigUtils.configInt(config, "ReloadTimePrimary", this.reloadTimePrimary);
            this.reloadTimeSecondary = ConfigUtils.configInt(config, "ReloadTimeSecondary", this.reloadTimeSecondary);
            this.alternatePrimary = ConfigUtils.configBool(config, "AlternatePrimary", this.alternatePrimary);
            this.alternateSecondary = ConfigUtils.configBool(config, "AlternateSecondary", this.alternateSecondary);
            line = ConfigUtils.configString(config, "ModePrimary", null);
            try {
                if (line != null) {
                    this.modePrimary = EnumFireMode.valueOf(line.toUpperCase());
                }
            }
            catch (Exception ex) {
                FlansMod.logPackError(file.name, this.packName, this.shortName, "Primary weapon fire mode not known", new String[]{"PrimaryMode", line}, ex);
            }
            line = ConfigUtils.configString(config, "ModeSecondary", null);
            try {
                if (line != null) {
                    this.modeSecondary = EnumFireMode.valueOf(line.toUpperCase());
                }
            }
            catch (Exception ex) {
                FlansMod.logPackError(file.name, this.packName, this.shortName, "Secondary weapon fire mode not known", new String[]{"SecondaryMode", line}, ex);
            }
            this.bulletSpeed = ConfigUtils.configFloat(config, "BulletSpeed", this.bulletSpeed);
            this.bulletSpread = ConfigUtils.configFloat(config, "BulletSpread", this.bulletSpread);
            this.rangingGun = ConfigUtils.configBool(config, "RangingGun", this.rangingGun);
            this.recoilTime = ConfigUtils.configFloat(config, "RecoilTime", this.recoilTime);
            splits = ConfigUtils.getSplitsFromKey(config, new String[]{"ShootPointPrimary"});
            for (String[] split : splits) {
                try {
                    Vector3f offPos;
                    String[] gun;
                    if (split.length == 9) {
                        gun = new String[]{split[0], split[1], split[2], split[3], split[4], split[5]};
                        offPos = new Vector3f(Float.parseFloat(split[6]) / 16.0f, Float.parseFloat(split[7]) / 16.0f, Float.parseFloat(split[8]) / 16.0f);
                    } else if (split.length == 8) {
                        gun = new String[]{split[0], split[1], split[2], split[3], split[4]};
                        offPos = new Vector3f(Float.parseFloat(split[5]) / 16.0f, Float.parseFloat(split[6]) / 16.0f, Float.parseFloat(split[7]) / 16.0f);
                    } else {
                        gun = split;
                        offPos = new Vector3f(0.0f, 0.0f, 0.0f);
                    }
                    DriveablePosition rootPos = this.getShootPoint(gun);
                    ShootPoint sPoint = new ShootPoint(rootPos, offPos);
                    this.shootPointsPrimary.add(sPoint);
                    if (!(rootPos instanceof PilotGun)) continue;
                    this.pilotGuns.add((PilotGun)sPoint.rootPos);
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Error thrown while adding ShootPointPrimary", split, ex);
                }
            }
            splits = ConfigUtils.getSplitsFromKey(config, new String[]{"ShootPointSecondary"});
            for (String[] split : splits) {
                try {
                    Vector3f offPos;
                    String[] gun;
                    if (split.length == 9) {
                        gun = new String[]{split[0], split[1], split[2], split[3], split[4], split[5]};
                        offPos = new Vector3f(Float.parseFloat(split[6]) / 16.0f, Float.parseFloat(split[7]) / 16.0f, Float.parseFloat(split[8]) / 16.0f);
                    } else if (split.length == 8) {
                        gun = new String[]{split[0], split[1], split[2], split[3], split[4]};
                        offPos = new Vector3f(Float.parseFloat(split[5]) / 16.0f, Float.parseFloat(split[6]) / 16.0f, Float.parseFloat(split[7]) / 16.0f);
                    } else {
                        gun = split;
                        offPos = new Vector3f(0.0f, 0.0f, 0.0f);
                    }
                    DriveablePosition rootPos = this.getShootPoint(gun);
                    ShootPoint sPoint = new ShootPoint(rootPos, offPos);
                    this.shootPointsSecondary.add(sPoint);
                    if (!(rootPos instanceof PilotGun)) continue;
                    this.pilotGuns.add((PilotGun)sPoint.rootPos);
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Error thrown while adding ShootPointSecondary", split, ex);
                }
            }
            splits = ConfigUtils.getSplitsFromKey(config, new String[]{"ShootParticlesPrimary"});
            for (String[] split : splits) {
                try {
                    if (split.length == 5) {
                        this.shootParticlesPrimary.add(new ShootParticle(split[1], Float.parseFloat(split[2]), Float.parseFloat(split[3]), Float.parseFloat(split[4])));
                        continue;
                    }
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "ShootParticlesPrimary has invalid format", split, null);
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Error thrown while adding ShootParticlesPrimary", split, ex);
                }
            }
            splits = ConfigUtils.getSplitsFromKey(config, new String[]{"ShootParticlesSecondary"});
            for (String[] split : splits) {
                try {
                    if (split.length == 5) {
                        this.shootParticlesSecondary.add(new ShootParticle(split[1], Float.parseFloat(split[2]), Float.parseFloat(split[3]), Float.parseFloat(split[4])));
                        continue;
                    }
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "ShootParticlesSecondary has invalid format", split, null);
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Error thrown while adding ShootParticlesSecondary", split, ex);
                }
            }
            this.setPlayerInvisible = ConfigUtils.configBool(config, "SetPlayerInvisible", this.setPlayerInvisible);
            this.IT1 = ConfigUtils.configBool(config, "IT1", this.IT1);
            this.fixedPrimaryFire = ConfigUtils.configBool(config, "FixedPrimary", this.fixedPrimaryFire);
            this.fixedSecondaryFire = ConfigUtils.configBool(config, "FixedSecondary", this.fixedSecondaryFire);
            this.primaryFireAngle = ConfigUtils.configVector(config, "PrimaryAngle", this.primaryFireAngle);
            this.secondaryFireAngle = ConfigUtils.configVector(config, "SecondaryAngle", this.secondaryFireAngle);
            splits = ConfigUtils.getSplitsFromKey(config, new String[]{"AddGun"});
            for (String[] split : splits) {
                try {
                    this.secondary = EnumWeaponType.GUN;
                    if (split.length == 6 || split.length == 9) {
                        Vector3f offPos;
                        PilotGun pilotGun = new PilotGun(Arrays.copyOfRange(split, 0, 6));
                        Vector3f vector3f = offPos = split.length == 6 ? Vector3f.Zero : new Vector3f(Float.parseFloat(split[6]) / 16.0f, Float.parseFloat(split[7]) / 16.0f, Float.parseFloat(split[8]) / 16.0f);
                        if (pilotGun.type == null) {
                            FlansMod.logPackError(file.name, this.packName, this.shortName, "Could not find gun type for AddGun. Skipping.", split, null);
                            continue;
                        }
                        ShootPoint sPoint = new ShootPoint(pilotGun, offPos);
                        this.shootPointsSecondary.add(sPoint);
                        this.pilotGuns.add(pilotGun);
                        this.driveableRecipe.add(new ItemStack(pilotGun.type.item));
                        continue;
                    }
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "AddGun not in correct format. Skipping.", split, null);
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Error thrown while adding pilot gun with AddGun", split, ex);
                }
            }
            splits = ConfigUtils.getSplitsFromKey(config, new String[]{"BombPosition"});
            if (splits.size() > 1) {
                this.primary = EnumWeaponType.BOMB;
            }
            for (String[] split : splits) {
                try {
                    if (split.length == 4) {
                        this.shootPointsPrimary.add(new ShootPoint(new DriveablePosition(new Vector3f(Float.parseFloat(split[1]) / 16.0f, Float.parseFloat(split[2]) / 16.0f, Float.parseFloat(split[3]) / 16.0f), EnumDriveablePart.core), new Vector3f(0.0f, 0.0f, 0.0f)));
                        continue;
                    }
                    if (split.length != 7) continue;
                    this.shootPointsPrimary.add(new ShootPoint(new DriveablePosition(new Vector3f(Float.parseFloat(split[1]) / 16.0f, Float.parseFloat(split[2]) / 16.0f, Float.parseFloat(split[3]) / 16.0f), EnumDriveablePart.core), new Vector3f(Float.parseFloat(split[4]) / 16.0f, Float.parseFloat(split[5]) / 16.0f, Float.parseFloat(split[6]) / 16.0f)));
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Error thrown while setting BombPosition", split, ex);
                }
            }
            splits = ConfigUtils.getSplitsFromKey(config, new String[]{"BarrelPosition"});
            if (splits.size() >= 1) {
                this.primary = EnumWeaponType.SHELL;
            }
            for (String[] split : splits) {
                try {
                    if (split.length == 4) {
                        this.shootPointsPrimary.add(new ShootPoint(new DriveablePosition(new Vector3f(Float.parseFloat(split[1]) / 16.0f, Float.parseFloat(split[2]) / 16.0f, Float.parseFloat(split[3]) / 16.0f), EnumDriveablePart.turret), new Vector3f(0.0f, 0.0f, 0.0f)));
                        continue;
                    }
                    if (split.length != 7) continue;
                    this.shootPointsPrimary.add(new ShootPoint(new DriveablePosition(new Vector3f(Float.parseFloat(split[1]) / 16.0f, Float.parseFloat(split[2]) / 16.0f, Float.parseFloat(split[3]) / 16.0f), EnumDriveablePart.turret), new Vector3f(Float.parseFloat(split[4]) / 16.0f, Float.parseFloat(split[5]) / 16.0f, Float.parseFloat(split[6]) / 16.0f)));
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Error thrown while setting BarrelPosition", split, ex);
                }
            }
            splits = ConfigUtils.getSplitsFromKey(config, new String[]{"AddRecipeParts"});
            for (String[] split : splits) {
                try {
                    EnumDriveablePart part = EnumDriveablePart.getPart(split[1]);
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    for (int i = 0; i < (split.length - 2) / 2; ++i) {
                        int damage;
                        int amount = Integer.parseInt(split[2 * i + 2]);
                        boolean damaged = split[2 * i + 3].contains(".");
                        String itemName = damaged ? split[2 * i + 3].split("\\.")[0] : split[2 * i + 3];
                        ItemStack potentialPart = DriveableType.getRecipeElement(itemName, amount, damage = damaged ? Integer.parseInt(split[2 * i + 3].split("\\.")[1]) : 0, this.shortName);
                        if (potentialPart != null) {
                            stacks.add(potentialPart);
                            this.driveableRecipe.add(potentialPart);
                            continue;
                        }
                        FlansMod.logPackError(file.name, this.packName, this.shortName, "Item not found for AddRecipeParts", split, null);
                    }
                    ItemStack[] items = new ItemStack[stacks.size()];
                    items = stacks.toArray(items);
                    this.partwiseRecipe.put(part, items);
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "AddRecipeParts threw an error", split, ex);
                }
            }
            splits = ConfigUtils.getSplitsFromKey(config, new String[]{"AddDye"});
            for (String[] split : splits) {
                try {
                    int amount = Integer.parseInt(split[1]);
                    int damage = -1;
                    for (int i = 0; i < ItemDye.field_150923_a.length; ++i) {
                        if (!ItemDye.field_150923_a[i].equals(split[2])) continue;
                        damage = i;
                    }
                    if (damage == -1) {
                        FlansMod.logPackError(file.name, this.packName, this.shortName, "Failed to find dye colour in AddDye", split, null);
                        return;
                    }
                    this.driveableRecipe.add(new ItemStack(Items.field_151100_aR, amount, damage));
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "AddDye threw an error", split, ex);
                }
            }
            splits = ConfigUtils.getSplitsFromKey(config, new String[]{"SetupPart"});
            for (String[] split : splits) {
                try {
                    EnumDriveablePart part = EnumDriveablePart.getPart(split[1]);
                    CollisionBox box = split.length > 9 ? new CollisionBox(Integer.parseInt(split[2]), Integer.parseInt(split[3]), Integer.parseInt(split[4]), Integer.parseInt(split[5]), Integer.parseInt(split[6]), Integer.parseInt(split[7]), Integer.parseInt(split[8]), Float.parseFloat(split[9])) : new CollisionBox(Integer.parseInt(split[2]), Integer.parseInt(split[3]), Integer.parseInt(split[4]), Integer.parseInt(split[5]), Integer.parseInt(split[6]), Integer.parseInt(split[7]), Integer.parseInt(split[8]));
                    this.health.put(part, box);
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "SetupPart threw an error", split, ex);
                }
            }
            splits = ConfigUtils.getSplitsFromKey(config, new String[]{"PartDeathExplosion"});
            for (String[] split : splits) {
                try {
                    EnumDriveablePart part = EnumDriveablePart.getPart(split[1]);
                    BoxExplosion exp = split.length > 5 ? new BoxExplosion(Float.parseFloat(split[2]), Float.parseFloat(split[3]), Boolean.parseBoolean(split[4]), Float.parseFloat(split[5]), Float.parseFloat(split[6]), Float.parseFloat(split[6]), Float.parseFloat(split[7])) : new BoxExplosion(Float.parseFloat(split[2]), Float.parseFloat(split[3]), Boolean.parseBoolean(split[4]));
                    this.partDeathExplosions.put(part, exp);
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "PartDeathExplosion threw an error", split, ex);
                }
            }
            if (this.seats.length <= 0 || this.seats[0] == null) {
                FlansMod.logPackError(file.name, this.packName, this.shortName, "Driver is not defined!", null, null);
                throw new Exception("Driver is not defined! Cannot proceed further.");
            }
            this.seats[0].part = EnumDriveablePart.getPart(ConfigUtils.configString(config, "DriverPart", "core"));
            this.seats[0].gunName = ConfigUtils.configString(config, new String[]{"DriverGun", "PilotGun"}, this.seats[0].gunName);
            this.seats[0].gunOrigin = ConfigUtils.configVector(config, "DriverGunOrigin", this.seats[0].gunOrigin, 0.0625f);
            this.seats[0].rotatedOffset = ConfigUtils.configVector(config, "RotatedDriverOffset", this.seats[0].rotatedOffset, 0.0625f);
            this.seats[0].aimingSpeed = ConfigUtils.configVector(config, "DriverAimSpeed", this.seats[0].aimingSpeed);
            this.seats[0].legacyAiming = ConfigUtils.configBool(config, "DriverLegacyAiming", this.seats[0].legacyAiming);
            this.seats[0].yawBeforePitch = ConfigUtils.configBool(config, "DriverYawBeforePitch", this.seats[0].yawBeforePitch);
            this.seats[0].latePitch = ConfigUtils.configBool(config, "DriverLatePitch", this.seats[0].latePitch);
            this.seats[0].traverseSounds = ConfigUtils.configBool(config, "DriverTraverseSounds", this.seats[0].traverseSounds);
            splits = ConfigUtils.getSplitsFromKey(config, new String[]{"RotatedPassengerOffset"});
            for (String[] split : splits) {
                try {
                    this.seats[Integer.parseInt((String)split[1])].rotatedOffset = new Vector3f((float)Integer.parseInt(split[2]) / 16.0f, (float)Integer.parseInt(split[3]) / 16.0f, (float)Integer.parseInt(split[4]) / 16.0f);
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Could not set RotatedPassengerOffset", split, ex);
                }
            }
            splits = ConfigUtils.getSplitsFromKey(config, new String[]{"PassengerAimSpeed"});
            for (String[] split : splits) {
                try {
                    this.seats[Integer.parseInt((String)split[1])].aimingSpeed = new Vector3f(Float.parseFloat(split[2]), Float.parseFloat(split[3]), Float.parseFloat(split[4]));
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Could not set PassengerAimSpeed", split, ex);
                }
            }
            splits = ConfigUtils.getSplitsFromKey(config, new String[]{"PassengerLegacyAiming"});
            for (String[] split : splits) {
                try {
                    this.seats[Integer.parseInt((String)split[1])].legacyAiming = Boolean.parseBoolean(split[2]);
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Could not set PassengerLegacyAiming", split, ex);
                }
            }
            splits = ConfigUtils.getSplitsFromKey(config, new String[]{"PassengerYawBeforePitch"});
            for (String[] split : splits) {
                try {
                    this.seats[Integer.parseInt((String)split[1])].yawBeforePitch = Boolean.parseBoolean(split[2]);
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Could not set PassengerYawBeforePitch", split, ex);
                }
            }
            splits = ConfigUtils.getSplitsFromKey(config, new String[]{"PassengerLatePitch"});
            for (String[] split : splits) {
                try {
                    this.seats[Integer.parseInt((String)split[1])].latePitch = Boolean.parseBoolean(split[2]);
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Could not set PassengerLatePitch", split, ex);
                }
            }
            splits = ConfigUtils.getSplitsFromKey(config, new String[]{"PassengerTraverseSounds"});
            for (String[] split : splits) {
                try {
                    this.seats[Integer.parseInt((String)split[1])].traverseSounds = Boolean.parseBoolean(split[2]);
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Could not set PassengerTraverseSounds", split, ex);
                }
            }
            splits = ConfigUtils.getSplitsFromKey(config, new String[]{"PassengerYawSoundLength"});
            for (String[] split : splits) {
                try {
                    this.seats[Integer.parseInt((String)split[1])].yawSoundLength = Integer.parseInt(split[2]);
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Could not set PassengerYawSoundLength", split, ex);
                }
            }
            splits = ConfigUtils.getSplitsFromKey(config, new String[]{"PassengerPitchSoundLength"});
            for (String[] split : splits) {
                try {
                    this.seats[Integer.parseInt((String)split[1])].pitchSoundLength = Integer.parseInt(split[2]);
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Could not set PassengerPitchSoundLength", split, ex);
                }
            }
            splits = ConfigUtils.getSplitsFromKey(config, new String[]{"PassengerYawSound"});
            for (String[] split : splits) {
                try {
                    this.seats[Integer.parseInt((String)split[1])].yawSound = split[2];
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Could not set PassengerYawSound", split, ex);
                }
            }
            splits = ConfigUtils.getSplitsFromKey(config, new String[]{"PassengerPitchSound"});
            for (String[] split : splits) {
                try {
                    this.seats[Integer.parseInt((String)split[1])].pitchSound = split[2];
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Could not set PassengerPitchSound", split, ex);
                }
            }
            splits = ConfigUtils.getSplitsFromKey(config, new String[]{"GunOrigin"});
            for (String[] split : splits) {
                try {
                    int seatId = Integer.parseInt(split[1]);
                    float x = Float.parseFloat(split[2]) / 16.0f;
                    float y = Float.parseFloat(split[3]) / 16.0f;
                    float z = Float.parseFloat(split[4]) / 16.0f;
                    if (seatId < this.seats.length && this.seats[seatId] != null) {
                        this.seats[Integer.parseInt((String)split[1])].gunOrigin = new Vector3f(x, y, z);
                        continue;
                    }
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Passenger seat not found for GunOrigin", split, null);
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Could not set GunOrigin", split, ex);
                }
            }
            this.yOffset = ConfigUtils.configFloat(config, "YOffset", this.yOffset);
            this.cameraDistance = ConfigUtils.configFloat(config, "CameraDistance", this.cameraDistance);
            this.startSoundRange = ConfigUtils.configInt(config, "StartSoundRange", this.startSoundRange);
            this.startSoundLength = ConfigUtils.configInt(config, "StartSoundLength", this.startSoundLength);
            this.engineSoundRange = ConfigUtils.configInt(config, "EngineSoundRange", this.engineSoundRange);
            this.engineSoundLength = ConfigUtils.configInt(config, "EngineSoundLength", this.engineSoundLength);
            this.idleSoundLength = ConfigUtils.configInt(config, "IdleSoundLength", this.idleSoundLength);
            this.exitSoundLength = ConfigUtils.configInt(config, "ExitSoundLength", this.exitSoundLength);
            this.backSoundRange = ConfigUtils.configInt(config, "BackSoundRange", this.backSoundRange);
            this.backSoundLength = ConfigUtils.configInt(config, "BackSoundLength", this.backSoundLength);
            this.soundTime = ConfigUtils.configInt(config, "SoundTime", this.soundTime);
            this.seats[0].yawSoundLength = ConfigUtils.configInt(config, "YawSoundLength", this.seats[0].yawSoundLength);
            this.seats[0].pitchSoundLength = ConfigUtils.configInt(config, "PitchSoundLength", this.seats[0].pitchSoundLength);
            this.seats[0].yawSound = ConfigUtils.configDriveableSound(this.packName, config, "YawSound", this.seats[0].yawSound);
            this.seats[0].pitchSound = ConfigUtils.configDriveableSound(this.packName, config, "PitchSound", this.seats[0].pitchSound);
            this.startSound = ConfigUtils.configDriveableSound(this.packName, config, "StartSound", this.startSound);
            this.engineSound = ConfigUtils.configDriveableSound(this.packName, config, "EngineSound", this.engineSound);
            this.idleSound = ConfigUtils.configDriveableSound(this.packName, config, "IdleSound", this.idleSound);
            this.exitSound = ConfigUtils.configDriveableSound(this.packName, config, "ExitSound", this.exitSound);
            this.backSound = ConfigUtils.configDriveableSound(this.packName, config, "BackSound", this.backSound);
            this.shootSoundPrimary = ConfigUtils.configDriveableSound(this.packName, config, new String[]{"ShootMainSound", "BombSound", "ShootSoundPrimary", "ShellSound"}, this.shootSoundPrimary);
            this.shootReloadSound = ConfigUtils.configDriveableSound(this.packName, config, "ShootReloadSound", this.shootReloadSound);
            this.shootSoundSecondary = ConfigUtils.configDriveableSound(this.packName, config, new String[]{"ShootSecondarySound", "ShootSoundSecondary"}, this.shootSoundSecondary);
            this.placeSoundPrimary = ConfigUtils.configDriveableSound(this.packName, config, "PlaceSoundPrimary", this.placeSoundPrimary);
            this.placeSoundSecondary = ConfigUtils.configDriveableSound(this.packName, config, "PlaceSoundSecondary", this.placeSoundSecondary);
            this.reloadSoundPrimary = ConfigUtils.configDriveableSound(this.packName, config, "ReloadSoundPrimary", this.reloadSoundPrimary);
            this.reloadSoundSecondary = ConfigUtils.configDriveableSound(this.packName, config, "ReloadSoundSecondary", this.reloadSoundSecondary);
            this.lockedOnSound = ConfigUtils.configDriveableSound(this.packName, config, "LockedOnSound", this.lockedOnSound);
            this.lockOnSound = ConfigUtils.configGunSound(this.packName, config, "LockOnSound", this.lockOnSound);
            this.lockingOnSound = ConfigUtils.configGunSound(this.packName, config, "LockingOnSound", this.lockingOnSound);
            this.flareSound = ConfigUtils.configDriveableSound(this.packName, config, "FlareSound", this.flareSound);
            this.fancyCollision = ConfigUtils.configBool(config, "FancyCollision", this.fancyCollision);
            splits = ConfigUtils.getSplitsFromKey(config, new String[]{"AddCollisionMesh", "AddTurretCollisionMesh"});
            for (String[] split : splits) {
                try {
                    CollisionShapeBox box = new CollisionShapeBox(new Vector3f(split[1]), new Vector3f(split[2]), new Vector3f(split[3]), new Vector3f(split[4]), new Vector3f(split[5]), new Vector3f(split[6]), new Vector3f(split[7]), new Vector3f(split[8]), new Vector3f(split[9]), new Vector3f(split[10]), split[0].contains("Turret") ? "turret" : "core");
                    this.collisionBox.add(box);
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Adding collision mesh failed", split, ex);
                }
            }
            splits = ConfigUtils.getSplitsFromKey(config, new String[]{"AddCollisionMeshRaw", "AddTurretCollisionMeshRaw"});
            for (String[] split : splits) {
                try {
                    Vector3f pos = new Vector3f(Float.parseFloat(split[1]), Float.parseFloat(split[2]), Float.parseFloat(split[3]));
                    Vector3f size = new Vector3f(Float.parseFloat(split[4]), Float.parseFloat(split[5]), Float.parseFloat(split[6]));
                    Vector3f p1 = new Vector3f(Float.parseFloat(split[8]), Float.parseFloat(split[9]), Float.parseFloat(split[10]));
                    Vector3f p2 = new Vector3f(Float.parseFloat(split[11]), Float.parseFloat(split[12]), Float.parseFloat(split[13]));
                    Vector3f p3 = new Vector3f(Float.parseFloat(split[14]), Float.parseFloat(split[15]), Float.parseFloat(split[16]));
                    Vector3f p4 = new Vector3f(Float.parseFloat(split[17]), Float.parseFloat(split[18]), Float.parseFloat(split[19]));
                    Vector3f p5 = new Vector3f(Float.parseFloat(split[20]), Float.parseFloat(split[21]), Float.parseFloat(split[22]));
                    Vector3f p6 = new Vector3f(Float.parseFloat(split[23]), Float.parseFloat(split[24]), Float.parseFloat(split[25]));
                    Vector3f p7 = new Vector3f(Float.parseFloat(split[26]), Float.parseFloat(split[27]), Float.parseFloat(split[28]));
                    Vector3f p8 = new Vector3f(Float.parseFloat(split[29]), Float.parseFloat(split[30]), Float.parseFloat(split[31]));
                    CollisionShapeBox box = new CollisionShapeBox(pos, size, p1, p2, p3, p4, p5, p6, p7, p8, split[0].contains("Turret") ? "turret" : "core");
                    this.collisionBox.add(box);
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Adding collision mesh failed", split, ex);
                }
            }
            splits = ConfigUtils.getSplitsFromKey(config, new String[]{"LeftLinkPoint"});
            for (String[] split : splits) {
                try {
                    this.leftTrackPoints.add(new Vector3f(split[1]));
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Adding LeftLinkPoint failed", split, ex);
                }
            }
            splits = ConfigUtils.getSplitsFromKey(config, new String[]{"RightLinkPoint"});
            for (String[] split : splits) {
                try {
                    this.rightTrackPoints.add(new Vector3f(split[1]));
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Adding RightLinkPoint failed", split, ex);
                }
            }
            this.trackLinkLength = ConfigUtils.configFloat(config, "TrackLinkLength", this.trackLinkLength);
            this.onRadar = ConfigUtils.configBool(config, "OnRadar", this.onRadar);
            splits = ConfigUtils.getSplitsFromKey(config, new String[]{"AddParticle", "AddEmitter"});
            for (String[] split : splits) {
                try {
                    ParticleEmitter emitter = new ParticleEmitter();
                    emitter.effectType = split[1];
                    emitter.emitRate = Integer.parseInt(split[2]);
                    emitter.origin = new Vector3f(split[3]);
                    emitter.extents = new Vector3f(split[4]);
                    emitter.velocity = new Vector3f(split[5]);
                    emitter.minThrottle = Float.parseFloat(split[6]);
                    emitter.maxThrottle = Float.parseFloat(split[7]);
                    emitter.minHealth = Float.parseFloat(split[8]);
                    emitter.maxHealth = Float.parseFloat(split[9]);
                    emitter.part = split[10];
                    emitter.origin.scale(0.0625f);
                    emitter.extents.scale(0.0625f);
                    emitter.velocity.scale(0.0625f);
                    this.emitters.add(emitter);
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Adding particle failed", split, ex);
                }
            }
        }
        catch (Exception ex) {
            FlansMod.logPackError(file.name, this.packName, this.shortName, "Fatal Error! Reading DriveableType failed", null, ex);
            this.isValid = false;
        }
    }

    private DriveablePosition getShootPoint(String[] split) {
        if (split.length == 6) {
            return new PilotGun(split);
        }
        if (split.length == 5) {
            return new DriveablePosition(split);
        }
        return new DriveablePosition(new Vector3f(), EnumDriveablePart.core);
    }

    public ArrayList<ShootPoint> shootPoints(boolean s) {
        return s ? this.shootPointsSecondary : this.shootPointsPrimary;
    }

    public boolean alternate(boolean s) {
        return s ? this.alternateSecondary : this.alternatePrimary;
    }

    public EnumWeaponType weaponType(boolean s) {
        return s ? this.secondary : this.primary;
    }

    public float shootDelay(boolean s) {
        return s ? this.shootDelaySecondary : this.shootDelayPrimary;
    }

    public String shootSound(boolean s) {
        return s ? this.shootSoundSecondary : this.shootSoundPrimary;
    }

    public ArrayList<ShootParticle> shootParticle(boolean s) {
        return s ? this.shootParticlesSecondary : this.shootParticlesPrimary;
    }

    public int numEngines() {
        return 1;
    }

    public int ammoSlots() {
        return this.numPassengerGunners + this.pilotGuns.size();
    }

    public boolean isValidAmmo(BulletType bulletType, EnumWeaponType weaponType) {
        return (this.acceptAllAmmo || this.ammo.contains(bulletType)) && bulletType.weaponType == weaponType;
    }

    public ArrayList<ItemStack> getItemsRequired(DriveablePart part, PartType engine) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (this.partwiseRecipe.get((Object)part.type) != null) {
            for (ItemStack itemStack : this.partwiseRecipe.get((Object)part.type)) {
                if (itemStack != null) {
                    stacks.add(itemStack.func_77946_l());
                    continue;
                }
                FlansMod.logPackError("", this.packName, this.shortName, "Failed to drop item on death of part " + part.type.getShortName(), null, null);
            }
        }
        for (PilotGun gun : this.pilotGuns) {
            if (gun == null || gun.part != part.type) continue;
            stacks.add(new ItemStack(gun.type.item));
        }
        for (Seat seat : this.seats) {
            if (seat == null || seat.part != part.type || seat.gunType == null) continue;
            stacks.add(new ItemStack(seat.gunType.item));
        }
        return stacks;
    }

    public static DriveableType getDriveable(String find) {
        for (DriveableType type : types) {
            if (!type.shortName.equals(find)) continue;
            return type;
        }
        return null;
    }

    @Override
    public float GetRecommendedScale() {
        return 100.0f / this.cameraDistance;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBase GetModel() {
        return this.model;
    }

    public class ParticleEmitter {
        public String effectType;
        public int emitRate;
        public Vector3f origin;
        public Vector3f extents;
        public Vector3f velocity;
        public float minThrottle;
        public float maxThrottle;
        public String part;
        public float minHealth;
        public float maxHealth;
    }

    public static class ShootParticle {
        float x;
        float y;
        float z;
        String name;

        public ShootParticle(String s, float x1, float y1, float z1) {
            this.x = x1;
            this.y = y1;
            this.z = z1;
            this.name = s;
        }
    }
}

