/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blocks;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import gollorum.signpost.blocks.tiles.BasePostTile;
import gollorum.signpost.event.UpdateWaystoneEvent;
import gollorum.signpost.management.ClientConfigStorage;
import gollorum.signpost.management.PostHandler;
import gollorum.signpost.network.NetworkHandler;
import gollorum.signpost.network.messages.BaseUpdateClientMessage;
import gollorum.signpost.network.messages.ChatMessage;
import gollorum.signpost.network.messages.OpenGuiMessage;
import gollorum.signpost.util.BaseInfo;
import gollorum.signpost.util.MyBlockPos;
import java.util.UUID;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class BasePost
extends BlockContainer {
    public BasePost() {
        super(Material.field_151576_e);
        this.func_149711_c(2.0f);
        this.func_149752_b(100000.0f);
        this.func_149663_c("SignpostBase");
        this.func_149647_a(CreativeTabs.field_78029_e);
        this.func_149658_d("signpost:waystone");
    }

    public boolean func_149727_a(World worldIn, int x, int y, int z, EntityPlayer playerIn, int side, float hitX, float hitY, float hitZ) {
        if (ClientConfigStorage.INSTANCE.deactivateTeleportation()) {
            return false;
        }
        if (!worldIn.field_72995_K) {
            BaseInfo ws = BasePost.getWaystoneRootTile(worldIn, x, y, z).getBaseInfo();
            if (ws == null) {
                ws = new BaseInfo(BasePost.generateName(), new MyBlockPos(worldIn, x, y, z, playerIn.field_71093_bK), playerIn.func_110124_au());
                PostHandler.addWaystone(ws);
            }
            if (!playerIn.func_70093_af()) {
                if (!PostHandler.doesPlayerKnowNativeWaystone((EntityPlayerMP)playerIn, ws)) {
                    if (!ClientConfigStorage.INSTANCE.deactivateTeleportation() || ClientConfigStorage.INSTANCE.isDisableDiscovery()) {
                        NetworkHandler.netWrap.sendTo((IMessage)new ChatMessage("signpost.discovered", "<Waystone>", ws.getName()), (EntityPlayerMP)playerIn);
                    }
                    PostHandler.addDiscovered(playerIn.func_110124_au(), ws);
                }
            } else if (!ClientConfigStorage.INSTANCE.deactivateTeleportation() && ClientConfigStorage.INSTANCE.getSecurityLevelWaystone().canUse((EntityPlayerMP)playerIn, "" + ws.owner)) {
                NetworkHandler.netWrap.sendTo((IMessage)new OpenGuiMessage(0, x, y, z), (EntityPlayerMP)playerIn);
            }
        }
        return true;
    }

    public TileEntity func_149915_a(World world, int p_149915_2_) {
        return new BasePostTile().setup();
    }

    public static BasePostTile getWaystoneRootTile(World world, int x, int y, int z) {
        TileEntity ret = world.func_147438_o(x, y, z);
        if (ret instanceof BasePostTile) {
            return (BasePostTile)ret;
        }
        return null;
    }

    public static String generateName() {
        String ret;
        int i = 1;
        do {
            ret = "Waystone " + i++;
        } while (PostHandler.getAllWaystones().nameTaken(ret));
        return ret;
    }

    public static void placeServer(World world, MyBlockPos pos, EntityPlayerMP player) {
        BasePostTile tile = BasePost.getWaystoneRootTile(world, pos.x, pos.y, pos.z);
        String name = BasePost.generateName();
        UUID owner = player.func_110124_au();
        BaseInfo ws = tile.getBaseInfo();
        if (ws == null) {
            ws = new BaseInfo(name, pos, owner);
            PostHandler.addWaystone(ws);
        } else {
            ws.setAll(new BaseInfo(name, pos, owner));
        }
        PostHandler.addDiscovered(player.func_110124_au(), ws);
        NetworkHandler.netWrap.sendToAll((IMessage)new BaseUpdateClientMessage());
        MinecraftForge.EVENT_BUS.post((Event)new UpdateWaystoneEvent(UpdateWaystoneEvent.WaystoneEventType.PLACED, world, pos.x, pos.y, pos.z, name));
        NetworkHandler.netWrap.sendTo((IMessage)new OpenGuiMessage(0, pos.x, pos.y, pos.z), player);
    }

    public static void placeClient(World world, MyBlockPos pos, EntityPlayer player) {
        BaseInfo ws;
        BasePostTile tile = BasePost.getWaystoneRootTile(world, pos.x, pos.y, pos.z);
        if (tile != null && tile.getBaseInfo() == null && (ws = PostHandler.getAllWaystones().getByPos(pos)) == null) {
            UUID owner = player.func_110124_au();
            PostHandler.getAllWaystones().add(new BaseInfo("", pos, owner));
        }
    }

    public static void generate(World world, MyBlockPos blockPos, MyBlockPos telePos) {
        String name = BasePost.generateName();
        BasePost.generate(world, blockPos, telePos, name);
    }

    public static void generate(World world, MyBlockPos blockPos, MyBlockPos telePos, String name) {
        BasePostTile tile = BasePost.getWaystoneRootTile(world, blockPos.x, blockPos.y, blockPos.z);
        UUID owner = null;
        BaseInfo ws = tile.getBaseInfo();
        if (ws == null) {
            ws = new BaseInfo(name, blockPos, telePos, owner);
            PostHandler.addWaystone(ws);
        } else {
            ws.setAll(new BaseInfo(name, blockPos, telePos, owner));
        }
        NetworkHandler.netWrap.sendToAll((IMessage)new BaseUpdateClientMessage());
        MinecraftForge.EVENT_BUS.post((Event)new UpdateWaystoneEvent(UpdateWaystoneEvent.WaystoneEventType.PLACED, world, blockPos.x, blockPos.y, blockPos.z, name));
    }
}

