/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import gollorum.signpost.CommonProxy;
import gollorum.signpost.commands.ConfirmTeleportCommand;
import gollorum.signpost.commands.DiscoverWaystone;
import gollorum.signpost.commands.GetSignpostCount;
import gollorum.signpost.commands.GetWaystoneCount;
import gollorum.signpost.commands.ListAllWaystones;
import gollorum.signpost.commands.SetSignpostCount;
import gollorum.signpost.commands.SetWaystoneCount;
import gollorum.signpost.gui.SignGuiHandler;
import gollorum.signpost.management.ConfigHandler;
import gollorum.signpost.management.PostHandler;
import gollorum.signpost.util.BigBaseInfo;
import gollorum.signpost.util.DoubleBaseInfo;
import gollorum.signpost.util.MyBlockPos;
import gollorum.signpost.util.StonedHashSet;
import gollorum.signpost.util.collections.Lurchpaerchensauna;
import gollorum.signpost.worldGen.villages.NameLibrary;
import gollorum.signpost.worldGen.villages.VillageLibrary;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="signpost", version="1.08.4", name="SignPost")
public class Signpost {
    @Mod.Instance
    public static Signpost instance;
    public static final String MODID = "signpost";
    public static final String VERSION = "1.08.4";
    public static final int GuiBaseID = 0;
    public static final int GuiPostID = 1;
    public static final int GuiBigPostID = 2;
    public static final int GuiPostBrushID = 3;
    public static final int GuiPostRotationID = 4;
    public static NBTTagCompound saveFile;
    public static final Logger LOG;
    public static File configFile;
    public static File configFolder;
    @SidedProxy(clientSide="gollorum.signpost.ClientProxy", serverSide="gollorum.signpost.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        configFolder = new File(event.getModConfigurationDirectory() + "/" + MODID);
        configFolder.mkdirs();
        configFile = new File(configFolder.getPath(), "signpost.cfg");
        ConfigHandler.init(configFile);
        NameLibrary.init(configFolder.getPath());
        proxy.preInit();
        proxy.init();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new SignGuiHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ConfigHandler.postInit();
        PostHandler.setNativeWaystones(new StonedHashSet());
        PostHandler.setPosts(new Lurchpaerchensauna<MyBlockPos, DoubleBaseInfo>());
        PostHandler.setBigPosts(new Lurchpaerchensauna<MyBlockPos, BigBaseInfo>());
        PostHandler.awaiting = new Lurchpaerchensauna();
    }

    @Mod.EventHandler
    public void preServerStart(FMLServerAboutToStartEvent event) {
        PostHandler.init();
        VillageLibrary.init();
    }

    @Mod.EventHandler
    public void serverAboutToStart(FMLServerAboutToStartEvent e) {
        PostHandler.init();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent e) {
        this.registerCommands((ServerCommandManager)e.getServer().func_71187_D());
        ConfigHandler.init(configFile);
    }

    private void registerCommands(ServerCommandManager manager) {
        manager.func_71560_a((ICommand)new ConfirmTeleportCommand());
        manager.func_71560_a((ICommand)new GetWaystoneCount());
        manager.func_71560_a((ICommand)new GetSignpostCount());
        manager.func_71560_a((ICommand)new SetWaystoneCount());
        manager.func_71560_a((ICommand)new SetSignpostCount());
        manager.func_71560_a((ICommand)new DiscoverWaystone());
        manager.func_71560_a((ICommand)new ListAllWaystones());
    }

    static {
        LOG = LogManager.getLogger((String)MODID);
    }
}

