/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.cartography.render;

import com.google.common.base.Optional;
import com.google.common.cache.RemovalNotification;
import java.awt.Graphics2D;
import net.minecraft.world.ChunkCoordIntPair;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.cartography.IChunkRenderer;
import net.techbrew.journeymap.cartography.RGB;
import net.techbrew.journeymap.cartography.Strata;
import net.techbrew.journeymap.cartography.Stratum;
import net.techbrew.journeymap.cartography.render.BaseRenderer;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.log.StatTimer;
import net.techbrew.journeymap.model.BlockMD;
import net.techbrew.journeymap.model.ChunkMD;
import org.apache.logging.log4j.Level;

public class SurfaceRenderer
extends BaseRenderer
implements IChunkRenderer {
    protected final Object chunkLock = new Object();
    protected final BaseRenderer.HeightsCache chunkSurfaceHeights;
    protected final BaseRenderer.SlopesCache chunkSurfaceSlopes;
    protected StatTimer renderSurfaceTimer = StatTimer.get("SurfaceRenderer.renderSurface");
    protected StatTimer renderSurfacePrepassTimer = StatTimer.get("SurfaceRenderer.renderSurface.CavePrepass");
    protected Strata strata = new Strata("Surface", 40, 8, false);
    protected float maxDepth = 8.0f;

    public SurfaceRenderer() {
        this("Surface");
    }

    protected SurfaceRenderer(String cachePrefix) {
        this.cachePrefix = cachePrefix;
        this.columnPropertiesCache = new BaseRenderer.BlockColumnPropertiesCache(cachePrefix + "ColumnProps");
        this.chunkSurfaceHeights = new BaseRenderer.HeightsCache(cachePrefix + "Heights");
        this.chunkSurfaceSlopes = new BaseRenderer.SlopesCache(cachePrefix + "Slopes");
        DataCache.instance().addChunkMDListener(this);
    }

    @Override
    protected void updateOptions() {
        super.updateOptions();
        this.ambientColor = RGB.floats(this.tweakSurfaceAmbientColor);
    }

    @Override
    public boolean render(Graphics2D dayG2d, ChunkMD chunkMd, Integer ignored) {
        return this.render(dayG2d, null, chunkMd, null, false);
    }

    public boolean render(Graphics2D dayG2d, Graphics2D nightG2d, ChunkMD chunkMd) {
        return this.render(dayG2d, nightG2d, chunkMd, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean render(Graphics2D dayG2d, Graphics2D nightG2d, ChunkMD chunkMd, Integer vSlice, boolean cavePrePass) {
        StatTimer timer = cavePrePass ? this.renderSurfacePrepassTimer : this.renderSurfaceTimer;
        try {
            timer.start();
            this.updateOptions();
            if (this.chunkSurfaceSlopes.getIfPresent(chunkMd.getCoord()) == null) {
                this.populateSlopes(chunkMd, null, this.chunkSurfaceHeights, this.chunkSurfaceSlopes);
            }
            boolean bl = this.renderSurface(dayG2d, nightG2d, chunkMd, vSlice, cavePrePass);
            return bl;
        }
        catch (Throwable e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            this.strata.reset();
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean renderSurface(Graphics2D dayG2d, Graphics2D nightG2d, ChunkMD chunkMd, Integer vSlice, boolean cavePrePass) {
        boolean chunkOk = false;
        try {
            dayG2d.setComposite(ALPHA_OPAQUE);
            if (nightG2d != null) {
                nightG2d.setComposite(ALPHA_OPAQUE);
            }
            int sliceMaxY = 0;
            if (cavePrePass) {
                int[] sliceBounds = this.getVSliceBounds(chunkMd, vSlice);
                sliceMaxY = sliceBounds[1];
            }
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    this.strata.reset();
                    BlockMD topBlockMd = null;
                    int standardY = Math.max(0, this.getSurfaceBlockHeight(chunkMd, x, z, this.chunkSurfaceHeights));
                    if (cavePrePass && standardY > sliceMaxY && (float)(standardY - sliceMaxY) > this.maxDepth) {
                        chunkOk = true;
                        this.paintBlackBlock(x, z, dayG2d);
                        continue;
                    }
                    int roofY = 0;
                    int y = standardY;
                    roofY = Math.max(0, chunkMd.getAbsoluteHeightValue(x, z));
                    if (standardY < roofY) {
                        for (int checkY = roofY; checkY > standardY; --checkY) {
                            topBlockMd = this.dataCache.getBlockMD(chunkMd, x, checkY, z);
                            if (!topBlockMd.isTransparentRoof()) continue;
                            y = Math.max(standardY, checkY);
                            break;
                        }
                    }
                    if (roofY == 0 || standardY == 0) {
                        this.paintVoidBlock(x, z, dayG2d);
                        if (!cavePrePass && nightG2d != null) {
                            this.paintVoidBlock(x, z, nightG2d);
                        }
                        chunkOk = true;
                        continue;
                    }
                    if (this.mapBathymetry) {
                        standardY = this.getColumnProperty("waterHeight", standardY, chunkMd, x, z);
                    }
                    if ((topBlockMd = chunkMd.getTopBlockMD(x, standardY, z)) == null) {
                        this.paintBadBlock(x, standardY, z, dayG2d);
                        this.paintBadBlock(x, standardY, z, nightG2d);
                        continue;
                    }
                    if (this.mapPlants || this.mapCrops) {
                        BlockMD temp = chunkMd.getTopBlockMD(x, standardY + 1, z);
                        if (this.mapPlants && temp.hasFlag(BlockMD.Flag.Plant) || this.mapCrops && temp.hasFlag(BlockMD.Flag.Crop)) {
                            ++standardY;
                        }
                    }
                    this.buildStrata(this.strata, roofY, chunkMd, x, standardY, z);
                    chunkOk = this.paintStrata(this.strata, dayG2d, nightG2d, chunkMd, topBlockMd, vSlice, x, y, z, cavePrePass) || chunkOk;
                }
            }
        }
        catch (Throwable t) {
            JourneyMap.getLogger().log(Level.WARN, LogFormatter.toString(t));
        }
        finally {
            this.strata.reset();
        }
        return chunkOk;
    }

    protected void buildStrata(Strata strata, int roofY, ChunkMD chunkMd, int x, int y, int z) {
        BlockMD blockMD;
        if (roofY > y) {
            while (roofY > y) {
                blockMD = this.dataCache.getBlockMD(chunkMd, x, roofY, z);
                if (!blockMD.isAir() && blockMD.isTransparentRoof()) {
                    strata.push(chunkMd, blockMD, x, roofY, z);
                    if (!this.mapTransparency) break;
                }
                --roofY;
            }
        }
        if (this.mapTransparency || strata.isEmpty()) {
            while (y >= 0) {
                blockMD = this.dataCache.getBlockMD(chunkMd, x, y, z);
                if (!blockMD.isAir()) {
                    strata.push(chunkMd, blockMD, x, y, z);
                    if (blockMD.getAlpha() == 1.0f || !this.mapTransparency) break;
                }
                --y;
            }
        }
    }

    protected boolean paintStrata(Strata strata, Graphics2D dayG2d, Graphics2D nightG2d, ChunkMD chunkMd, BlockMD topBlockMd, Integer vSlice, int x, int y, int z, boolean cavePrePass) {
        float slope;
        if (strata.isEmpty()) {
            this.paintBadBlock(x, y, z, dayG2d);
            this.paintBadBlock(x, y, z, nightG2d);
            return false;
        }
        while (!strata.isEmpty()) {
            Stratum stratum = strata.nextUp(this, true);
            if (strata.getRenderDayColor() == null || strata.getRenderNightColor() == null) {
                strata.setRenderDayColor(stratum.getDayColor());
                if (!cavePrePass) {
                    strata.setRenderNightColor(stratum.getNightColor());
                }
            } else {
                strata.setRenderDayColor(RGB.blendWith(strata.getRenderDayColor(), stratum.getDayColor(), stratum.getBlockMD().getAlpha()));
                if (!cavePrePass) {
                    strata.setRenderNightColor(RGB.blendWith(strata.getRenderNightColor(), stratum.getNightColor(), stratum.getBlockMD().getAlpha()));
                }
            }
            strata.release(stratum);
        }
        if (strata.getRenderDayColor() == null) {
            this.paintBadBlock(x, y, z, dayG2d);
            this.paintBadBlock(x, y, z, nightG2d);
            return false;
        }
        if (nightG2d != null && strata.getRenderNightColor() == null) {
            this.paintBadBlock(x, y, z, nightG2d);
            return false;
        }
        if ((topBlockMd.isWater() && this.mapBathymetry || !topBlockMd.hasFlag(BlockMD.Flag.NoShadow)) && (slope = this.getSlope(chunkMd, topBlockMd, x, null, z, this.chunkSurfaceHeights, this.chunkSurfaceSlopes)) != 1.0f) {
            strata.setRenderDayColor(RGB.bevelSlope(strata.getRenderDayColor(), slope));
            if (!cavePrePass) {
                strata.setRenderNightColor(RGB.bevelSlope(strata.getRenderNightColor(), slope));
            }
        }
        if (chunkMd.getHasNoSky().booleanValue()) {
            this.paintBlock(x, z, strata.getRenderNightColor(), dayG2d);
        } else {
            this.paintBlock(x, z, strata.getRenderDayColor(), dayG2d);
            if (nightG2d != null) {
                this.paintBlock(x, z, strata.getRenderNightColor(), nightG2d);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRemoval(RemovalNotification<ChunkCoordIntPair, Optional<ChunkMD>> notification) {
        Object object = this.chunkLock;
        synchronized (object) {
            ChunkCoordIntPair coord = (ChunkCoordIntPair)notification.getKey();
            this.chunkSurfaceHeights.invalidate(coord);
            this.chunkSurfaceSlopes.invalidate(coord);
        }
    }
}

