/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngjExceptionInternal;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunkBKGD;
import ar.com.hjg.pngj.chunks.PngChunkCHRM;
import ar.com.hjg.pngj.chunks.PngChunkGAMA;
import ar.com.hjg.pngj.chunks.PngChunkHIST;
import ar.com.hjg.pngj.chunks.PngChunkICCP;
import ar.com.hjg.pngj.chunks.PngChunkIDAT;
import ar.com.hjg.pngj.chunks.PngChunkIEND;
import ar.com.hjg.pngj.chunks.PngChunkIHDR;
import ar.com.hjg.pngj.chunks.PngChunkITXT;
import ar.com.hjg.pngj.chunks.PngChunkOFFS;
import ar.com.hjg.pngj.chunks.PngChunkPHYS;
import ar.com.hjg.pngj.chunks.PngChunkPLTE;
import ar.com.hjg.pngj.chunks.PngChunkSBIT;
import ar.com.hjg.pngj.chunks.PngChunkSPLT;
import ar.com.hjg.pngj.chunks.PngChunkSRGB;
import ar.com.hjg.pngj.chunks.PngChunkSTER;
import ar.com.hjg.pngj.chunks.PngChunkTEXT;
import ar.com.hjg.pngj.chunks.PngChunkTIME;
import ar.com.hjg.pngj.chunks.PngChunkTRNS;
import ar.com.hjg.pngj.chunks.PngChunkUNKNOWN;
import ar.com.hjg.pngj.chunks.PngChunkZTXT;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public abstract class PngChunk {
    public final String id;
    public final boolean crit;
    public final boolean pub;
    public final boolean safe;
    protected final ImageInfo imgInfo;
    private boolean priority = false;
    protected int chunkGroup = -1;
    protected int length = -1;
    protected long offset = 0L;
    private static final Map<String, Class<? extends PngChunk>> factoryMap = new HashMap<String, Class<? extends PngChunk>>();

    public static void factoryRegister(String chunkId, Class<? extends PngChunk> chunkClass) {
        factoryMap.put(chunkId, chunkClass);
    }

    public static boolean isKnown(String id) {
        return factoryMap.containsKey(id);
    }

    protected PngChunk(String id, ImageInfo imgInfo) {
        this.id = id;
        this.imgInfo = imgInfo;
        this.crit = ChunkHelper.isCritical(id);
        this.pub = ChunkHelper.isPublic(id);
        this.safe = ChunkHelper.isSafeToCopy(id);
    }

    public static PngChunk factory(ChunkRaw chunk, ImageInfo info) {
        PngChunk c = PngChunk.factoryFromId(ChunkHelper.toString(chunk.idbytes), info);
        c.length = chunk.len;
        c.parseFromRaw(chunk);
        return c;
    }

    public static PngChunk factoryFromId(String cid, ImageInfo info) {
        PngChunk chunk = null;
        try {
            Class<? extends PngChunk> cla = factoryMap.get(cid);
            if (cla != null) {
                Constructor<? extends PngChunk> constr = cla.getConstructor(ImageInfo.class);
                chunk = constr.newInstance(info);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (chunk == null) {
            chunk = new PngChunkUNKNOWN(cid, info);
        }
        return chunk;
    }

    protected final ChunkRaw createEmptyChunk(int len, boolean alloc) {
        ChunkRaw c = new ChunkRaw(len, ChunkHelper.toBytes(this.id), alloc);
        return c;
    }

    public static <T extends PngChunk> T cloneChunk(T chunk, ImageInfo info) {
        PngChunk cn = PngChunk.factoryFromId(chunk.id, info);
        if (cn.getClass() != chunk.getClass()) {
            throw new PngjExceptionInternal("bad class cloning chunk: " + cn.getClass() + " " + chunk.getClass());
        }
        cn.cloneDataFromRead(chunk);
        return (T)cn;
    }

    public final int getChunkGroup() {
        return this.chunkGroup;
    }

    public final void setChunkGroup(int chunkGroup) {
        this.chunkGroup = chunkGroup;
    }

    public boolean hasPriority() {
        return this.priority;
    }

    public void setPriority(boolean priority) {
        this.priority = priority;
    }

    final void write(OutputStream os) {
        ChunkRaw c = this.createRawChunk();
        if (c == null) {
            throw new PngjExceptionInternal("null chunk ! creation failed for " + this);
        }
        c.writeChunk(os);
    }

    public int getLength() {
        return this.length;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public abstract ChunkRaw createRawChunk();

    public abstract void parseFromRaw(ChunkRaw var1);

    public abstract void cloneDataFromRead(PngChunk var1);

    public abstract boolean allowsMultiple();

    public abstract ChunkOrderingConstraint getOrderingConstraint();

    public String toString() {
        return "chunk id= " + this.id + " (len=" + this.length + " offset=" + this.offset + ") c=" + this.getClass().getSimpleName();
    }

    static {
        factoryMap.put("IDAT", PngChunkIDAT.class);
        factoryMap.put("IHDR", PngChunkIHDR.class);
        factoryMap.put("PLTE", PngChunkPLTE.class);
        factoryMap.put("IEND", PngChunkIEND.class);
        factoryMap.put("tEXt", PngChunkTEXT.class);
        factoryMap.put("iTXt", PngChunkITXT.class);
        factoryMap.put("zTXt", PngChunkZTXT.class);
        factoryMap.put("bKGD", PngChunkBKGD.class);
        factoryMap.put("gAMA", PngChunkGAMA.class);
        factoryMap.put("pHYs", PngChunkPHYS.class);
        factoryMap.put("iCCP", PngChunkICCP.class);
        factoryMap.put("tIME", PngChunkTIME.class);
        factoryMap.put("tRNS", PngChunkTRNS.class);
        factoryMap.put("cHRM", PngChunkCHRM.class);
        factoryMap.put("sBIT", PngChunkSBIT.class);
        factoryMap.put("sRGB", PngChunkSRGB.class);
        factoryMap.put("hIST", PngChunkHIST.class);
        factoryMap.put("sPLT", PngChunkSPLT.class);
        factoryMap.put("oFFs", PngChunkOFFS.class);
        factoryMap.put("sTER", PngChunkSTER.class);
    }

    public static enum ChunkOrderingConstraint {
        NONE,
        BEFORE_PLTE_AND_IDAT,
        AFTER_PLTE_BEFORE_IDAT,
        BEFORE_IDAT,
        NA;


        public boolean mustGoBeforePLTE() {
            return this == BEFORE_PLTE_AND_IDAT;
        }

        public boolean mustGoBeforeIDAT() {
            return this == BEFORE_IDAT || this == BEFORE_PLTE_AND_IDAT || this == AFTER_PLTE_BEFORE_IDAT;
        }

        public boolean mustGoAfterPLTE() {
            return this == AFTER_PLTE_BEFORE_IDAT;
        }
    }
}

