/*
 * Decompiled with CFR 0.152.
 */
package hohserg.elegant.networking.impl;

import hohserg.elegant.networking.Refs;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public interface IRegistryHandlerBase {
    public static final Map<Class, IdMapper> mappers = new HashMap<Class, IdMapper>();

    default public <A> void serializeSingleton(Class<A> type, A value, ByteBuf acc) {
        Integer id = (Integer)((IdMapper)IRegistryHandlerBase.getMapper(type)).valueToId.apply(value);
        if (id == -1) {
            throw new IllegalArgumentException("Attempt to serialize unregistered " + type.getSimpleName() + ": " + value);
        }
        acc.writeInt(id.intValue());
    }

    default public <A> A unserializeSingleton(Class<A> type, ByteBuf acc) {
        Object r = ((IdMapper)IRegistryHandlerBase.getMapper(type)).idToValue.apply(acc.readInt());
        if (r == null) {
            throw new IllegalArgumentException("Illegal id of " + type.getSimpleName() + " from ByteBuf");
        }
        return (A)r;
    }

    default public <A> void register(Class<A> type, Function<A, Integer> valueToId, Function<Integer, A> idToValue) {
        mappers.put(type, new IdMapper<A>(valueToId, idToValue));
    }

    public static <A> IdMapper<A> getMapper(Class<A> type) {
        IdMapper idMapper = mappers.get(type);
        if (idMapper == null) {
            throw new IllegalArgumentException("Attempt to get id mapper for unregistered type " + type.getSimpleName() + ". " + Refs.reportUrlPlea);
        }
        return idMapper;
    }

    public static final class IdMapper<A> {
        private final Function<A, Integer> valueToId;
        private final Function<Integer, A> idToValue;

        public IdMapper(Function<A, Integer> valueToId, Function<Integer, A> idToValue) {
            this.valueToId = valueToId;
            this.idToValue = idToValue;
        }

        public Function<A, Integer> getValueToId() {
            return this.valueToId;
        }

        public Function<Integer, A> getIdToValue() {
            return this.idToValue;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IdMapper)) {
                return false;
            }
            IdMapper other = (IdMapper)o;
            Function<A, Integer> this$valueToId = this.getValueToId();
            Function<A, Integer> other$valueToId = other.getValueToId();
            if (this$valueToId == null ? other$valueToId != null : !this$valueToId.equals(other$valueToId)) {
                return false;
            }
            Function<Integer, A> this$idToValue = this.getIdToValue();
            Function<Integer, A> other$idToValue = other.getIdToValue();
            return !(this$idToValue == null ? other$idToValue != null : !this$idToValue.equals(other$idToValue));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Function<A, Integer> $valueToId = this.getValueToId();
            result = result * 59 + ($valueToId == null ? 43 : $valueToId.hashCode());
            Function<Integer, A> $idToValue = this.getIdToValue();
            result = result * 59 + ($idToValue == null ? 43 : $idToValue.hashCode());
            return result;
        }

        public String toString() {
            return "IRegistryHandlerBase.IdMapper(valueToId=" + this.getValueToId() + ", idToValue=" + this.getIdToValue() + ")";
        }
    }
}

