/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.worldGen.villages.waystone;

import gollorum.signpost.SPEventHandler;
import gollorum.signpost.Signpost;
import gollorum.signpost.blocks.BaseModelPost;
import gollorum.signpost.blocks.BasePost;
import gollorum.signpost.blocks.WaystoneContainer;
import gollorum.signpost.management.PostHandler;
import gollorum.signpost.util.BoolRun;
import gollorum.signpost.util.MyBlockPos;
import gollorum.signpost.worldGen.villages.GenerateStructureHelper;
import gollorum.signpost.worldGen.villages.NameLibrary;
import gollorum.signpost.worldGen.villages.VillageLibrary;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;

public class VillageComponentWaystone
extends StructureVillagePieces.Village {
    private boolean built = false;
    private StructureVillagePieces.Start start;
    private int facing;

    public VillageComponentWaystone() {
    }

    public VillageComponentWaystone(StructureVillagePieces.Start start, int type, StructureBoundingBox boundingBox, int facing) {
        super(start, type);
        this.field_74887_e = boundingBox;
        this.start = start;
        this.facing = facing;
    }

    @Nullable
    public static StructureVillagePieces.Village buildComponent(StructureVillagePieces.Start startPiece, List<StructureComponent> pieces, Random random, int x, int y, int z, int facing, int type) {
        StructureBoundingBox boundingBox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)1, (int)1, (int)1, (int)facing);
        if (VillageComponentWaystone.func_74895_a((StructureBoundingBox)boundingBox) && VillageComponentWaystone.func_74883_a(pieces, (StructureBoundingBox)boundingBox) == null) {
            return new VillageComponentWaystone(startPiece, type, boundingBox, facing);
        }
        return null;
    }

    public boolean func_74875_a(final World world, final Random random, StructureBoundingBox boundingBox) {
        if (this.built || this.start == null || !NameLibrary.getInstance().namesLeft()) {
            return true;
        }
        this.built = true;
        final String name = NameLibrary.getInstance().getName(random);
        if (name == null) {
            return true;
        }
        final int x = this.field_74887_e.func_78881_e();
        final int z = this.field_74887_e.func_78891_g();
        final int y = GenerateStructureHelper.getInstance().getTopSolidOrLiquidBlock(world, x, z);
        List<BaseModelPost> allowedModelTypes = Signpost.proxy.blockHandler.baseModelsForVillages();
        if (allowedModelTypes.size() == 0) {
            return true;
        }
        if (world.func_147439_a(x, y - 1, z).func_149688_o().func_76224_d()) {
            Block block = this.func_151558_b(Blocks.field_150344_f, 0);
            world.func_147449_b(x, y - 1, z, block);
        }
        if (world.func_147465_d(x, y, z, (Block)allowedModelTypes.get(random.nextInt(allowedModelTypes.size())), this.facing, 3)) {
            SPEventHandler.scheduleTask(new BoolRun(){

                @Override
                public boolean run() {
                    TileEntity tile = world.func_147438_o(x, y, z);
                    if (tile instanceof WaystoneContainer) {
                        if (PostHandler.getNativeWaystones().nameTaken(name)) {
                            VillageComponentWaystone.this.setupWaystone(NameLibrary.getInstance().getName(random), world, x, y, z, (WaystoneContainer)tile);
                        } else {
                            VillageComponentWaystone.this.setupWaystone(name, world, x, y, z, (WaystoneContainer)tile);
                        }
                        return true;
                    }
                    return false;
                }
            });
        }
        return true;
    }

    private void setupWaystone(String name, World world, int x, int y, int z, WaystoneContainer container) {
        this.assureBaseInfo(container, world, new MyBlockPos(world, x, y, z), this.getEnumFacing(this.facing), name);
        StructureBoundingBox villageBox = this.start.func_74874_b();
        MyBlockPos villagePos = new MyBlockPos(world, villageBox.field_78897_a, 0, villageBox.field_78896_c);
        MyBlockPos blockPos = new MyBlockPos(world, x, y, z);
        VillageLibrary.getInstance().putWaystone(villagePos, blockPos);
    }

    private void assureBaseInfo(WaystoneContainer container, World world, MyBlockPos blockPos, EnumFacing facing, String name) {
        if (container.getBaseInfo() == null) {
            MyBlockPos telePos = GenerateStructureHelper.getInstance().getTopSolidOrLiquidBlock(blockPos.front(facing, 2));
            BasePost.generate(world, blockPos, telePos, name);
        } else {
            container.setName(name);
        }
    }

    private EnumFacing getEnumFacing(int facing) {
        switch (facing) {
            case 0: {
                return EnumFacing.NORTH;
            }
            case 1: {
                return EnumFacing.WEST;
            }
            case 2: {
                return EnumFacing.SOUTH;
            }
            case 3: {
                return EnumFacing.EAST;
            }
        }
        return EnumFacing.EAST;
    }
}

