/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import gollorum.signpost.blocks.BaseModelPost;
import gollorum.signpost.blocks.BasePost;
import gollorum.signpost.blocks.SuperPostPost;
import gollorum.signpost.blocks.WaystoneContainer;
import gollorum.signpost.blocks.tiles.BaseModelPostTile;
import gollorum.signpost.blocks.tiles.BasePostTile;
import gollorum.signpost.blocks.tiles.SuperPostPostTile;
import gollorum.signpost.items.CalibratedPostWrench;
import gollorum.signpost.items.PostWrench;
import gollorum.signpost.management.ClientConfigStorage;
import gollorum.signpost.management.PlayerStore;
import gollorum.signpost.management.PostHandler;
import gollorum.signpost.management.WorldSigns;
import gollorum.signpost.network.NetworkHandler;
import gollorum.signpost.network.messages.InitPlayerResponseMessage;
import gollorum.signpost.network.messages.SendAllBigPostBasesMessage;
import gollorum.signpost.network.messages.SendAllPostBasesMessage;
import gollorum.signpost.util.BoolRun;
import gollorum.signpost.util.MyBlockPos;
import gollorum.signpost.util.MyBlockPosSet;
import gollorum.signpost.util.collections.Lurchpaerchensauna;
import gollorum.signpost.util.collections.Lurchsauna;
import gollorum.signpost.util.collections.Pair;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;

public class SPEventHandler {
    private static Lurchpaerchensauna<Runnable, Integer> serverTasks = new Lurchpaerchensauna();
    private static Lurchsauna<BoolRun> serverPredicatedTasks = new Lurchsauna();
    private static Lurchpaerchensauna<Runnable, Integer> clientTasks = new Lurchpaerchensauna();
    private static Lurchsauna<BoolRun> clientPredicatedTasks = new Lurchsauna();
    public static final SPEventHandler INSTANCE = new SPEventHandler();

    private SPEventHandler() {
    }

    public static void scheduleTask(Runnable task, int delay) {
        if (FMLCommonHandler.instance().getEffectiveSide().equals((Object)Side.SERVER)) {
            serverTasks.put(task, delay);
        } else {
            clientTasks.put(task, delay);
        }
    }

    public static void scheduleTask(BoolRun task) {
        if (FMLCommonHandler.instance().getEffectiveSide().equals((Object)Side.SERVER)) {
            serverPredicatedTasks.add(task);
        } else {
            clientPredicatedTasks.add(task);
        }
    }

    public static boolean cancelTask(BoolRun task) {
        if (FMLCommonHandler.instance().getEffectiveSide().equals((Object)Side.SERVER)) {
            return serverPredicatedTasks.remove(task);
        }
        return clientPredicatedTasks.remove(task);
    }

    @SubscribeEvent
    public void onServerTick(TickEvent event) {
        if (!(event instanceof TickEvent.ServerTickEvent)) {
            return;
        }
        Lurchpaerchensauna<Runnable, Integer> serverTasksTEMP = serverTasks;
        Lurchsauna<BoolRun> serverPredicatedTasksTEMP = serverPredicatedTasks;
        serverTasks = new Lurchpaerchensauna();
        serverPredicatedTasks = new Lurchsauna();
        Lurchpaerchensauna remainingTasks = new Lurchpaerchensauna();
        for (Map.Entry<Runnable, Integer> entry : serverTasksTEMP.entrySet()) {
            int val = entry.getValue() - 1;
            if (val < 2) {
                entry.getKey().run();
                continue;
            }
            serverTasks.put(entry.getKey(), val);
        }
        for (BoolRun boolRun : serverPredicatedTasksTEMP) {
            if (boolRun.run()) continue;
            serverPredicatedTasks.add(boolRun);
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent event) {
        if (!(event instanceof TickEvent.ClientTickEvent)) {
            return;
        }
        Lurchpaerchensauna<Runnable, Integer> clientTasksTEMP = clientTasks;
        Lurchsauna<BoolRun> clientPredicatedTasksTEMP = clientPredicatedTasks;
        clientTasks = new Lurchpaerchensauna();
        clientPredicatedTasks = new Lurchsauna();
        for (Map.Entry<Runnable, Integer> entry : clientTasksTEMP.entrySet()) {
            int val = entry.getValue() - 1;
            if (val < 2) {
                entry.getKey().run();
                continue;
            }
            clientTasks.put(entry.getKey(), val);
        }
        for (BoolRun boolRun : clientPredicatedTasksTEMP) {
            if (boolRun.run()) continue;
            clientPredicatedTasks.add(boolRun);
        }
    }

    @SubscribeEvent
    public void loggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            NetworkHandler.netWrap.sendTo((IMessage)new InitPlayerResponseMessage(), (EntityPlayerMP)event.player);
            NetworkHandler.netWrap.sendTo((IMessage)new SendAllPostBasesMessage(), (EntityPlayerMP)event.player);
            NetworkHandler.netWrap.sendTo((IMessage)new SendAllBigPostBasesMessage(), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void entConst(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayerMP) {
            event.entity.registerExtendedProperties("KnownWaystones", (IExtendedEntityProperties)new PlayerStore());
        }
    }

    @SubscribeEvent
    public void onLoad(WorldEvent.Load event) {
        if (!event.world.field_72995_K) {
            WorldSigns.worldSigns(event.world);
        }
    }

    @SubscribeEvent
    public void onSave(WorldEvent.Save event) {
        if (!event.world.field_72995_K) {
            WorldSigns.worldSigns(event.world);
        }
    }

    @SubscribeEvent
    public void oBlockPlace(BlockEvent.PlaceEvent event) {
        if (!(event.player instanceof EntityPlayerMP)) {
            if (event.block instanceof BasePost) {
                BasePost.placeClient(event.world, new MyBlockPos("", event.x, event.y, event.z, event.player.field_71093_bK), event.player);
            } else if (event.block instanceof BaseModelPost) {
                BaseModelPost.placeClient(event.world, new MyBlockPos("", event.x, event.y, event.z, event.player.field_71093_bK), event.player);
            } else if (event.block instanceof SuperPostPost) {
                SuperPostPost.placeClient(event.world, new MyBlockPos("", event.x, event.y, event.z, event.player.field_71093_bK), event.player);
            }
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        if (event.block instanceof BasePost) {
            BasePostTile tile = BasePost.getWaystoneRootTile(event.world, event.x, event.y, event.z);
            if (!ClientConfigStorage.INSTANCE.getSecurityLevelWaystone().canPlace(player) || !this.checkWaystoneCount(player)) {
                tile.onBlockDestroy(new MyBlockPos(event.world, event.x, event.y, event.z, player.field_71093_bK));
                event.setCanceled(true);
            } else {
                BasePost.placeServer(event.world, new MyBlockPos(event.world.func_72912_H().func_76065_j(), event.x, event.y, event.z, event.player.field_71093_bK), (EntityPlayerMP)event.player);
            }
        } else if (event.block instanceof BaseModelPost) {
            BaseModelPostTile tile = BaseModelPost.getWaystoneRootTile(event.world, event.x, event.y, event.z);
            if (!ClientConfigStorage.INSTANCE.getSecurityLevelWaystone().canPlace(player) || !this.checkWaystoneCount(player)) {
                tile.onBlockDestroy(new MyBlockPos(event.world, event.x, event.y, event.z, player.field_71093_bK));
                event.setCanceled(true);
            } else {
                BaseModelPost.placeServer(event.world, new MyBlockPos(event.world.func_72912_H().func_76065_j(), event.x, event.y, event.z, event.player.field_71093_bK), (EntityPlayerMP)event.player);
            }
        } else if (event.block instanceof SuperPostPost) {
            SuperPostPostTile tile = SuperPostPost.getSuperTile(event.world, event.x, event.y, event.z);
            if (!ClientConfigStorage.INSTANCE.getSecurityLevelSignpost().canPlace(player) || !this.checkSignpostCount(player)) {
                tile.onBlockDestroy(new MyBlockPos(event.world, event.x, event.y, event.z, player.field_71093_bK));
                event.setCanceled(true);
            } else {
                SuperPostPost.placeServer(event.world, new MyBlockPos(event.world.func_72912_H().func_76065_j(), event.x, event.y, event.z, event.player.field_71093_bK), (EntityPlayerMP)event.player);
            }
        }
    }

    public boolean checkWaystoneCount(EntityPlayerMP player) {
        Pair<MyBlockPosSet, Pair<Integer, Integer>> pair = PostHandler.playerKnownWaystonePositions.get(player.func_110124_au());
        int remaining = (Integer)((Pair)pair.b).a;
        if (remaining == 0) {
            player.func_145747_a((IChatComponent)new ChatComponentText("You are not allowed to place more waystones"));
            return false;
        }
        if (remaining > 0) {
            Pair pair2 = (Pair)pair.b;
            Integer n = (Integer)pair2.a;
            pair2.a = (Integer)pair2.a - 1;
            Integer n2 = pair2.a;
        }
        return true;
    }

    public void updateWaystoneCount(WaystoneContainer tile) {
        if (tile == null || tile.getBaseInfo() == null) {
            return;
        }
        UUID owner = tile.getBaseInfo().owner;
        if (owner == null) {
            return;
        }
        Pair<MyBlockPosSet, Pair<Integer, Integer>> pair = PostHandler.playerKnownWaystonePositions.get(owner);
        if (pair != null && (Integer)((Pair)pair.b).a >= 0) {
            Pair pair2 = (Pair)pair.b;
            Integer n = (Integer)pair2.a;
            pair2.a = (Integer)pair2.a + 1;
            Integer n2 = pair2.a;
        }
    }

    private boolean checkSignpostCount(EntityPlayerMP player) {
        Pair<MyBlockPosSet, Pair<Integer, Integer>> pair = PostHandler.playerKnownWaystonePositions.get(player.func_110124_au());
        int remaining = (Integer)((Pair)pair.b).b;
        if (remaining == 0) {
            player.func_145747_a((IChatComponent)new ChatComponentText("You are not allowed to place more signposts"));
            return false;
        }
        if (remaining > 0) {
            Pair pair2 = (Pair)pair.b;
            Integer n = (Integer)pair2.b;
            pair2.b = (Integer)pair2.b - 1;
            Integer n2 = pair2.b;
        }
        return true;
    }

    private void updateSignpostCount(SuperPostPostTile tile) {
        if (tile == null || tile.owner == null) {
            return;
        }
        Pair<MyBlockPosSet, Pair<Integer, Integer>> pair = PostHandler.playerKnownWaystonePositions.get(tile.owner);
        if ((Integer)((Pair)pair.b).b >= 0) {
            Pair pair2 = (Pair)pair.b;
            Integer n = (Integer)pair2.b;
            pair2.b = (Integer)pair2.b + 1;
            Integer n2 = pair2.b;
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        try {
            TileEntity tile = event.world.func_147438_o(event.x, event.y, event.z);
            if (tile instanceof SuperPostPostTile && event.getPlayer().func_70694_bm() != null && (event.getPlayer().func_70694_bm().func_77973_b() instanceof PostWrench || event.getPlayer().func_70694_bm().func_77973_b() instanceof CalibratedPostWrench || event.getPlayer().func_70694_bm().func_77973_b().equals(Items.field_151014_N) || event.getPlayer().func_70694_bm().func_77973_b().equals(Items.field_151126_ay) || event.getPlayer().func_70694_bm().func_77973_b().equals(Item.func_150898_a((Block)Blocks.field_150395_bd)))) {
                event.setCanceled(true);
                ((SuperPostPost)tile.field_145854_h).func_149699_a(event.world, event.x, event.y, event.z, event.getPlayer());
                return;
            }
            if (!(event.getPlayer() instanceof EntityPlayerMP)) {
                return;
            }
            EntityPlayerMP player = (EntityPlayerMP)event.getPlayer();
            if (event.block instanceof BasePost) {
                BasePostTile t = BasePost.getWaystoneRootTile(event.world, event.x, event.y, event.z);
                if (!ClientConfigStorage.INSTANCE.getSecurityLevelWaystone().canUse(player, "" + t.getBaseInfo().owner)) {
                    event.setCanceled(true);
                } else {
                    this.updateWaystoneCount(t);
                    t.onBlockDestroy(new MyBlockPos(event.world, event.x, event.y, event.z, player.field_71093_bK));
                }
            } else if (event.block instanceof BaseModelPost) {
                BaseModelPostTile t = BaseModelPost.getWaystoneRootTile(event.world, event.x, event.y, event.z);
                if (!ClientConfigStorage.INSTANCE.getSecurityLevelWaystone().canUse(player, "" + t.getBaseInfo().owner)) {
                    event.setCanceled(true);
                } else {
                    this.updateWaystoneCount(t);
                    t.onBlockDestroy(new MyBlockPos(event.world, event.x, event.y, event.z, player.field_71093_bK));
                }
            } else if (event.block instanceof SuperPostPost) {
                SuperPostPostTile t = SuperPostPost.getSuperTile(event.world, event.x, event.y, event.z);
                if (!ClientConfigStorage.INSTANCE.getSecurityLevelSignpost().canUse(player, "" + t.owner)) {
                    event.setCanceled(true);
                } else {
                    this.updateSignpostCount(t);
                    t.onBlockDestroy(new MyBlockPos(event.world, event.x, event.y, event.z, player.field_71093_bK));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

