/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.scripted;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.Vec3;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.blocks.tiles.TileBigSign;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.scripted.NpcAPI;
import noppes.npcs.scripted.ScriptScoreboard;
import noppes.npcs.scripted.interfaces.IBlock;
import noppes.npcs.scripted.interfaces.IParticle;
import noppes.npcs.scripted.interfaces.IPos;
import noppes.npcs.scripted.interfaces.ITileEntity;
import noppes.npcs.scripted.interfaces.IWorld;
import noppes.npcs.scripted.interfaces.entity.IEntity;
import noppes.npcs.scripted.interfaces.entity.IPlayer;
import noppes.npcs.scripted.interfaces.item.IItemStack;

public class ScriptWorld
implements IWorld {
    private static Map<String, Object> tempData = new HashMap<String, Object>();
    public WorldServer world;

    public ScriptWorld(WorldServer world) {
        this.world = world;
    }

    public static ScriptWorld createNew(int dimensionId) {
        WorldServer[] worlds = CustomNpcs.getServer().field_71305_c;
        WorldServer world = worlds[0];
        for (WorldServer w : worlds) {
            if (w.field_73011_w.field_76574_g != dimensionId) continue;
            world = w;
        }
        return new ScriptWorld(world);
    }

    @Override
    public long getTime() {
        return this.world.func_72820_D();
    }

    @Override
    public long getTotalTime() {
        return this.world.func_82737_E();
    }

    @Override
    public boolean areAllPlayersAsleep() {
        return this.world.func_73056_e();
    }

    @Override
    public IBlock getBlock(int x, int y, int z) {
        Block block = this.world.func_147439_a(x, y, z);
        if (block == null || block.isAir((IBlockAccess)this.world, x, y, z)) {
            return null;
        }
        return NpcAPI.Instance().getIBlock((World)this.world, block, new BlockPos(x, y, z));
    }

    @Override
    public boolean isBlockFreezable(int x, int y, int z) {
        return this.world.func_72884_u(x, y, z);
    }

    @Override
    public boolean isBlockFreezableNaturally(int x, int y, int z) {
        return this.world.func_72850_v(x, y, z);
    }

    @Override
    public boolean canBlockFreeze(int x, int y, int z, boolean adjacentToWater) {
        return this.world.func_72834_c(x, y, z, adjacentToWater);
    }

    @Override
    public boolean canBlockFreezeBody(int x, int y, int z, boolean adjacentToWater) {
        return this.world.canBlockFreezeBody(x, y, z, adjacentToWater);
    }

    @Override
    public boolean canSnowAt(int x, int y, int z, boolean checkLight) {
        return this.world.func_147478_e(x, y, z, checkLight);
    }

    @Override
    public boolean canSnowAtBody(int x, int y, int z, boolean checkLight) {
        return this.world.canSnowAtBody(x, y, z, checkLight);
    }

    @Override
    public IBlock getTopBlock(int x, int z) {
        int y = 63;
        while (!this.world.func_147437_c(x, y + 1, z)) {
            ++y;
        }
        Block block = this.world.func_147439_a(x, y, z);
        return NpcAPI.Instance().getIBlock((World)this.world, block, new BlockPos(x, y, z));
    }

    @Override
    public int getHeightValue(int x, int z) {
        return this.world.func_72976_f(x, z);
    }

    @Override
    public int getChunkHeightMapMinimum(int x, int z) {
        return this.world.func_82734_g(x, z);
    }

    @Override
    public int getBlockMetadata(int x, int y, int z) {
        return this.world.func_72805_g(x, y, z);
    }

    @Override
    public boolean setBlockMetadataWithNotify(int x, int y, int z, int metadata, int flag) {
        return this.world.func_72921_c(x, y, z, metadata, flag);
    }

    @Override
    public boolean canBlockSeeTheSky(int x, int y, int z) {
        return this.world.func_72937_j(x, y, z);
    }

    @Override
    public int getFullBlockLightValue(int x, int y, int z) {
        return this.world.func_72883_k(x, y, z);
    }

    @Override
    public int getBlockLightValue(int x, int y, int z) {
        return this.world.func_72957_l(x, y, z);
    }

    @Override
    public void playSoundAtEntity(IEntity entity, String sound, float volume, float pitch) {
        this.world.func_72956_a(entity.getMCEntity(), sound, volume, pitch);
    }

    @Override
    public void playSoundToNearExcept(IPlayer player, String sound, float volume, float pitch) {
        this.world.func_85173_a((EntityPlayer)((EntityPlayerMP)player.getMCEntity()), sound, volume, pitch);
    }

    @Override
    public IEntity getEntityByID(int id) {
        return NpcAPI.Instance().getIEntity(this.world.func_73045_a(id));
    }

    @Override
    public boolean spawnEntityInWorld(IEntity entity) {
        return this.world.func_72838_d(entity.getMCEntity());
    }

    @Override
    public IPlayer getClosestPlayerToEntity(IEntity entity, double range) {
        return (IPlayer)NpcAPI.Instance().getIEntity((Entity)this.world.func_72890_a(entity.getMCEntity(), range));
    }

    @Override
    public IPlayer getClosestPlayer(double x, double y, double z, double range) {
        return (IPlayer)NpcAPI.Instance().getIEntity((Entity)this.world.func_72977_a(x, y, z, range));
    }

    @Override
    public IPlayer getClosestVulnerablePlayerToEntity(IEntity entity, double range) {
        return (IPlayer)NpcAPI.Instance().getIEntity((Entity)this.world.func_72856_b(entity.getMCEntity(), range));
    }

    @Override
    public IPlayer getClosestVulnerablePlayer(double x, double y, double z, double range) {
        return (IPlayer)NpcAPI.Instance().getIEntity((Entity)this.world.func_72846_b(x, y, z, range));
    }

    @Override
    public int countEntities(IEntity entity) {
        return this.world.func_72907_a(entity.getMCEntity().getClass());
    }

    @Override
    public IEntity[] getLoadedEntities() {
        ArrayList<IEntity> list = new ArrayList<IEntity>();
        for (Object obj : this.world.field_72996_f) {
            list.add(NpcAPI.Instance().getIEntity((Entity)obj));
        }
        return list.toArray(new IEntity[0]);
    }

    @Override
    public void setTileEntity(int x, int y, int z, ITileEntity tileEntity) {
        this.world.func_147455_a(x, y, z, tileEntity.getMCTileEntity());
    }

    @Override
    public void removeTileEntity(int x, int y, int z) {
        this.world.func_147475_p(x, y, z);
    }

    @Override
    public boolean isBlockFullCube(int x, int y, int z) {
        return this.world.func_147469_q(x, y, z);
    }

    @Override
    public long getSeed() {
        return this.world.func_72905_C();
    }

    @Override
    public void setSpawnLocation(int x, int y, int z) {
        this.world.func_72950_A(x, y, z);
    }

    @Override
    public boolean canLightningStrikeAt(int x, int y, int z) {
        return this.world.func_72951_B(x, y, z);
    }

    @Override
    public boolean isBlockHighHumidity(int x, int y, int z) {
        return this.world.func_72958_C(x, y, z);
    }

    @Override
    public IBlock getBlock(IPos pos) {
        return this.getBlock(pos.getX(), pos.getY(), pos.getZ());
    }

    @Override
    public String getSignText(int x, int y, int z) {
        TileEntity tile = this.world.func_147438_o(x, y, z);
        if (tile instanceof TileBigSign) {
            return ((TileBigSign)tile).getText();
        }
        if (tile instanceof TileEntitySign) {
            TileEntitySign tileSign = (TileEntitySign)tile;
            String s = tileSign.field_145915_a[0] + "\n";
            s = s + tileSign.field_145915_a[1] + "\n";
            s = s + tileSign.field_145915_a[2] + "\n";
            s = s + tileSign.field_145915_a[3];
            return s;
        }
        return null;
    }

    @Override
    public void setBlock(int x, int y, int z, IBlock block) {
        if (block == null || block.getMCBlock().isAir((IBlockAccess)this.world, x, y, z)) {
            this.removeBlock(x, y, z);
            return;
        }
        this.world.func_147449_b(x, y, z, block.getMCBlock());
    }

    @Override
    public void setBlock(int x, int y, int z, IItemStack item) {
        if (item == null) {
            this.removeBlock(x, y, z);
            return;
        }
        Block block = Block.func_149634_a((Item)item.getMCItemStack().func_77973_b());
        if (block == null || block == Blocks.field_150350_a) {
            return;
        }
        this.world.func_147449_b(x, y, z, block);
    }

    @Override
    public void removeBlock(int x, int y, int z) {
        this.world.func_147449_b(x, y, z, Blocks.field_150350_a);
    }

    @Override
    public IBlock rayCastBlock(double[] startPos, double[] lookVector, int maxDistance) {
        if (startPos.length != 3 || lookVector.length != 3) {
            return null;
        }
        Vec3 currentPos = Vec3.func_72443_a((double)startPos[0], (double)startPos[1], (double)startPos[2]);
        int rep = 0;
        while (rep++ < maxDistance + 10) {
            currentPos = currentPos.func_72441_c(lookVector[0], lookVector[1], lookVector[2]);
            IBlock block = this.getBlock((int)currentPos.field_72450_a, (int)currentPos.field_72448_b, (int)currentPos.field_72449_c);
            if (block == null) continue;
            double distance = Math.pow(Math.pow(currentPos.field_72450_a - startPos[0], 2.0) + Math.pow(currentPos.field_72448_b - startPos[1], 2.0) + Math.pow(currentPos.field_72449_c - startPos[2], 2.0), 0.5);
            if (distance > (double)maxDistance) {
                return null;
            }
            return block;
        }
        return null;
    }

    @Override
    public IBlock rayCastBlock(IPos startPos, IPos lookVector, int maxDistance) {
        return this.rayCastBlock(new double[]{startPos.getX(), startPos.getY(), startPos.getZ()}, lookVector.normalize(), maxDistance);
    }

    @Override
    public IPos getNearestAir(IPos pos, int maxHeight) {
        if (pos == null) {
            return null;
        }
        IPos currentPos = pos;
        IBlock block = null;
        int rep = 0;
        while (rep++ < maxHeight && (block = this.getBlock(currentPos = currentPos.add(1, 0, 0))) != null && (block = this.getBlock(currentPos = currentPos.add(-2, 0, 0))) != null && (block = this.getBlock(currentPos = currentPos.add(1, 0, 1))) != null && (block = this.getBlock(currentPos = currentPos.add(0, 0, -2))) != null && (block = this.getBlock(currentPos = currentPos.add(0, 1, 1))) != null) {
        }
        return currentPos;
    }

    @Override
    public boolean canSeeSky(int x, int y, int z) {
        return this.world.func_72937_j(x, y, z);
    }

    @Override
    public boolean canSeeSky(IPos pos) {
        return this.canSeeSky(pos.getX(), pos.getY(), pos.getZ());
    }

    @Override
    public IPlayer getPlayer(String name) {
        EntityPlayer player = this.world.func_72924_a(name);
        if (player == null) {
            return null;
        }
        return (IPlayer)NpcAPI.Instance().getIEntity((Entity)player);
    }

    @Override
    public IPlayer getPlayerByUUID(String uuid) {
        return (IPlayer)NpcAPI.Instance().getIEntity((Entity)this.world.func_152378_a(UUID.fromString(uuid)));
    }

    @Override
    public void setTime(long time) {
        this.world.func_72877_b(time);
    }

    @Override
    public boolean isDay() {
        return this.world.func_72820_D() % 24000L < 12000L;
    }

    @Override
    public boolean isRaining() {
        return this.world.func_72912_H().func_76059_o();
    }

    @Override
    public void setRaining(boolean bo) {
        this.world.func_72912_H().func_76084_b(bo);
    }

    @Override
    public void thunderStrike(double x, double y, double z) {
        this.world.func_72942_c((Entity)new EntityLightningBolt((World)this.world, x, y, z));
    }

    @Override
    public void spawnParticle(String particle, double x, double y, double z, double dx, double dy, double dz, double speed, int count) {
        this.world.func_147487_a(particle, x, y, z, count, dx, dy, dz, speed);
    }

    @Override
    public IItemStack createItem(String id, int damage, int size) {
        return NpcAPI.Instance().createItem(id, damage, size);
    }

    @Override
    @Deprecated
    public IParticle createEntityParticle(String directory) {
        return NpcAPI.Instance().createEntityParticle(directory);
    }

    @Override
    public Object getTempData(String key) {
        return tempData.get(key);
    }

    @Override
    public void setTempData(String key, Object value) {
        tempData.put(key, value);
    }

    @Override
    public boolean hasTempData(String key) {
        return tempData.containsKey(key);
    }

    @Override
    public void removeTempData(String key) {
        tempData.remove(key);
    }

    @Override
    public void clearTempData() {
        tempData.clear();
    }

    @Override
    public Object getStoredData(String key) {
        NBTTagCompound compound = ScriptController.Instance.compound;
        if (!compound.func_74764_b(key)) {
            return null;
        }
        NBTBase base = compound.func_74781_a(key);
        if (base instanceof NBTBase.NBTPrimitive) {
            return ((NBTBase.NBTPrimitive)base).func_150286_g();
        }
        return ((NBTTagString)base).func_150285_a_();
    }

    @Override
    public void setStoredData(String key, Object value) {
        NBTTagCompound compound = ScriptController.Instance.compound;
        if (value instanceof Number) {
            compound.func_74780_a(key, ((Number)value).doubleValue());
        } else if (value instanceof String) {
            compound.func_74778_a(key, (String)value);
        }
        ScriptController.Instance.shouldSave = true;
    }

    @Override
    public boolean hasStoredData(String key) {
        return ScriptController.Instance.compound.func_74764_b(key);
    }

    @Override
    public void removeStoredData(String key) {
        ScriptController.Instance.compound.func_82580_o(key);
        ScriptController.Instance.shouldSave = true;
    }

    @Override
    public void clearStoredData() {
        ScriptController.Instance.compound = new NBTTagCompound();
        ScriptController.Instance.shouldSave = true;
    }

    @Override
    public void explode(double x, double y, double z, float range, boolean fire, boolean grief) {
        this.world.func_72885_a(null, x, y, z, range, fire, grief);
    }

    @Override
    public IPlayer[] getAllServerPlayers() {
        List list = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        IPlayer[] arr = new IPlayer[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            arr[i] = (IPlayer)NpcAPI.Instance().getIEntity((Entity)list.get(i));
        }
        return arr;
    }

    @Override
    public String[] getPlayerNames() {
        IPlayer[] players = this.getAllServerPlayers();
        String[] names = new String[players.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = players[i].getDisplayName();
        }
        return names;
    }

    @Override
    public String getBiomeName(int x, int z) {
        return this.world.func_72807_a((int)x, (int)z).field_76791_y;
    }

    @Override
    public IEntity spawnClone(int x, int y, int z, int tab, String name) {
        NBTTagCompound compound = ServerCloneController.Instance.getCloneData(null, name, tab);
        if (compound == null) {
            return null;
        }
        Entity entity = NoppesUtilServer.spawnClone(compound, x, y, z, (World)this.world);
        if (entity == null) {
            return null;
        }
        return NpcAPI.Instance().getIEntity(entity);
    }

    @Override
    public ScriptScoreboard getScoreboard() {
        return new ScriptScoreboard();
    }

    @Override
    public BlockPos getMCBlockPos(int x, int y, int z) {
        return new BlockPos(x, y, z);
    }

    @Override
    public WorldServer getMCWorld() {
        return this.world;
    }

    @Override
    public int getDimensionID() {
        return this.world.field_73011_w.field_76574_g;
    }
}

