/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.quests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.NBTTags;
import noppes.npcs.constants.EnumQuestType;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.quests.QuestInterface;
import noppes.npcs.scripted.CustomNPCsException;
import noppes.npcs.scripted.interfaces.handler.data.IQuestDialog;
import noppes.npcs.scripted.interfaces.handler.data.IQuestObjective;

public class QuestDialog
extends QuestInterface
implements IQuestDialog {
    public HashMap<Integer, Integer> dialogs = new HashMap();

    @Override
    public void readEntityFromNBT(NBTTagCompound compound) {
        this.dialogs = NBTTags.getIntegerIntegerMap(compound.func_150295_c("QuestDialogs", 10));
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound compound) {
        compound.func_74782_a("QuestDialogs", (NBTBase)NBTTags.nbtIntegerIntegerMap(this.dialogs));
    }

    @Override
    public boolean isCompleted(PlayerData playerData) {
        for (int dialogId : this.dialogs.values()) {
            if (playerData.dialogData.dialogsRead.contains(dialogId)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void handleComplete(EntityPlayer player) {
        super.handleComplete(player);
    }

    @Override
    public Vector<String> getQuestLogStatus(EntityPlayer player) {
        Vector<String> vec = new Vector<String>();
        for (int dialogId : this.dialogs.values()) {
            Dialog dialog = DialogController.instance.dialogs.get(dialogId);
            if (dialog == null) continue;
            String title = dialog.title;
            title = PlayerDataController.instance.getPlayerData((EntityPlayer)player).dialogData.dialogsRead.contains(dialogId) ? title + " (read)" : title + " (unread)";
            vec.add(title);
        }
        return vec;
    }

    @Override
    public IQuestObjective[] getObjectives(EntityPlayer player) {
        ArrayList<QuestDialogObjective> list = new ArrayList<QuestDialogObjective>();
        for (int i = 0; i < 3; ++i) {
            Dialog dialog;
            if (!this.dialogs.containsKey(i) || (dialog = DialogController.instance.dialogs.get(this.dialogs.get(i))) == null) continue;
            list.add(new QuestDialogObjective(this, player, dialog));
        }
        return list.toArray(new IQuestObjective[list.size()]);
    }

    class QuestDialogObjective
    implements IQuestObjective {
        private final QuestDialog parent;
        private final EntityPlayer player;
        private final Dialog dialog;

        public QuestDialogObjective(QuestDialog this$02, EntityPlayer player, Dialog dialog) {
            this.parent = this$02;
            this.player = player;
            this.dialog = dialog;
        }

        @Override
        public int getProgress() {
            return this.isCompleted() ? 1 : 0;
        }

        @Override
        public void setProgress(int progress) {
            if (progress >= 0 && progress <= 1) {
                PlayerData data = PlayerDataController.instance.getPlayerData(this.player);
                boolean completed = data.dialogData.dialogsRead.contains(this.dialog.id);
                if (progress == 0 && completed) {
                    data.dialogData.dialogsRead.remove(this.dialog.id);
                    data.questData.checkQuestCompletion(data, EnumQuestType.values()[1]);
                    data.saveNBTData(data.getNBT());
                }
                if (progress == 1 && !completed) {
                    data.dialogData.dialogsRead.add(this.dialog.id);
                    data.questData.checkQuestCompletion(data, EnumQuestType.values()[1]);
                    data.saveNBTData(data.getNBT());
                }
            } else {
                throw new CustomNPCsException("Progress has to be 0 or 1", new Object[0]);
            }
        }

        @Override
        public int getMaxProgress() {
            return 1;
        }

        @Override
        public boolean isCompleted() {
            PlayerData data = PlayerDataController.instance.getPlayerData(this.player);
            return data.dialogData.dialogsRead.contains(this.dialog.id);
        }

        @Override
        public String getText() {
            return this.dialog.title + (this.isCompleted() ? " (read)" : " (unread)");
        }
    }
}

