/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import com.google.common.collect.Sets;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.ForgeEventFactory;
import noppes.npcs.EventHooks;
import noppes.npcs.controllers.SpawnController;
import noppes.npcs.controllers.data.SpawnData;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;

public class NPCSpawning {
    private static Set<ChunkCoordIntPair> eligibleChunksForSpawning = Sets.newHashSet();
    private static boolean animalSpawn;
    private static boolean monsterSpawn;
    private static boolean airSpawn;
    private static boolean liquidSpawn;

    public static void findChunksForSpawning(WorldServer world) {
        if (SpawnController.instance.data.isEmpty() || world.func_72912_H().func_82573_f() % 400L != 0L) {
            return;
        }
        eligibleChunksForSpawning.clear();
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer entityplayer = (EntityPlayer)world.field_73010_i.get(i);
            int j = MathHelper.func_76128_c((double)(entityplayer.field_70165_t / 16.0));
            int k = MathHelper.func_76128_c((double)(entityplayer.field_70161_v / 16.0));
            int size = 7;
            for (int x = -size; x <= size; ++x) {
                for (int z = -size; z <= size; ++z) {
                    ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(x + j, z + k);
                    if (eligibleChunksForSpawning.contains(chunkcoordintpair)) continue;
                    eligibleChunksForSpawning.add(chunkcoordintpair);
                }
            }
        }
        if (NPCSpawning.countNPCs((World)world) > eligibleChunksForSpawning.size()) {
            return;
        }
        ArrayList<ChunkCoordIntPair> tmp = new ArrayList<ChunkCoordIntPair>(eligibleChunksForSpawning);
        Collections.shuffle(tmp);
        for (ChunkCoordIntPair chunkcoordintpair1 : tmp) {
            ChunkPosition chunkposition = NPCSpawning.getChunk((World)world, chunkcoordintpair1.field_77276_a, chunkcoordintpair1.field_77275_b);
            int j1 = chunkposition.field_151329_a;
            int y = chunkposition.field_151327_b;
            int l1 = chunkposition.field_151328_c;
            for (int i = 0; i < 3; ++i) {
                int x = j1;
                int z = l1;
                String name = world.func_72807_a((int)x, (int)z).field_76791_y;
                int b1 = 6;
                Block block = world.func_147439_a(x += world.field_73012_v.nextInt(b1) - world.field_73012_v.nextInt(b1), y, z += world.field_73012_v.nextInt(b1) - world.field_73012_v.nextInt(b1));
                SpawnData data = SpawnController.instance.getRandomSpawnData(name, block.func_149688_o() == Material.field_151579_a);
                if (data == null || !NPCSpawning.canCreatureTypeSpawnAtLocation(data, (World)world, x, y, z) || world.func_72977_a((double)x, (double)y, (double)z, 24.0) != null) continue;
                NPCSpawning.spawnData(data, (World)world, x, y, z);
            }
        }
    }

    public static int countNPCs(World world) {
        int count = 0;
        List list = world.field_72996_f;
        for (Entity entity : list) {
            if (!(entity instanceof EntityNPCInterface)) continue;
            ++count;
        }
        return count;
    }

    protected static ChunkPosition getChunk(World world, int x, int z) {
        Chunk chunk = world.func_72964_e(x, z);
        int k = x * 16 + world.field_73012_v.nextInt(16);
        int l = z * 16 + world.field_73012_v.nextInt(16);
        int i1 = world.field_73012_v.nextInt(chunk == null ? world.func_72940_L() : chunk.func_76625_h() + 16 - 1);
        return new ChunkPosition(k, i1, l);
    }

    public static void performWorldGenSpawning(World world, int x, int z, Random rand) {
        BiomeGenBase biome = world.func_72807_a(x + 8, z + 8);
        block0: while (rand.nextFloat() < biome.func_76741_f()) {
            SpawnData data = SpawnController.instance.getRandomSpawnData(biome.field_76791_y, true);
            if (data == null) continue;
            int size = 16;
            int j1 = x + rand.nextInt(size);
            int k1 = z + rand.nextInt(size);
            int l1 = j1;
            int i2 = k1;
            for (int k2 = 0; k2 < 4; ++k2) {
                int l2 = world.func_72825_h(j1, k1);
                if (l2 > data.spawnHeightMax || l2 < data.spawnHeightMin) continue;
                if (data.airSpawning && l2 < data.spawnHeightMax) {
                    l2 += (int)((double)(data.spawnHeightMax - l2) * Math.random());
                }
                if (!NPCSpawning.canCreatureTypeSpawnAtLocation(data, world, j1, l2, k1)) {
                    j1 += rand.nextInt(5) - rand.nextInt(5);
                    k1 += rand.nextInt(5) - rand.nextInt(5);
                    while (j1 < x || j1 >= x + size || k1 < z || k1 >= z + size) {
                        j1 = l1 + rand.nextInt(5) - rand.nextInt(5);
                        k1 = i2 + rand.nextInt(5) - rand.nextInt(5);
                    }
                    continue;
                }
                if (NPCSpawning.spawnData(data, world, j1, l2, k1)) continue block0;
            }
        }
    }

    private static boolean spawnData(SpawnData data, World world, int x, int y, int z) {
        EntityLiving entityliving;
        try {
            NBTTagCompound[] allCompoundList = new NBTTagCompound[]{data.compound1, data.compound2, data.compound3, data.compound4, data.compound5};
            ArrayList<Entity> entities = new ArrayList<Entity>();
            for (NBTTagCompound compound : allCompoundList) {
                Entity entity;
                try {
                    entity = EntityList.func_75615_a((NBTTagCompound)compound, (World)world);
                }
                catch (Exception e) {
                    continue;
                }
                entities.add(entity);
            }
            Entity spawnEntity = (Entity)entities.get((int)Math.floor(Math.random() * (double)entities.size()));
            if (!(spawnEntity instanceof EntityLiving)) {
                return false;
            }
            entityliving = (EntityLiving)spawnEntity;
            if (spawnEntity instanceof EntityCustomNpc) {
                EntityCustomNpc npc = (EntityCustomNpc)spawnEntity;
                npc.stats.spawnCycle = 3;
                npc.ai.returnToStart = false;
                npc.ai.startPos = new int[]{x, y, z};
                npc.updateAI = true;
                npc.updateClient = true;
                npc.func_70661_as().func_75499_g();
            }
            spawnEntity.func_70012_b((double)x + 0.5, (double)y, (double)z + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)entityliving, (World)world, (float)((float)x + 0.5f), (float)y, (float)((float)z + 0.5f));
        if (canSpawn == Event.Result.DENY || canSpawn == Event.Result.DEFAULT && !NPCSpawning.canEntitySpawn(data, entityliving)) {
            return false;
        }
        if (!EventHooks.onCNPCNaturalSpawn(data, new BlockPos(x, y, z), animalSpawn, monsterSpawn, liquidSpawn, airSpawn)) {
            return false;
        }
        world.func_72838_d((Entity)entityliving);
        return true;
    }

    public static boolean canEntitySpawn(SpawnData data, EntityLiving entityLiving) {
        if (!data.liquidSpawning) {
            return entityLiving.func_70601_bi();
        }
        return entityLiving.field_70170_p.func_72855_b(entityLiving.field_70121_D) && entityLiving.field_70170_p.func_72945_a((Entity)entityLiving, entityLiving.field_70121_D).isEmpty();
    }

    public static boolean canCreatureTypeSpawnAtLocation(SpawnData data, World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y - 1, z);
        boolean hasSolidSurface = World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z);
        boolean spawnBlockCreature = block.canCreatureSpawn(EnumCreatureType.creature, (IBlockAccess)world, x, y - 1, z);
        boolean spawnBlockMonster = block.canCreatureSpawn(EnumCreatureType.monster, (IBlockAccess)world, x, y - 1, z);
        boolean animalSpawn = data.animalSpawning && hasSolidSurface && spawnBlockCreature && !world.func_147439_a(x, y, z).func_149721_r() && !world.func_147439_a(x, y, z).func_149688_o().func_76224_d() && !world.func_147439_a(x, y + 1, z).func_149721_r();
        boolean monsterSpawn = data.monsterSpawning && hasSolidSurface && spawnBlockMonster && !world.func_147439_a(x, y, z).func_149721_r() && !world.func_147439_a(x, y, z).func_149688_o().func_76224_d() && !world.func_147439_a(x, y + 1, z).func_149721_r();
        boolean liquidSpawn = data.liquidSpawning && world.func_147439_a(x, y - 1, z).func_149688_o().func_76224_d() && world.func_147439_a(x, y, z).func_149688_o().func_76224_d();
        boolean caveSpawn = data.airSpawning && world.func_147439_a(x, y - 1, z) == Blocks.field_150350_a && world.func_147439_a(x, y, z) == Blocks.field_150350_a && world.func_147439_a(x, y + 1, z) == Blocks.field_150350_a;
        NPCSpawning.animalSpawn = animalSpawn;
        NPCSpawning.monsterSpawn = monsterSpawn;
        NPCSpawning.liquidSpawn = liquidSpawn;
        airSpawn = caveSpawn;
        return animalSpawn || monsterSpawn || caveSpawn || liquidSpawn;
    }
}

