/*
 * Decompiled with CFR 0.152.
 */
package tennox.keyandcodelock.connection;

import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import tennox.keyandcodelock.IKeyAndCodeLockPacket;
import tennox.keyandcodelock.KeyAndCodeLock;
import tennox.keyandcodelock.blocks.BlockDoorLockedKey;
import tennox.keyandcodelock.blocks.BlockRedstoneLockKey;
import tennox.keyandcodelock.blocks.TileEntityCodeLocked;
import tennox.keyandcodelock.connection.PacketCodeCheckAnswer;

public class PacketCodeCheck
implements IKeyAndCodeLockPacket {
    int x;
    int y;
    int z;
    int code;
    boolean open;

    public PacketCodeCheck() {
    }

    public PacketCodeCheck(TileEntity tile, int code, boolean open) {
        this.x = tile.field_145851_c;
        this.y = tile.field_145848_d;
        this.z = tile.field_145849_e;
        this.code = code;
        this.open = open;
    }

    @Override
    public void readBytes(ByteBuf buffer) {
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.code = buffer.readInt();
        this.open = buffer.readBoolean();
        KeyAndCodeLock.debug("Read PacketCodeCheck: " + this.x + "," + this.y + "," + this.z + " code=" + this.code + " open=" + this.open);
    }

    @Override
    public void writeBytes(ByteBuf buffer) {
        KeyAndCodeLock.debug("Writing PacketCodeCheck... " + this.x + "," + this.y + "," + this.z + " code=" + this.code + " open=" + this.open);
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        buffer.writeInt(this.code);
        buffer.writeBoolean(this.open);
    }

    @Override
    public void executeServer(EntityPlayerMP player) {
        TileEntity t = player.field_70170_p.func_147438_o(this.x, this.y, this.z);
        if (t != null && t instanceof TileEntityCodeLocked) {
            TileEntityCodeLocked tile = (TileEntityCodeLocked)t;
            if (tile.code == this.code) {
                this.sendCodeCheckAnswer(this.x, this.y, this.z, true, (EntityPlayer)player);
                if (this.open) {
                    if (player.field_70170_p.func_147439_a(this.x, this.y, this.z) == KeyAndCodeLock.codelockeddoor) {
                        ((BlockDoorLockedKey)KeyAndCodeLock.keylockeddoor).flipDoor(player.field_70170_p, this.x, this.y, this.z, (EntityPlayer)player);
                    } else if (player.field_70170_p.func_147439_a(this.x, this.y, this.z) == KeyAndCodeLock.coderedstonelock) {
                        ((BlockRedstoneLockKey)KeyAndCodeLock.keyredstonelock).changePowerState(player.field_70170_p, this.x, this.y, this.z);
                    }
                }
                player.field_71135_a.func_147359_a(tile.func_145844_m());
                KeyAndCodeLock.debug("Code accepted!");
            } else {
                this.sendCodeCheckAnswer(this.x, this.y, this.z, false, (EntityPlayer)player);
                KeyAndCodeLock.debug("Code denied!");
            }
        }
    }

    private void sendCodeCheckAnswer(int x, int y, int z, boolean answer, EntityPlayer player) {
        KeyAndCodeLock.debug("Sending CodeCheckAnswer...");
        KeyAndCodeLock.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        KeyAndCodeLock.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        KeyAndCodeLock.channels.get(Side.SERVER).writeOutbound(new Object[]{new PacketCodeCheckAnswer(x, y, z, answer)});
        KeyAndCodeLock.debug("CodeCheckAnswer sent!");
    }

    @Override
    public void executeClient() {
    }
}

