/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.renderer;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.BossStatus;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.client.ImageDownloadAlt;
import noppes.npcs.client.model.ModelMPM;
import noppes.npcs.client.renderer.ImageBufferDownloadAlt;
import noppes.npcs.constants.EnumAnimation;
import noppes.npcs.constants.EnumStandingType;
import noppes.npcs.controllers.data.SkinOverlay;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.scripted.interfaces.ISkinOverlay;
import org.lwjgl.opengl.GL11;

public class RenderNPCInterface
extends RenderLiving {
    public static long LastTextureTick = 0L;
    public ModelBase originalModel;

    public RenderNPCInterface(ModelBase model, float f) {
        super(model, f);
        this.originalModel = model;
    }

    protected void renderName(EntityNPCInterface npc, double d, double d1, double d2) {
        float f3;
        if (!this.func_110813_b((EntityLiving)npc)) {
            return;
        }
        float f2 = npc.func_70032_d((Entity)this.field_76990_c.field_78734_h);
        float f = f3 = npc.func_70093_af() ? 32.0f : 64.0f;
        if (f2 > f3) {
            return;
        }
        if (npc.messages != null) {
            float height = npc.baseHeight / 5.0f * (float)npc.display.modelSize;
            float offset = npc.field_70131_O * (1.2f + (!npc.display.showName() ? 0.0f : (npc.display.title.isEmpty() ? 0.15f : 0.25f)));
            npc.messages.renderMessages(d, d1 + (double)offset, d2, 0.666667f * height);
        }
        float scale = npc.baseHeight / 5.0f * (float)npc.display.modelSize;
        int height = 0;
        if (npc.display.showName()) {
            String s = npc.func_70005_c_();
            if (!npc.display.title.isEmpty()) {
                this.renderLivingLabel(npc, d, d1 + (double)npc.field_70131_O - (double)(0.06f * scale), d2, 64, "<" + npc.display.title + ">", Float.valueOf(0.6f), s, Float.valueOf(1.0f));
                height = 2;
            } else {
                this.renderLivingLabel(npc, d, d1 + (double)npc.field_70131_O - (double)(0.06f * scale), d2, 64, s, Float.valueOf(1.0f));
                height = 1;
            }
        }
    }

    public void func_76979_b(Entity par1Entity, double par2, double par4, double par6, float par8, float par9) {
        EntityNPCInterface npc = (EntityNPCInterface)par1Entity;
        if (!npc.isKilled() && !npc.scriptInvisibleToPlayer((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            super.func_76979_b(par1Entity, par2, par4, par6, par8, par9);
        }
    }

    protected void renderLivingLabel(EntityNPCInterface npc, double d, double d1, double d2, int i, Object ... obs) {
        FontRenderer fontrenderer = this.func_76983_a();
        i = npc.func_70070_b(0.0f);
        int j = i % 65536;
        int k = i / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)j / 1.0f), (float)((float)k / 1.0f));
        float f1 = npc.baseHeight / 5.0f * (float)npc.display.modelSize;
        float f2 = 0.01666667f * f1;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)d + 0.0f), (float)((float)d1), (float)((float)d2));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)this.field_76990_c.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        Tessellator tessellator = Tessellator.field_78398_a;
        float height = f1 / 6.5f;
        for (j = 0; j < obs.length; j += 2) {
            float scale = ((Float)obs[j + 1]).floatValue();
            height += f1 / 6.5f * scale;
            GL11.glPushMatrix();
            GL11.glDisable((int)2896);
            GL11.glDepthMask((boolean)false);
            GL11.glDisable((int)3008);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)3553);
            String s = obs[j].toString();
            GL11.glTranslatef((float)0.0f, (float)height, (float)0.0f);
            GL11.glScalef((float)(-f2 * scale), (float)(-f2 * scale), (float)(f2 * scale));
            tessellator.func_78382_b();
            int size = fontrenderer.func_78256_a(s) / 2;
            tessellator.func_78369_a(0.0f, 0.0f, 0.0f, 0.25f);
            tessellator.func_78377_a((double)(-size - 1), -1.0, 0.0);
            tessellator.func_78377_a((double)(-size - 1), 8.0, 0.0);
            tessellator.func_78377_a((double)(size + 1), 8.0, 0.0);
            tessellator.func_78377_a((double)(size + 1), -1.0, 0.0);
            tessellator.func_78381_a();
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2929);
            GL11.glDepthMask((boolean)true);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int color = npc.faction.color;
            fontrenderer.func_78276_b(s, -fontrenderer.func_78256_a(s) / 2, 0, color);
            GL11.glPopMatrix();
        }
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    protected void renderPlayerScale(EntityNPCInterface npc, float f) {
        GL11.glScalef((float)(npc.scaleX / 5.0f * (float)npc.display.modelSize), (float)(npc.scaleY / 5.0f * (float)npc.display.modelSize), (float)(npc.scaleZ / 5.0f * (float)npc.display.modelSize));
    }

    protected void renderPlayerSleep(EntityNPCInterface npc, double d, double d1, double d2) {
        this.field_76989_e = (float)npc.display.modelSize / 10.0f;
        float xOffset = 0.0f;
        float yOffset = npc.currentAnimation == EnumAnimation.NONE ? npc.ai.bodyOffsetY / 10.0f - 0.5f : 0.0f;
        float zOffset = 0.0f;
        if (npc.func_70089_S()) {
            if (npc.func_70608_bn()) {
                xOffset = (float)(-Math.cos(Math.toRadians(180 - npc.ai.orientation)));
                zOffset = (float)(-Math.sin(Math.toRadians(npc.ai.orientation)));
                yOffset += 0.14f;
            } else if (npc.func_70115_ae()) {
                yOffset -= 0.5f - ((EntityCustomNpc)npc).modelData.getLegsY() * 0.8f;
            }
        }
        this.renderLiving(npc, d, d1, d2, xOffset, yOffset, zOffset);
    }

    private void renderLiving(EntityNPCInterface npc, double d, double d1, double d2, float xoffset, float yoffset, float zoffset) {
        xoffset = xoffset / 5.0f * (float)npc.display.modelSize;
        yoffset = yoffset / 5.0f * (float)npc.display.modelSize;
        zoffset = zoffset / 5.0f * (float)npc.display.modelSize;
        super.func_77039_a((EntityLivingBase)npc, d + (double)xoffset, d1 + (double)yoffset, d2 + (double)zoffset);
    }

    protected void func_77043_a(EntityLivingBase entity, float f, float f1, float f2) {
        EntityNPCInterface npc = (EntityNPCInterface)entity;
        if (npc.func_70089_S() && npc.func_70608_bn()) {
            GL11.glRotatef((float)npc.ai.orientation, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)this.func_77037_a((EntityLivingBase)npc), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (npc.func_70089_S() && npc.currentAnimation == EnumAnimation.CRAWLING) {
            GL11.glRotatef((float)(270.0f - f1), (float)0.0f, (float)1.0f, (float)0.0f);
            float scale = (float)((EntityCustomNpc)npc).display.modelSize / 5.0f;
            GL11.glTranslated((double)(-scale + ((EntityCustomNpc)npc).modelData.getLegsY() * scale), (double)0.14f, (double)0.0);
            GL11.glRotatef((float)270.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            super.func_77043_a((EntityLivingBase)npc, f, f1, f2);
        }
    }

    protected void func_77033_b(EntityLivingBase par1EntityLivingBase, double par2, double par4, double par6) {
        this.renderName((EntityNPCInterface)par1EntityLivingBase, par2, par4, par6);
    }

    protected void func_77041_b(EntityLivingBase entityliving, float f) {
        this.renderPlayerScale((EntityNPCInterface)entityliving, f);
    }

    public void func_76986_a(EntityLiving entityliving, double d, double d1, double d2, float f, float f1) {
        EntityNPCInterface npc = (EntityNPCInterface)entityliving;
        if (npc.isKilled() && npc.stats.hideKilledBody && npc.field_70725_aQ > 20) {
            return;
        }
        if ((npc.display.showBossBar == 1 || npc.display.showBossBar == 2 && npc.isAttacking()) && !npc.isKilled() && npc.field_70725_aQ <= 20 && npc.canSee((Entity)Minecraft.func_71410_x().field_71439_g)) {
            BossStatus.func_82824_a((IBossDisplayData)npc, (boolean)true);
        }
        if (npc.ai.standingType == EnumStandingType.HeadRotation && !npc.isWalking() && !npc.isInteracting()) {
            npc.field_70760_ar = npc.field_70761_aq = (float)npc.ai.orientation;
        }
        super.func_76986_a(entityliving, d, d1, d2, f, f1);
    }

    protected void func_77036_a(EntityLivingBase entityliving, float par2, float par3, float par4, float par5, float par6, float par7) {
        super.func_77036_a(entityliving, par2, par3, par4, par5, par6, par7);
        EntityNPCInterface npc = (EntityNPCInterface)entityliving;
        if (!npc.display.skinOverlayData.overlayList.isEmpty()) {
            for (ISkinOverlay overlayData : npc.display.skinOverlayData.overlayList.values()) {
                try {
                    if (overlayData.getTexture().isEmpty()) continue;
                    if (((SkinOverlay)overlayData).getLocation() == null) {
                        ((SkinOverlay)overlayData).setLocation(new ResourceLocation(overlayData.getTexture()));
                    } else {
                        String str = ((SkinOverlay)npc.display.skinOverlayData.overlayList.get(0)).getLocation().func_110624_b() + ":" + ((SkinOverlay)npc.display.skinOverlayData.overlayList.get(0)).getLocation().func_110623_a();
                        if (!str.equals(overlayData.getTexture())) {
                            ((SkinOverlay)overlayData).setLocation(new ResourceLocation(overlayData.getTexture()));
                        }
                    }
                    if (((SkinOverlay)overlayData).getLocation().func_110623_a().isEmpty()) continue;
                    try {
                        this.func_110776_a(((SkinOverlay)overlayData).getLocation());
                    }
                    catch (Exception e) {
                        continue;
                    }
                    GL11.glEnable((int)3042);
                    if (overlayData.getBlend()) {
                        GL11.glBlendFunc((int)1, (int)1);
                    } else {
                        GL11.glBlendFunc((int)770, (int)771);
                    }
                    GL11.glAlphaFunc((int)516, (float)0.003921569f);
                    if (overlayData.getGlow()) {
                        GL11.glDisable((int)2896);
                        Minecraft.func_71410_x().field_71460_t.func_78483_a(0.0);
                    }
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)overlayData.getAlpha());
                    GL11.glDepthMask((!npc.func_82150_aj() ? 1 : 0) != 0);
                    GL11.glPushMatrix();
                    GL11.glMatrixMode((int)5890);
                    GL11.glLoadIdentity();
                    GL11.glTranslatef((float)((float)npc.display.overlayRenderTicks * 0.001f * overlayData.getSpeedX()), (float)((float)npc.display.overlayRenderTicks * 0.001f * overlayData.getSpeedY()), (float)0.0f);
                    GL11.glScalef((float)overlayData.getTextureScaleX(), (float)overlayData.getTextureScaleY(), (float)1.0f);
                    GL11.glMatrixMode((int)5888);
                    float scale = 1.005f * overlayData.getSize();
                    GL11.glTranslatef((float)overlayData.getOffsetX(), (float)overlayData.getOffsetY(), (float)overlayData.getOffsetZ());
                    GL11.glScalef((float)scale, (float)scale, (float)scale);
                    if (this.field_77045_g instanceof ModelMPM) {
                        ((ModelMPM)this.field_77045_g).isArmor = true;
                        this.field_77045_g.func_78088_a((Entity)entityliving, par2, par3, par4, par5, par6, par7);
                        ((ModelMPM)this.field_77045_g).isArmor = false;
                    } else {
                        this.field_77045_g.func_78088_a((Entity)entityliving, par2, par3, par4, par5, par6, par7);
                    }
                    GL11.glPopMatrix();
                    GL11.glMatrixMode((int)5890);
                    GL11.glLoadIdentity();
                    GL11.glMatrixMode((int)5888);
                    GL11.glEnable((int)2896);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glDepthFunc((int)515);
                    GL11.glDisable((int)3042);
                    GL11.glAlphaFunc((int)516, (float)0.1f);
                    Minecraft.func_71410_x().field_71460_t.func_78463_b(0.0);
                }
                catch (Exception exception) {}
            }
            ++npc.display.overlayRenderTicks;
        }
    }

    protected float func_77044_a(EntityLivingBase par1EntityLiving, float par2) {
        EntityNPCInterface npc = (EntityNPCInterface)par1EntityLiving;
        if (npc.isKilled() || npc.display.disableLivingAnimation) {
            return 0.0f;
        }
        return super.func_77044_a(par1EntityLiving, par2);
    }

    protected void func_77039_a(EntityLivingBase entityliving, double d, double d1, double d2) {
        this.renderPlayerSleep((EntityNPCInterface)entityliving, d, d1, d2);
    }

    public ResourceLocation func_110775_a(Entity entity) {
        EntityNPCInterface npc = (EntityNPCInterface)entity;
        if (npc.textureLocation == null) {
            if (npc.display.skinType == 0) {
                if (npc instanceof EntityCustomNpc && ((EntityCustomNpc)npc).modelData.entityClass == null) {
                    if (!npc.display.texture.equals("")) {
                        try {
                            npc.textureLocation = this.adjustLocalTexture(npc, new ResourceLocation(npc.display.texture));
                        }
                        catch (IOException iOException) {}
                    }
                } else {
                    npc.textureLocation = new ResourceLocation(npc.display.texture);
                }
            } else {
                if (LastTextureTick < 5L) {
                    return AbstractClientPlayer.field_110314_b;
                }
                if (npc.display.skinType == 1 && npc.display.playerProfile != null) {
                    Minecraft minecraft = Minecraft.func_71410_x();
                    Map map = minecraft.func_152342_ad().func_152788_a(npc.display.playerProfile);
                    if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                        npc.textureLocation = minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
                    }
                    LastTextureTick = 0L;
                } else if (npc.display.skinType == 2 || npc.display.skinType == 3) {
                    try {
                        MessageDigest digest = MessageDigest.getInstance("MD5");
                        byte[] hash = digest.digest(npc.display.url.getBytes("UTF-8"));
                        StringBuilder sb = new StringBuilder(2 * hash.length);
                        for (byte b : hash) {
                            sb.append(String.format("%02x", b & 0xFF));
                        }
                        if (npc.display.skinType == 2) {
                            npc.textureLocation = new ResourceLocation("skins/" + sb.toString());
                            this.loadSkin(null, npc.textureLocation, npc.display.url, false);
                        } else {
                            npc.textureLocation = new ResourceLocation("skins64/" + sb.toString());
                            this.loadSkin(null, npc.textureLocation, npc.display.url, true);
                        }
                        LastTextureTick = 0L;
                    }
                    catch (Exception exception) {}
                } else {
                    return AbstractClientPlayer.field_110314_b;
                }
            }
        }
        return npc.textureLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceLocation adjustLocalTexture(EntityNPCInterface npc, ResourceLocation location) throws IOException {
        try (InputStream inputstream = null;){
            TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
            texturemanager.func_147645_c(location);
            IResource iresource = Minecraft.func_71410_x().func_110442_L().func_110536_a(location);
            inputstream = iresource.func_110527_b();
            BufferedImage bufferedimage = ImageIO.read(inputstream);
            int totalWidth = bufferedimage.getWidth();
            int totalHeight = bufferedimage.getHeight();
            if (totalHeight > 32 && npc.display.modelType == 0) {
                bufferedimage = bufferedimage.getSubimage(0, 0, totalWidth, 32);
            }
            ImageDownloadAlt object = new ImageDownloadAlt(null, npc.display.texture, SkinManager.field_152793_a, (IImageBuffer)new ImageBufferDownloadAlt(false));
            object.setBufferedImage(bufferedimage);
            try {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                byte[] hash = digest.digest(npc.display.texture.getBytes("UTF-8"));
                StringBuilder sb = new StringBuilder(2 * hash.length);
                for (byte b : hash) {
                    sb.append(String.format("%02x", b & 0xFF));
                }
                location = totalHeight > 32 && npc.display.modelType == 0 ? new ResourceLocation("skin/" + sb.toString()) : new ResourceLocation("skin64/" + sb.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            texturemanager.func_110579_a(location, (ITextureObject)object);
            ResourceLocation resourceLocation = location;
            return resourceLocation;
        }
    }

    private void loadSkin(File file, ResourceLocation resource, String par1Str, boolean version) {
        TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
        ImageDownloadAlt object = new ImageDownloadAlt(file, par1Str, SkinManager.field_152793_a, (IImageBuffer)new ImageBufferDownloadAlt(version));
        texturemanager.func_110579_a(resource, (ITextureObject)object);
    }
}

