/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.sync;

import com.flansmod.common.FlansMod;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.binary.Hex;

public class Sync {
    private static TreeMap<String, String> hashes = new TreeMap();
    private static String cachedHash = "";

    public static String getStringHash(String str) {
        String hash = "";
        try {
            MessageDigest digester = MessageDigest.getInstance("SHA-512");
            byte[] encodedHash = digester.digest(Sync.validateString(str).getBytes(StandardCharsets.US_ASCII));
            hash = Hex.encodeHexString((byte[])encodedHash);
        }
        catch (Exception e) {
            FlansMod.log("[Sync] Error has occured.");
            e.printStackTrace();
        }
        return hash;
    }

    public static String getUnifiedHash() {
        if (cachedHash.isEmpty()) {
            StringBuilder str = new StringBuilder();
            for (Map.Entry<String, String> hash : hashes.entrySet()) {
                str.append(hash.getKey());
                FlansMod.log(hash.getKey() + " " + hash.getValue());
            }
            cachedHash = Sync.getStringHash(str.toString());
        }
        return cachedHash;
    }

    public static void addHash(String str, String shortname) {
        hashes.put(Sync.getStringHash(str), shortname);
    }

    private static String validateString(String e) {
        StringBuilder out = new StringBuilder();
        for (char c : e.toCharArray()) {
            if (!"ABCDEFGHIJKLMNOPQRSTUVWXYZ+=-()[]{}#%^&$\u00a3@?.,<>0123456789".contains("" + Character.toUpperCase(c))) continue;
            out.append(c);
        }
        return out.toString();
    }
}

