/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.driveables;

import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.CollisionBox;
import com.flansmod.common.driveables.DriveableData;
import com.flansmod.common.driveables.EntityVehicle;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.driveables.VehicleType;
import com.flansmod.common.paintjob.IPaintableItem;
import com.flansmod.common.paintjob.PaintableType;
import com.flansmod.common.paintjob.Paintjob;
import com.flansmod.common.parts.PartType;
import com.flansmod.common.teams.TeamsManager;
import com.flansmod.common.types.EnumType;
import com.flansmod.common.types.InfoType;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockSponge;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMapBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class ItemVehicle
extends ItemMapBase
implements IPaintableItem {
    public VehicleType type;
    public IIcon[] icons;

    public ItemVehicle(VehicleType type1) {
        this.field_77777_bU = 1;
        this.type = type1;
        this.type.item = this;
        this.func_77637_a(FlansMod.tabFlanDriveables);
        GameRegistry.registerItem((Item)this, (String)this.type.shortName, (String)"flansmod");
    }

    public boolean func_77651_p() {
        return true;
    }

    private NBTTagCompound getTagCompound(ItemStack stack, World world) {
        if (stack.field_77990_d == null) {
            if (!world.field_72995_K) {
                stack.field_77990_d = this.getOldTagCompound(stack, world);
            }
            if (stack.field_77990_d == null) {
                stack.field_77990_d = new NBTTagCompound();
                stack.field_77990_d.func_74778_a("Type", this.type.shortName);
                stack.field_77990_d.func_74778_a("Engine", PartType.defaultEngines.get((Object)((Object)EnumType.vehicle)).shortName);
            }
        }
        return stack.field_77990_d;
    }

    private NBTTagCompound getOldTagCompound(ItemStack stack, World world) {
        try {
            File file1 = world.func_72860_G().func_75758_b("vehicle_" + stack.func_77960_j());
            FileInputStream fileinputstream = new FileInputStream(file1);
            NBTTagCompound tags = CompressedStreamTools.func_74796_a((InputStream)fileinputstream).func_74775_l("data");
            for (EnumDriveablePart part : EnumDriveablePart.values()) {
                tags.func_74776_a(part.getShortName() + "_Health", this.type.health.get((Object)part) == null ? 0.0f : ((CollisionBox)this.type.health.get((Object)((Object)part))).health);
                tags.func_74757_a(part.getShortName() + "_Fire", false);
            }
            fileinputstream.close();
            return tags;
        }
        catch (IOException e) {
            FlansMod.log("Failed to read old vehicle file");
            e.printStackTrace();
            return null;
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List lines, boolean advancedTooltips) {
        String paintName = this.type.getPaintjob((int)stack.func_77960_j()).displayName;
        if (!paintName.equals("default") && !paintName.isEmpty()) {
            lines.add("\u00a7b\u00a7o" + paintName);
        }
        if (!this.type.packName.isEmpty() && FlansMod.showPackNameInItemDescriptions) {
            lines.add("\u00a7o" + this.type.packName);
        }
        if (this.type.description != null) {
            Collections.addAll(lines, this.type.description.split("_"));
        }
        lines.add("");
        NBTTagCompound tags = this.getTagCompound(stack, player.field_70170_p);
        PartType engine = PartType.getPart(tags.func_74779_i("Engine"));
        if (engine != null) {
            lines.add("\u00a79Engine\u00a77: " + engine.name);
        }
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        Vec3 lookVec;
        if (!TeamsManager.survivalCanPlaceVehicles && !entityplayer.field_71075_bZ.field_75098_d) {
            return itemstack;
        }
        float cosYaw = MathHelper.func_76134_b((float)(-entityplayer.field_70177_z * 0.01745329f - 3.141593f));
        float sinYaw = MathHelper.func_76126_a((float)(-entityplayer.field_70177_z * 0.01745329f - 3.141593f));
        float cosPitch = -MathHelper.func_76134_b((float)(-entityplayer.field_70125_A * 0.01745329f));
        float sinPitch = MathHelper.func_76126_a((float)(-entityplayer.field_70125_A * 0.01745329f));
        double length = 5.0;
        Vec3 posVec = Vec3.func_72443_a((double)entityplayer.field_70165_t, (double)(entityplayer.field_70163_u + 1.62 - (double)entityplayer.field_70129_M), (double)entityplayer.field_70161_v);
        MovingObjectPosition movingobjectposition = world.func_72901_a(posVec, lookVec = posVec.func_72441_c((double)(sinYaw * cosPitch) * length, (double)sinPitch * length, (double)(cosYaw * cosPitch) * length), this.type.placeableOnWater);
        if (movingobjectposition == null) {
            return itemstack;
        }
        if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int i = movingobjectposition.field_72311_b;
            int j = movingobjectposition.field_72312_c;
            int k = movingobjectposition.field_72309_d;
            Block block = world.func_147439_a(i, j, k);
            if (this.type.placeableOnLand || block instanceof BlockLiquid || this.type.placeableOnSponge && block instanceof BlockSponge) {
                if (!world.field_72995_K) {
                    EntityVehicle e = new EntityVehicle(world, (double)i + 0.5, (double)j + 2.5, (double)k + 0.5, entityplayer, this.type, this.getData(itemstack, world));
                    world.func_72838_d((Entity)e);
                    if (!world.field_72995_K) {
                        FlansMod.log("Player %s placed vehicle %s (%d) at (%d, %d, %d)", entityplayer.getDisplayName(), this.type.shortName, e.func_145782_y(), i, j, k);
                    }
                }
                if (!entityplayer.field_71075_bZ.field_75098_d) {
                    --itemstack.field_77994_a;
                }
            }
        }
        return itemstack;
    }

    public Entity spawnVehicle(World world, double x, double y, double z, ItemStack stack) {
        EntityVehicle entity = new EntityVehicle(world, x, y, z, this.type, this.getData(stack, world));
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)entity);
        }
        return entity;
    }

    public DriveableData getData(ItemStack itemstack, World world) {
        return new DriveableData(this.getTagCompound(itemstack, world), itemstack.func_77960_j());
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack par1ItemStack, int par2) {
        return this.type.colour;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister icon) {
        this.icons = new IIcon[this.type.paintjobs.size()];
        this.field_77791_bV = icon.func_94245_a("FlansMod:" + this.type.iconPath);
        for (int i = 0; i < this.type.paintjobs.size(); ++i) {
            this.icons[i] = icon.func_94245_a("FlansMod:" + ((Paintjob)this.type.paintjobs.get((int)i)).iconName);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        try {
            if (stack.func_77960_j() < this.icons.length) {
                return this.icons[stack.func_77960_j()];
            }
            return this.icons[0];
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        ItemStack planeStack = new ItemStack(item, 1, 0);
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74778_a("Type", this.type.shortName);
        if (PartType.defaultEngines.containsKey((Object)EnumType.vehicle)) {
            tags.func_74778_a("Engine", PartType.defaultEngines.get((Object)((Object)EnumType.vehicle)).shortName);
        }
        for (EnumDriveablePart part : EnumDriveablePart.values()) {
            tags.func_74776_a(part.getShortName() + "_Health", this.type.health.get((Object)part) == null ? 0.0f : ((CollisionBox)this.type.health.get((Object)((Object)part))).health);
            tags.func_74757_a(part.getShortName() + "_Fire", false);
        }
        planeStack.field_77990_d = tags;
        list.add(planeStack);
    }

    @Override
    public InfoType getInfoType() {
        return this.type;
    }

    @Override
    public PaintableType GetPaintableType() {
        return this.type;
    }
}

