/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.model;

import com.flansmod.client.FlansModClient;
import com.flansmod.common.vector.Vector3f;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public class GunAnimations {
    public static GunAnimations defaults = new GunAnimations();
    public boolean isGunEmpty;
    public float gunRecoil = 0.0f;
    public float lastGunRecoil = 0.0f;
    public float recoilAmount = 0.33f;
    public float gunSlide = 0.0f;
    public float lastGunSlide = 0.0f;
    public int timeUntilPump = 0;
    public int timeToPumpFor = 0;
    public float pumped = -1.0f;
    public float lastPumped = -1.0f;
    public boolean pumping = false;
    public int timeUntilCharge = 0;
    public int timeToChargeFor = 0;
    public float charged = -1.0f;
    public float lastCharged = -1.0f;
    public boolean charging = false;
    public boolean reloading = false;
    public float reloadAnimationTime = 0.0f;
    public float reloadAnimationProgress = 0.0f;
    public float lastReloadAnimationProgress = 0.0f;
    public int reloadAmmoCount = 1;
    public boolean singlesReload = false;
    public float minigunBarrelRotation = 0.0f;
    public float minigunBarrelRotationSpeed = 0.0f;
    public int muzzleFlashTime = 0;
    public int flashInt = 0;
    public int timeUntilCasing = 0;
    public int casingStage = 0;
    public int lastCasingStage = 0;
    public float hammerRotation = 0.0f;
    public float althammerRotation = 0.0f;
    public int timeUntilPullback = 0;
    public float gunPullback = -1.0f;
    public float lastGunPullback = -1.0f;
    public boolean isFired = false;
    public Vector3f casingRandom = new Vector3f(0.0f, 0.0f, 0.0f);
    public int meleeAnimationProgress = 0;
    public int meleeAnimationLength = 0;
    public float switchAnimationProgress = 0.0f;
    public float switchAnimationLength = 0.0f;
    public static int lastInventorySlot = -1;
    public float runningStanceAnimationProgress = 0.0f;
    public float runningStanceAnimationLength = 4.0f;
    public Vector3f sprintingStance;
    public int stanceTimer = 0;

    public static float randomSeededFloat(float min, float max, long seed) {
        Random random = new Random(seed);
        return random.nextFloat() * (max - min) + min;
    }

    public void updateSprintStance(String shortName) {
        long seed = GunAnimations.getSeedFromString(shortName);
        this.sprintingStance = new Vector3f(GunAnimations.randomSeededFloat(-15.0f, -5.0f, seed), GunAnimations.randomSeededFloat(0.0f, 45.0f, seed), GunAnimations.randomSeededFloat(-20.0f, 10.0f, seed));
    }

    public void update() {
        this.lastPumped = this.pumped;
        this.lastCharged = this.charged;
        this.lastGunPullback = this.gunPullback;
        this.lastCasingStage = this.casingStage;
        if (this.timeUntilPump > 0) {
            --this.timeUntilPump;
            if (this.timeUntilPump == 0) {
                this.pumping = true;
                this.pumped = -1.0f;
                this.lastPumped = -1.0f;
                FlansModClient.shotState = 1;
            }
        }
        if (this.timeUntilCharge > 0) {
            --this.timeUntilCharge;
            if (this.timeUntilCharge == 0) {
                this.charging = true;
                this.charged = -1.0f;
                this.lastCharged = -1.0f;
            }
        }
        if (this.timeUntilPullback > 0) {
            --this.timeUntilPullback;
            if (this.timeUntilPullback == 0) {
                this.isFired = true;
                this.gunPullback = -1.0f;
                this.lastGunPullback = -1.0f;
            }
        } else {
            this.hammerRotation *= 0.6f;
            this.althammerRotation *= 0.6f;
        }
        if (this.timeUntilCasing > 0) {
            --this.timeUntilCasing;
            if (this.timeUntilCasing == 0) {
                ++this.casingStage;
            }
        } else {
            ++this.casingStage;
        }
        if (this.muzzleFlashTime > 0) {
            --this.muzzleFlashTime;
        }
        if (this.pumping) {
            this.pumped += 2.0f / (float)this.timeToPumpFor;
            if (this.pumped >= 0.999f) {
                this.pumping = false;
            }
        }
        if (this.charging) {
            this.charged += 2.0f / (float)this.timeToChargeFor;
            if (this.charged >= 0.999f) {
                this.charging = false;
            }
        }
        if (this.isFired) {
            this.gunPullback += 0.5f;
            if (this.gunPullback >= 0.999f) {
                this.isFired = false;
            }
        }
        this.lastGunRecoil = this.gunRecoil;
        if (this.gunRecoil > 0.0f) {
            this.gunRecoil *= 0.7f;
        }
        this.lastGunSlide = this.gunSlide;
        if (this.isGunEmpty) {
            this.gunSlide = 0.5f;
            this.lastGunSlide = 0.5f;
        }
        if (!this.isGunEmpty && (double)this.gunSlide > 0.9) {
            this.gunSlide -= 0.1f;
        } else if (this.gunSlide > 0.0f && !this.isGunEmpty) {
            this.gunSlide *= 0.5f;
        }
        this.lastReloadAnimationProgress = this.reloadAnimationProgress;
        if (this.reloading) {
            this.reloadAnimationProgress += 1.0f / this.reloadAnimationTime;
        }
        if (this.reloading && this.reloadAnimationProgress >= 0.9f) {
            this.isGunEmpty = false;
        }
        if (this.reloading && this.reloadAnimationProgress >= 1.0f) {
            this.reloading = false;
        }
        this.minigunBarrelRotation += this.minigunBarrelRotationSpeed;
        this.minigunBarrelRotationSpeed *= 0.9f;
        if (this.meleeAnimationLength > 0) {
            ++this.meleeAnimationProgress;
            if (this.meleeAnimationProgress > this.meleeAnimationLength) {
                this.meleeAnimationLength = 0;
                this.meleeAnimationProgress = 0;
            }
        }
        if (this.switchAnimationProgress > 0.0f) {
            this.switchAnimationProgress += 1.0f;
            if (this.switchAnimationProgress == this.switchAnimationLength) {
                this.switchAnimationLength = 0.0f;
                this.switchAnimationLength = 0.0f;
            }
        }
        if (this.runningStanceAnimationProgress > 0.0f && this.runningStanceAnimationProgress < this.runningStanceAnimationLength) {
            this.runningStanceAnimationProgress += 1.0f;
        }
        if (this.stanceTimer > 0) {
            --this.stanceTimer;
        }
    }

    public void onGunEmpty(boolean atLastBullet) {
        this.isGunEmpty = atLastBullet;
    }

    public void doShoot(int pumpDelay, int pumpTime, int hammerDelay, float hammerAngle, float althammerAngle, int casingDelay) {
        Random r = new Random();
        this.lastGunRecoil = this.gunRecoil += this.recoilAmount;
        this.minigunBarrelRotationSpeed += 2.0f;
        this.gunSlide = 1.0f;
        this.lastGunSlide = 1.0f;
        this.timeUntilPump = pumpDelay;
        this.timeToPumpFor = pumpTime;
        this.timeUntilPullback = hammerDelay;
        this.timeUntilCasing = casingDelay;
        this.hammerRotation = hammerAngle;
        this.althammerRotation = althammerAngle;
        this.muzzleFlashTime = 2;
        this.stanceTimer = 20;
        int High = 3;
        int Low = -1;
        int result = r.nextInt(High - Low) + Low;
        if (result == -1) {
            result = 0;
        }
        if (result == 3) {
            result = 2;
        }
        this.flashInt = result;
        this.casingRandom.x = r.nextFloat() * 2.0f - 1.0f;
        this.casingRandom.y = r.nextFloat() * 2.0f - 1.0f;
        this.casingRandom.z = r.nextFloat() * 2.0f - 1.0f;
        this.casingStage = 0;
        if (pumpDelay == 0) {
            FlansModClient.shotState = 1;
        }
    }

    public void doReload(int reloadTime, int pumpDelay, int pumpTime, int chargeDelay, int chargeTime, int ammoCount, boolean single) {
        this.reloading = true;
        this.reloadAnimationProgress = 0.0f;
        this.lastReloadAnimationProgress = 0.0f;
        this.reloadAnimationTime = reloadTime;
        this.timeUntilPump = pumpDelay;
        this.timeToPumpFor = pumpTime;
        this.timeUntilCharge = chargeDelay;
        this.timeToChargeFor = chargeTime;
        this.reloadAmmoCount = ammoCount;
        this.singlesReload = single;
        FlansModClient.lastBulletReload = ammoCount - 1;
    }

    public void doMelee(int meleeTime) {
        this.meleeAnimationLength = meleeTime;
    }

    private static long getSeedFromString(String str) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            byte[] digest = messageDigest.digest(str.getBytes());
            long seed = 0L;
            for (int i = 0; i < 8; ++i) {
                seed = seed << 8 | (long)(digest[i] & 0xFF);
            }
            return seed;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-1 not supported", e);
        }
    }
}

