/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.gui;

import com.flansmod.client.FlansModResourceHandler;
import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.driveables.mechas.MechaType;
import com.flansmod.common.parts.ItemPart;
import com.flansmod.common.parts.PartType;
import com.flansmod.common.types.EnumType;
import cpw.mods.fml.client.FMLClientHandler;
import java.util.Collections;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiDriveableCrafting
extends GuiScreen {
    private static final ResourceLocation texture = new ResourceLocation("flansmod", "gui/driveableCrafting.png");
    private final InventoryPlayer inventory;
    private final Minecraft mc;
    private final World world;
    private final int x;
    private final int y;
    private final int z;
    private static final RenderItem itemRenderer = new RenderItem();
    private int guiOriginX;
    private int guiOriginY;
    private static int blueprintsScroll = 0;
    private int recipeScroll = 0;
    private static int selectedBlueprint = 0;
    private float spinner = 0.0f;
    private boolean canCraft = false;
    DriveableType selectedType;
    String recipeTooltip;

    public GuiDriveableCrafting(InventoryPlayer inventoryPlayer, World w, int i, int j, int k) {
        this.inventory = inventoryPlayer;
        this.mc = FMLClientHandler.instance().getClient();
        this.world = w;
        this.x = i;
        this.y = j;
        this.z = k;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 + 22, this.field_146295_m / 2 + 63, 40, 20, "Craft"));
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0 && DriveableType.types.size() > 0) {
            FlansMod.proxy.craftDriveable(this.inventory.field_70458_d, DriveableType.types.get(selectedBlueprint));
        }
    }

    public void func_73863_a(int i, int j, float f) {
        ScaledResolution scaledresolution = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
        int w = scaledresolution.func_78326_a();
        int h = scaledresolution.func_78328_b();
        this.func_146276_q_();
        GL11.glEnable((int)3042);
        this.mc.field_71446_o.func_110577_a(texture);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.guiOriginX = w / 2 - 88;
        this.guiOriginY = h / 2 - 99;
        this.func_73729_b(this.guiOriginX, this.guiOriginY, 0, 0, 176, 198);
        this.func_73731_b(this.field_146289_q, "Vehicle Crafting", this.guiOriginX + 6, this.guiOriginY + 6, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, "Requires", this.guiOriginX + 6, this.guiOriginY + 125, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, "Engine", this.guiOriginX + 114, this.guiOriginY + 141, 0xFFFFFF);
        for (int m = 0; m < 2; ++m) {
            for (int n = 0; n < 8; ++n) {
                int blueprintNumber = blueprintsScroll * 8 + 8 * m + n;
                if (blueprintNumber == selectedBlueprint) {
                    this.mc.field_71446_o.func_110577_a(texture);
                    this.func_73729_b(this.guiOriginX + 8 + n * 18, this.guiOriginY + 18 + m * 18, 213, 11, 16, 16);
                }
                if (blueprintNumber >= DriveableType.types.size()) continue;
                DriveableType type = DriveableType.types.get(blueprintNumber);
                this.drawSlotInventory(new ItemStack(type.item), this.guiOriginX + 8 + n * 18, this.guiOriginY + 18 + m * 18);
            }
        }
        this.spinner += 1.0f;
        if (selectedBlueprint >= DriveableType.types.size()) {
            return;
        }
        this.canCraft = true;
        this.selectedType = DriveableType.types.get(selectedBlueprint);
        if (this.selectedType != null) {
            String recipeName;
            GL11.glPushMatrix();
            GL11.glEnable((int)2929);
            GL11.glEnable((int)3008);
            GL11.glTranslatef((float)(w / 2 - 46), (float)(h / 2 - 10), (float)100.0f);
            if (this.selectedType instanceof MechaType) {
                GL11.glTranslatef((float)0.0f, (float)15.0f, (float)0.0f);
            }
            GL11.glScalef((float)(-50.0f * this.selectedType.modelScale / this.selectedType.cameraDistance), (float)(50.0f * this.selectedType.modelScale / this.selectedType.cameraDistance), (float)(50.0f * this.selectedType.modelScale / this.selectedType.cameraDistance));
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(this.spinner / 5.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            this.mc.field_71446_o.func_110577_a(FlansModResourceHandler.getTexture(this.selectedType));
            if (this.selectedType.model != null) {
                this.selectedType.model.render(this.selectedType);
            }
            GL11.glDisable((int)2929);
            GL11.glDisable((int)3008);
            GL11.glPopMatrix();
            if (this.selectedType.model == null) {
                this.func_73731_b(this.field_146289_q, "Model not found.", this.guiOriginX + 12, this.guiOriginY + 84, 0xFFFFFF);
            }
            if ((recipeName = this.selectedType.name).length() > 16) {
                recipeName = recipeName.substring(0, 15) + "...";
            }
            this.func_73731_b(this.field_146289_q, recipeName, this.guiOriginX + 82, this.guiOriginY + 64, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, "Cargo Slots : " + this.selectedType.numCargoSlots, this.guiOriginX + 82, this.guiOriginY + 74, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, "Bomb Slots : " + this.selectedType.numBombSlots, this.guiOriginX + 82, this.guiOriginY + 84, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, "Passengers : " + this.selectedType.numPassengers, this.guiOriginX + 82, this.guiOriginY + 94, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, "Guns : " + this.selectedType.ammoSlots(), this.guiOriginX + 82, this.guiOriginY + 104, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, this.selectedType.numEngines() + "x", this.guiOriginX + 100, this.guiOriginY + 141, 0xFFFFFF);
            InventoryPlayer temporaryInventory = new InventoryPlayer(null);
            temporaryInventory.func_70455_b(this.inventory);
            for (int r = 0; r < 3; ++r) {
                for (int c = 0; c < 4; ++c) {
                    int recipeItemNumber = this.recipeScroll * 4 + r * 4 + c;
                    if (recipeItemNumber >= this.selectedType.driveableRecipe.size()) continue;
                    ItemStack recipeStack = this.selectedType.driveableRecipe.get(recipeItemNumber);
                    int totalAmountFound = 0;
                    for (int n = 0; n < temporaryInventory.func_70302_i_(); ++n) {
                        ItemStack stackInSlot = temporaryInventory.func_70301_a(n);
                        if (stackInSlot == null || recipeStack == null || stackInSlot.func_77973_b() != recipeStack.func_77973_b() || stackInSlot.func_77960_j() != recipeStack.func_77960_j()) continue;
                        int amountFound = Math.min(stackInSlot.field_77994_a, recipeStack.field_77994_a - totalAmountFound);
                        stackInSlot.field_77994_a -= amountFound;
                        if (stackInSlot.field_77994_a <= 0) {
                            stackInSlot = null;
                        }
                        temporaryInventory.func_70299_a(n, stackInSlot);
                        if ((totalAmountFound += amountFound) == recipeStack.field_77994_a) break;
                    }
                    if (totalAmountFound < recipeStack.field_77994_a && !this.inventory.field_70458_d.field_71075_bZ.field_75098_d) {
                        this.mc.field_71446_o.func_110577_a(texture);
                        this.func_73729_b(this.guiOriginX + 8 + c * 18, this.guiOriginY + 138 + r * 18, 195, 11, 16, 16);
                        this.canCraft = false;
                    }
                    this.drawSlotInventory(recipeStack, this.guiOriginX + 8 + c * 18, this.guiOriginY + 138 + r * 18);
                }
            }
            HashMap<PartType, ItemStack> engines = new HashMap<PartType, ItemStack>();
            for (int n = 0; n < temporaryInventory.func_70302_i_(); ++n) {
                ItemStack stackInSlot = temporaryInventory.func_70301_a(n);
                if (stackInSlot == null || !(stackInSlot.func_77973_b() instanceof ItemPart)) continue;
                PartType partType = ((ItemPart)stackInSlot.func_77973_b()).type;
                if (partType.category != 2 || !partType.worksWith.contains((Object)EnumType.getFromObject(this.selectedType))) continue;
                if (engines.containsKey(partType)) {
                    ((ItemStack)engines.get((Object)partType)).field_77994_a += stackInSlot.field_77994_a;
                    continue;
                }
                engines.put(partType, stackInSlot);
            }
            float bestEngineSpeed = -1.0f;
            ItemStack bestEngineStack = null;
            for (PartType part : engines.keySet()) {
                if (!(part.engineSpeed > bestEngineSpeed) || ((ItemStack)engines.get((Object)part)).field_77994_a < this.selectedType.numEngines()) continue;
                bestEngineSpeed = part.engineSpeed;
                bestEngineStack = (ItemStack)engines.get(part);
            }
            this.mc.field_71446_o.func_110577_a(texture);
            if (bestEngineStack == null) {
                this.func_73729_b(this.guiOriginX + 152, this.guiOriginY + 138, 195, 11, 16, 16);
                this.canCraft = false;
            } else {
                this.drawSlotInventory(bestEngineStack, this.guiOriginX + 152, this.guiOriginY + 138);
            }
        }
        if (!this.canCraft) {
            this.mc.field_71446_o.func_110577_a(texture);
            this.func_73729_b(this.guiOriginX + 108, this.guiOriginY + 160, 176, 28, 44, 24);
            this.func_73731_b(this.field_146289_q, "Craft", this.guiOriginX + 116, this.guiOriginY + 168, 0xA0A0A0);
        } else {
            super.func_73863_a(i, j, f);
        }
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.mc.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.mc.field_71440_d - 1;
        if (this.recipeTooltip != null) {
            this.drawHoveringText(Collections.singletonList(this.recipeTooltip), mouseX, mouseY, this.field_146289_q);
        }
    }

    private void drawSlotInventory(ItemStack itemstack, int i, int j) {
        if (itemstack == null || itemstack.func_77973_b() == null) {
            return;
        }
        itemRenderer.func_77015_a(this.field_146289_q, this.mc.field_71446_o, itemstack, i, j);
        itemRenderer.func_77021_b(this.field_146289_q, this.mc.field_71446_o, itemstack, i, j);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
    }

    protected void func_73869_a(char c, int i) {
        if (i == 1 || i == this.mc.field_71474_y.field_151445_Q.func_151463_i()) {
            this.mc.field_71439_g.func_71053_j();
        }
    }

    protected void func_73864_a(int i, int j, int k) {
        super.func_73864_a(i, j, k);
        int x = i - this.guiOriginX;
        int y = j - this.guiOriginY;
        if (k == 0 || k == 1) {
            for (int m = 0; m < 2; ++m) {
                for (int n = 0; n < 8; ++n) {
                    if (x < 8 + n * 18 || x > 26 + n * 18 || y < 18 + 18 * m || y > 42 + 18 * m) continue;
                    selectedBlueprint = blueprintsScroll * 8 + m * 8 + n;
                }
            }
            if (x >= 157 && x <= 167 && y >= 21 && y <= 31 && blueprintsScroll > 0) {
                --blueprintsScroll;
            }
            if (x >= 157 && x <= 167 && y >= 39 && y <= 49 && blueprintsScroll * 8 + 16 < DriveableType.types.size()) {
                ++blueprintsScroll;
            }
            if (selectedBlueprint >= DriveableType.types.size()) {
                return;
            }
            if (x >= 83 && x <= 93 && y >= 141 && y <= 151 && this.recipeScroll > 0) {
                --this.recipeScroll;
            }
            if (x >= 83 && x <= 93 && y >= 177 && y <= 187) {
                this.selectedType = DriveableType.types.get(selectedBlueprint);
                if (this.selectedType != null && this.recipeScroll * 4 + 12 < this.selectedType.driveableRecipe.size()) {
                    ++this.recipeScroll;
                }
            }
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146274_d() {
        super.func_146274_d();
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.mc.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.mc.field_71440_d - 1;
        int recipeX = mouseX - 8 - this.guiOriginX;
        int recipeY = mouseY - 138 - this.guiOriginY;
        if (recipeX >= 0 && recipeY >= 0 && recipeX < 72 && recipeY < 51) {
            int idX = recipeX / 18;
            int idY = recipeY / 18;
            int id = recipeX % 18 >= 16 || recipeY % 18 >= 16 ? -1 : this.recipeScroll * 4 + idY * 4 + idX;
            if (id < this.selectedType.driveableRecipe.size() && id > -1) {
                ItemStack recipeStack = this.selectedType.driveableRecipe.get(id);
                this.recipeTooltip = recipeStack.func_82833_r();
            } else {
                this.recipeTooltip = null;
            }
        } else {
            this.recipeTooltip = null;
        }
    }
}

