/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class ConnectedParser {
    private String context = null;
    public static final VillagerProfession[] PROFESSIONS_INVALID = new VillagerProfession[0];

    public ConnectedParser(String context) {
        this.context = context;
    }

    public String parseName(String path) {
        int pos2;
        String str = path;
        int pos = str.lastIndexOf(47);
        if (pos >= 0) {
            str = str.substring(pos + 1);
        }
        if ((pos2 = str.lastIndexOf(46)) >= 0) {
            str = str.substring(0, pos2);
        }
        return str;
    }

    public String parseBasePath(String path) {
        int pos = path.lastIndexOf(47);
        if (pos < 0) {
            return "";
        }
        return path.substring(0, pos);
    }

    public MatchBlock[] parseMatchBlocks(String propMatchBlocks) {
        if (propMatchBlocks == null) {
            return null;
        }
        ArrayList<MatchBlock> list = new ArrayList<MatchBlock>();
        String[] blockStrs = Config.tokenize(propMatchBlocks, " ");
        for (int i = 0; i < blockStrs.length; ++i) {
            String blockStr = blockStrs[i];
            MatchBlock[] mbs = this.parseMatchBlock(blockStr);
            if (mbs == null) continue;
            list.addAll(Arrays.asList(mbs));
        }
        MatchBlock[] mbs = list.toArray(new MatchBlock[list.size()]);
        return mbs;
    }

    public MatchBlock[] parseMatchBlock(String blockStr) {
        if (blockStr == null) {
            return null;
        }
        if ((blockStr = blockStr.trim()).length() <= 0) {
            return null;
        }
        String[] parts = Config.tokenize(blockStr, ":");
        String domain = "minecraft";
        int blockIndex = 0;
        if (parts.length > 1 && this.isFullBlockName(parts)) {
            domain = parts[0];
            blockIndex = 1;
        } else {
            domain = "minecraft";
            blockIndex = 0;
        }
        String blockPart = parts[blockIndex];
        String[] params = Arrays.copyOfRange(parts, blockIndex + 1, parts.length);
        aji[] blocks = this.parseBlockPart(domain, blockPart);
        if (blocks == null) {
            return null;
        }
        MatchBlock[] datas = new MatchBlock[blocks.length];
        for (int i = 0; i < blocks.length; ++i) {
            MatchBlock bd;
            aji block = blocks[i];
            int blockId = aji.b((aji)block);
            int[] metadatas = null;
            if (params.length > 0 && (metadatas = this.parseBlockMetadatas(block, params)) == null) {
                return null;
            }
            datas[i] = bd = new MatchBlock(blockId, metadatas);
        }
        return datas;
    }

    public boolean isFullBlockName(String[] parts) {
        if (parts.length < 2) {
            return false;
        }
        String part1 = parts[1];
        if (part1.length() < 1) {
            return false;
        }
        if (this.startsWithDigit(part1)) {
            return false;
        }
        return !part1.contains("=");
    }

    public boolean startsWithDigit(String str) {
        if (str == null) {
            return false;
        }
        if (str.length() < 1) {
            return false;
        }
        char ch = str.charAt(0);
        return Character.isDigit(ch);
    }

    public aji[] parseBlockPart(String domain, String blockPart) {
        if (this.startsWithDigit(blockPart)) {
            int[] ids = this.parseIntList(blockPart);
            if (ids == null) {
                return null;
            }
            aji[] blocks = new aji[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                int id = ids[i];
                aji block = aji.e((int)id);
                if (block == null) {
                    this.warn("Block not found for id: " + id);
                    return null;
                }
                blocks[i] = block;
            }
            return blocks;
        }
        String fullName = domain + ":" + blockPart;
        aji block = aji.b((String)fullName);
        if (block == null) {
            this.warn("Block not found for name: " + fullName);
            return null;
        }
        aji[] blocks = new aji[]{block};
        return blocks;
    }

    public int[] parseBlockMetadatas(aji block, String[] params) {
        if (params.length <= 0) {
            return null;
        }
        String param0 = params[0];
        if (this.startsWithDigit(param0)) {
            int[] mds = this.parseIntList(param0);
            return mds;
        }
        this.warn("Invalid block metadata: " + param0);
        return null;
    }

    public ahu[] parseBiomes(String str) {
        if (str == null) {
            return null;
        }
        str = str.trim();
        boolean negative = false;
        if (str.startsWith("!")) {
            negative = true;
            str = str.substring(1);
        }
        String[] biomeNames = Config.tokenize(str, " ");
        ArrayList<ahu> list = new ArrayList<ahu>();
        for (int i = 0; i < biomeNames.length; ++i) {
            String biomeName = biomeNames[i];
            ahu biome = this.findBiome(biomeName);
            if (biome == null) {
                this.warn("Biome not found: " + biomeName);
                continue;
            }
            list.add(biome);
        }
        if (negative) {
            ArrayList<ahu> listAllBiomes = new ArrayList<ahu>(Arrays.asList(ahu.n()));
            listAllBiomes.removeAll(list);
            list = listAllBiomes;
        }
        ahu[] biomeArr = list.toArray(new ahu[list.size()]);
        return biomeArr;
    }

    public ahu findBiome(String biomeName) {
        if ((biomeName = biomeName.toLowerCase()).equals("nether")) {
            return ahu.w;
        }
        ahu[] biomeList = ahu.n();
        for (int i = 0; i < biomeList.length; ++i) {
            String name;
            ahu biome = biomeList[i];
            if (biome == null || !(name = biome.af.replace(" ", "").toLowerCase()).equals(biomeName)) continue;
            return biome;
        }
        return null;
    }

    public int parseInt(String str) {
        if (str == null) {
            return -1;
        }
        int num = Config.parseInt(str = str.trim(), -1);
        if (num < 0) {
            this.warn("Invalid number: " + str);
        }
        return num;
    }

    public int parseInt(String str, int defVal) {
        if (str == null) {
            return defVal;
        }
        int num = Config.parseInt(str = str.trim(), -1);
        if (num < 0) {
            this.warn("Invalid number: " + str);
            return defVal;
        }
        return num;
    }

    public int[] parseIntList(String str) {
        if (str == null) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        String[] intStrs = Config.tokenize(str, " ,");
        for (int i = 0; i < intStrs.length; ++i) {
            String intStr = intStrs[i];
            if (intStr.contains("-")) {
                String[] subStrs = Config.tokenize(intStr, "-");
                if (subStrs.length != 2) {
                    this.warn("Invalid interval: " + intStr + ", when parsing: " + str);
                    continue;
                }
                int min = Config.parseInt(subStrs[0], -1);
                int max = Config.parseInt(subStrs[1], -1);
                if (min < 0 || max < 0 || min > max) {
                    this.warn("Invalid interval: " + intStr + ", when parsing: " + str);
                    continue;
                }
                for (int n = min; n <= max; ++n) {
                    list.add(n);
                }
                continue;
            }
            int val = Config.parseInt(intStr, -1);
            if (val < 0) {
                this.warn("Invalid number: " + intStr + ", when parsing: " + str);
                continue;
            }
            list.add(val);
        }
        int[] ints = new int[list.size()];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = (Integer)list.get(i);
        }
        return ints;
    }

    public void dbg(String str) {
        Config.dbg("" + this.context + ": " + str);
    }

    public void warn(String str) {
        Config.warn("" + this.context + ": " + str);
    }

    public RangeListInt parseRangeListInt(String str) {
        if (str == null) {
            return null;
        }
        RangeListInt list = new RangeListInt();
        String[] parts = Config.tokenize(str, " ,");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            RangeInt ri = this.parseRangeInt(part);
            if (ri == null) {
                return null;
            }
            list.addRange(ri);
        }
        return list;
    }

    private RangeInt parseRangeInt(String str) {
        if (str == null) {
            return null;
        }
        if (str.indexOf(45) >= 0) {
            String[] parts = Config.tokenize(str, "-");
            if (parts.length != 2) {
                this.warn("Invalid range: " + str);
                return null;
            }
            int min = Config.parseInt(parts[0], -1);
            int max = Config.parseInt(parts[1], -1);
            if (min < 0 || max < 0) {
                this.warn("Invalid range: " + str);
                return null;
            }
            return new RangeInt(min, max);
        }
        int val = Config.parseInt(str, -1);
        if (val < 0) {
            this.warn("Invalid integer: " + str);
            return null;
        }
        return new RangeInt(val, val);
    }

    public boolean parseBoolean(String str) {
        if (str == null) {
            return false;
        }
        String strLower = str.toLowerCase().trim();
        return strLower.equals("true");
    }

    public Boolean parseBooleanObject(String str) {
        if (str == null) {
            return null;
        }
        String strLower = str.toLowerCase().trim();
        if (strLower.equals("true")) {
            return Boolean.TRUE;
        }
        if (strLower.equals("false")) {
            return Boolean.FALSE;
        }
        this.warn("Invalid boolean: " + str);
        return null;
    }

    public static int parseColor(String str, int defVal) {
        if (str == null) {
            return defVal;
        }
        str = str.trim();
        try {
            int val = Integer.parseInt(str, 16) & 0xFFFFFF;
            return val;
        }
        catch (NumberFormatException e) {
            return defVal;
        }
    }

    public NbtTagValue parseNbtTagValue(String path, String value) {
        if (path == null || value == null) {
            return null;
        }
        return new NbtTagValue(path, value);
    }

    public VillagerProfession[] parseProfessions(String profStr) {
        if (profStr == null) {
            return null;
        }
        ArrayList<VillagerProfession> list = new ArrayList<VillagerProfession>();
        String[] tokens = Config.tokenize(profStr, " ");
        for (int i = 0; i < tokens.length; ++i) {
            String str = tokens[i];
            VillagerProfession prof = this.parseProfession(str);
            if (prof == null) {
                this.warn("Invalid profession: " + str);
                return PROFESSIONS_INVALID;
            }
            list.add(prof);
        }
        if (list.isEmpty()) {
            return null;
        }
        VillagerProfession[] arr = list.toArray(new VillagerProfession[list.size()]);
        return arr;
    }

    private VillagerProfession parseProfession(String str) {
        int prof;
        String[] parts = Config.tokenize(str = str.toLowerCase(), ":");
        if (parts.length > 2) {
            return null;
        }
        String profStr = parts[0];
        String carStr = null;
        if (parts.length > 1) {
            carStr = parts[1];
        }
        if ((prof = ConnectedParser.parseProfessionId(profStr)) < 0) {
            return null;
        }
        int[] cars = null;
        if (carStr != null && (cars = ConnectedParser.parseCareerIds(prof, carStr)) == null) {
            return null;
        }
        return new VillagerProfession(prof, cars);
    }

    private static int parseProfessionId(String str) {
        int id = Config.parseInt(str, -1);
        if (id >= 0) {
            return id;
        }
        if (str.equals("farmer")) {
            return 0;
        }
        if (str.equals("librarian")) {
            return 1;
        }
        if (str.equals("priest")) {
            return 2;
        }
        if (str.equals("blacksmith")) {
            return 3;
        }
        if (str.equals("butcher")) {
            return 4;
        }
        if (str.equals("nitwit")) {
            return 5;
        }
        return -1;
    }

    private static int[] parseCareerIds(int prof, String str) {
        HashSet<Integer> set = new HashSet<Integer>();
        String[] parts = Config.tokenize(str, ",");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            int id = ConnectedParser.parseCareerId(prof, part);
            if (id < 0) {
                return null;
            }
            set.add(id);
        }
        Integer[] integerArr = set.toArray(new Integer[set.size()]);
        int[] arr = new int[integerArr.length];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = integerArr[i];
        }
        return arr;
    }

    private static int parseCareerId(int prof, String str) {
        int id = Config.parseInt(str, -1);
        if (id >= 0) {
            return id;
        }
        if (prof == 0) {
            if (str.equals("farmer")) {
                return 1;
            }
            if (str.equals("fisherman")) {
                return 2;
            }
            if (str.equals("shepherd")) {
                return 3;
            }
            if (str.equals("fletcher")) {
                return 4;
            }
        }
        if (prof == 1) {
            if (str.equals("librarian")) {
                return 1;
            }
            if (str.equals("cartographer")) {
                return 2;
            }
        }
        if (prof == 2 && str.equals("cleric")) {
            return 1;
        }
        if (prof == 3) {
            if (str.equals("armor")) {
                return 1;
            }
            if (str.equals("weapon")) {
                return 2;
            }
            if (str.equals("tool")) {
                return 3;
            }
        }
        if (prof == 4) {
            if (str.equals("butcher")) {
                return 1;
            }
            if (str.equals("leather")) {
                return 2;
            }
        }
        if (prof == 5 && str.equals("nitwit")) {
            return 1;
        }
        return -1;
    }
}

