/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.properties;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.techbrew.journeymap.model.MapType;
import net.techbrew.journeymap.properties.MapProperties;
import net.techbrew.journeymap.properties.config.Config;
import net.techbrew.journeymap.server.MapApiService;

public class WebMapProperties
extends MapProperties {
    @Config(category=Config.Category.WebMap, master=true, key="jm.webmap.enable", defaultBoolean=false)
    public final AtomicBoolean enabled = new AtomicBoolean(false);
    @Config(category=Config.Category.WebMap, key="jm.advanced.port", minValue=80.0, maxValue=10000.0, defaultValue=8080.0)
    public final AtomicInteger port = new AtomicInteger(8080);
    @Config(category=Config.Category.WebMap, key="jm.webmap.google_domain", stringListProvider=MapApiService.TopLevelDomains.class)
    public final AtomicReference<String> googleMapApiDomain = new AtomicReference<String>(".com");
    public final AtomicReference<MapType.Name> preferredMapType = new AtomicReference<MapType.Name>(MapType.Name.day);
    protected final transient String name = "webmap";

    @Override
    public AtomicReference<String> getEntityIconSetName() {
        return this.entityIconSetName;
    }

    @Override
    public AtomicReference<MapType.Name> getPreferredMapType() {
        return this.preferredMapType;
    }

    @Override
    public String getName() {
        return "webmap";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WebMapProperties that = (WebMapProperties)o;
        return 0 == this.compareTo(that);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + "webmap".hashCode();
        result = 31 * result + this.port.hashCode();
        result = 31 * result + this.enabled.hashCode();
        return result;
    }

    public String toString() {
        return "WebMapProperties: , enabled=" + this.enabled + ", port=" + this.port + ", showMobs=" + this.showMobs + ", showAnimals=" + this.showAnimals + ", showVillagers=" + this.showVillagers + ", showPets=" + this.showPets + ", showPlayers=" + this.showPlayers + ", showWaypoints=" + this.showWaypoints + ", entityIconSetName=" + this.getEntityIconSetName();
    }
}

