/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.forge.event;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventBus;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import net.minecraftforge.common.MinecraftForge;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.cartography.ColorCache;
import net.techbrew.journeymap.forge.event.ChatEventHandler;
import net.techbrew.journeymap.forge.event.ChunkUpdateHandler;
import net.techbrew.journeymap.forge.event.KeyEventHandler;
import net.techbrew.journeymap.forge.event.MiniMapOverlayHandler;
import net.techbrew.journeymap.forge.event.ResourceManagerHandler;
import net.techbrew.journeymap.forge.event.StateTickHandler;
import net.techbrew.journeymap.forge.event.WaypointBeaconHandler;
import net.techbrew.journeymap.forge.event.WorldEventHandler;
import net.techbrew.journeymap.forge.event.WorldInfoHandler;
import net.techbrew.journeymap.log.LogFormatter;

public class EventHandlerManager {
    static WorldInfoHandler worldInfoHandler;
    static ResourceManagerHandler resourceManagerHandler;
    private static HashMap<Class<? extends EventHandler>, EventHandler> handlers;

    public static void registerGeneralHandlers() {
        EventHandlerManager.register(new ChatEventHandler());
        EventHandlerManager.register(new StateTickHandler());
        EventHandlerManager.register(new WorldEventHandler());
        EventHandlerManager.register(new ChunkUpdateHandler());
        EventHandlerManager.register(new WaypointBeaconHandler());
        worldInfoHandler = new WorldInfoHandler();
        resourceManagerHandler = new ResourceManagerHandler();
        ColorCache.instance();
    }

    public static void registerGuiHandlers() {
        EventHandlerManager.register(new MiniMapOverlayHandler());
        KeyEventHandler.initKeyBindings();
        EventHandlerManager.register(new KeyEventHandler());
    }

    public static void unregisterAll() {
        ArrayList<Class<? extends EventHandler>> list = new ArrayList<Class<? extends EventHandler>>(handlers.keySet());
        for (Class<? extends EventHandler> handlerClass : list) {
            EventHandlerManager.unregister(handlerClass);
        }
    }

    private static void register(EventHandler handler) {
        if (handlers.containsKey(handler.getClass())) {
            JourneyMap.getLogger().warn("Handler already registered: " + handler.getClass().getName());
            return;
        }
        boolean registered = false;
        for (BusType busType : handler.getBus()) {
            String name = handler.getClass().getName();
            try {
                busType.eventBus.register((Object)handler);
                registered = true;
                JourneyMap.getLogger().debug(name + " registered in " + (Object)((Object)busType));
            }
            catch (Throwable t) {
                JourneyMap.getLogger().error(name + " registration FAILED in " + (Object)((Object)busType) + ": " + LogFormatter.toString(t));
            }
        }
        if (registered) {
            handlers.put(handler.getClass(), handler);
        } else {
            JourneyMap.getLogger().warn("Handler was not registered at all: " + handler.getClass().getName());
        }
    }

    public static void unregister(Class<? extends EventHandler> handlerClass) {
        EventHandler handler = handlers.remove(handlerClass);
        if (handler != null) {
            EnumSet<BusType> buses = handler.getBus();
            for (BusType busType : handler.getBus()) {
                String name = handler.getClass().getName();
                try {
                    boolean unregistered = false;
                    switch (busType) {
                        case MinecraftForgeBus: {
                            MinecraftForge.EVENT_BUS.unregister((Object)handler);
                            unregistered = true;
                        }
                    }
                    if (!unregistered) continue;
                    JourneyMap.getLogger().debug(name + " unregistered from " + (Object)((Object)busType));
                }
                catch (Throwable t) {
                    JourneyMap.getLogger().error(name + " unregistration FAILED from " + (Object)((Object)busType) + ": " + LogFormatter.toString(t));
                }
            }
        }
    }

    static {
        handlers = new HashMap();
    }

    public static interface EventHandler {
        public EnumSet<BusType> getBus();
    }

    public static enum BusType {
        FMLCommonHandlerBus(FMLCommonHandler.instance().bus()),
        MinecraftForgeBus(MinecraftForge.EVENT_BUS);

        protected final EventBus eventBus;

        private BusType(EventBus eventBus) {
            this.eventBus = eventBus;
        }
    }
}

