/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.gui.controls;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.impl.Pair;
import com.gitlab.cdagaming.craftpresence.utils.ImageUtils;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import com.gitlab.cdagaming.craftpresence.utils.gui.GuiUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;

public class ScrollableListControl
extends GuiSlot {
    public String currentValue;
    public List<String> itemList;
    public RenderType renderType;

    public ScrollableListControl(Minecraft mc, int width, int height, int topIn, int bottomIn, int slotHeightIn, List<String> itemList, String currentValue) {
        this(mc, width, height, topIn, bottomIn, slotHeightIn, itemList, currentValue, RenderType.None);
    }

    public ScrollableListControl(Minecraft mc, int width, int height, int topIn, int bottomIn, int slotHeightIn, List<String> itemList, String currentValue, RenderType renderType) {
        super(mc, width, height, topIn, bottomIn, slotHeightIn);
        this.itemList = itemList;
        this.currentValue = currentValue;
        this.renderType = renderType;
    }

    protected int func_148127_b() {
        return this.itemList.size();
    }

    public void func_148144_a(int slotIndex, boolean isDoubleClick, int mouseX, int mouseY) {
        this.currentValue = this.getSelectedItem(slotIndex);
    }

    public boolean func_148131_a(int slotIndex) {
        return this.getSelectedItem(slotIndex).equals(this.currentValue);
    }

    protected void func_148123_a() {
    }

    protected void func_148126_a(int slotIndex, int xPos, int yPos, int heightIn, Tessellator tessellatorIn, int mouseXIn, int mouseYIn) {
        int xOffset = xPos;
        String displayName = this.getSelectedItem(slotIndex);
        if (!CraftPresence.CONFIG.stripExtraGuiElements && (this.renderType == RenderType.DiscordAsset || this.renderType == RenderType.ServerData && CraftPresence.SERVER.enabled || this.renderType == RenderType.EntityData && CraftPresence.ENTITIES.enabled || this.renderType == RenderType.ItemData && CraftPresence.TILE_ENTITIES.enabled)) {
            ResourceLocation texture = new ResourceLocation("");
            if (this.renderType == RenderType.ServerData) {
                ServerData data = CraftPresence.SERVER.getDataFromName(displayName);
                if (data != null) {
                    String assetUrl = "data:image/unknown;base64," + data.func_147409_e();
                    texture = ImageUtils.getTextureFromUrl(displayName, new Pair<ImageUtils.InputType, Object>(ImageUtils.InputType.ByteStream, assetUrl));
                }
            } else if (this.renderType == RenderType.DiscordAsset) {
                String assetUrl = DiscordAssetUtils.getAssetUrl(CraftPresence.CONFIG.clientId, displayName, true);
                texture = ImageUtils.getTextureFromUrl(displayName, assetUrl);
            } else if (this.renderType == RenderType.EntityData) {
                if (StringUtils.isValidUuid(displayName)) {
                    displayName = displayName.replaceAll("-", "");
                    texture = ImageUtils.getTextureFromUrl(displayName, "https://crafatar.com/avatars/" + displayName);
                }
            } else if (this.renderType == RenderType.ItemData) {
                texture = CraftPresence.TILE_ENTITIES.TILE_ENTITY_RESOURCES.getOrDefault(displayName, texture);
            }
            if (!ImageUtils.isTextureNull(texture)) {
                CraftPresence.GUIS.drawTextureRect(0.0, xOffset, (double)yPos + 4.5, 32.0, 32.0, 0.0, texture);
            }
            xOffset += 35;
        }
        this.getFontRenderer().func_78261_a(displayName, xOffset, yPos + (heightIn / 2 - this.getFontRenderer().field_78288_b / 2), 0xFFFFFF);
    }

    public String getSelectedItem(int slotIndex) {
        try {
            return this.itemList.get(slotIndex);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public FontRenderer getFontRenderer() {
        return GuiUtils.getDefaultFontRenderer();
    }

    public int getFontHeight() {
        return this.getFontRenderer().field_78288_b;
    }

    public static enum RenderType {
        DiscordAsset,
        ServerData,
        EntityData,
        ItemData,
        None;

    }
}

