/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.discord.rpc.entities.pipe;

import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.IPCClient;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.entities.Callback;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.entities.Packet;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.entities.pipe.Pipe;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.entities.pipe.PipeStatus;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;

public class UnixPipe
extends Pipe {
    private final AFUNIXSocket socket = AFUNIXSocket.newInstance();

    UnixPipe(IPCClient ipcClient, HashMap<String, Callback> callbacks, String location) throws IOException {
        super(ipcClient, callbacks);
        this.socket.connect(new AFUNIXSocketAddress(new File(location)));
    }

    @Override
    public Packet read() throws IOException, JsonParseException {
        InputStream is = this.socket.getInputStream();
        while ((this.status == PipeStatus.CONNECTED || this.status == PipeStatus.CLOSING) && is.available() == 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.status == PipeStatus.DISCONNECTED) {
            throw new IOException("Disconnected!");
        }
        if (this.status == PipeStatus.CLOSED) {
            return new Packet(Packet.OpCode.CLOSE, null, this.ipcClient.getEncoding());
        }
        byte[] d = new byte[8];
        int readResult = is.read(d);
        ByteBuffer bb = ByteBuffer.wrap(d);
        if (this.ipcClient.isDebugMode() && this.ipcClient.isVerboseLogging()) {
            ModUtils.LOG.debugInfo(String.format("Read Byte Data: %s with result %s", new String(d), readResult), new Object[0]);
        }
        Packet.OpCode op = Packet.OpCode.values()[Integer.reverseBytes(bb.getInt())];
        d = new byte[Integer.reverseBytes(bb.getInt())];
        int reversedResult = is.read(d);
        if (this.ipcClient.isDebugMode() && this.ipcClient.isVerboseLogging()) {
            ModUtils.LOG.debugInfo(String.format("Read Reversed Byte Data: %s with result %s", new String(d), reversedResult), new Object[0]);
        }
        return this.receive(op, d);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.socket.getOutputStream().write(b);
    }

    @Override
    public void close() throws IOException {
        if (this.ipcClient.isDebugMode()) {
            ModUtils.LOG.debugInfo("Closing IPC pipe...", new Object[0]);
        }
        this.status = PipeStatus.CLOSING;
        this.send(Packet.OpCode.CLOSE, new JsonObject(), null);
        this.status = PipeStatus.CLOSED;
        this.socket.close();
    }

    public boolean mkdir(String path) {
        File file = new File(path);
        return file.exists() && file.isDirectory() || file.mkdir();
    }

    @Override
    public void registerApp(String applicationId, String command) {
        String home = System.getenv("HOME");
        if (home == null) {
            throw new RuntimeException("Unable to find user HOME directory");
        }
        if (command == null) {
            try {
                command = Files.readSymbolicLink(Paths.get("/proc/self/exe", new String[0])).toString();
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to get current exe path from /proc/self/exe", ex);
            }
        }
        String desktopFile = "[Desktop Entry]\nName=Game " + applicationId + "\nExec=" + command + " %%u\nType=Application\nNoDisplay=true\nCategories=Discord;Games;\nMimeType=x-scheme-handler/discord-" + applicationId + ";\n";
        String desktopFileName = "/discord-" + applicationId + ".desktop";
        String desktopFilePath = home + "/.local";
        if (this.mkdir(desktopFilePath)) {
            ModUtils.LOG.debugWarn("Failed to create directory '" + desktopFilePath + "', may already exist", new Object[0]);
        }
        if (this.mkdir(desktopFilePath = desktopFilePath + "/share")) {
            ModUtils.LOG.debugWarn("Failed to create directory '" + desktopFilePath + "', may already exist", new Object[0]);
        }
        if (this.mkdir(desktopFilePath = desktopFilePath + "/applications")) {
            ModUtils.LOG.debugWarn("Failed to create directory '" + desktopFilePath + "', may already exist", new Object[0]);
        }
        desktopFilePath = desktopFilePath + desktopFileName;
        try (FileWriter fileWriter = new FileWriter(desktopFilePath);){
            fileWriter.write(desktopFile);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to write desktop info into '" + desktopFilePath + "'");
        }
        String xdgMimeCommand = "xdg-mime default discord-" + applicationId + ".desktop x-scheme-handler/discord-" + applicationId;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(xdgMimeCommand.split(" "));
            processBuilder.environment();
            int result = processBuilder.start().waitFor();
            if (result < 0) {
                throw new Exception("xdg-mime returned " + result);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to register mime handler", ex);
        }
    }

    @Override
    public void registerSteamGame(String applicationId, String steamId) {
        this.registerApp(applicationId, "xdg-open steam://rungameid/" + steamId);
    }
}

