/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.impl.ImageFrame;
import com.gitlab.cdagaming.craftpresence.impl.Pair;
import com.gitlab.cdagaming.craftpresence.impl.Tuple;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.utils.UrlUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.ResourceLocation;

public class ImageUtils {
    private static final BlockingQueue<Pair<String, Pair<InputType, Object>>> urlRequests = Queues.newLinkedBlockingQueue();
    private static final Map<String, Tuple<Pair<InputType, Object>, Pair<Integer, List<ImageFrame>>, List<ResourceLocation>>> cachedImages = Maps.newHashMap();
    private static final Thread urlQueue = new Thread("Url Queue"){

        @Override
        public void run() {
            block12: while (true) {
                try {
                    while (!CraftPresence.closing) {
                        Pair request = (Pair)urlRequests.take();
                        boolean isGif = ((String)request.getFirst()).endsWith(".gif");
                        Pair bufferData = (Pair)((Tuple)cachedImages.get(request.getFirst())).getSecond();
                        if (bufferData == null) continue;
                        try {
                            InputStream streamData;
                            Object originData = ((Pair)request.getSecond()).getSecond();
                            switch ((InputType)((Object)((Pair)request.getSecond()).getFirst())) {
                                case FileData: {
                                    streamData = new FileInputStream((File)originData);
                                    break;
                                }
                                case FileStream: {
                                    streamData = new FileInputStream(originData.toString());
                                    break;
                                }
                                case ByteStream: {
                                    Tuple<Boolean, String, String> base64Data = StringUtils.isBase64(originData.toString());
                                    byte[] dataSet = base64Data.getFirst() != false ? ImageUtils.decodeBase64(base64Data.getThird(), "UTF-8", false, false) : (originData instanceof byte[] ? (byte[])originData : originData.toString().getBytes());
                                    streamData = dataSet != null ? new ByteArrayInputStream(dataSet) : null;
                                    isGif = base64Data.getSecond().contains("gif");
                                    break;
                                }
                                case Url: {
                                    streamData = UrlUtils.getURLStream((URL)originData);
                                    break;
                                }
                                default: {
                                    streamData = null;
                                }
                            }
                            if (streamData == null) continue block12;
                            if (isGif) {
                                ImageFrame[] frames;
                                for (ImageFrame frame : frames = ImageFrame.readGif(streamData)) {
                                    try {
                                        ((List)bufferData.getSecond()).add(frame);
                                    }
                                    catch (Exception ex) {
                                        if (!ModUtils.IS_VERBOSE) continue;
                                        ex.printStackTrace();
                                    }
                                }
                            } else {
                                ((List)bufferData.getSecond()).add(new ImageFrame(ImageIO.read(streamData)));
                            }
                            ((Tuple)cachedImages.get(request.getFirst())).setSecond(bufferData);
                            ((Tuple)cachedImages.get(request.getFirst())).setThird(new ArrayList(((List)bufferData.getSecond()).size()));
                            continue block12;
                        }
                        catch (Exception ex) {
                            if (!ModUtils.IS_VERBOSE) continue;
                            ex.printStackTrace();
                        }
                    }
                    break;
                }
                catch (Exception ex) {
                    if (!ModUtils.IS_VERBOSE) break;
                    ex.printStackTrace();
                    break;
                }
            }
        }
    };

    public static ResourceLocation getTextureFromUrl(String textureName, String url) {
        try {
            return ImageUtils.getTextureFromUrl(textureName, new URL(url));
        }
        catch (Exception ex) {
            if (ModUtils.IS_VERBOSE) {
                ex.printStackTrace();
            }
            return new ResourceLocation("");
        }
    }

    public static ResourceLocation getTextureFromUrl(String textureName, URL url) {
        try {
            return ImageUtils.getTextureFromUrl(textureName, new Pair<InputType, Object>(InputType.Url, url));
        }
        catch (Exception ex) {
            if (ModUtils.IS_VERBOSE) {
                ex.printStackTrace();
            }
            return new ResourceLocation("");
        }
    }

    public static ResourceLocation getTextureFromUrl(String textureName, File url) {
        try {
            return ImageUtils.getTextureFromUrl(textureName, new Pair<InputType, Object>(InputType.FileData, url));
        }
        catch (Exception ex) {
            if (ModUtils.IS_VERBOSE) {
                ex.printStackTrace();
            }
            return new ResourceLocation("");
        }
    }

    public static ResourceLocation getTextureFromUrl(String textureName, Object url) {
        if (url instanceof File) {
            return ImageUtils.getTextureFromUrl(textureName, (File)url);
        }
        if (url instanceof URL) {
            return ImageUtils.getTextureFromUrl(textureName, (URL)url);
        }
        if (url.toString().toLowerCase().startsWith("http")) {
            return ImageUtils.getTextureFromUrl(textureName, url.toString());
        }
        return ImageUtils.getTextureFromUrl(textureName, new Pair<InputType, Object>(StringUtils.isBase64(url.toString()).getFirst() != false ? InputType.ByteStream : InputType.FileStream, url.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceLocation getTextureFromUrl(String textureName, Pair<InputType, Object> stream) {
        Map<String, Tuple<Pair<InputType, Object>, Pair<Integer, List<ImageFrame>>, List<ResourceLocation>>> map = cachedImages;
        synchronized (map) {
            Pair<Integer, List<ImageFrame>> bufferData;
            block21: {
                if (!cachedImages.containsKey(textureName)) {
                    cachedImages.put(textureName, new Tuple<Pair<InputType, Object>, Pair<Integer, ArrayList>, Object>(stream, new Pair<Integer, ArrayList>(0, Lists.newArrayList()), null));
                    try {
                        urlRequests.put(new Pair<String, Pair<InputType, Object>>(textureName, stream));
                    }
                    catch (Exception ex) {
                        if (!ModUtils.IS_VERBOSE) break block21;
                        ex.printStackTrace();
                    }
                }
            }
            if ((bufferData = cachedImages.get(textureName).getSecond()) == null || bufferData.getSecond() == null || bufferData.getSecond().isEmpty()) {
                return new ResourceLocation("");
            }
            if (textureName != null) {
                boolean shouldRepeat = textureName.endsWith(".gif") || stream.getSecond().toString().contains("gif");
                boolean doesContinue = bufferData.getFirst() < bufferData.getSecond().size() - 1;
                List<ResourceLocation> resources = cachedImages.get(textureName).getThird();
                if (bufferData.getFirst() < resources.size()) {
                    ResourceLocation texLocation = resources.get(bufferData.getFirst());
                    if (bufferData.getSecond().get(bufferData.getFirst()).shouldRenderNext()) {
                        if (doesContinue) {
                            bufferData.getSecond().get(bufferData.setFirst(bufferData.getFirst() + 1)).setRenderTime(System.currentTimeMillis());
                        } else if (shouldRepeat) {
                            bufferData.getSecond().get(bufferData.setFirst(0)).setRenderTime(System.currentTimeMillis());
                        }
                    }
                    return texLocation;
                }
                try {
                    DynamicTexture dynTexture = new DynamicTexture(bufferData.getSecond().get(bufferData.getFirst()).getImage());
                    ResourceLocation cachedTexture = CraftPresence.instance.func_110434_K().func_110578_a(textureName + (textureName.endsWith(".gif") ? "_" + cachedImages.get(textureName).getSecond().getFirst() : ""), dynTexture);
                    if (bufferData.getSecond().get(bufferData.getFirst()).shouldRenderNext()) {
                        if (doesContinue) {
                            bufferData.getSecond().get(bufferData.setFirst(bufferData.getFirst() + 1)).setRenderTime(System.currentTimeMillis());
                        } else if (shouldRepeat) {
                            bufferData.setFirst(0);
                        }
                    }
                    if (!resources.contains(cachedTexture)) {
                        resources.add(cachedTexture);
                    }
                    return cachedTexture;
                }
                catch (Exception ex) {
                    if (ModUtils.IS_VERBOSE) {
                        ex.printStackTrace();
                    }
                    return new ResourceLocation("");
                }
            }
            return new ResourceLocation("");
        }
    }

    public static boolean isExternalImage(String input) {
        return !StringUtils.isNullOrEmpty(input) && (input.toLowerCase().startsWith("http") || StringUtils.isBase64(input).getFirst() != false || input.toLowerCase().startsWith("file://"));
    }

    public static byte[] decodeBase64(String input, String encoding, boolean useDecodingMethod, boolean repeatCycle) {
        try {
            return Base64.getDecoder().decode(useDecodingMethod ? URLDecoder.decode(input, encoding) : input);
        }
        catch (Exception ex) {
            if (ModUtils.IS_VERBOSE) {
                ex.printStackTrace();
            }
            if (!repeatCycle) {
                return ImageUtils.decodeBase64(input, encoding, !useDecodingMethod, true);
            }
            return null;
        }
    }

    public static boolean isTextureNull(ResourceLocation location) {
        return location == null || StringUtils.isNullOrEmpty(location.func_110624_b()) || StringUtils.isNullOrEmpty(location.func_110623_a());
    }

    static {
        urlQueue.start();
    }

    public static enum InputType {
        FileData,
        FileStream,
        ByteStream,
        Url,
        Unknown;

    }
}

