/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.driveables;

import com.flansmod.client.model.ModelDriveable;
import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.CollisionBox;
import com.flansmod.common.driveables.DriveablePart;
import com.flansmod.common.driveables.DriveablePosition;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.driveables.EnumWeaponType;
import com.flansmod.common.driveables.PilotGun;
import com.flansmod.common.driveables.Seat;
import com.flansmod.common.driveables.ShootPoint;
import com.flansmod.common.driveables.collisions.CollisionShapeBox;
import com.flansmod.common.guns.BulletType;
import com.flansmod.common.guns.EnumFireMode;
import com.flansmod.common.paintjob.PaintableType;
import com.flansmod.common.parts.PartType;
import com.flansmod.common.types.TypeFile;
import com.flansmod.common.vector.Vector3f;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.model.ModelBase;
import net.minecraft.init.Items;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;

public class DriveableType
extends PaintableType {
    public ModelDriveable model;
    public HashMap<EnumDriveablePart, CollisionBox> health = new HashMap();
    public HashMap<EnumDriveablePart, ItemStack[]> partwiseRecipe = new HashMap();
    public ArrayList<ItemStack> driveableRecipe = new ArrayList();
    public boolean acceptAllAmmo = true;
    public List<BulletType> ammo = new ArrayList<BulletType>();
    public boolean harvestBlocks = false;
    public ArrayList<Material> materialsHarvested = new ArrayList();
    public boolean collectHarvest = false;
    public boolean dropHarvest = false;
    public Vector3f harvestBoxSize = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f harvestBoxPos = new Vector3f(0.0f, 0.0f, 0.0f);
    public int reloadSoundTick = 15214541;
    public float fallDamageFactor = 1.0f;
    public int engineStartTime = 0;
    public EnumWeaponType primary = EnumWeaponType.NONE;
    public EnumWeaponType secondary = EnumWeaponType.NONE;
    public boolean alternatePrimary = false;
    public boolean alternateSecondary = false;
    public float shootDelayPrimary = -1.0f;
    public float shootDelaySecondary = -1.0f;
    public float damageMultiplierPrimary = 1.0f;
    public float damageMultiplierSecondary = 1.0f;
    public EnumFireMode modePrimary = EnumFireMode.FULLAUTO;
    public EnumFireMode modeSecondary = EnumFireMode.FULLAUTO;
    public String shootSoundPrimary;
    public String shootSoundSecondary;
    public String shootReloadSound;
    public ArrayList<ShootPoint> shootPointsPrimary = new ArrayList();
    public ArrayList<ShootPoint> shootPointsSecondary = new ArrayList();
    public ArrayList<PilotGun> pilotGuns = new ArrayList();
    public int reloadTimePrimary = 0;
    public int reloadTimeSecondary = 0;
    public String reloadSoundPrimary = "";
    public String reloadSoundSecondary = "";
    public int placeTimePrimary = 5;
    public int placeTimeSecondary = 5;
    public String placeSoundPrimary = "";
    public String placeSoundSecondary = "";
    public int numPassengers = 0;
    public Seat[] seats;
    public int numPassengerGunners = 0;
    public float vehicleGunModelScale = 1.0f;
    public boolean filterAmmunition = false;
    public boolean worksUnderWater = false;
    public ArrayList<ShootParticle> shootParticlesPrimary = new ArrayList();
    public ArrayList<ShootParticle> shootParticlesSecondary = new ArrayList();
    public int numCargoSlots;
    public int numBombSlots;
    public int numMissileSlots;
    public int fuelTankSize = 100;
    public float yOffset = 0.625f;
    public float cameraDistance = 5.0f;
    public ArrayList<ParticleEmitter> emitters = new ArrayList();
    public float maxThrottle = 1.0f;
    public float maxNegativeThrottle = 0.0f;
    public float clutchBrake = 0.0f;
    public Vector3f turretOrigin = new Vector3f();
    public Vector3f turretOriginOffset = new Vector3f();
    public DriveablePosition[] wheelPositions = new DriveablePosition[0];
    public float wheelSpringStrength = 0.5f;
    public float wheelStepHeight = 1.0f;
    public boolean canRoll = true;
    public ArrayList<DriveablePosition> collisionPoints = new ArrayList();
    public float drag = 1.0f;
    public boolean floatOnWater = false;
    public boolean placeableOnLand = true;
    public boolean placeableOnWater = false;
    public boolean placeableOnSponge = false;
    public float buoyancy = 0.0165f;
    public float floatOffset = 0.0f;
    public float bulletDetectionRadius = 5.0f;
    public boolean onRadar = false;
    public int animFrames = 2;
    public int startSoundRange = 50;
    public String startSound = "";
    public int startSoundLength;
    public int engineSoundRange = 50;
    public String engineSound = "";
    public int engineSoundLength;
    public int backSoundRange = 50;
    public String exitSound = "";
    public int exitSoundLength = 50;
    public String idleSound = "";
    public int idleSoundLength = 50;
    public String backSound = "";
    public int backSoundLength;
    public boolean collisionDamageEnable = false;
    public boolean pushOnCollision = true;
    public float collisionDamageThrottle = 0.0f;
    public float collisionDamageTimes = 0.0f;
    public boolean enableReloadTime = false;
    public boolean canMountEntity = false;
    public float bulletSpread = 0.0f;
    public float bulletSpeed = 3.0f;
    public boolean rangingGun = false;
    public boolean isExplosionWhenDestroyed = false;
    public float deathFireRadius = 0.0f;
    public float deathExplosionRadius = 4.0f;
    public float deathExplosionPower = 1.0f;
    public boolean deathExplosionBreaksBlocks = false;
    public float deathExplosionDamageVsLiving = 1.0f;
    public float deathExplosionDamageVsPlayer = 1.0f;
    public float deathExplosionDamageVsPlane = 1.0f;
    public float deathExplosionDamageVsVehicle = 1.0f;
    public String lockedOnSound = "";
    public int soundTime = 0;
    public int canLockOnAngle = 10;
    public int lockOnSoundTime = 60;
    public String lockOnSound = "";
    public int maxRangeLockOn = 500;
    public int lockedOnSoundRange = 5;
    public String lockingOnSound = "";
    public boolean lockOnToPlanes = false;
    public boolean lockOnToVehicles = false;
    public boolean lockOnToMechas = false;
    public boolean lockOnToPlayers = false;
    public boolean lockOnToLivings = false;
    public boolean hasFlare = false;
    public int flareDelay = 200;
    public String flareSound = "";
    public int timeFlareUsing = 1;
    public float recoilDist = 5.0f;
    public float recoilTime = 5.0f;
    public boolean fixedPrimaryFire = false;
    public Vector3f primaryFireAngle = new Vector3f(0.0f, 0.0f, 0.0f);
    public float gunLength = 0.0f;
    public boolean setPlayerInvisible = false;
    public float maxThrottleInWater = 0.5f;
    public int maxDepth = 3;
    public ArrayList<Vector3f> leftTrackPoints = new ArrayList();
    public ArrayList<Vector3f> rightTrackPoints = new ArrayList();
    public float trackLinkLength = 0.0f;
    public boolean IT1 = false;
    public static ArrayList<DriveableType> types = new ArrayList();
    public ArrayList<CollisionShapeBox> collisionBox = new ArrayList();
    public boolean fancyCollision = false;
    public CollisionShapeBox colbox;

    public DriveableType(TypeFile file) {
        super(file);
    }

    @Override
    public void preRead(TypeFile file) {
        StringBuilder msg;
        String[] split;
        super.preRead(file);
        for (String line : file.lines) {
            if (line == null) break;
            split = line.split(" ");
            if (line.startsWith("//") || split.length < 2) continue;
            try {
                if (!split[0].equals("Passengers")) continue;
                this.numPassengers = Integer.parseInt(split[1]);
                this.seats = new Seat[this.numPassengers + 1];
                break;
            }
            catch (Exception e) {
                msg = new StringBuilder(" : ");
                for (String s : split) {
                    msg.append(" ").append(s);
                }
                FlansMod.log("Errored reading " + file.name + msg);
                if (!FlansMod.printStackTrace) continue;
                e.printStackTrace();
            }
        }
        for (String line : file.lines) {
            if (line == null) break;
            if (line.startsWith("//") || (split = line.split(" ")).length < 2) continue;
            try {
                if (!split[0].equals("NumWheels")) continue;
                this.wheelPositions = new DriveablePosition[Integer.parseInt(split[1])];
                break;
            }
            catch (Exception e) {
                msg = new StringBuilder(" : ");
                for (String s : split) {
                    msg.append(" ").append(s);
                }
                FlansMod.log("Errored pre-reading " + file.name + msg);
                if (!FlansMod.printStackTrace) continue;
                e.printStackTrace();
            }
        }
        int counter = 0;
        for (String line : file.lines) {
            block19: {
                StringBuilder msg2;
                String[] split2;
                block18: {
                    if (line == null) break;
                    if (line.startsWith("//") || (split2 = line.split(" ")).length < 2) continue;
                    try {
                        if (split2[0].equals("Passenger")) {
                            Seat seat;
                            this.seats[seat.id] = seat = new Seat(split2);
                            if (seat.gunType != null) {
                                ++this.numPassengerGunners;
                                seat.gunnerID = seat.gunnerID;
                                this.driveableRecipe.add(new ItemStack(seat.gunType.item));
                            }
                            ++counter;
                        }
                    }
                    catch (Exception ex) {
                        msg2 = new StringBuilder(" : ");
                        for (String s : split2) {
                            msg2.append(" ").append(s);
                        }
                        FlansMod.log("Errored pre-reading " + file.name + msg2);
                        if (!FlansMod.printStackTrace) break block18;
                        ex.printStackTrace();
                    }
                }
                try {
                    if (split2[0].equals("Driver") || split2[0].equals("Pilot")) {
                        this.seats[0] = split2.length > 4 ? new Seat(Integer.parseInt(split2[1]), Integer.parseInt(split2[2]), Integer.parseInt(split2[3]), Float.parseFloat(split2[4]), Float.parseFloat(split2[5]), Float.parseFloat(split2[6]), Float.parseFloat(split2[7])) : new Seat(Integer.parseInt(split2[1]), Integer.parseInt(split2[2]), Integer.parseInt(split2[3]));
                    }
                }
                catch (Exception ex) {
                    msg2 = new StringBuilder(" : ");
                    for (String s : split2) {
                        msg2.append(" ").append(s);
                    }
                    FlansMod.log("Errored pre-reading " + file.name + msg2);
                    if (!FlansMod.printStackTrace) break block19;
                    ex.printStackTrace();
                }
            }
            if (counter != this.seats.length) continue;
            break;
        }
        types.add(this);
    }

    @Override
    public void postRead(TypeFile file) {
        super.postRead(file);
    }

    @Override
    protected void read(String[] split, TypeFile file) {
        block362: {
            super.read(split, file);
            try {
                CollisionShapeBox box;
                Vector3f p8;
                Vector3f p7;
                Vector3f p6;
                Vector3f p4;
                Vector3f p2;
                EnumDriveablePart part;
                ShootPoint sPoint;
                DriveablePosition rootPos;
                String[] gun;
                if (split[0].equals("VehicleGunModelScale")) {
                    this.vehicleGunModelScale = Float.parseFloat(split[1]);
                }
                if (FMLCommonHandler.instance().getSide().isClient() && split[0].equals("Model")) {
                    this.model = FlansMod.proxy.loadModel(split[1], this.shortName, ModelDriveable.class);
                } else if (split[0].equals("VehicleGunReloadTick")) {
                    this.reloadSoundTick = Integer.parseInt(split[1]);
                } else if (split[0].equals("Texture")) {
                    this.texture = split[1];
                } else if (split[0].equals("IsExplosionWhenDestroyed")) {
                    this.isExplosionWhenDestroyed = Boolean.parseBoolean(split[1]);
                } else if (split[0].equals("DeathFireRadius") || split[0].equals("DeathFire")) {
                    this.deathFireRadius = Float.parseFloat(split[1]);
                } else if (split[0].equals("DeathExplosionRadius") || split[0].equals("DeathExplosion")) {
                    this.deathExplosionRadius = Float.parseFloat(split[1]);
                } else if (split[0].equals("DeathExplosionPower")) {
                    this.deathExplosionPower = Float.parseFloat(split[1]);
                } else if (split[0].equals("DeathExplosionBreaksBlocks")) {
                    this.deathExplosionBreaksBlocks = Boolean.parseBoolean(split[1].toLowerCase());
                } else if (split[0].equals("DeathExplosionDamageVsLiving")) {
                    this.deathExplosionDamageVsLiving = Float.parseFloat(split[1]);
                } else if (split[0].equals("DeathExplosionDamageVsPlayer")) {
                    this.deathExplosionDamageVsPlayer = Float.parseFloat(split[1]);
                } else if (split[0].equals("DeathExplosionDamageVsPlane")) {
                    this.deathExplosionDamageVsPlane = Float.parseFloat(split[1]);
                } else if (split[0].equals("DeathExplosionDamageVsVehicle")) {
                    this.deathExplosionDamageVsVehicle = Float.parseFloat(split[1]);
                } else if (split[0].equals("FallDamageFactor")) {
                    this.fallDamageFactor = Float.parseFloat(split[1]);
                } else if (split[0].equals("MaxThrottle")) {
                    this.maxThrottle = Float.parseFloat(split[1]);
                } else if (split[0].equals("MaxNegativeThrottle")) {
                    this.maxNegativeThrottle = Float.parseFloat(split[1]);
                } else if (split[0].equals("ClutchBrake")) {
                    this.clutchBrake = Float.parseFloat(split[1]);
                } else if (split[0].equals("MaxThrottleInWater")) {
                    this.maxThrottleInWater = Float.parseFloat(split[1]);
                } else if (split[0].equals("MaxDepth")) {
                    this.maxDepth = Integer.parseInt(split[1]);
                } else if (split[0].equals("Drag")) {
                    this.drag = Float.parseFloat(split[1]);
                } else if (split[0].equals("TurretOrigin")) {
                    this.turretOrigin = new Vector3f(Float.parseFloat(split[1]) / 16.0f, Float.parseFloat(split[2]) / 16.0f, Float.parseFloat(split[3]) / 16.0f);
                } else if (split[0].equals("TurretOriginOffset")) {
                    this.turretOriginOffset = new Vector3f(Float.parseFloat(split[1]) / 16.0f, Float.parseFloat(split[2]) / 16.0f, Float.parseFloat(split[3]) / 16.0f);
                } else if (split[0].equals("CollisionPoint") || split[0].equals("AddCollisionPoint")) {
                    this.collisionPoints.add(new DriveablePosition(split));
                } else if (split[0].equals("CollisionDamageEnable")) {
                    this.collisionDamageEnable = Boolean.parseBoolean(split[1]);
                } else if (split[0].equals("CollisionDamageThrottle")) {
                    this.collisionDamageThrottle = Float.parseFloat(split[1]);
                } else if (split[0].equals("CollisionDamageTimes")) {
                    this.collisionDamageTimes = Float.parseFloat(split[1]);
                } else if (split[0].equals("CanLockAngle")) {
                    this.canLockOnAngle = Integer.parseInt(split[1]);
                } else if (split[0].equals("LockOnSoundTime")) {
                    this.lockOnSoundTime = Integer.parseInt(split[1]);
                } else if (split[0].equals("LockOnToDriveables")) {
                    this.lockOnToVehicles = this.lockOnToMechas = Boolean.parseBoolean(split[1].toLowerCase());
                    this.lockOnToPlanes = this.lockOnToMechas;
                } else if (split[0].equals("LockOnToVehicles")) {
                    this.lockOnToVehicles = Boolean.parseBoolean(split[1].toLowerCase());
                } else if (split[0].equals("LockOnToPlanes")) {
                    this.lockOnToPlanes = Boolean.parseBoolean(split[1].toLowerCase());
                } else if (split[0].equals("LockOnToMechas")) {
                    this.lockOnToMechas = Boolean.parseBoolean(split[1].toLowerCase());
                } else if (split[0].equals("LockOnToPlayers")) {
                    this.lockOnToPlayers = Boolean.parseBoolean(split[1].toLowerCase());
                } else if (split[0].equals("LockOnToLivings")) {
                    this.lockOnToLivings = Boolean.parseBoolean(split[1].toLowerCase());
                } else if (split[0].equals("LockedOnSoundRange")) {
                    this.lockedOnSoundRange = Integer.parseInt(split[1]);
                } else if (split[0].equals("CanRoll")) {
                    this.canRoll = Boolean.parseBoolean(split[1]);
                }
                if (split[0].equals("HasFlare")) {
                    this.hasFlare = Boolean.parseBoolean(split[1]);
                }
                if (split[0].equals("FlareDelay")) {
                    this.flareDelay = Integer.parseInt(split[1]);
                    if (this.flareDelay <= 0) {
                        this.flareDelay = 1;
                    }
                }
                if (split[0].equals("TimeFlareUsing")) {
                    this.timeFlareUsing = Integer.parseInt(split[1]);
                    if (this.timeFlareUsing <= 0) {
                        this.timeFlareUsing = 1;
                    }
                } else if (split[0].equals("PlaceableOnLand")) {
                    this.placeableOnLand = Boolean.parseBoolean(split[1]);
                } else if (split[0].equals("PlaceableOnWater")) {
                    this.placeableOnWater = Boolean.parseBoolean(split[1]);
                } else if (split[0].equals("WorksUnderwater")) {
                    this.worksUnderWater = Boolean.parseBoolean(split[1]);
                } else if (split[0].equals("PlaceableOnSponge")) {
                    this.placeableOnSponge = Boolean.parseBoolean(split[1]);
                } else if (split[0].equals("FloatOnWater")) {
                    this.floatOnWater = Boolean.parseBoolean(split[1]);
                } else if (split[0].equals("Boat")) {
                    this.placeableOnLand = false;
                    this.placeableOnWater = true;
                    this.floatOnWater = true;
                    this.wheelStepHeight = 0.0f;
                } else if (split[0].equals("Buoyancy")) {
                    this.buoyancy = Float.parseFloat(split[1]);
                } else if (split[0].equals("FloatOffset")) {
                    this.floatOffset = Float.parseFloat(split[1]);
                } else if (split[0].equals("CanMountEntity")) {
                    this.canMountEntity = Boolean.parseBoolean(split[1]);
                } else if (split[0].equals("Wheel") || split[0].equals("WheelPosition")) {
                    this.wheelPositions[Integer.parseInt((String)split[1])] = new DriveablePosition(new Vector3f(Float.parseFloat(split[2]) / 16.0f, Float.parseFloat(split[3]) / 16.0f, Float.parseFloat(split[4]) / 16.0f), split.length > 5 ? EnumDriveablePart.getPart(split[5]) : EnumDriveablePart.coreWheel);
                } else if (split[0].equals("WheelRadius") || split[0].equals("WheelStepHeight")) {
                    this.wheelStepHeight = Float.parseFloat(split[1]);
                } else if (split[0].equals("WheelSpringStrength") || split[0].equals("SpringStrength")) {
                    this.wheelSpringStrength = Float.parseFloat(split[1]);
                } else if (split[0].equals("TrackFrames")) {
                    this.animFrames = Integer.parseInt(split[1]) - 1;
                } else if (split[0].equals("Harvester")) {
                    this.harvestBlocks = Boolean.parseBoolean(split[1]);
                } else if (split[0].equals("CollectHarvest")) {
                    this.collectHarvest = Boolean.parseBoolean(split[1]);
                } else if (split[0].equals("DropHarvest")) {
                    this.dropHarvest = Boolean.parseBoolean(split[1]);
                } else if (split[0].equals("HarvestBox")) {
                    this.harvestBoxSize = new Vector3f(split[1], this.shortName);
                    this.harvestBoxPos = new Vector3f(split[2], this.shortName);
                } else if (split[0].equals("HarvestMaterial")) {
                    this.materialsHarvested.add(DriveableType.getMaterial(split[1]));
                } else if (split[0].equals("HarvestToolType")) {
                    switch (split[1]) {
                        case "Axe": {
                            this.materialsHarvested.add(Material.field_151575_d);
                            this.materialsHarvested.add(Material.field_151585_k);
                            this.materialsHarvested.add(Material.field_151582_l);
                            break;
                        }
                        case "Pickaxe": 
                        case "Drill": {
                            this.materialsHarvested.add(Material.field_151573_f);
                            this.materialsHarvested.add(Material.field_151574_g);
                            this.materialsHarvested.add(Material.field_151576_e);
                            break;
                        }
                        case "Spade": 
                        case "Shovel": 
                        case "Excavator": {
                            this.materialsHarvested.add(Material.field_151578_c);
                            this.materialsHarvested.add(Material.field_151577_b);
                            this.materialsHarvested.add(Material.field_151595_p);
                            this.materialsHarvested.add(Material.field_151597_y);
                            this.materialsHarvested.add(Material.field_151571_B);
                            break;
                        }
                        case "Hoe": 
                        case "Combine": {
                            this.materialsHarvested.add(Material.field_151585_k);
                            this.materialsHarvested.add(Material.field_151584_j);
                            this.materialsHarvested.add(Material.field_151582_l);
                            this.materialsHarvested.add(Material.field_151570_A);
                            this.materialsHarvested.add(Material.field_151572_C);
                            break;
                        }
                        case "Tank": {
                            this.materialsHarvested.add(Material.field_151584_j);
                            this.materialsHarvested.add(Material.field_151570_A);
                            this.materialsHarvested.add(Material.field_151575_d);
                            this.materialsHarvested.add(Material.field_151585_k);
                        }
                    }
                } else if (split[0].equals("CargoSlots")) {
                    this.numCargoSlots = Integer.parseInt(split[1]);
                } else if (split[0].equals("BombSlots") || split[0].equals("MineSlots")) {
                    this.numBombSlots = Integer.parseInt(split[1]);
                } else if (split[0].equals("MissileSlots") || split[0].equals("ShellSlots")) {
                    this.numMissileSlots = Integer.parseInt(split[1]);
                } else if (split[0].equals("FuelTankSize")) {
                    this.fuelTankSize = Integer.parseInt(split[1]);
                } else if (split[0].equals("EngineStartTime")) {
                    this.engineStartTime = Integer.parseInt(split[1]);
                } else if (split[0].equals("FilterAmmunitionInput")) {
                    this.filterAmmunition = Boolean.parseBoolean(split[1]);
                } else if (split[0].equals("BulletDetection")) {
                    this.bulletDetectionRadius = Integer.parseInt(split[1]);
                } else if (split[0].equals("AddAmmo")) {
                    this.ammo.add(BulletType.getBullet(split[1]));
                } else if (split[0].equals("AllowAllAmmo") || split[0].equals("AcceptAllAmmo")) {
                    this.acceptAllAmmo = Boolean.parseBoolean(split[1]);
                } else if (split[0].equals("Primary")) {
                    this.primary = EnumWeaponType.valueOf(split[1].toUpperCase());
                } else if (split[0].equals("Secondary")) {
                    this.secondary = EnumWeaponType.valueOf(split[1].toUpperCase());
                } else if (split[0].equals("ShootDelayPrimary")) {
                    this.shootDelayPrimary = Integer.parseInt(split[1]);
                } else if (split[0].equals("ShootDelaySecondary")) {
                    this.shootDelaySecondary = Integer.parseInt(split[1]);
                } else if (split[0].equals("DamageMultiplierPrimary")) {
                    this.damageMultiplierPrimary = Float.parseFloat(split[1]);
                } else if (split[0].equals("DamageMultiplierSecondary")) {
                    this.damageMultiplierSecondary = Float.parseFloat(split[1]);
                } else if (split[0].equals("RoundsPerMinPrimary")) {
                    this.shootDelayPrimary = Float.parseFloat(split[1]) < 1200.0f ? 1200.0f / Float.parseFloat(split[1]) : 1.0f;
                } else if (split[0].equals("RoundsPerMinSecondary")) {
                    this.shootDelaySecondary = Float.parseFloat(split[1]) < 1200.0f ? 1200.0f / Float.parseFloat(split[1]) : 1.0f;
                } else if (split[0].equals("PlaceTimePrimary")) {
                    this.placeTimePrimary = Integer.parseInt(split[1]);
                } else if (split[0].equals("PlaceTimeSecondary")) {
                    this.placeTimeSecondary = Integer.parseInt(split[1]);
                } else if (split[0].equals("ReloadTimePrimary")) {
                    this.reloadTimePrimary = Integer.parseInt(split[1]);
                } else if (split[0].equals("ReloadTimeSecondary")) {
                    this.reloadTimeSecondary = Integer.parseInt(split[1]);
                } else if (split[0].equals("AlternatePrimary")) {
                    this.alternatePrimary = Boolean.parseBoolean(split[1]);
                } else if (split[0].equals("AlternateSecondary")) {
                    this.alternateSecondary = Boolean.parseBoolean(split[1]);
                } else if (split[0].equals("ModePrimary")) {
                    this.modePrimary = EnumFireMode.valueOf(split[1].toUpperCase());
                } else if (split[0].equals("ModeSecondary")) {
                    this.modeSecondary = EnumFireMode.valueOf(split[1].toUpperCase());
                } else if (split[0].equals("BulletSpeed")) {
                    this.bulletSpeed = Float.parseFloat(split[1]);
                } else if (split[0].equals("BulletSpread")) {
                    this.bulletSpread = Float.parseFloat(split[1]);
                } else if (split[0].equals("RangingGun")) {
                    this.rangingGun = Boolean.parseBoolean(split[1]);
                } else if (split[0].equals("GunLength")) {
                    this.gunLength = Float.parseFloat(split[1]);
                } else if (split[0].equals("RecoilDistance")) {
                    this.recoilDist = Float.parseFloat(split[1]);
                } else if (split[0].equals("RecoilTime")) {
                    this.recoilTime = Float.parseFloat(split[1]);
                } else if (split[0].equals("ShootPointPrimary")) {
                    Vector3f offPos;
                    if (split.length == 9) {
                        gun = new String[]{split[0], split[1], split[2], split[3], split[4], split[5]};
                        offPos = new Vector3f(Float.parseFloat(split[6]) / 16.0f, Float.parseFloat(split[7]) / 16.0f, Float.parseFloat(split[8]) / 16.0f);
                    } else if (split.length == 8) {
                        gun = new String[]{split[0], split[1], split[2], split[3], split[4]};
                        offPos = new Vector3f(Float.parseFloat(split[5]) / 16.0f, Float.parseFloat(split[6]) / 16.0f, Float.parseFloat(split[7]) / 16.0f);
                    } else {
                        gun = split;
                        offPos = new Vector3f(0.0f, 0.0f, 0.0f);
                    }
                    rootPos = this.getShootPoint(gun);
                    sPoint = new ShootPoint(rootPos, offPos);
                    this.shootPointsPrimary.add(sPoint);
                    if (rootPos instanceof PilotGun) {
                        this.pilotGuns.add((PilotGun)sPoint.rootPos);
                    }
                } else if (split[0].equals("ShootPointSecondary")) {
                    Vector3f offPos;
                    if (split.length == 9) {
                        gun = new String[]{split[0], split[1], split[2], split[3], split[4], split[5]};
                        offPos = new Vector3f(Float.parseFloat(split[6]) / 16.0f, Float.parseFloat(split[7]) / 16.0f, Float.parseFloat(split[8]) / 16.0f);
                    } else if (split.length == 8) {
                        gun = new String[]{split[0], split[1], split[2], split[3], split[4]};
                        offPos = new Vector3f(Float.parseFloat(split[5]) / 16.0f, Float.parseFloat(split[6]) / 16.0f, Float.parseFloat(split[7]) / 16.0f);
                    } else {
                        gun = split;
                        offPos = new Vector3f(0.0f, 0.0f, 0.0f);
                    }
                    rootPos = this.getShootPoint(gun);
                    sPoint = new ShootPoint(rootPos, offPos);
                    this.shootPointsSecondary.add(sPoint);
                    if (rootPos instanceof PilotGun) {
                        this.pilotGuns.add((PilotGun)sPoint.rootPos);
                    }
                } else if (split[0].equals("EnableReloadTime")) {
                    this.enableReloadTime = Boolean.parseBoolean(split[1]);
                } else if (split[0].equals("ShootParticlesPrimary")) {
                    this.shootParticlesPrimary.add(new ShootParticle(split[1], Float.parseFloat(split[2]), Float.parseFloat(split[3]), Float.parseFloat(split[4])));
                } else if (split[0].equals("ShootParticlesSecondary")) {
                    this.shootParticlesSecondary.add(new ShootParticle(split[1], Float.parseFloat(split[2]), Float.parseFloat(split[3]), Float.parseFloat(split[4])));
                }
                if (split[0].equals("SetPlayerInvisible")) {
                    this.setPlayerInvisible = Boolean.parseBoolean(split[1].toLowerCase());
                }
                if (split[0].equals("IT1")) {
                    this.IT1 = Boolean.parseBoolean(split[1].toLowerCase());
                }
                if (split[0].equals("FixedPrimary")) {
                    this.fixedPrimaryFire = Boolean.parseBoolean(split[1].toLowerCase());
                }
                if (split[0].equals("PrimaryAngle")) {
                    this.primaryFireAngle = new Vector3f(Float.parseFloat(split[1]), Float.parseFloat(split[2]), Float.parseFloat(split[3]));
                } else if (split[0].equals("AddGun")) {
                    PilotGun pilotGun;
                    Vector3f offPos;
                    this.secondary = EnumWeaponType.GUN;
                    if (split.length == 6) {
                        rootPos = (PilotGun)this.getShootPoint(split);
                        offPos = new Vector3f(0.0f, 0.0f, 0.0f);
                        pilotGun = (PilotGun)this.getShootPoint(split);
                    } else {
                        String[] gun2 = new String[]{split[0], split[1], split[2], split[3], split[4], split[5]};
                        rootPos = (PilotGun)this.getShootPoint(gun2);
                        pilotGun = (PilotGun)this.getShootPoint(gun2);
                        offPos = new Vector3f(Float.parseFloat(split[6]) / 16.0f, Float.parseFloat(split[7]) / 16.0f, Float.parseFloat(split[8]) / 16.0f);
                    }
                    sPoint = new ShootPoint(rootPos, offPos);
                    this.shootPointsSecondary.add(sPoint);
                    this.pilotGuns.add(pilotGun);
                    this.driveableRecipe.add(new ItemStack(pilotGun.type.item));
                } else if (split[0].equals("BombPosition")) {
                    this.primary = EnumWeaponType.BOMB;
                    if (split.length == 4) {
                        this.shootPointsPrimary.add(new ShootPoint(new DriveablePosition(new Vector3f(Float.parseFloat(split[1]) / 16.0f, Float.parseFloat(split[2]) / 16.0f, Float.parseFloat(split[3]) / 16.0f), EnumDriveablePart.core), new Vector3f(0.0f, 0.0f, 0.0f)));
                    } else if (split.length == 7) {
                        this.shootPointsPrimary.add(new ShootPoint(new DriveablePosition(new Vector3f(Float.parseFloat(split[1]) / 16.0f, Float.parseFloat(split[2]) / 16.0f, Float.parseFloat(split[3]) / 16.0f), EnumDriveablePart.core), new Vector3f(Float.parseFloat(split[4]) / 16.0f, Float.parseFloat(split[5]) / 16.0f, Float.parseFloat(split[6]) / 16.0f)));
                    }
                } else if (split[0].equals("BarrelPosition")) {
                    this.primary = EnumWeaponType.SHELL;
                    if (split.length == 4) {
                        this.shootPointsPrimary.add(new ShootPoint(new DriveablePosition(new Vector3f(Float.parseFloat(split[1]) / 16.0f, Float.parseFloat(split[2]) / 16.0f, Float.parseFloat(split[3]) / 16.0f), EnumDriveablePart.turret), new Vector3f(0.0f, 0.0f, 0.0f)));
                    } else if (split.length == 7) {
                        this.shootPointsPrimary.add(new ShootPoint(new DriveablePosition(new Vector3f(Float.parseFloat(split[1]) / 16.0f, Float.parseFloat(split[2]) / 16.0f, Float.parseFloat(split[3]) / 16.0f), EnumDriveablePart.turret), new Vector3f(Float.parseFloat(split[4]) / 16.0f, Float.parseFloat(split[5]) / 16.0f, Float.parseFloat(split[6]) / 16.0f)));
                    }
                } else if (split[0].equals("ShootDelay")) {
                    this.shootDelaySecondary = Float.parseFloat(split[1]);
                } else if (split[0].equals("ShellDelay") || split[0].equals("BombDelay")) {
                    this.shootDelayPrimary = Float.parseFloat(split[1]);
                } else if (split[0].equals("AddRecipeParts")) {
                    part = EnumDriveablePart.getPart(split[1]);
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    for (int i = 0; i < (split.length - 2) / 2; ++i) {
                        int damage;
                        int amount = Integer.parseInt(split[2 * i + 2]);
                        boolean damaged = split[2 * i + 3].contains(".");
                        String itemName = damaged ? split[2 * i + 3].split("\\.")[0] : split[2 * i + 3];
                        ItemStack potentialPart = DriveableType.getRecipeElement(itemName, amount, damage = damaged ? Integer.parseInt(split[2 * i + 3].split("\\.")[1]) : 0, this.shortName);
                        if (potentialPart == null) continue;
                        stacks.add(potentialPart);
                        this.driveableRecipe.add(potentialPart);
                    }
                    ItemStack[] items = new ItemStack[stacks.size()];
                    items = stacks.toArray(items);
                    this.partwiseRecipe.put(part, items);
                } else if (split[0].equals("AddDye")) {
                    int amount = Integer.parseInt(split[1]);
                    int damage = -1;
                    for (int i = 0; i < ItemDye.field_150923_a.length; ++i) {
                        if (!ItemDye.field_150923_a[i].equals(split[2])) continue;
                        damage = i;
                    }
                    if (damage == -1) {
                        FlansMod.log("Failed to find dye colour : " + split[2] + " while adding " + file.name);
                        return;
                    }
                    this.driveableRecipe.add(new ItemStack(Items.field_151100_aR, amount, damage));
                } else if (split[0].equals("SetupPart")) {
                    part = EnumDriveablePart.getPart(split[1]);
                    CollisionBox box2 = split.length > 9 ? new CollisionBox(Integer.parseInt(split[2]), Integer.parseInt(split[3]), Integer.parseInt(split[4]), Integer.parseInt(split[5]), Integer.parseInt(split[6]), Integer.parseInt(split[7]), Integer.parseInt(split[8]), Float.parseFloat(split[9])) : new CollisionBox(Integer.parseInt(split[2]), Integer.parseInt(split[3]), Integer.parseInt(split[4]), Integer.parseInt(split[5]), Integer.parseInt(split[6]), Integer.parseInt(split[7]), Integer.parseInt(split[8]));
                    this.health.put(part, box2);
                } else if (split[0].equals("DriverPart")) {
                    this.seats[0].part = EnumDriveablePart.getPart(split[1]);
                } else if (split[0].equals("DriverGun") || split[0].equals("PilotGun")) {
                    this.seats[0].gunName = split[2];
                } else if (split[0].equals("DriverGunOrigin")) {
                    this.seats[0].gunOrigin = new Vector3f(Float.parseFloat(split[1]) / 16.0f, Float.parseFloat(split[2]) / 16.0f, Float.parseFloat(split[3]) / 16.0f);
                } else if (split[0].equals("RotatedDriverOffset")) {
                    this.seats[0].rotatedOffset = new Vector3f((float)Integer.parseInt(split[1]) / 16.0f, (float)Integer.parseInt(split[2]) / 16.0f, (float)Integer.parseInt(split[3]) / 16.0f);
                } else if (split[0].equals("RotatedPassengerOffset")) {
                    this.seats[Integer.parseInt((String)split[1])].rotatedOffset = new Vector3f((float)Integer.parseInt(split[2]) / 16.0f, (float)Integer.parseInt(split[3]) / 16.0f, (float)Integer.parseInt(split[4]) / 16.0f);
                } else if (split[0].equals("DriverAimSpeed")) {
                    this.seats[0].aimingSpeed = new Vector3f(Float.parseFloat(split[1]), Float.parseFloat(split[2]), Float.parseFloat(split[3]));
                } else if (split[0].equals("PassengerAimSpeed")) {
                    this.seats[Integer.parseInt((String)split[1])].aimingSpeed = new Vector3f(Float.parseFloat(split[2]), Float.parseFloat(split[3]), Float.parseFloat(split[4]));
                } else if (split[0].equals("DriverLegacyAiming")) {
                    this.seats[0].legacyAiming = Boolean.parseBoolean(split[1]);
                } else if (split[0].equals("PassengerLegacyAiming")) {
                    this.seats[Integer.parseInt((String)split[1])].legacyAiming = Boolean.parseBoolean(split[2]);
                } else if (split[0].equals("DriverYawBeforePitch")) {
                    this.seats[0].yawBeforePitch = Boolean.parseBoolean(split[1]);
                } else if (split[0].equals("PassengerYawBeforePitch")) {
                    this.seats[Integer.parseInt((String)split[1])].yawBeforePitch = Boolean.parseBoolean(split[2]);
                } else if (split[0].equals("DriverLatePitch")) {
                    this.seats[0].latePitch = Boolean.parseBoolean(split[1]);
                } else if (split[0].equals("PassengerLatePitch")) {
                    this.seats[Integer.parseInt((String)split[1])].latePitch = Boolean.parseBoolean(split[2]);
                } else if (split[0].equals("DriverTraverseSounds")) {
                    this.seats[0].traverseSounds = Boolean.parseBoolean(split[1]);
                } else if (split[0].equals("PassengerTraverseSounds")) {
                    this.seats[Integer.parseInt((String)split[1])].traverseSounds = Boolean.parseBoolean(split[2]);
                } else if (split[0].equals("GunOrigin")) {
                    this.seats[Integer.parseInt((String)split[1])].gunOrigin = new Vector3f(Float.parseFloat(split[2]) / 16.0f, Float.parseFloat(split[3]) / 16.0f, Float.parseFloat(split[4]) / 16.0f);
                } else if (split[0].equals("YOffset")) {
                    this.yOffset = Float.parseFloat(split[1]);
                } else if (split[0].equals("CameraDistance")) {
                    this.cameraDistance = Float.parseFloat(split[1]);
                } else if (split[0].equals("StartSoundRange")) {
                    this.startSoundRange = Integer.parseInt(split[1]);
                } else if (split[0].equals("StartSoundLength")) {
                    this.startSoundLength = Integer.parseInt(split[1]);
                } else if (split[0].equals("EngineSoundRange")) {
                    this.engineSoundRange = Integer.parseInt(split[1]);
                } else if (split[0].equals("EngineSoundLength")) {
                    this.engineSoundLength = Integer.parseInt(split[1]);
                } else if (split[0].equals("IdleSoundLength")) {
                    this.idleSoundLength = Integer.parseInt(split[1]);
                } else if (split[0].equals("ExitSoundLength")) {
                    this.exitSoundLength = Integer.parseInt(split[1]);
                } else if (split[0].equals("BackSoundRange")) {
                    this.backSoundRange = Integer.parseInt(split[1]);
                } else if (split[0].equals("BackSoundLength")) {
                    this.backSoundLength = Integer.parseInt(split[1]);
                } else if (split[0].equals("SoundTime")) {
                    this.soundTime = Integer.parseInt(split[1]);
                } else if (split[0].equals("YawSoundLength")) {
                    this.seats[0].yawSoundLength = Integer.parseInt(split[1]);
                } else if (split[0].equals("PitchSoundLength")) {
                    this.seats[0].pitchSoundLength = Integer.parseInt(split[1]);
                } else if (split[0].equals("PassengerYawSoundLength")) {
                    this.seats[Integer.parseInt((String)split[1])].yawSoundLength = Integer.parseInt(split[2]);
                } else if (split[0].equals("PassengerPitchSoundLength")) {
                    this.seats[Integer.parseInt((String)split[1])].pitchSoundLength = Integer.parseInt(split[2]);
                } else if (split[0].equals("StartSound")) {
                    this.startSound = split[1];
                    FlansMod.proxy.loadSound(this.contentPack, "driveables", split[1]);
                } else if (split[0].equals("EngineSound")) {
                    this.engineSound = split[1];
                    FlansMod.proxy.loadSound(this.contentPack, "driveables", split[1]);
                } else if (split[0].equals("IdleSound")) {
                    this.idleSound = split[1];
                    FlansMod.proxy.loadSound(this.contentPack, "driveables", split[1]);
                } else if (split[0].equals("ExitSound")) {
                    this.exitSound = split[1];
                    FlansMod.proxy.loadSound(this.contentPack, "driveables", split[1]);
                } else if (split[0].equals("BackSound")) {
                    this.backSound = split[1];
                    FlansMod.proxy.loadSound(this.contentPack, "driveables", split[1]);
                } else if (split[0].equals("YawSound")) {
                    this.seats[0].yawSound = split[1];
                    FlansMod.proxy.loadSound(this.contentPack, "driveables", split[1]);
                } else if (split[0].equals("PitchSound")) {
                    this.seats[0].pitchSound = split[1];
                    FlansMod.proxy.loadSound(this.contentPack, "driveables", split[1]);
                } else if (split[0].equals("PassengerYawSound")) {
                    this.seats[Integer.parseInt((String)split[1])].yawSound = split[2];
                    FlansMod.proxy.loadSound(this.contentPack, "driveables", split[1]);
                } else if (split[0].equals("PassengerPitchSound")) {
                    this.seats[Integer.parseInt((String)split[1])].pitchSound = split[2];
                    FlansMod.proxy.loadSound(this.contentPack, "driveables", split[1]);
                } else if (split[0].equals("ShootMainSound") || split[0].equals("ShootSoundPrimary") || split[0].equals("ShellSound") || split[0].equals("BombSound")) {
                    this.shootSoundPrimary = split[1];
                    FlansMod.proxy.loadSound(this.contentPack, "driveables", split[1]);
                } else if (split[0].equals("ShootReloadSound")) {
                    this.shootReloadSound = split[1];
                    FlansMod.proxy.loadSound(this.contentPack, "driveables", split[1]);
                } else if (split[0].equals("ShootSecondarySound") || split[0].equals("ShootSoundSecondary")) {
                    this.shootSoundSecondary = split[1];
                    FlansMod.proxy.loadSound(this.contentPack, "driveables", split[1]);
                } else if (split[0].equals("PlaceSoundPrimary")) {
                    this.placeSoundPrimary = split[1];
                    FlansMod.proxy.loadSound(this.contentPack, "driveables", split[1]);
                } else if (split[0].equals("PlaceSoundSecondary")) {
                    this.placeSoundSecondary = split[1];
                    FlansMod.proxy.loadSound(this.contentPack, "driveables", split[1]);
                } else if (split[0].equals("ReloadSoundPrimary")) {
                    this.reloadSoundPrimary = split[1];
                    FlansMod.proxy.loadSound(this.contentPack, "driveables", split[1]);
                } else if (split[0].equals("ReloadSoundSecondary")) {
                    this.reloadSoundSecondary = split[1];
                    FlansMod.proxy.loadSound(this.contentPack, "driveables", split[1]);
                } else if (split[0].equals("LockedOnSound")) {
                    this.lockedOnSound = split[1];
                    FlansMod.proxy.loadSound(this.contentPack, "driveables", split[1]);
                } else if (split[0].equals("LockOnSound")) {
                    this.lockOnSound = split[1];
                    FlansMod.proxy.loadSound(this.contentPack, "guns", split[1]);
                } else if (split[0].equals("LockingOnSound")) {
                    this.lockingOnSound = split[1];
                    FlansMod.proxy.loadSound(this.contentPack, "guns", split[1]);
                }
                if (split[0].equals("FlareSound")) {
                    this.flareSound = split[1];
                    FlansMod.proxy.loadSound(this.contentPack, "driveables", split[1]);
                }
                if (split[0].equals("FancyCollision")) {
                    this.fancyCollision = Boolean.parseBoolean(split[1]);
                }
                if (split[0].equals("AddCollisionMesh")) {
                    CollisionShapeBox box3 = new CollisionShapeBox(new Vector3f(split[1], this.shortName), new Vector3f(split[2], this.shortName), new Vector3f(split[3], this.shortName), new Vector3f(split[4], this.shortName), new Vector3f(split[5], this.shortName), new Vector3f(split[6], this.shortName), new Vector3f(split[7], this.shortName), new Vector3f(split[8], this.shortName), new Vector3f(split[9], this.shortName), new Vector3f(split[10], this.shortName), "core");
                    this.collisionBox.add(box3);
                }
                if (split[0].equals("AddCollisionMeshRaw")) {
                    Vector3f pos = new Vector3f(Float.parseFloat(split[1]), Float.parseFloat(split[2]), Float.parseFloat(split[3]));
                    Vector3f size = new Vector3f(Float.parseFloat(split[4]), Float.parseFloat(split[5]), Float.parseFloat(split[6]));
                    Vector3f p1 = new Vector3f(Float.parseFloat(split[8]), Float.parseFloat(split[9]), Float.parseFloat(split[10]));
                    p2 = new Vector3f(Float.parseFloat(split[11]), Float.parseFloat(split[12]), Float.parseFloat(split[13]));
                    Vector3f p3 = new Vector3f(Float.parseFloat(split[14]), Float.parseFloat(split[15]), Float.parseFloat(split[16]));
                    p4 = new Vector3f(Float.parseFloat(split[17]), Float.parseFloat(split[18]), Float.parseFloat(split[19]));
                    Vector3f p5 = new Vector3f(Float.parseFloat(split[20]), Float.parseFloat(split[21]), Float.parseFloat(split[22]));
                    p6 = new Vector3f(Float.parseFloat(split[23]), Float.parseFloat(split[24]), Float.parseFloat(split[25]));
                    p7 = new Vector3f(Float.parseFloat(split[26]), Float.parseFloat(split[27]), Float.parseFloat(split[28]));
                    p8 = new Vector3f(Float.parseFloat(split[29]), Float.parseFloat(split[30]), Float.parseFloat(split[31]));
                    box = new CollisionShapeBox(pos, size, p1, p2, p3, p4, p5, p6, p7, p8, "core");
                    this.collisionBox.add(box);
                }
                if (split[0].equals("AddTurretCollisionMesh")) {
                    CollisionShapeBox box4 = new CollisionShapeBox(new Vector3f(split[1], this.shortName), new Vector3f(split[2], this.shortName), new Vector3f(split[3], this.shortName), new Vector3f(split[4], this.shortName), new Vector3f(split[5], this.shortName), new Vector3f(split[6], this.shortName), new Vector3f(split[7], this.shortName), new Vector3f(split[8], this.shortName), new Vector3f(split[9], this.shortName), new Vector3f(split[10], this.shortName), "turret");
                    this.collisionBox.add(box4);
                }
                if (split[0].equals("AddTurretCollisionMeshRaw")) {
                    Vector3f pos = new Vector3f(Float.parseFloat(split[1]), Float.parseFloat(split[2]), Float.parseFloat(split[3]));
                    Vector3f size = new Vector3f(Float.parseFloat(split[4]), Float.parseFloat(split[5]), Float.parseFloat(split[6]));
                    Vector3f p1 = new Vector3f(Float.parseFloat(split[8]), Float.parseFloat(split[9]), Float.parseFloat(split[10]));
                    p2 = new Vector3f(Float.parseFloat(split[11]), Float.parseFloat(split[12]), Float.parseFloat(split[13]));
                    Vector3f p3 = new Vector3f(Float.parseFloat(split[14]), Float.parseFloat(split[15]), Float.parseFloat(split[16]));
                    p4 = new Vector3f(Float.parseFloat(split[17]), Float.parseFloat(split[18]), Float.parseFloat(split[19]));
                    Vector3f p5 = new Vector3f(Float.parseFloat(split[20]), Float.parseFloat(split[21]), Float.parseFloat(split[22]));
                    p6 = new Vector3f(Float.parseFloat(split[23]), Float.parseFloat(split[24]), Float.parseFloat(split[25]));
                    p7 = new Vector3f(Float.parseFloat(split[26]), Float.parseFloat(split[27]), Float.parseFloat(split[28]));
                    p8 = new Vector3f(Float.parseFloat(split[29]), Float.parseFloat(split[30]), Float.parseFloat(split[31]));
                    box = new CollisionShapeBox(pos, size, p1, p2, p3, p4, p5, p6, p7, p8, "turret");
                    this.collisionBox.add(box);
                }
                if (split[0].equals("LeftLinkPoint")) {
                    this.leftTrackPoints.add(new Vector3f(split[1], this.shortName));
                }
                if (split[0].equals("RightLinkPoint")) {
                    this.rightTrackPoints.add(new Vector3f(split[1], this.shortName));
                }
                if (split[0].equals("TrackLinkLength")) {
                    this.trackLinkLength = Float.parseFloat(split[1]);
                } else if (split[0].equals("OnRadar")) {
                    this.onRadar = split[1].equals("True");
                } else if (split[0].equalsIgnoreCase("AddParticle") || split[0].equalsIgnoreCase("AddEmitter")) {
                    ParticleEmitter emitter = new ParticleEmitter();
                    emitter.effectType = split[1];
                    emitter.emitRate = Integer.parseInt(split[2]);
                    emitter.origin = new Vector3f(split[3], this.shortName);
                    emitter.extents = new Vector3f(split[4], this.shortName);
                    emitter.velocity = new Vector3f(split[5], this.shortName);
                    emitter.minThrottle = Float.parseFloat(split[6]);
                    emitter.maxThrottle = Float.parseFloat(split[7]);
                    emitter.minHealth = Float.parseFloat(split[8]);
                    emitter.maxHealth = Float.parseFloat(split[9]);
                    emitter.part = split[10];
                    emitter.origin.scale(0.0625f);
                    emitter.extents.scale(0.0625f);
                    emitter.velocity.scale(0.0625f);
                    this.emitters.add(emitter);
                }
            }
            catch (Exception e) {
                if (split != null) {
                    StringBuilder msg = new StringBuilder(" : ");
                    for (String s : split) {
                        msg.append(" ").append(s);
                    }
                    FlansMod.log("Errored reading " + file.name + msg);
                } else {
                    FlansMod.log("Errored reading " + file.name);
                }
                if (!FlansMod.printStackTrace) break block362;
                e.printStackTrace();
            }
        }
    }

    private DriveablePosition getShootPoint(String[] split) {
        if (split.length == 6) {
            return new PilotGun(split);
        }
        if (split.length == 5) {
            return new DriveablePosition(split);
        }
        return new DriveablePosition(new Vector3f(), EnumDriveablePart.core);
    }

    public ArrayList<ShootPoint> shootPoints(boolean s) {
        return s ? this.shootPointsSecondary : this.shootPointsPrimary;
    }

    public boolean alternate(boolean s) {
        return s ? this.alternateSecondary : this.alternatePrimary;
    }

    public EnumWeaponType weaponType(boolean s) {
        return s ? this.secondary : this.primary;
    }

    public float shootDelay(boolean s) {
        return s ? this.shootDelaySecondary : this.shootDelayPrimary;
    }

    public String shootSound(boolean s) {
        return s ? this.shootSoundSecondary : this.shootSoundPrimary;
    }

    public ArrayList<ShootParticle> shootParticle(boolean s) {
        return s ? this.shootParticlesSecondary : this.shootParticlesPrimary;
    }

    public int numEngines() {
        return 1;
    }

    public int ammoSlots() {
        return this.numPassengerGunners + this.pilotGuns.size();
    }

    public boolean isValidAmmo(BulletType bulletType, EnumWeaponType weaponType) {
        return (this.acceptAllAmmo || this.ammo.contains(bulletType)) && bulletType.weaponType == weaponType;
    }

    public ArrayList<ItemStack> getItemsRequired(DriveablePart part, PartType engine) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (this.partwiseRecipe.get((Object)part.type) != null) {
            for (ItemStack itemStack : this.partwiseRecipe.get((Object)part.type)) {
                if (itemStack != null) {
                    stacks.add(itemStack.func_77946_l());
                    continue;
                }
                FlansMod.log("Failed to drop item on death of part [%s] on vehicle [%s]", part.type.getShortName(), this.name);
            }
        }
        for (PilotGun gun : this.pilotGuns) {
            if (gun.part != part.type) continue;
            stacks.add(new ItemStack(gun.type.item));
        }
        for (Seat seat : this.seats) {
            if (seat == null || seat.part != part.type || seat.gunType == null) continue;
            stacks.add(new ItemStack(seat.gunType.item));
        }
        return stacks;
    }

    public static DriveableType getDriveable(String find) {
        for (DriveableType type : types) {
            if (!type.shortName.equals(find)) continue;
            return type;
        }
        return null;
    }

    @Override
    public float GetRecommendedScale() {
        return 100.0f / this.cameraDistance;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBase GetModel() {
        return this.model;
    }

    public class ParticleEmitter {
        public String effectType;
        public int emitRate;
        public Vector3f origin;
        public Vector3f extents;
        public Vector3f velocity;
        public float minThrottle;
        public float maxThrottle;
        public String part;
        public float minHealth;
        public float maxHealth;
    }

    public class ShootParticle {
        float x;
        float y;
        float z;
        String name;

        public ShootParticle(String s, float x1, float y1, float z1) {
            this.x = x1;
            this.y = y1;
            this.z = z1;
            this.name = s;
        }
    }
}

