/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.terrain.enhancedbiomes;

import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.gen.terrain.BumpyHillsEffect;
import rtg.world.gen.terrain.GroundEffect;
import rtg.world.gen.terrain.HeightEffect;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.VariableRuggednessEffect;

public class TerrainEBShield
extends TerrainBase {
    private float rollHeight = 10.0f;
    private float hillWidth = 40.0f;
    private float hillHeight = 40.0f;
    private float baseHeight = 66.0f;
    private HeightEffect height;

    public TerrainEBShield() {
        BumpyHillsEffect intermittentHills = new BumpyHillsEffect();
        intermittentHills.hillHeight = this.rollHeight;
        intermittentHills.hillWavelength = VariableRuggednessEffect.STANDARD_RUGGEDNESS_WAVELENGTH;
        intermittentHills.hillOctave = VariableRuggednessEffect.STANDARD_RUGGEDNESS_OCTAVE;
        intermittentHills.spikeHeight = this.hillHeight;
        intermittentHills.spikeWavelength = this.hillWidth;
        this.height = intermittentHills.plus(new GroundEffect(4.0f));
    }

    @Override
    public float generateNoise(OpenSimplexNoise simplex, CellNoise cell, int x, int y, float border, float river) {
        return TerrainEBShield.riverized(this.height.added(simplex, cell, x, y) + this.baseHeight, river);
    }
}

