/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.terrain.enhancedbiomes;

import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.gen.terrain.GroundEffect;
import rtg.world.gen.terrain.HeightEffect;
import rtg.world.gen.terrain.HeightVariation;
import rtg.world.gen.terrain.JitterEffect;
import rtg.world.gen.terrain.RaiseEffect;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.VariableRuggednessEffect;

public class TerrainEBKakadu
extends TerrainBase {
    private float minHeight = 65.0f;
    private float mesaWavelength = 80.0f;
    private float hillStrength = 10.0f;
    private float topBumpinessHeight = 3.0f;
    private float topBumpinessWavelength = 15.0f;
    private HeightEffect height;
    private HeightEffect groundEffect = new GroundEffect(5.0f);
    private float jitterAmplitude = 6.0f;
    private float jitterWavelength = 15.0f;

    public TerrainEBKakadu() {
        HeightVariation topVariation = new HeightVariation();
        topVariation.height = this.hillStrength;
        topVariation.octave = 1;
        topVariation.wavelength = VariableRuggednessEffect.STANDARD_RUGGEDNESS_WAVELENGTH;
        HeightVariation topBumpiness = new HeightVariation();
        topBumpiness.height = this.topBumpinessHeight;
        topBumpiness.wavelength = this.topBumpinessWavelength;
        topBumpiness.octave = 3;
        this.height = new VariableRuggednessEffect(new RaiseEffect(0.0f), topVariation.plus(topBumpiness).plus(new RaiseEffect(this.hillStrength)), 0.2f, 0.2f, this.mesaWavelength);
        this.height = new JitterEffect(this.jitterAmplitude, this.jitterWavelength, this.height);
    }

    @Override
    public float generateNoise(OpenSimplexNoise simplex, CellNoise cell, int x, int y, float border, float river) {
        return TerrainEBKakadu.riverized(this.minHeight + this.groundEffect.added(simplex, cell, x, y) + this.height.added(simplex, cell, x, y), river);
    }
}

