/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.terrain.enhancedbiomes;

import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.gen.terrain.BlendedHillEffect;
import rtg.world.gen.terrain.HeightEffect;
import rtg.world.gen.terrain.HeightVariation;
import rtg.world.gen.terrain.JitterEffect;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.VariableRuggednessEffect;

public class TerrainEBCarr
extends TerrainBase {
    private HeightEffect height;

    public TerrainEBCarr() {
        this.base = 62.5f;
        HeightVariation waterLand = new HeightVariation();
        waterLand.height = 3.0f;
        waterLand.wavelength = 30.0f;
        waterLand.octave = VariableRuggednessEffect.STANDARD_RUGGEDNESS_OCTAVE;
        this.height = new JitterEffect(15.0f, 30.0f, waterLand);
        this.height = new JitterEffect(5.0f, 10.0f, this.height);
        BlendedHillEffect intermittentHills = new BlendedHillEffect();
        intermittentHills.height = 10.0f;
        intermittentHills.hillBottomSimplexValue = 0.5f;
        intermittentHills.wavelength = 80.0f;
        JitterEffect jitteredHills = new JitterEffect(5.0f, 15.0f, intermittentHills);
        this.height = this.height.plus(jitteredHills);
    }

    @Override
    public float generateNoise(OpenSimplexNoise simplex, CellNoise cell, int x, int y, float border, float river) {
        return TerrainEBCarr.riverized(this.base + this.height.added(simplex, cell, x, y), river);
    }
}

