/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.surface.highlands;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import rtg.api.biome.BiomeConfig;
import rtg.util.CellNoise;
import rtg.util.CliffCalculator;
import rtg.util.OpenSimplexNoise;
import rtg.world.gen.surface.SurfaceBase;

public class SurfaceHLDunes
extends SurfaceBase {
    public SurfaceHLDunes(BiomeConfig config, Block top, Block fill) {
        super(config, top, (byte)0, fill, (byte)0);
    }

    @Override
    public void paintTerrain(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, OpenSimplexNoise simplex, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        boolean water = false;
        boolean riverPaint = false;
        boolean grass = false;
        if (river > 0.05f && river + simplex.noise2((float)i / 10.0f, (float)j / 10.0f) * 0.1f > 0.86f) {
            riverPaint = true;
            if (simplex.noise2((float)i / 12.0f, (float)j / 12.0f) > 0.25f) {
                grass = true;
            }
        }
        for (int k = 255; k > -1; --k) {
            Block b = blocks[(y * 16 + x) * 256 + k];
            if (b == Blocks.field_150350_a) {
                depth = -1;
                continue;
            }
            if (b != Blocks.field_150348_b) continue;
            ++depth;
            if (riverPaint) {
                if (grass && depth < 4) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150349_c;
                    continue;
                }
                if (depth != 0) continue;
                blocks[(y * 16 + x) * 256 + k] = rand.nextInt(2) == 0 ? Blocks.field_150354_m : Blocks.field_150322_A;
                continue;
            }
            if (depth <= -1 || depth >= 9) continue;
            if (depth > 4) {
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150322_A;
                continue;
            }
            float c = CliffCalculator.calc(x, y, noise);
            if ((double)c < 0.8) {
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150354_m;
                continue;
            }
            if ((double)c > 4.4 + (double)(simplex.octave(4).noise2((float)x / 20.0f, (float)y / 20.0f) * 2.0f)) {
                blocks[(y * 16 + x) * 256 + k] = this.getShadowDesertBlock(world, i, j, x, y, k);
                metadata[(y * 16 + x) * 256 + k] = this.getShadowDesertMeta(world, i, j, x, y, k);
                continue;
            }
            if ((double)c > 1.4) {
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150322_A;
                metadata[(y * 16 + x) * 256 + k] = 2;
                continue;
            }
            blocks[(y * 16 + x) * 256 + k] = Blocks.field_150322_A;
        }
    }
}

