/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.feature.tree.rtg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import rtg.world.gen.feature.tree.rtg.TreeRTG;

public class TreeRTGPinusPonderosa
extends TreeRTG {
    public TreeRTGPinusPonderosa() {
        this.validGroundBlocks = new ArrayList<Block>(Arrays.asList(Blocks.field_150349_c, Blocks.field_150346_d));
    }

    @Override
    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int i;
        int startY = y;
        Block g = world.func_147439_a(x, y - 1, z);
        boolean validGroundBlock = false;
        for (i = 0; i < this.validGroundBlocks.size(); ++i) {
            if (g != this.validGroundBlocks.get(i)) continue;
            validGroundBlock = true;
            break;
        }
        if (!validGroundBlock) {
            return false;
        }
        this.buildTrunk(world, rand, x + 1, y, z);
        this.buildTrunk(world, rand, x - 1, y, z);
        this.buildTrunk(world, rand, x, y, z + 1);
        this.buildTrunk(world, rand, x, y, z - 1);
        for (i = 0; i < this.trunkSize; ++i) {
            world.func_147465_d(x, y, z, this.logBlock, (int)this.logMeta, this.generateFlag);
            if (i > 5 && rand.nextInt(7) == 0) {
                int dX = -1 + rand.nextInt(3);
                int dZ = -1 + rand.nextInt(3);
                if (dX == 0 && dZ == 0) {
                    dX = -1 + rand.nextInt(3);
                    dZ = -1 + rand.nextInt(3);
                }
                this.buildBranch(world, rand, x, y, z, dX, dZ, 1, 1);
            }
            ++y;
        }
        int pX = 0;
        int pZ = 0;
        for (i = 0; i < this.crownSize; ++i) {
            if (rand.nextInt(i < this.crownSize - 12 && i > 2 ? 2 : 1) == 0 && i < this.crownSize - 2) {
                int dX = -1 + rand.nextInt(3);
                int dZ = -1 + rand.nextInt(3);
                if (dX == 0 && dZ == 0) {
                    dX = -1 + rand.nextInt(3);
                    dZ = -1 + rand.nextInt(3);
                }
                if (pX == dX && rand.nextBoolean()) {
                    dX = -dX;
                }
                if (pZ == dZ && rand.nextBoolean()) {
                    dZ = -dZ;
                }
                pX = dX;
                pZ = dZ;
                this.buildBranch(world, rand, x, y, z, dX, dZ, i < this.crownSize - 12 && i > 3 ? 3 : (i < this.crownSize - 8 ? 2 : 1), i < this.crownSize - 5 ? 2 : 1);
            }
            world.func_147465_d(x, y, z, this.logBlock, (int)this.logMeta, this.generateFlag);
            if (i < this.crownSize - 2) {
                if (rand.nextBoolean()) {
                    this.buildLeaves(world, x, y, z + 1);
                }
                if (rand.nextBoolean()) {
                    this.buildLeaves(world, x, y, z - 1);
                }
                if (rand.nextBoolean()) {
                    this.buildLeaves(world, x + 1, y, z);
                }
                if (rand.nextBoolean()) {
                    this.buildLeaves(world, x - 1, y, z);
                }
            }
            ++y;
        }
        this.buildLeaves(world, x, y - 1, z + 1);
        this.buildLeaves(world, x, y - 1, z - 1);
        this.buildLeaves(world, x + 1, y - 1, z);
        this.buildLeaves(world, x - 1, y - 1, z);
        this.buildLeaves(world, x, y, z);
        return true;
    }

    @Override
    public void buildTrunk(World world, Random rand, int x, int y, int z) {
        int h = (int)Math.ceil((float)this.trunkSize / 4.0f);
        h += rand.nextInt(h * 2);
        for (int i = -1; i < h; ++i) {
            world.func_147465_d(x, y + i, z, this.logBlock, this.logMeta + 12, this.generateFlag);
        }
    }

    @Override
    public void buildBranch(World world, Random rand, int x, int y, int z, int dX, int dZ, int logLength, int leaveSize) {
        if (logLength == 3 && Math.abs(dX) + Math.abs(dZ) == 2) {
            --logLength;
        }
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = 0; k < 2; ++k) {
                    if (Math.abs(i) + Math.abs(j) + Math.abs(k) >= leaveSize + 1) continue;
                    this.buildLeaves(world, x + i + dX * logLength, y + k, z + j + dZ * logLength);
                }
            }
        }
        for (int m = 1; m <= logLength; ++m) {
            world.func_147465_d(x + dX * m, y, z + dZ * m, this.logBlock, (int)this.logMeta, this.generateFlag);
        }
    }

    @Override
    public void buildLeaves(World world, int x, int y, int z) {
        Block b;
        if (!this.noLeaves && (b = world.func_147439_a(x, y, z)).func_149688_o() == Material.field_151579_a) {
            world.func_147465_d(x, y, z, this.leavesBlock, (int)this.leavesMeta, this.generateFlag);
        }
    }
}

