/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.MapGenRavine;
import net.minecraft.world.gen.feature.WorldGenLiquids;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.ChunkProviderEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.event.world.ChunkEvent;
import rtg.config.rtg.ConfigRTG;
import rtg.util.AICWrapper;
import rtg.util.Acceptor;
import rtg.util.Accessor;
import rtg.util.CanyonColour;
import rtg.util.CellNoise;
import rtg.util.Compass;
import rtg.util.Converter;
import rtg.util.Direction;
import rtg.util.LimitedMap;
import rtg.util.LimitedSet;
import rtg.util.OpenSimplexNoise;
import rtg.util.PlaneLocation;
import rtg.util.SimplexCellularNoise;
import rtg.util.TimeTracker;
import rtg.util.TimedHashSet;
import rtg.world.WorldTypeRTG;
import rtg.world.biome.BiomeAnalyzer;
import rtg.world.biome.RTGBiomeProvider;
import rtg.world.biome.WorldChunkManagerRTG;
import rtg.world.biome.realistic.RealisticBiomeBase;
import rtg.world.biome.realistic.RealisticBiomePatcher;
import rtg.world.gen.ChunkLandscape;
import rtg.world.gen.LandscapeGenerator;
import rtg.world.gen.MapGenCavesRTG;
import rtg.world.gen.MapGenRavineRTG;

public class ChunkProviderRTG
implements IChunkProvider {
    private final MapGenBase caveGenerator;
    private final MapGenBase ravineGenerator;
    private final MapGenStronghold strongholdGenerator;
    private final MapGenMineshaft mineshaftGenerator;
    private final MapGenVillage villageGenerator;
    private final MapGenScatteredFeature scatteredFeatureGenerator;
    private boolean mapFeaturesEnabled;
    private final int worldHeight;
    private final boolean isRTGWorld;
    private final int sampleSize = 8;
    private final int sampleArraySize;
    private BiomeAnalyzer analyzer = new BiomeAnalyzer();
    private int[] xyinverted = this.analyzer.xyinverted();
    private Block bedrockBlock = (Block)GameData.getBlockRegistry().func_82594_a(ConfigRTG.bedrockBlockId);
    private byte bedrockByte = (byte)ConfigRTG.bedrockBlockByte;
    private Random rand;
    private Random mapRand;
    private World worldObj;
    protected RTGBiomeProvider cmr;
    private final LandscapeGenerator landscapeGenerator;
    private OpenSimplexNoise simplex;
    private CellNoise cell;
    private BiomeGenBase[] baseBiomesList;
    private int[] biomeData;
    private float[] testHeight;
    private boolean[] biomesGeneratedInChunk;
    private float[] borderNoise;
    private float[][] weightings;
    private long worldSeed;
    private RealisticBiomePatcher biomePatcher;
    private HashMap<PlaneLocation, Chunk> inGeneration = new HashMap();
    private HashSet<PlaneLocation> toCheck = new HashSet();
    private static String rtgTerrain = "RTG Terrain";
    private static String rtgNoise = "RTG Noise";
    private AICWrapper aic;
    private boolean isAICExtendingBiomeIdsLimit;
    private Set<Long> serverLoadingChunks;
    public final Acceptor<ChunkEvent.Load> delayedDecorator = new Acceptor<ChunkEvent.Load>(){

        @Override
        public void accept(ChunkEvent.Load accepted) {
            if (accepted.isCanceled()) {
                return;
            }
            int cx = accepted.getChunk().field_76635_g;
            int cy = accepted.getChunk().field_76647_h;
            PlaneLocation.Invariant location = new PlaneLocation.Invariant(cx, cy);
            if (!ChunkProviderRTG.this.toCheck.contains(location)) {
                return;
            }
            ChunkProviderRTG.this.toCheck.remove(location);
            for (Direction forPopulation : ChunkProviderRTG.this.directions) {
                ChunkProviderRTG.this.decorateIfOtherwiseSurrounded(ChunkProviderRTG.this.worldObj.func_72863_F(), location, forPopulation);
            }
        }
    };
    Accessor<ChunkProviderServer, Set<Long>> forServerLoadingChunks = new Accessor("loadingChunks");
    private Compass compass = new Compass();
    ArrayList<Direction> directions = this.compass.directions();
    private TimedHashSet<PlaneLocation> chunkMade = new TimedHashSet(5000);
    private final LimitedMap<PlaneLocation, Chunk> availableChunks;
    private static final int centerLocationIndex = 312;
    public static String firstBlock;
    public static String biomeLayoutActivity;
    private PlaneLocation.Probe probe = new PlaneLocation.Probe(0, 0);
    private boolean populating = false;
    private static ChunkProviderRTG populatingProvider;
    private final HashSet<PlaneLocation> toDecorate = new HashSet();
    private LimitedSet<PlaneLocation> alreadyDecorated = new LimitedSet(1000);
    private AnvilChunkLoader chunkLoader;

    public ChunkProviderRTG(World world, long l) {
        this.worldObj = world;
        this.cmr = (WorldChunkManagerRTG)this.worldObj.func_72959_q();
        this.worldHeight = this.worldObj.field_73011_w.getActualHeight();
        this.rand = new Random(l);
        this.simplex = new OpenSimplexNoise(l);
        this.cell = new SimplexCellularNoise(l);
        this.landscapeGenerator = new LandscapeGenerator(this.simplex, this.cell);
        this.mapRand = new Random(l);
        this.worldSeed = l;
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("size", "0");
        m.put("distance", "24");
        this.mapFeaturesEnabled = world.func_72912_H().func_76089_r();
        this.isRTGWorld = world.func_72912_H().func_76067_t() instanceof WorldTypeRTG;
        this.caveGenerator = this.isRTGWorld && ConfigRTG.enableCaveModifications ? TerrainGen.getModdedMapGen((MapGenBase)new MapGenCavesRTG(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE) : TerrainGen.getModdedMapGen((MapGenBase)new MapGenCaves(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
        this.ravineGenerator = this.isRTGWorld && ConfigRTG.enableRavineModifications ? TerrainGen.getModdedMapGen((MapGenBase)new MapGenRavineRTG(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.RAVINE) : TerrainGen.getModdedMapGen((MapGenBase)new MapGenRavine(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.RAVINE);
        this.villageGenerator = (MapGenVillage)TerrainGen.getModdedMapGen((MapGenBase)new MapGenVillage(m), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.VILLAGE);
        this.strongholdGenerator = (MapGenStronghold)TerrainGen.getModdedMapGen((MapGenBase)new MapGenStronghold(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.STRONGHOLD);
        this.mineshaftGenerator = (MapGenMineshaft)TerrainGen.getModdedMapGen((MapGenBase)new MapGenMineshaft(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.MINESHAFT);
        this.scatteredFeatureGenerator = (MapGenScatteredFeature)TerrainGen.getModdedMapGen((MapGenBase)new MapGenScatteredFeature(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.SCATTERED_FEATURE);
        CanyonColour.init(l);
        this.sampleArraySize = 21;
        this.baseBiomesList = new BiomeGenBase[256];
        this.biomeData = new int[this.sampleArraySize * this.sampleArraySize];
        this.testHeight = new float[256];
        this.biomesGeneratedInChunk = new boolean[256];
        this.borderNoise = new float[256];
        this.biomePatcher = new RealisticBiomePatcher();
        this.aic = new AICWrapper();
        this.isAICExtendingBiomeIdsLimit = this.aic.isAICExtendingBiomeIdsLimit();
        this.availableChunks = new LimitedMap(1000);
        this.setWeightings();
        if (this.worldObj == null) {
            throw new RuntimeException("Attempt to create chunk provider without a world");
        }
    }

    private void setWeightings() {
        this.weightings = new float[this.sampleArraySize * this.sampleArraySize][256];
        int adjustment = 4;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int locationIndex = (i + adjustment) * 25 + (j + adjustment);
                TimeTracker.manager.start("Weighting");
                float totalWeight = 0.0f;
                float limit = (float)Math.pow(3136.0, 0.7);
                for (int mapX = 0; mapX < this.sampleArraySize; ++mapX) {
                    for (int mapZ = 0; mapZ < this.sampleArraySize; ++mapZ) {
                        float yDist;
                        float xDist = i - this.chunkCoordinate(mapX);
                        float distanceSquared = xDist * xDist + (yDist = (float)(j - this.chunkCoordinate(mapZ))) * yDist;
                        float distance = (float)Math.pow(distanceSquared, 0.7);
                        float weight = 1.0f - distance / limit;
                        if (weight < 0.0f) {
                            weight = 0.0f;
                        }
                        this.weightings[mapX * this.sampleArraySize + mapZ][i * 16 + j] = weight;
                    }
                }
            }
        }
    }

    public void isFakeGenerator() {
        this.mapFeaturesEnabled = false;
    }

    public Chunk func_73154_d(int cx, int cy) {
        int k;
        Chunk available;
        PlaneLocation.Invariant chunkLocation = new PlaneLocation.Invariant(cx, cy);
        if (this.inGeneration.containsKey(chunkLocation)) {
            return this.inGeneration.get(chunkLocation);
        }
        if (this.chunkMade.contains(chunkLocation) && (available = this.availableChunks.get(chunkLocation)) != null) {
            List[] entityLists = available.field_76645_j;
            for (int i = 0; i < entityLists.length; ++i) {
                Iterator iterator = entityLists[i].iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                    iterator.remove();
                }
                this.worldObj.func_72828_b(entityLists[i]);
            }
            this.toCheck.add(chunkLocation);
            return available;
        }
        TimeTracker.manager.start(rtgTerrain);
        this.rand.setSeed((long)cx * 341873128712L + (long)cy * 132897987541L);
        Block[] blocks = new Block[65536];
        byte[] metadata = new byte[65536];
        ChunkLandscape landscape = this.landscapeGenerator.landscape(this.cmr, cx * 16, cy * 16);
        this.generateTerrain(this.cmr, cx, cy, blocks, metadata, landscape.biome, landscape.noise);
        for (int ci = 0; ci < 256; ++ci) {
            this.biomesGeneratedInChunk[landscape.biome[ci].baseBiome.field_76756_M] = true;
        }
        for (k = 0; k < 256; ++k) {
            if (this.biomesGeneratedInChunk[k]) {
                RealisticBiomeBase.getBiome(k).generateMapGen(blocks, metadata, this.worldSeed, this.worldObj, this.cmr, this.mapRand, cx, cy, this.simplex, this.cell, landscape.noise);
                this.biomesGeneratedInChunk[k] = false;
            }
            try {
                this.baseBiomesList[k] = landscape.biome[k].baseBiome;
                continue;
            }
            catch (Exception e) {
                this.baseBiomesList[k] = this.biomePatcher.getPatchedBaseBiome("" + landscape.biome[k].baseBiome.field_76756_M);
            }
        }
        this.replaceBlocksForBiome(cx, cy, blocks, metadata, landscape.biome, this.baseBiomesList, landscape.noise);
        this.caveGenerator.func_151539_a((IChunkProvider)this, this.worldObj, cx, cy, blocks);
        this.ravineGenerator.func_151539_a((IChunkProvider)this, this.worldObj, cx, cy, blocks);
        if (this.mapFeaturesEnabled) {
            if (ConfigRTG.generateMineshafts) {
                this.mineshaftGenerator.func_151539_a((IChunkProvider)this, this.worldObj, cx, cy, blocks);
            }
            if (ConfigRTG.generateStrongholds) {
                this.strongholdGenerator.func_151539_a((IChunkProvider)this, this.worldObj, cx, cy, blocks);
            }
            if (ConfigRTG.generateVillages) {
                if (ConfigRTG.villageCrashFix) {
                    try {
                        this.villageGenerator.func_151539_a((IChunkProvider)this, this.worldObj, cx, cy, blocks);
                    }
                    catch (Exception e) {}
                } else {
                    this.villageGenerator.func_151539_a((IChunkProvider)this, this.worldObj, cx, cy, blocks);
                }
            }
            if (ConfigRTG.generateScatteredFeatures) {
                this.scatteredFeatureGenerator.func_151539_a((IChunkProvider)this, this.worldObj, cx, cy, blocks);
            }
        }
        Chunk chunk = new Chunk(this.worldObj, blocks, metadata, cx, cy);
        this.inGeneration.put(chunkLocation, chunk);
        if (this.isAICExtendingBiomeIdsLimit) {
            this.aic.setBiomeArray(chunk, this.baseBiomesList, this.xyinverted);
        } else {
            byte[] abyte1 = chunk.func_76605_m();
            for (k = 0; k < abyte1.length; ++k) {
                byte b;
                abyte1[k] = b = (byte)this.baseBiomesList[this.xyinverted[k]].field_76756_M;
            }
            chunk.func_76616_a(abyte1);
        }
        chunk.func_76603_b();
        this.toCheck.add(chunkLocation);
        this.inGeneration.remove(chunkLocation);
        this.chunkMade.add(chunkLocation);
        this.availableChunks.put(chunkLocation, chunk);
        TimeTracker.manager.stop(rtgTerrain);
        return chunk;
    }

    public void decorateIfOtherwiseSurrounded(IChunkProvider world, PlaneLocation source, Direction fromNewChunk) {
        if (WorldTypeRTG.chunkProvider != this) {
            return;
        }
        int cx = source.x() + fromNewChunk.xOffset;
        int cy = source.z() + fromNewChunk.zOffset;
        this.probe.setX(cx);
        this.probe.setZ(cy);
        if (this.alreadyDecorated.contains(this.probe)) {
            return;
        }
        for (Direction checked : this.directions) {
            if (checked == this.compass.opposite(fromNewChunk) || this.chunkExists(world, cx + checked.xOffset, cy + checked.zOffset)) continue;
            return;
        }
        this.addToDecorationList(new PlaneLocation.Invariant(cx, cy));
    }

    public void generateTerrain(RTGBiomeProvider cmr, int cx, int cy, Block[] blocks, byte[] metadata, RealisticBiomeBase[] biomes, float[] noise) {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int h = (int)noise[j * 16 + i];
                for (int k = 0; k < 256; ++k) {
                    int p = (j * 16 + i) * 256 + k;
                    if (k > h) {
                        if (k < 63) {
                            blocks[p] = Blocks.field_150355_j;
                            continue;
                        }
                        blocks[p] = Blocks.field_150350_a;
                        continue;
                    }
                    blocks[p] = Blocks.field_150348_b;
                }
            }
        }
    }

    private boolean totalNotOne(float[] tested) {
        float total = 0.0f;
        for (int i = 0; i < tested.length; ++i) {
            total += tested[i];
        }
        return (double)total < 0.999 || total > 1.001f;
    }

    private int chunkCoordinate(int biomeMapCoordinate) {
        return (biomeMapCoordinate - 8) * 8;
    }

    public String description(float[] biomeArray) {
        String result = "";
        for (int i = 0; i < BiomeGenBase.func_150565_n().length; ++i) {
            if (!(biomeArray[i] > 0.0f)) continue;
            result = result + " " + i + " " + biomeArray[i];
        }
        return result;
    }

    public void replaceBlocksForBiome(int cx, int cy, Block[] blocks, byte[] metadata, RealisticBiomeBase[] biomes, BiomeGenBase[] base, float[] n) {
        ChunkProviderEvent.ReplaceBiomeBlocks event = new ChunkProviderEvent.ReplaceBiomeBlocks((IChunkProvider)this, cx, cy, blocks, metadata, base, this.worldObj);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return;
        }
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                RealisticBiomeBase biome = biomes[j * 16 + i];
                float river = -this.cmr.getRiverStrength(cx * 16 + j, cy * 16 + i);
                int depth = -1;
                biome.rReplace(blocks, metadata, cx * 16 + j, cy * 16 + i, i, j, depth, this.worldObj, this.rand, this.simplex, this.cell, n, river, base);
                int flatBedrockLayers = ConfigRTG.flatBedrockLayers;
                int n2 = flatBedrockLayers < 0 ? 0 : (flatBedrockLayers = flatBedrockLayers > 5 ? 5 : flatBedrockLayers);
                if (flatBedrockLayers > 0) {
                    for (int bl = 0; bl < flatBedrockLayers; ++bl) {
                        blocks[(j * 16 + i) * 256 + bl] = this.bedrockBlock;
                        metadata[(j * 16 + i) * 256 + bl] = this.bedrockByte;
                    }
                    continue;
                }
                blocks[(j * 16 + i) * 256] = this.bedrockBlock;
                metadata[(j * 16 + i) * 256] = this.bedrockByte;
                int rough = this.rand.nextInt(2);
                blocks[(j * 16 + i) * 256 + rough] = this.bedrockBlock;
                metadata[(j * 16 + i) * 256 + rough] = this.bedrockByte;
                rough = this.rand.nextInt(3);
                blocks[(j * 16 + i) * 256 + rough] = this.bedrockBlock;
                metadata[(j * 16 + i) * 256 + rough] = this.bedrockByte;
                rough = this.rand.nextInt(4);
                blocks[(j * 16 + i) * 256 + rough] = this.bedrockBlock;
                metadata[(j * 16 + i) * 256 + rough] = this.bedrockByte;
                rough = this.rand.nextInt(5);
                blocks[(j * 16 + i) * 256 + rough] = this.bedrockBlock;
                metadata[(j * 16 + i) * 256 + rough] = this.bedrockByte;
            }
        }
    }

    public Chunk func_73158_c(int par1, int par2) {
        throw new RuntimeException();
    }

    private double[] func_4061_a(double[] ad, int i, int j, int k, int l, int i1, int j1) {
        return null;
    }

    private boolean chunkExists(IChunkProvider world, int par1, int par2) {
        PlaneLocation.Invariant location = new PlaneLocation.Invariant(par1, par2);
        if (this.inGeneration.containsKey(location)) {
            return true;
        }
        if (this.toCheck.contains(location)) {
            return true;
        }
        if (this.chunkMade.contains(location)) {
            return true;
        }
        if (world.func_73149_a(par1, par2)) {
            return true;
        }
        return this.chunkLoader().chunkExists(this.worldObj, par1, par2);
    }

    public boolean func_73149_a(int par1, int par2) {
        this.probe.setX(par1);
        this.probe.setZ(par2);
        return this.inGeneration.containsKey(this.probe);
    }

    public void func_73153_a(IChunkProvider ichunkprovider, int chunkX, int chunkZ) {
        if (WorldTypeRTG.chunkProvider != this) {
            return;
        }
        if (this.neighborsDone(ichunkprovider, chunkX, chunkZ)) {
            this.doPopulate(ichunkprovider, chunkX, chunkZ);
        }
        this.clearDecorations(0);
    }

    public Runnable clearOnServerClose() {
        return new Runnable(){

            @Override
            public void run() {
                ChunkProviderRTG.this.clearToDecorateList();
            }
        };
    }

    private void clearToDecorateList() {
        if (WorldTypeRTG.chunkProvider != this) {
            return;
        }
        if (this.populating) {
            return;
        }
        IChunkProvider ichunkprovider = this.worldObj.func_72863_F();
        Set<PlaneLocation> toProcess = this.doableLocations(0);
        while (toProcess.size() > 0) {
            for (PlaneLocation location : toProcess) {
                this.removeFromDecorationList(location);
            }
            for (PlaneLocation location : toProcess) {
                this.doPopulate(ichunkprovider, location.x(), location.z());
            }
            toProcess = this.doableLocations(0);
        }
    }

    private void clearDecorations(int limit) {
        if (WorldTypeRTG.chunkProvider != this) {
            return;
        }
        IChunkProvider ichunkprovider = this.worldObj.func_72863_F();
        Set<PlaneLocation> toProcess = this.doableLocations(limit);
        for (PlaneLocation location : toProcess) {
            this.removeFromDecorationList(location);
        }
        for (PlaneLocation location : toProcess) {
            this.doPopulate(ichunkprovider, location.x(), location.z());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<PlaneLocation> doableLocations(int limit) {
        HashSet<PlaneLocation> toProcess = new HashSet<PlaneLocation>();
        int found = 0;
        HashSet<PlaneLocation> hashSet = this.toDecorate;
        synchronized (hashSet) {
            for (PlaneLocation location : this.toDecorate) {
                Chunk existing = this.availableChunks.get(location);
                if (existing == null || !existing.field_76646_k) {
                    // empty if block
                }
                if (this.inGeneration.containsKey(location)) continue;
                toProcess.add(location);
                if (++found != limit) continue;
                return toProcess;
            }
        }
        return toProcess;
    }

    private Converter<Chunk, PlaneLocation> keyer() {
        return new Converter<Chunk, PlaneLocation>(){

            @Override
            public final PlaneLocation result(Chunk original) {
                return new PlaneLocation.Invariant(original.field_76635_g, original.field_76647_h);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addToDecorationList(PlaneLocation toAdd) {
        HashSet<PlaneLocation> hashSet = this.toDecorate;
        synchronized (hashSet) {
            this.toDecorate.add(toAdd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeFromDecorationList(PlaneLocation toAdd) {
        HashSet<PlaneLocation> hashSet = this.toDecorate;
        synchronized (hashSet) {
            this.toDecorate.remove(toAdd);
        }
    }

    private void doPopulate(IChunkProvider ichunkprovider, int chunkX, int chunkZ) {
        PlaneLocation.Invariant location = new PlaneLocation.Invariant(chunkX, chunkZ);
        if (this.alreadyDecorated.contains(location)) {
            return;
        }
        if (this.populating) {
            this.addToDecorationList(location);
            return;
        }
        if (populatingProvider != null) {
            throw new RuntimeException(this.toString() + " " + populatingProvider.toString());
        }
        if (this.inGeneration.containsKey(location)) {
            this.addToDecorationList(location);
            return;
        }
        this.alreadyDecorated.add(location);
        this.populating = true;
        populatingProvider = this;
        TimeTracker.manager.start("RTG populate");
        TimeTracker.manager.start("Features");
        BlockFalling.field_149832_M = true;
        int worldX = chunkX * 16;
        int worldZ = chunkZ * 16;
        TimeTracker.manager.start(biomeLayoutActivity);
        RealisticBiomeBase biome = this.cmr.getBiomeDataAt(worldX + 16, worldZ + 16);
        TimeTracker.manager.stop(biomeLayoutActivity);
        this.rand.setSeed(this.worldObj.func_72905_C());
        long i1 = this.rand.nextLong() / 2L * 2L + 1L;
        long j1 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * i1 + (long)chunkZ * j1 ^ this.worldObj.func_72905_C());
        boolean hasPlacedVillageBlocks = false;
        boolean gen = false;
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(ichunkprovider, this.worldObj, this.rand, chunkX, chunkZ, hasPlacedVillageBlocks));
        if (this.mapFeaturesEnabled) {
            TimeTracker.manager.start("Mineshafts");
            if (ConfigRTG.generateMineshafts) {
                this.mineshaftGenerator.func_75051_a(this.worldObj, this.rand, chunkX, chunkZ);
            }
            TimeTracker.manager.stop("Mineshafts");
            TimeTracker.manager.start("Strongholds");
            if (ConfigRTG.generateStrongholds) {
                this.strongholdGenerator.func_75051_a(this.worldObj, this.rand, chunkX, chunkZ);
            }
            TimeTracker.manager.stop("Strongholds");
            TimeTracker.manager.start("Villages");
            if (ConfigRTG.generateVillages) {
                if (ConfigRTG.villageCrashFix) {
                    try {
                        hasPlacedVillageBlocks = this.villageGenerator.func_75051_a(this.worldObj, this.rand, chunkX, chunkZ);
                    }
                    catch (Exception e) {
                        hasPlacedVillageBlocks = false;
                    }
                } else {
                    hasPlacedVillageBlocks = this.villageGenerator.func_75051_a(this.worldObj, this.rand, chunkX, chunkZ);
                }
            }
            TimeTracker.manager.stop("Villages");
            TimeTracker.manager.start("Scattered");
            if (ConfigRTG.generateScatteredFeatures) {
                this.scatteredFeatureGenerator.func_75051_a(this.worldObj, this.rand, chunkX, chunkZ);
            }
            TimeTracker.manager.stop("Scattered");
        }
        TimeTracker.manager.start("Pools");
        biome.rPopulatePreDecorate(ichunkprovider, this.worldObj, this.rand, chunkX, chunkZ, hasPlacedVillageBlocks);
        TimeTracker.manager.stop("Pools");
        int adjust = 24;
        TimeTracker.manager.start(biomeLayoutActivity);
        for (int bx = -4; bx <= 4; ++bx) {
            for (int by = -4; by <= 4; ++by) {
                int n = this.landscapeGenerator.getBiomeDataAt(this.cmr, worldX + 24 + bx * 4, worldZ + 24 + by * 4);
                this.borderNoise[n] = this.borderNoise[n] + 0.01234569f;
            }
        }
        TimeTracker.manager.stop(biomeLayoutActivity);
        TimeTracker.manager.stop("Features");
        TimeTracker.manager.start("Decorations");
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(this.worldObj, this.rand, worldX, worldZ));
        float river = -this.cmr.getRiverStrength(worldX + 16, worldZ + 16);
        biome.rDecorateClay(this.worldObj, this.rand, chunkX, chunkZ, river, worldX, worldZ);
        float snow = 0.0f;
        for (int bn = 0; bn < 256; ++bn) {
            RealisticBiomeBase realisticBiome;
            if (!(this.borderNoise[bn] > 0.0f)) continue;
            if (this.borderNoise[bn] >= 1.0f) {
                this.borderNoise[bn] = 1.0f;
            }
            if ((realisticBiome = RealisticBiomeBase.getBiome(bn)) == null) {
                realisticBiome = this.biomePatcher.getPatchedRealisticBiome("NULL biome (" + bn + ") found when generating border noise.");
            }
            if (ConfigRTG.enableRTGBiomeDecorations && realisticBiome.config._boolean("useRTGDecorations")) {
                realisticBiome.decorateInAnOrderlyFashion(this.worldObj, this.rand, worldX, worldZ, this.simplex, this.cell, this.borderNoise[bn], river, hasPlacedVillageBlocks);
            } else {
                try {
                    realisticBiome.baseBiome.func_76728_a(this.worldObj, this.rand, worldX, worldZ);
                }
                catch (Exception e) {
                    realisticBiome.decorateInAnOrderlyFashion(this.worldObj, this.rand, worldX, worldZ, this.simplex, this.cell, this.borderNoise[bn], river, hasPlacedVillageBlocks);
                }
            }
            snow = realisticBiome.baseBiome.field_76750_F < 0.15f ? (snow -= 0.6f * this.borderNoise[bn]) : (snow += 0.6f * this.borderNoise[bn]);
            this.borderNoise[bn] = 0.0f;
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(this.worldObj, this.rand, worldX, worldZ));
        TimeTracker.manager.stop("Decorations");
        TimeTracker.manager.start("Post-decorations");
        biome.rPopulatePostDecorate(ichunkprovider, this.worldObj, this.rand, chunkX, chunkZ, hasPlacedVillageBlocks);
        if (ConfigRTG.flowingWaterChance > 0 && this.rand.nextInt(ConfigRTG.flowingWaterChance) == 0) {
            for (int l18 = 0; l18 < 50; ++l18) {
                int l21 = worldX + this.rand.nextInt(16);
                int k23 = this.rand.nextInt(this.rand.nextInt(this.worldHeight - 16) + 10);
                int l24 = worldZ + this.rand.nextInt(16);
                new WorldGenLiquids((Block)Blocks.field_150358_i).func_76484_a(this.worldObj, this.rand, l21, k23, l24);
            }
        }
        if (ConfigRTG.flowingLavaChance > 0 && this.rand.nextInt(ConfigRTG.flowingLavaChance) == 0) {
            for (int i19 = 0; i19 < 20; ++i19) {
                int i22 = worldX + this.rand.nextInt(16);
                int l23 = this.rand.nextInt(this.worldHeight / 2);
                int i25 = worldZ + this.rand.nextInt(16);
                new WorldGenLiquids((Block)Blocks.field_150356_k).func_76484_a(this.worldObj, this.rand, i22, l23, i25);
            }
        }
        TimeTracker.manager.stop("Post-decorations");
        TimeTracker.manager.start("Entities");
        this.probe.setX(chunkX);
        this.probe.setZ(chunkZ);
        if (TerrainGen.populate((IChunkProvider)this, (World)this.worldObj, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)hasPlacedVillageBlocks, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            SpawnerAnimals.func_77191_a((World)this.worldObj, (BiomeGenBase)this.worldObj.func_72807_a(worldX + 16, worldZ + 16), (int)worldX, (int)worldZ, (int)16, (int)16, (Random)this.rand);
        }
        TimeTracker.manager.stop("Entities");
        TimeTracker.manager.start("Ice");
        this.probe.setX(chunkX);
        this.probe.setZ(chunkZ);
        if (TerrainGen.populate((IChunkProvider)this, (World)this.worldObj, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)hasPlacedVillageBlocks, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE)) {
            for (int k1 = 0; k1 < 16; ++k1) {
                for (int l1 = 0; l1 < 16; ++l1) {
                    int i2 = this.worldObj.func_72874_g(worldX + k1, worldZ + l1);
                    if (this.worldObj.func_72884_u(k1 + worldX, i2 - 1, l1 + worldZ)) {
                        this.worldObj.func_147465_d(k1 + worldX, i2 - 1, l1 + worldZ, Blocks.field_150432_aD, 0, 2);
                    }
                    if (!ConfigRTG.enableSnowLayers || !this.worldObj.func_147478_e(k1 + worldX, i2, l1 + worldZ, true)) continue;
                    this.worldObj.func_147465_d(k1 + worldX, i2, l1 + worldZ, Blocks.field_150431_aC, 0, 2);
                }
            }
        } else {
            throw new RuntimeException();
        }
        TimeTracker.manager.stop("Ice");
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(ichunkprovider, this.worldObj, this.rand, chunkX, chunkZ, hasPlacedVillageBlocks));
        BlockFalling.field_149832_M = false;
        TimeTracker.manager.stop("RTG populate");
        this.populating = false;
        populatingProvider = null;
    }

    public boolean neighborsDone(IChunkProvider world, int cx, int cz) {
        if (!this.chunkExists(world, cx - 1, cz - 1)) {
            return false;
        }
        if (!this.chunkExists(world, cx - 1, cz)) {
            return false;
        }
        if (!this.chunkExists(world, cx - 1, cz + 1)) {
            return false;
        }
        if (!this.chunkExists(world, cx, cz - 1)) {
            return false;
        }
        if (!this.chunkExists(world, cx, cz + 1)) {
            return false;
        }
        if (!this.chunkExists(world, cx + 1, cz - 1)) {
            return false;
        }
        if (!this.chunkExists(world, cx + 1, cz)) {
            return false;
        }
        return this.chunkExists(world, cx + 1, cz + 1);
    }

    public boolean func_73151_a(boolean par1, IProgressUpdate par2IProgressUpdate) {
        return true;
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean unload100OldestChunks() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "ChunkProviderRTG";
    }

    public List func_73155_a(EnumCreatureType par1EnumCreatureType, int par2, int par3, int par4) {
        BiomeGenBase var5 = this.worldObj.func_72807_a(par2, par4);
        return var5 == null ? null : var5.func_76747_a(par1EnumCreatureType);
    }

    public ChunkPosition func_147416_a(World par1World, String par2Str, int par3, int par4, int par5) {
        if (!ConfigRTG.generateStrongholds) {
            return null;
        }
        return "Stronghold".equals(par2Str) && this.strongholdGenerator != null ? this.strongholdGenerator.func_151545_a(par1World, par3, par4, par5) : null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int par1, int par2) {
        if (this.mapFeaturesEnabled) {
            if (ConfigRTG.generateMineshafts) {
                this.mineshaftGenerator.func_151539_a((IChunkProvider)this, this.worldObj, par1, par2, (Block[])null);
            }
            if (ConfigRTG.generateStrongholds) {
                this.strongholdGenerator.func_151539_a((IChunkProvider)this, this.worldObj, par1, par2, (Block[])null);
            }
            if (ConfigRTG.generateVillages) {
                if (ConfigRTG.villageCrashFix) {
                    try {
                        this.villageGenerator.func_151539_a((IChunkProvider)this, this.worldObj, par1, par2, (Block[])null);
                    }
                    catch (Exception exception) {}
                } else {
                    this.villageGenerator.func_151539_a((IChunkProvider)this, this.worldObj, par1, par2, (Block[])null);
                }
            }
            if (ConfigRTG.generateScatteredFeatures) {
                this.scatteredFeatureGenerator.func_151539_a((IChunkProvider)this, this.worldObj, par1, par2, (Block[])null);
            }
        }
    }

    public void func_104112_b() {
    }

    private AnvilChunkLoader chunkLoader() {
        if (this.chunkLoader == null) {
            ChunkProviderServer server = (ChunkProviderServer)this.worldObj.func_72863_F();
            this.chunkLoader = (AnvilChunkLoader)server.field_73247_e;
        }
        return this.chunkLoader;
    }

    public Set<Long> serverLoadingChunks() {
        if (this.serverLoadingChunks == null) {
            ChunkProviderServer server = (ChunkProviderServer)this.worldObj.func_72863_F();
            this.chunkLoader = (AnvilChunkLoader)server.field_73247_e;
            this.serverLoadingChunks = this.forServerLoadingChunks.get(server);
        }
        return this.serverLoadingChunks;
    }

    static {
        biomeLayoutActivity = "Biome Layout";
    }
}

