/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.biomesoplenty;

import biomesoplenty.api.content.BOPCBiomes;
import net.minecraft.block.Block;
import net.minecraft.world.biome.BiomeGenBase;
import rtg.api.biome.BiomeConfig;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.util.SimplexOctave;
import rtg.world.biome.deco.DecoBaseBiomeDecorations;
import rtg.world.biome.realistic.biomesoplenty.RealisticBiomeBOPBase;
import rtg.world.gen.surface.biomesoplenty.SurfaceBOPBayou;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.biomesoplenty.TerrainBOPBayou;

public class RealisticBiomeBOPBayou
extends RealisticBiomeBOPBase {
    public static BiomeGenBase bopBiome = BOPCBiomes.bayou;
    public static Block topBlock = RealisticBiomeBOPBayou.bopBiome.field_76752_A;
    public static Block fillerBlock = RealisticBiomeBOPBayou.bopBiome.field_76753_B;
    private double lakeWaterLevel = 0.04;
    private double lakeDepressionLevel = 0.3;

    public RealisticBiomeBOPBayou(BiomeConfig config) {
        super(config, bopBiome, BiomeGenBase.field_76781_i, (TerrainBase)new TerrainBOPBayou(), new SurfaceBOPBayou(config, topBlock, fillerBlock));
        DecoBaseBiomeDecorations decoBaseBiomeDecorations = new DecoBaseBiomeDecorations();
        this.addDeco(decoBaseBiomeDecorations);
    }

    @Override
    public float lakePressure(OpenSimplexNoise simplex, CellNoise simplexCell, int x, int y, float border) {
        float result;
        SimplexOctave.Disk jitter = new SimplexOctave.Disk();
        simplex.riverJitter().evaluateNoise((double)x / 40.0, (double)y / 40.0, jitter);
        double pX = (double)x + jitter.deltax() * 35.0;
        double pY = (double)y + jitter.deltay() * 35.0;
        double[] results = simplexCell.river().eval(pX / 150.0, pY / 150.0);
        if ((double)border < 0.5) {
            border = 0.5f;
        }
        if ((double)(result = (float)(results[1] - results[0])) > 1.01) {
            throw new RuntimeException("" + results[0] + " , " + results[1]);
        }
        if ((double)result < -0.01) {
            throw new RuntimeException("" + results[0] + " , " + results[1]);
        }
        return result;
    }

    @Override
    public float lakeFlattening(float pressure, float bottomLevel, float topLevel) {
        if ((double)pressure > this.lakeDepressionLevel) {
            return 1.0f;
        }
        if ((double)pressure < this.lakeWaterLevel) {
            return 0.0f;
        }
        return (float)(((double)pressure - this.lakeWaterLevel) / (this.lakeDepressionLevel - this.lakeWaterLevel));
    }
}

