/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome;

import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import rtg.config.rtg.ConfigRTG;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.util.SimplexCellularNoise;
import rtg.util.SimplexOctave;
import rtg.util.VoronoiCellNoise;
import rtg.world.biome.RTGBiomeProvider;
import rtg.world.biome.realistic.RealisticBiomeBase;
import rtg.world.biome.realistic.RealisticBiomePatcher;

public class WorldChunkManagerRTG
extends WorldChunkManager
implements RTGBiomeProvider {
    private GenLayer genBiomes;
    private GenLayer biomeIndexLayer;
    private List biomesToSpawnIn;
    private OpenSimplexNoise simplex;
    private CellNoise cell;
    private VoronoiCellNoise river;
    private float[] borderNoise;
    private TLongObjectHashMap<RealisticBiomeBase> biomeDataMap = new TLongObjectHashMap();
    private BiomeCache biomeCache = new BiomeCache((WorldChunkManager)this);
    private RealisticBiomePatcher biomePatcher;
    private static int[] incidences = new int[100];
    private static int references = 0;
    private double riverValleyLevel = 0.13333333333333333;
    private float riverSeparation = 1875.0f;
    private float largeBendSize = 140.0f;
    private float smallBendSize = 30.0f;

    protected WorldChunkManagerRTG() {
        this.biomesToSpawnIn = new ArrayList();
        this.borderNoise = new float[256];
        this.biomePatcher = new RealisticBiomePatcher();
        this.riverSeparation /= ConfigRTG.riverFrequencyMultiplier;
        this.riverValleyLevel *= (double)ConfigRTG.riverSizeMultiplier();
        this.largeBendSize *= ConfigRTG.riverBendinessMultiplier;
        this.smallBendSize *= ConfigRTG.riverBendinessMultiplier;
    }

    public WorldChunkManagerRTG(World par1World, WorldType worldType) {
        this();
        long seed = par1World.func_72905_C();
        if (par1World.field_73011_w.field_76574_g != 0) {
            throw new RuntimeException();
        }
        this.simplex = new OpenSimplexNoise(seed);
        this.cell = new SimplexCellularNoise(seed);
        this.river = new VoronoiCellNoise(seed);
        GenLayer[] agenlayer = GenLayer.func_75901_a((long)seed, (WorldType)worldType);
        agenlayer = this.getModdedBiomeGenerators(worldType, seed, agenlayer);
        this.genBiomes = agenlayer[0];
        this.biomeIndexLayer = agenlayer[1];
        WorldChunkManagerRTG.testCellBorder();
    }

    @Override
    public int[] getBiomesGens(int par1, int par2, int par3, int par4) {
        int[] d = new int[par3 * par4];
        for (int i = 0; i < par3; ++i) {
            for (int j = 0; j < par4; ++j) {
                d[j * par3 + i] = this.func_76935_a((int)(par1 + i), (int)(par2 + j)).field_76756_M;
            }
        }
        return d;
    }

    public boolean diff(float sample1, float sample2, float base) {
        return sample1 < base && sample2 > base || sample1 > base && sample2 < base;
    }

    public float[] func_76936_a(float[] par1ArrayOfFloat, int par2, int par3, int par4, int par5) {
        IntCache.func_76446_a();
        if (par1ArrayOfFloat == null || par1ArrayOfFloat.length < par4 * par5) {
            par1ArrayOfFloat = new float[par4 * par5];
        }
        int[] aint = this.biomeIndexLayer.func_75904_a(par2, par3, par4, par5);
        for (int i1 = 0; i1 < par4 * par5; ++i1) {
            float f;
            block7: {
                f = 0.0f;
                int biome = aint[i1];
                try {
                    if (biome > 255) {
                        throw new RuntimeException(this.biomeIndexLayer.toString());
                    }
                    f = (float)RealisticBiomeBase.getBiome((int)biome).baseBiome.func_76744_g() / 65536.0f;
                }
                catch (Exception e) {
                    if (biome > 255) {
                        throw new RuntimeException(this.biomeIndexLayer.toString());
                    }
                    if (RealisticBiomeBase.getBiome(biome) != null) break block7;
                    f = (float)this.biomePatcher.getPatchedRealisticBiome((String)new StringBuilder().append((String)"Problem with biome ").append((int)biome).append((String)" from ").append((String)e.getMessage()).toString()).baseBiome.func_76744_g() / 65536.0f;
                }
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            par1ArrayOfFloat[i1] = f;
        }
        return par1ArrayOfFloat;
    }

    public BiomeGenBase[] func_76933_b(BiomeGenBase[] par1ArrayOfBiomeGenBase, int par2, int par3, int par4, int par5) {
        return this.func_76931_a(par1ArrayOfBiomeGenBase, par2, par3, par4, par5, true);
    }

    public BiomeGenBase func_76935_a(int par1, int par2) {
        BiomeGenBase result = this.biomeCache.func_76837_b(par1, par2);
        if (result == null) {
            result = this.biomePatcher.getPatchedBaseBiome("Biome cache contains NULL biome at " + par1 + "," + par2);
        }
        return result;
    }

    public BiomeGenBase[] func_76937_a(BiomeGenBase[] par1ArrayOfBiomeGenBase, int par2, int par3, int par4, int par5) {
        IntCache.func_76446_a();
        if (par1ArrayOfBiomeGenBase == null || par1ArrayOfBiomeGenBase.length < par4 * par5) {
            par1ArrayOfBiomeGenBase = new BiomeGenBase[par4 * par5];
        }
        int[] aint = this.genBiomes.func_75904_a(par2, par3, par4, par5);
        for (int i1 = 0; i1 < par4 * par5; ++i1) {
            par1ArrayOfBiomeGenBase[i1] = RealisticBiomeBase.getBiome((int)aint[i1]).baseBiome;
        }
        return par1ArrayOfBiomeGenBase;
    }

    @Override
    public RealisticBiomeBase getBiomeDataAt(int par1, int par2) {
        RealisticBiomeBase output = RealisticBiomeBase.getBiome(this.func_76935_a((int)par1, (int)par2).field_76756_M);
        if (output == null) {
            output = this.biomePatcher.getPatchedRealisticBiome("No biome " + par1 + " " + par2);
        }
        return output;
    }

    public void func_76938_b() {
        this.biomeCache.func_76838_a();
    }

    public float getNoiseAt(int x, int y) {
        float river = this.getRiverStrength(x, y) + 1.0f;
        if (river < 0.5f) {
            return 59.0f;
        }
        return this.getBiomeDataAt(x, y).rNoise(this.simplex, this.cell, x, y, 1.0f, river);
    }

    private static double cellBorder(double[] results, double width, double depth) {
        double c = (results[1] - results[0]) / results[1];
        if (c < 0.0) {
            throw new RuntimeException();
        }
        if (c < width) {
            return (c / width - 1.0) * depth;
        }
        return 0.0;
    }

    private static void testCellBorder() {
        double[] result = new double[]{0.5, 1.0};
        if (WorldChunkManagerRTG.cellBorder(result, 0.5, 1.0) < 0.0) {
            throw new RuntimeException();
        }
    }

    @Override
    public float getRiverStrength(int x, int y) {
        SimplexOctave.Disk jitter = new SimplexOctave.Disk();
        this.simplex.riverJitter().evaluateNoise((double)x / 240.0, (double)y / 240.0, jitter);
        double pX = (double)x + jitter.deltax() * (double)this.largeBendSize;
        double pY = (double)y + jitter.deltay() * (double)this.largeBendSize;
        this.simplex.octave(2).evaluateNoise((double)x / 80.0, (double)y / 80.0, jitter);
        double xRiver = (pX += jitter.deltax() * (double)this.smallBendSize) / (double)this.riverSeparation;
        double yRiver = (pY += jitter.deltay() * (double)this.smallBendSize) / (double)this.riverSeparation;
        return this.river.octave(0).border2(xRiver, yRiver, this.riverValleyLevel, 1.0f);
    }

    @Override
    public boolean isBorderlessAt(int x, int y) {
        int by;
        int bx;
        for (bx = -2; bx <= 2; ++bx) {
            for (by = -2; by <= 2; ++by) {
                int n = this.getBiomeDataAt((int)(x + bx * 16), (int)(y + by * 16)).baseBiome.field_76756_M;
                this.borderNoise[n] = this.borderNoise[n] + 0.04f;
            }
        }
        by = 0;
        for (bx = 0; bx < 256; ++bx) {
            if (this.borderNoise[bx] > 0.98f) {
                by = 1;
            }
            this.borderNoise[bx] = 0.0f;
        }
        return by == 1;
    }

    public List func_76932_a() {
        return this.biomesToSpawnIn;
    }

    public float func_76939_a(float par1, int par2) {
        return par1;
    }

    public BiomeGenBase[] func_76931_a(BiomeGenBase[] par1ArrayOfBiomeGenBase, int par2, int par3, int par4, int par5, boolean par6) {
        IntCache.func_76446_a();
        if (par1ArrayOfBiomeGenBase == null || par1ArrayOfBiomeGenBase.length < par4 * par5) {
            par1ArrayOfBiomeGenBase = new BiomeGenBase[par4 * par5];
        }
        if (par6 && par4 == 16 && par5 == 16 && (par2 & 0xF) == 0 && (par3 & 0xF) == 0) {
            BiomeGenBase[] abiomegenbase1 = this.biomeCache.func_76839_e(par2, par3);
            System.arraycopy(abiomegenbase1, 0, par1ArrayOfBiomeGenBase, 0, par4 * par5);
            return par1ArrayOfBiomeGenBase;
        }
        int[] aint = this.biomeIndexLayer.func_75904_a(par2, par3, par4, par5);
        for (int i1 = 0; i1 < par4 * par5; ++i1) {
            try {
                par1ArrayOfBiomeGenBase[i1] = RealisticBiomeBase.getBiome((int)aint[i1]).baseBiome;
            }
            catch (Exception e) {
                par1ArrayOfBiomeGenBase[i1] = this.biomePatcher.getPatchedBaseBiome(this.genBiomes.toString() + " " + this.biomeIndexLayer.toString());
            }
            if (par1ArrayOfBiomeGenBase[i1] != null) continue;
            par1ArrayOfBiomeGenBase[i1] = this.biomePatcher.getPatchedBaseBiome("Missing biome " + aint[i1]);
        }
        return par1ArrayOfBiomeGenBase;
    }

    public boolean func_76940_a(int x, int y, int par3, List par4List) {
        float centerNoise = this.getNoiseAt(x, y);
        if (centerNoise < 62.0f) {
            return false;
        }
        float lowestNoise = centerNoise;
        float highestNoise = centerNoise;
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (i == 0 || j == 0) continue;
                float n = this.getNoiseAt(x + i * 16, y + j * 16);
                if (n < lowestNoise) {
                    lowestNoise = n;
                }
                if (!(n > highestNoise)) continue;
                highestNoise = n;
            }
        }
        return highestNoise - lowestNoise < 22.0f;
    }

    public ChunkPosition func_150795_a(int p_150795_1_, int p_150795_2_, int p_150795_3_, List p_150795_4_, Random p_150795_5_) {
        IntCache.func_76446_a();
        int l = p_150795_1_ - p_150795_3_ >> 2;
        int i1 = p_150795_2_ - p_150795_3_ >> 2;
        int j1 = p_150795_1_ + p_150795_3_ >> 2;
        int k1 = p_150795_2_ + p_150795_3_ >> 2;
        int l1 = j1 - l + 1;
        int i2 = k1 - i1 + 1;
        int[] aint = this.genBiomes.func_75904_a(l, i1, l1, i2);
        ChunkPosition chunkposition = null;
        int j2 = 0;
        for (int k2 = 0; k2 < l1 * i2; ++k2) {
            int l2 = l + k2 % l1 << 2;
            int i3 = i1 + k2 / l1 << 2;
            BiomeGenBase biomegenbase = BiomeGenBase.func_150568_d((int)aint[k2]);
            if (!p_150795_4_.contains(biomegenbase) || chunkposition != null && p_150795_5_.nextInt(j2 + 1) != 0) continue;
            chunkposition = new ChunkPosition(l2, 0, i3);
            ++j2;
        }
        return chunkposition;
    }
}

