/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.FlansMod;
import com.flansmod.common.teams.ArmourType;
import com.flansmod.common.types.IFlanItem;
import com.flansmod.common.types.InfoType;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;

public class ItemTeamArmour
extends ItemArmor
implements ISpecialArmor,
IFlanItem {
    public ArmourType type;
    protected static final UUID[] uuid = new UUID[]{UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID()};

    public ItemTeamArmour(ArmourType t) {
        super(ItemArmor.ArmorMaterial.CLOTH, 0, t.type);
        this.type = t;
        this.type.item = this;
        this.func_77637_a(FlansMod.tabFlanTeams);
        GameRegistry.registerItem((Item)this, (String)this.type.shortName, (String)"flansmod");
    }

    public ItemTeamArmour(ItemArmor.ArmorMaterial armorMaterial, int renderIndex, int armourType) {
        super(armorMaterial, renderIndex, armourType);
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        return new ISpecialArmor.ArmorProperties(1, this.type.defence, Integer.MAX_VALUE);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return (int)(this.type.defence * 20.0);
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
    }

    public String getArmorTexture(ItemStack itemstack, Entity entity, int slot, String s) {
        return "flansmod:armor/" + this.type.armourTextureName + "_" + (this.type.type == 2 ? "2" : "1") + ".png";
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List lines, boolean b) {
        if (this.type.description != null) {
            Collections.addAll(lines, this.type.description.split("_"));
        }
        if (Math.abs(this.type.jumpModifier - 1.0f) > 0.01f) {
            lines.add("\u00a73+" + (int)((this.type.jumpModifier - 1.0f) * 100.0f) + "% Jump Height");
        }
        if (this.type.smokeProtection) {
            lines.add("\u00a72+Smoke Protection");
        }
        if (this.type.nightVision) {
            lines.add("\u00a72+Night Vision");
        }
        if (this.type.negateFallDamage) {
            lines.add("\u00a72+Negates Fall Damage");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack par1ItemStack, int par2) {
        return this.type.colour;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister icon) {
        this.field_77791_bV = icon.func_94245_a("FlansMod:" + this.type.iconPath);
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        Multimap map = super.getAttributeModifiers(stack);
        map.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(uuid[this.type.type], "KnockbackResist", (double)this.type.knockbackModifier, 0));
        map.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(uuid[this.type.type], "MovementSpeed", (double)(this.type.moveSpeedModifier - 1.0f), 2));
        return map;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        return this.type.model;
    }

    @Override
    public InfoType getInfoType() {
        return this.type;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (this.type.nightVision && FlansMod.ticker % 25 == 0) {
            player.func_70690_d(new PotionEffect(Potion.field_76439_r.field_76415_H, 250));
        }
        if (this.type.jumpModifier > 1.01f && FlansMod.ticker % 25 == 0) {
            player.func_70690_d(new PotionEffect(Potion.field_76430_j.field_76415_H, 250, (int)((this.type.jumpModifier - 1.0f) * 2.0f), true));
        }
        if (this.type.negateFallDamage) {
            player.field_70143_R = 0.0f;
        }
    }
}

